/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim.calc;

import Jama.Matrix;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import org.opensha.commons.calc.GaussianDistCalc;
import org.opensha.commons.calc.cholesky.CholeskyDecomposition;
import org.opensha.commons.calc.cholesky.NearPD;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.calc.AbstractCalculator;
import org.opensha.sha.calc.disaggregation.DisaggregationCalculator;
import org.opensha.sha.calc.params.filters.SourceFilter;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.gcim.Utils;
import org.opensha.sha.gcim.calc.GcimCalculatorAPI;
import org.opensha.sha.gcim.imCorrRel.ImCorrelationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_InterpolatedParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.util.TRTUtils;
import org.opensha.sha.util.TectonicRegionType;

public class GcimCalculator
extends AbstractCalculator
implements GcimCalculatorAPI {
    private static final String C = "GcimCalculator";
    private static final boolean D = true;
    private Map<TectonicRegionType, ScalarIMR> imrjMap;
    private double[][] pRup_IMj;
    private double[][] rupCdf;
    private double[][] epsilonIMj;
    private double[] sourceCdf;
    private double[][] randIMiRealizations;
    private double[][] randIMiRealizationStdevs;
    private int randSourceId;
    private int randRupId;
    private int numIMi = 0;
    private int num_z;
    private int numGcimRealizations;
    private int currentIMi = -1;
    private ArrayList<? extends Map<TectonicRegionType, ScalarIMR>> imiAttenRels;
    private ArrayList<String> imiTypes;
    private ArrayList<? extends Map<TectonicRegionType, ImCorrelationRelationship>> imijCorrRels;
    private double[][] imiArray;
    private double[][] cdfIMi_IMjArray;
    private double[] zApprox;
    private boolean corrMatrixPD = true;
    private double normFrob;
    private String corrMatrixNotPDString;
    private String corrMatrixPDString;
    private String GcimResultsString = "";
    private boolean gcimComplete = false;
    private boolean gcimRealizationsComplete = false;
    private Site site;
    private ERF eqkRupForecast;

    public GcimCalculator() {
        this.setApproxCDFvalues();
    }

    @Override
    public void getRuptureContributions(double iml, Site site, Map<TectonicRegionType, ScalarIMR> imrjMap, ERF eqkRupForecast, Collection<SourceFilter> sourceFilters, ParameterList calcParams) throws RemoteException {
        this.imrjMap = imrjMap;
        ScalarIMR firstIMRFromMap = TRTUtils.getFirstIMR(imrjMap);
        this.site = site;
        this.eqkRupForecast = eqkRupForecast;
        DisaggregationCalculator disaggCalc = new DisaggregationCalculator();
        disaggCalc.setStoreRupProbEpsilons(true);
        disaggCalc.disaggregate(iml, site, imrjMap, eqkRupForecast, sourceFilters, calcParams);
        double[][][] disaggRupDetails1 = disaggCalc.getRupProbEpsilons();
        double trate_imj = disaggCalc.getTotalRate();
        disaggCalc.disaggregate(iml * 1.01, site, imrjMap, eqkRupForecast, sourceFilters, calcParams);
        double[][][] disaggRupDetails2 = disaggCalc.getRupProbEpsilons();
        double trate_imj2 = disaggCalc.getTotalRate();
        int numSources = eqkRupForecast.getNumSources();
        if (numSources != disaggRupDetails1.length || numSources != disaggRupDetails2.length) {
            throw new IllegalArgumentException("Error: Num Sources != that from disagg calc");
        }
        this.pRup_IMj = new double[numSources][];
        this.epsilonIMj = new double[numSources][];
        this.rupCdf = new double[numSources][];
        this.sourceCdf = new double[numSources];
        double dtrate_imj = trate_imj - trate_imj2;
        double cumProb = 0.0;
        for (int i = 0; i < numSources; ++i) {
            int j;
            int numRup = eqkRupForecast.getSource(i).getNumRuptures();
            this.pRup_IMj[i] = new double[numRup];
            this.epsilonIMj[i] = new double[numRup];
            this.rupCdf[i] = new double[numRup];
            if (disaggRupDetails1[i] == null) {
                for (j = 0; j < numRup; ++j) {
                    this.pRup_IMj[i][j] = 0.0;
                    this.epsilonIMj[i][j] = 0.0;
                }
                continue;
            }
            for (j = 0; j < numRup; ++j) {
                double pRup_imj = disaggRupDetails1[i][j][0];
                double pRup_imj2 = disaggRupDetails2[i][j][0];
                this.pRup_IMj[i][j] = (pRup_imj * trate_imj - pRup_imj2 * trate_imj2) / dtrate_imj;
                this.epsilonIMj[i][j] = disaggRupDetails1[i][j][1];
                this.rupCdf[i][j] = cumProb += this.pRup_IMj[i][j];
            }
            this.sourceCdf[i] = cumProb;
        }
    }

    @Override
    public boolean getMultipleGcims(int numIMi, ArrayList<? extends Map<TectonicRegionType, ScalarIMR>> imiAttenRels, ArrayList<String> imiTypes, ArrayList<? extends Map<TectonicRegionType, ImCorrelationRelationship>> imijCorrRels, double maxDist, ArbitrarilyDiscretizedFunc magDistFilter) {
        this.numIMi = numIMi;
        this.imiAttenRels = imiAttenRels;
        this.imiTypes = imiTypes;
        this.imijCorrRels = imijCorrRels;
        this.setGcimOutputDimensions();
        for (int i = 0; i < numIMi; ++i) {
            this.currentIMi = i + 1;
            Map<TectonicRegionType, ScalarIMR> imriMap = imiAttenRels.get(i);
            Map<TectonicRegionType, ImCorrelationRelationship> corrImijMap = imijCorrRels.get(i);
            this.getSingleGcim(i, imriMap, corrImijMap, maxDist, magDistFilter);
        }
        this.gcimComplete = true;
        return this.gcimComplete;
    }

    @Override
    public boolean getSingleGcim(int imiNumber, Map<TectonicRegionType, ScalarIMR> imriMap, Map<TectonicRegionType, ImCorrelationRelationship> imijCorrRelMap, double maxDist, ArbitrarilyDiscretizedFunc magDistFilter) {
        int j;
        int numRuptures;
        int i;
        this.signalReset();
        for (ScalarIMR imri : imriMap.values()) {
            imri.resetParameterEventListeners();
            imri.setUserMaxDistance(maxDist);
            imri.setSite(this.site);
        }
        int numSources = this.eqkRupForecast.getNumSources();
        double[][] mulnIMi_RupIMj = new double[numSources][];
        double[][] stdlnIMi_RupIMj = new double[numSources][];
        boolean includeMagDistFilter = magDistFilter != null;
        double magThresh = 0.0;
        int numRupRejected = 0;
        for (i = 0; i < numSources; ++i) {
            if (this.isCancelled()) {
                return false;
            }
            ProbEqkSource source = this.eqkRupForecast.getSource(i);
            numRuptures = this.eqkRupForecast.getNumRuptures(i);
            mulnIMi_RupIMj[i] = new double[numRuptures];
            stdlnIMi_RupIMj[i] = new double[numRuptures];
            double distance = source.getMinDistance(this.site);
            if (distance > maxDist) continue;
            TectonicRegionType trt = source.getTectonicRegionType();
            ScalarIMR imri = TRTUtils.getIMRforTRT(imriMap, trt);
            ImCorrelationRelationship imijCorrRel = Utils.getIMCorrRelForTRT(imijCorrRelMap, trt);
            double rho_lnIMilnIMj = imijCorrRel.getImCorrelation();
            for (int j2 = 0; j2 < numRuptures; ++j2) {
                ProbEqkRupture rupture = source.getRupture(j2);
                if (includeMagDistFilter && rupture.getMag() < magThresh) {
                    ++numRupRejected;
                    continue;
                }
                imri.setEqkRupture(rupture);
                double mulnIMi_Rup = imri.getMean();
                double stdlnIMi_Rup = imri.getStdDev();
                mulnIMi_RupIMj[i][j2] = mulnIMi_Rup + stdlnIMi_Rup * rho_lnIMilnIMj * this.epsilonIMj[i][j2];
                stdlnIMi_RupIMj[i][j2] = stdlnIMi_Rup * Math.sqrt(1.0 - Math.pow(rho_lnIMilnIMj, 2.0));
            }
        }
        double mulnIMi_IMj = 0.0;
        for (i = 0; i < numSources; ++i) {
            int numRuptures2 = this.eqkRupForecast.getNumRuptures(i);
            for (j = 0; j < numRuptures2; ++j) {
                mulnIMi_IMj += mulnIMi_RupIMj[i][j] * this.pRup_IMj[i][j];
            }
        }
        double varlnIMi_IMj = 0.0;
        for (i = 0; i < numSources; ++i) {
            int numRuptures3 = this.eqkRupForecast.getNumRuptures(i);
            for (j = 0; j < numRuptures3; ++j) {
                varlnIMi_IMj += (Math.pow(stdlnIMi_RupIMj[i][j], 2.0) + Math.pow(mulnIMi_RupIMj[i][j] - mulnIMi_IMj, 2.0)) * this.pRup_IMj[i][j];
            }
        }
        double stdlnIMi_IMj = Math.sqrt(varlnIMi_IMj);
        for (int n = 0; n < this.zApprox.length; ++n) {
            this.imiArray[n][imiNumber] = Math.exp(mulnIMi_IMj + this.zApprox[n] * stdlnIMi_IMj);
            this.cdfIMi_IMjArray[n][imiNumber] = 0.0;
            for (int i2 = 0; i2 < numSources; ++i2) {
                numRuptures = this.eqkRupForecast.getNumRuptures(i2);
                for (int j3 = 0; j3 < numRuptures; ++j3) {
                    double z = (Math.log(this.imiArray[n][imiNumber]) - mulnIMi_RupIMj[i2][j3]) / stdlnIMi_RupIMj[i2][j3];
                    double cdfIMi_RupIMj = GaussianDistCalc.getCDF(z);
                    double[] dArray = this.cdfIMi_IMjArray[n];
                    int n2 = imiNumber;
                    dArray[n2] = dArray[n2] + cdfIMi_RupIMj * this.pRup_IMj[i2][j3];
                }
            }
        }
        return true;
    }

    public boolean getGcimRealizations(int numGcimRealizations, int numIMi, ArrayList<? extends Map<TectonicRegionType, ScalarIMR>> imiAttenRels, ArrayList<String> imiTypes, ArrayList<? extends Map<TectonicRegionType, ImCorrelationRelationship>> imijCorrRels, ArrayList<? extends Map<TectonicRegionType, ImCorrelationRelationship>> imikCorrRels, double maxDist, ArbitrarilyDiscretizedFunc magDistFilter) {
        this.numGcimRealizations = numGcimRealizations;
        this.randIMiRealizations = new double[numIMi][numGcimRealizations];
        this.randIMiRealizationStdevs = new double[numIMi][numGcimRealizations];
        for (int m = 0; m < numGcimRealizations; ++m) {
            Matrix L_matrix;
            boolean randSourceRupUpdated = this.getRandomSourceRupture();
            ProbEqkSource source = this.eqkRupForecast.getSource(this.randSourceId);
            ProbEqkRupture rupture = source.getRupture(this.randRupId);
            double[] mulnIMi_RandRupIMj = new double[numIMi];
            double[] stdlnIMi_RandRupIMj = new double[numIMi];
            double[] rho_lnIMilnIMj = new double[numIMi];
            double[][] rho_lnIMilnIMk_lnIMj = new double[numIMi][numIMi];
            double[] mulnIMi_RandRup = new double[numIMi];
            double[] stdlnIMi_RandRup = new double[numIMi];
            for (int i = 0; i < numIMi; ++i) {
                ScalarIMR imri2;
                Map<TectonicRegionType, ScalarIMR> imriMap = imiAttenRels.get(i);
                Map<TectonicRegionType, ImCorrelationRelationship> corrImijMap = imijCorrRels.get(i);
                for (ScalarIMR imri2 : imriMap.values()) {
                    imri2.resetParameterEventListeners();
                    imri2.setUserMaxDistance(maxDist);
                    imri2.setSite(this.site);
                }
                TectonicRegionType trt = source.getTectonicRegionType();
                imri2 = TRTUtils.getIMRforTRT(imriMap, trt);
                ImCorrelationRelationship imijCorrRel = Utils.getIMCorrRelForTRT(corrImijMap, trt);
                rho_lnIMilnIMj[i] = imijCorrRel.getImCorrelation();
                imri2.setEqkRupture(rupture);
                mulnIMi_RandRup[i] = imri2.getMean();
                stdlnIMi_RandRup[i] = imri2.getStdDev();
                mulnIMi_RandRupIMj[i] = mulnIMi_RandRup[i] + stdlnIMi_RandRup[i] * rho_lnIMilnIMj[i] * this.epsilonIMj[this.randSourceId][this.randRupId];
                stdlnIMi_RandRupIMj[i] = stdlnIMi_RandRup[i] * Math.sqrt(1.0 - Math.pow(rho_lnIMilnIMj[i], 2.0));
                rho_lnIMilnIMk_lnIMj[i][i] = 1.0;
                for (int k = 0; k < i; ++k) {
                    int corrImikIndex = i * (i - 1) / 2 + k;
                    Map<TectonicRegionType, ImCorrelationRelationship> corrImikMap = imikCorrRels.get(corrImikIndex);
                    ImCorrelationRelationship imikCorrRel = Utils.getIMCorrRelForTRT(corrImikMap, trt);
                    double rho_lnIMilnIMk = imikCorrRel.getImCorrelation();
                    rho_lnIMilnIMk_lnIMj[i][k] = (rho_lnIMilnIMk - rho_lnIMilnIMj[i] * rho_lnIMilnIMj[k]) / Math.sqrt((1.0 - Math.pow(rho_lnIMilnIMj[i], 2.0)) * (1.0 - Math.pow(rho_lnIMilnIMj[k], 2.0)));
                    rho_lnIMilnIMk_lnIMj[k][i] = rho_lnIMilnIMk_lnIMj[i][k];
                }
            }
            Matrix rho_lnIMilnIMk_lnIMj_matrix = new Matrix(rho_lnIMilnIMk_lnIMj);
            CholeskyDecomposition cholDecomp = new CholeskyDecomposition(rho_lnIMilnIMk_lnIMj_matrix);
            if (cholDecomp.isSPD()) {
                L_matrix = cholDecomp.getL();
            } else {
                this.corrMatrixPD = false;
                this.corrMatrixNotPDString = this.getMatrixAsString(rho_lnIMilnIMk_lnIMj_matrix);
                System.out.println("The corr matrix below is not PD");
                rho_lnIMilnIMk_lnIMj_matrix.print(10, 4);
                NearPD nearPd = new NearPD();
                nearPd.setKeepDiag(true);
                boolean success = nearPd.calcNearPD(rho_lnIMilnIMk_lnIMj_matrix);
                this.normFrob = nearPd.getFrobNorm();
                if (!success) {
                    throw new RuntimeException("Error: nearPD failed to converge, the correlation matrix maybe significantly different from a PD matrix, check that the correlation equationsused are reasonable");
                }
                Matrix rho_lnIMilnIMk_lnIMj_PDmatrix = nearPd.getX();
                this.corrMatrixPDString = this.getMatrixAsString(rho_lnIMilnIMk_lnIMj_PDmatrix);
                System.out.println("This is the nearest PD matrix to corr matrix");
                rho_lnIMilnIMk_lnIMj_PDmatrix.print(10, 6);
                CholeskyDecomposition cholDecompPD = new CholeskyDecomposition(rho_lnIMilnIMk_lnIMj_PDmatrix);
                if (cholDecompPD.isSPD()) {
                    L_matrix = cholDecompPD.getL();
                } else {
                    throw new RuntimeException("Error: Even after NearPD the matrix is not PD");
                }
            }
            Random generator = new Random();
            double[][] randArray = new double[numIMi][1];
            for (int i = 0; i < numIMi; ++i) {
                randArray[i][0] = generator.nextGaussian();
            }
            Matrix randArray_matrix = new Matrix(randArray);
            Matrix corrRandArray_matrix = L_matrix.times(randArray_matrix);
            for (int i = 0; i < numIMi; ++i) {
                this.randIMiRealizations[i][m] = Math.exp(mulnIMi_RandRupIMj[i] + stdlnIMi_RandRupIMj[i] * corrRandArray_matrix.get(i, 0));
                this.randIMiRealizationStdevs[i][m] = stdlnIMi_RandRupIMj[i];
            }
        }
        this.gcimRealizationsComplete = true;
        return this.gcimRealizationsComplete;
    }

    public boolean getRandomSourceRupture() {
        boolean randomSourceRupUpdated = false;
        double randVal = Math.random();
        int numSources = this.eqkRupForecast.getNumSources();
        for (int i = 0; i < numSources; ++i) {
            if (!(this.sourceCdf[i] > randVal)) continue;
            this.randSourceId = i;
            break;
        }
        boolean randRupId = false;
        int numRup = this.eqkRupForecast.getSource(this.randSourceId).getNumRuptures();
        for (int j = 0; j < numRup; ++j) {
            if (!(this.rupCdf[this.randSourceId][j] > randVal)) continue;
            this.randRupId = j;
            randomSourceRupUpdated = true;
            break;
        }
        return randomSourceRupUpdated;
    }

    @Override
    public void setApproxCDFvalues(double zmin, double zmax, double dz) {
        this.num_z = (int)Math.round((zmax - zmin) / dz + 1.0);
        this.zApprox = new double[this.num_z];
        for (int i = 0; i < this.num_z; ++i) {
            this.zApprox[i] = zmin + (double)i * dz;
        }
    }

    @Override
    public void setApproxCDFvalues() {
        this.setApproxCDFvalues(-3.0, 3.0, 0.2);
    }

    @Override
    public double[] getApproxCDFvalues() {
        return this.zApprox;
    }

    @Override
    public void setGcimOutputDimensions() {
        this.imiArray = new double[this.zApprox.length][this.numIMi];
        this.cdfIMi_IMjArray = new double[this.zApprox.length][this.numIMi];
    }

    public String getGcimResultsString() {
        int i;
        this.GcimResultsString = this.GcimResultsString + "Number of IMi's considered: " + this.numIMi + "\n";
        this.GcimResultsString = this.GcimResultsString + "Number of z values for each IMi: " + this.num_z + "\n";
        this.GcimResultsString = this.GcimResultsString + "Number of GCIM realizations: " + this.numGcimRealizations + "\n";
        this.GcimResultsString = this.GcimResultsString + "--------------------------------------------------\n";
        this.GcimResultsString = this.GcimResultsString + " IMi value     Cumulative Probability, F(IMi|IMj) \n";
        String[] IMiNames = new String[this.numIMi];
        for (i = 0; i < this.numIMi; ++i) {
            Map<TectonicRegionType, ScalarIMR> imriMap = this.imiAttenRels.get(i);
            ScalarIMR firstIMRiFromMap = TRTUtils.getFirstIMR(imriMap);
            this.GcimResultsString = this.GcimResultsString + "--------------------------------------------------\n";
            IMiNames[i] = firstIMRiFromMap.getIntensityMeasure().getName() == "SA" ? "SA (" + String.valueOf(((SA_Param)firstIMRiFromMap.getIntensityMeasure()).getPeriodParam().getValue()) + "s)" : (firstIMRiFromMap.getIntensityMeasure().getName() == "SA Interpolated" ? "SA (" + String.valueOf(((SA_InterpolatedParam)firstIMRiFromMap.getIntensityMeasure()).getPeriodInterpolatedParam().getValue()) + "s)" : firstIMRiFromMap.getIntensityMeasure().getName());
            this.GcimResultsString = this.GcimResultsString + "Results for " + IMiNames[i] + "\n";
            for (int j = 0; j < this.zApprox.length; ++j) {
                this.GcimResultsString = this.GcimResultsString + this.imiArray[j][i] + "\t" + this.cdfIMi_IMjArray[j][i] + "\n";
            }
            this.GcimResultsString = this.GcimResultsString + "--------------------------------------------------\n";
            this.GcimResultsString = this.GcimResultsString + "\n";
        }
        if (this.numGcimRealizations > 0) {
            this.GcimResultsString = this.GcimResultsString + "Realization";
            for (i = 0; i < this.numIMi; ++i) {
                this.GcimResultsString = this.GcimResultsString + "  " + IMiNames[i] + "           ";
            }
            this.GcimResultsString = this.GcimResultsString + "\n   ";
            for (i = 0; i < this.numIMi; ++i) {
                this.GcimResultsString = this.GcimResultsString + "|     IMi Val     |    Cond. Stddev     ";
            }
            this.GcimResultsString = this.GcimResultsString + "\n";
            for (int m = 0; m < this.numGcimRealizations; ++m) {
                this.GcimResultsString = this.GcimResultsString + " " + (m + 1) + " ";
                for (int i2 = 0; i2 < this.numIMi; ++i2) {
                    this.GcimResultsString = this.GcimResultsString + " " + this.randIMiRealizations[i2][m] + " " + this.randIMiRealizationStdevs[i2][m] + " ";
                }
                this.GcimResultsString = this.GcimResultsString + "\n";
            }
        }
        this.GcimResultsString = this.GcimResultsString + "\n";
        this.GcimResultsString = this.GcimResultsString + "Additional Notes/Comments: \n";
        this.GcimResultsString = this.GcimResultsString + "--------------------------------------------------\n";
        if (!this.corrMatrixPD) {
            this.GcimResultsString = this.GcimResultsString + "The conditional correlation matrix was not positive definite\nThe original correlation matrix was: Rho = \n" + this.corrMatrixNotPDString + "\nThe nearest PD correlation matrix used was: Rho_PD = \n" + this.corrMatrixPDString + "\nThe Frobenius norm of the difference of these two matricies is: \nnormFrob = " + this.normFrob + "\n";
        }
        return this.GcimResultsString;
    }

    private String getMatrixAsString(Matrix A) {
        Object aAsString = "";
        int m = A.getRowDimension();
        int n = A.getColumnDimension();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                aAsString = (String)aAsString + " " + (double)Math.round(A.get(i, j) * 100000.0) / 100000.0;
            }
            aAsString = (String)aAsString + "\n";
        }
        return aAsString;
    }

    public void printResultsToConsole() {
        System.out.println(this.GcimResultsString);
    }

    private static void setSAPeriodInIMR(ScalarIMR imr, double period) {
        imr.getIntensityMeasure().getIndependentParameter("SA Period").setValue(period);
    }

    public int getCurrIMi() throws RemoteException {
        return this.currentIMi;
    }

    public int getTotIMi() throws RemoteException {
        return this.numIMi;
    }

    public boolean done() throws RemoteException {
        return this.gcimComplete;
    }
}

