/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim.imCorrRel.imCorrRelImpl;

import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.sha.gcim.imCorrRel.ImCorrelationRelationship;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodInterpolatedParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_InterpolatedParam;
import org.opensha.sha.imr.param.OtherParams.TectonicRegionTypeParam;
import org.opensha.sha.util.TectonicRegionType;

public class GodaAtkinson09_ImCorrRel
extends ImCorrelationRelationship {
    static final String C = "GodaAtkinson09_ImCorrRel";
    public static final String NAME = "Goda and Atkinson (2009)";
    public static final String SHORT_NAME = "GA2009";
    private static final long serialVersionUID = 1234567890987654353L;
    public static final String TRT_SUBDUCTION_INTERFACE = TectonicRegionType.SUBDUCTION_INTERFACE.toString();
    public static final String TRT_SUBDUCTION_SLAB = TectonicRegionType.SUBDUCTION_SLAB.toString();
    private double t_min = 0.1;
    private double t_max = 5.0;

    public GodaAtkinson09_ImCorrRel() {
        this.initOtherParams();
        this.initSupportedIntensityMeasureParams();
        this.ti = Double.NaN;
        this.tj = Double.NaN;
    }

    @Override
    public double getImCorrelation() {
        if (this.imi.getName() == "SA Interpolated" && this.imj.getName() == "SA Interpolated") {
            this.ti = (Double)((SA_InterpolatedParam)this.imi).getPeriodInterpolatedParam().getValue();
            this.tj = (Double)((SA_InterpolatedParam)this.imj).getPeriodInterpolatedParam().getValue();
            double t_min = Math.min(this.ti, this.tj);
            double t_max = Math.max(this.ti, this.tj);
            double theta1 = 1.374;
            double theta2 = 5.586;
            double theta3 = 0.728;
            double Itmin = t_min < 0.25 ? 1.0 : 0.0;
            double term1 = theta1 + theta2 * Itmin * Math.pow(t_min / t_max, theta3) * Math.log10(t_min / 0.25);
            double rho = 0.3333333333333333 * (1.0 - Math.cos(1.5707963267948966 - term1 * Math.log10(t_max / t_min))) + 0.3333333333333333 * (1.0 + Math.cos(-1.5 * Math.log10(t_max / t_min)));
            return rho;
        }
        return Double.NaN;
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        StringConstraint trtConstraint = new StringConstraint();
        trtConstraint.addString(TRT_SUBDUCTION_INTERFACE);
        trtConstraint.addString(TRT_SUBDUCTION_SLAB);
        this.tectonicRegionTypeParam = new TectonicRegionTypeParam(trtConstraint, TRT_SUBDUCTION_INTERFACE);
        this.tectonicRegionTypeParam.setValueAsDefault();
        this.otherParams.replaceParameter("Tectonic Region", this.tectonicRegionTypeParam);
    }

    protected void initSupportedIntensityMeasureParams() {
        this.InterpPeriodiParam = new PeriodInterpolatedParam(this.t_min, this.t_max, 1.0, false);
        this.saiDampingParam = new DampingParam();
        this.saiInterpParam = new SA_InterpolatedParam(this.InterpPeriodiParam, this.saiDampingParam);
        this.saiInterpParam.setNonEditable();
        this.InterpPeriodjParam = new PeriodInterpolatedParam(this.t_min, this.t_max, 1.0, false);
        this.sajDampingParam = new DampingParam();
        this.sajInterpParam = new SA_InterpolatedParam(this.InterpPeriodjParam, this.sajDampingParam);
        this.sajInterpParam.setNonEditable();
        this.supportedIMiParams.clear();
        this.supportedIMjParams.clear();
        this.supportedIMiParams.add(this.saiInterpParam);
        this.supportedIMjParams.add(this.sajInterpParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }
}

