/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim.imr.attenRelImpl.ASI_WrapperAttenRel;

import java.net.MalformedURLException;
import java.net.URL;
import org.opensha.commons.data.Named;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.gcim.imCorrRel.ImCorrelationRelationship;
import org.opensha.sha.gcim.imCorrRel.imCorrRelImpl.BakerJayaram08_ImCorrRel;
import org.opensha.sha.gcim.imr.param.IntensityMeasureParams.ASI_Param;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodInterpolatedParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_InterpolatedParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncLevelParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncTypeParam;

public class ASI_AttenRelWrapper
extends AttenuationRelationship
implements ScalarIMR,
Named,
ParameterChangeListener {
    private static final String C = "ASI_AttenRelWrapper";
    private static final boolean D = false;
    public static final String SHORT_NAME = "ASI";
    private static final long serialVersionUID = 1234567890987654353L;
    private AttenuationRelationship attenRelToWrap;
    PeriodInterpolatedParam origPeriodParam;
    private ASI_Param asiParam;
    private ImCorrelationRelationship corr;
    double[] ti;
    double[] intWeight;
    double[] meanLnSa;
    double[] sigmaLnSa;
    double[] meanSa;
    double[] sigmaSa;
    double meanLnAsi;
    double sigmaLnAsi;
    int numIntPoints = 9;
    public static final String NAME = "ASI Atten Rel Wrapper";
    private static final String URL_INFO_STRING = null;
    private boolean parameterChange;
    private transient ParameterChangeWarningListener warningListener = null;

    public ASI_AttenRelWrapper() {
    }

    public ASI_AttenRelWrapper(ParameterChangeWarningListener warningListener, AttenuationRelationship attenRelToWrap) {
        this.attenRelToWrap = attenRelToWrap;
        attenRelToWrap.setIntensityMeasure("SA Interpolated");
        this.warningListener = warningListener;
        this.setDefaultImCorrRel();
        this.initSupportedIntensityMeasureParams();
        this.siteParams = attenRelToWrap.getSiteParams();
        this.eqkRuptureParams = attenRelToWrap.getEqkRuptureParams();
        this.propagationEffectParams = attenRelToWrap.getPropagationEffectParams();
        this.otherParams = attenRelToWrap.getOtherParams();
        this.sigmaTruncTypeParam = (SigmaTruncTypeParam)this.otherParams.getParameter("Gaussian Truncation");
        this.sigmaTruncLevelParam = (SigmaTruncLevelParam)this.otherParams.getParameter("Truncation Level");
        this.initIndependentParamLists();
        this.initParameterEventListeners();
        this.addParameterListener(this.siteParams);
        this.addParameterListener(this.eqkRuptureParams);
        this.addParameterListener(this.propagationEffectParams);
        this.addParameterListener(this.otherParams);
        this.ti = new double[this.numIntPoints];
        this.intWeight = new double[this.numIntPoints];
        this.meanLnSa = new double[this.numIntPoints];
        this.sigmaLnSa = new double[this.numIntPoints];
        this.meanSa = new double[this.numIntPoints];
        this.sigmaSa = new double[this.numIntPoints];
    }

    private void addParameterListener(ParameterList list) {
        for (Parameter<?> p : list) {
            p.addParameterChangeListener(this);
        }
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.attenRelToWrap.setEqkRupture(eqkRupture);
        this.eqkRupture = eqkRupture;
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.attenRelToWrap.setSite(site);
        this.site = site;
    }

    @Override
    protected void setPropagationEffectParams() {
    }

    @Override
    public double getMean() {
        if (this.parameterChange) {
            this.getSaAtPeriods();
            this.getMeanSigmaLnAsi();
            this.parameterChange = false;
        }
        return this.meanLnAsi;
    }

    @Override
    public double getStdDev() {
        if (this.parameterChange) {
            this.getSaAtPeriods();
            this.getMeanSigmaLnAsi();
            this.parameterChange = false;
        }
        return this.sigmaLnAsi;
    }

    public void setDefaultImCorrRel() {
        this.corr = new BakerJayaram08_ImCorrRel();
    }

    public void setImCorrRel(ImCorrelationRelationship imCorrRel) {
        this.corr = imCorrRel;
    }

    private void getSaAtPeriods() {
        for (int i = 0; i < this.numIntPoints; ++i) {
            this.ti[i] = Math.exp(Math.log(0.1) + Math.log(5.0) * ((double)i / ((double)this.numIntPoints - 1.0)));
            this.origPeriodParam.setValue(this.ti[i]);
            this.meanLnSa[i] = this.attenRelToWrap.getMean();
            this.sigmaLnSa[i] = this.attenRelToWrap.getStdDev();
            this.meanSa[i] = Math.exp(this.meanLnSa[i] + 0.5 * this.sigmaLnSa[i] * this.sigmaLnSa[i]);
            this.sigmaSa[i] = this.meanSa[i] * Math.sqrt(Math.exp(this.sigmaLnSa[i] * this.sigmaLnSa[i]) - 1.0);
        }
    }

    private void getMeanSigmaLnAsi() {
        this.corr.setIntensityMeasurei("SA Interpolated");
        this.corr.setIntensityMeasurej("SA Interpolated");
        double meanAsi = 0.0;
        double varAsi = 0.0;
        for (int i = 0; i < this.numIntPoints; ++i) {
            if (i == 0) {
                this.intWeight[0] = (this.ti[1] - this.ti[0]) / 2.0;
            } else if (i == this.numIntPoints - 1) {
                this.intWeight[this.numIntPoints - 1] = (this.ti[this.numIntPoints - 1] - this.ti[this.numIntPoints - 2]) / 2.0;
            } else {
                this.intWeight[i] = (this.ti[i + 1] - this.ti[i - 1]) / 2.0;
            }
            meanAsi += this.intWeight[i] * this.meanSa[i];
            varAsi += Math.pow(this.intWeight[i] * this.sigmaSa[i], 2.0);
            Parameter newIMTi = this.corr.getIntensityMeasurei();
            ((SA_InterpolatedParam)newIMTi).getPeriodInterpolatedParam().setValue(this.ti[i]);
            for (int j = 0; j < i; ++j) {
                Parameter newIMTj = this.corr.getIntensityMeasurej();
                ((SA_InterpolatedParam)newIMTj).getPeriodInterpolatedParam().setValue(this.ti[j]);
                double rhoLnSa = this.corr.getImCorrelation();
                double rhoSa = (Math.exp(rhoLnSa * this.sigmaLnSa[i] * this.sigmaLnSa[j]) - 1.0) / Math.sqrt((Math.exp(this.sigmaLnSa[i] * this.sigmaLnSa[i]) - 1.0) * (Math.exp(this.sigmaLnSa[j] * this.sigmaLnSa[j]) - 1.0));
                varAsi += 2.0 * rhoSa * this.intWeight[i] * this.intWeight[j] * this.sigmaSa[i] * this.sigmaSa[j];
            }
        }
        this.meanLnAsi = Math.log(meanAsi * meanAsi / Math.sqrt(varAsi + meanAsi * meanAsi));
        this.sigmaLnAsi = Math.sqrt(Math.log(varAsi / (meanAsi * meanAsi) + 1.0));
    }

    @Override
    public void setParamDefaults() {
        this.attenRelToWrap.setParamDefaults();
        this.asiParam.setValueAsDefault();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams = this.attenRelToWrap.getMeanIndependentParams();
        this.stdDevIndependentParams = this.attenRelToWrap.getStdDevIndependentParams();
        this.stdDevIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams = this.attenRelToWrap.getExceedProbIndependentParams();
        this.imlAtExceedProbIndependentParams = this.attenRelToWrap.getIML_AtExceedProbIndependentParams();
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        this.origPeriodParam = (PeriodInterpolatedParam)this.attenRelToWrap.getParameter("SA Interpolated Period");
        this.asiParam = new ASI_Param();
        this.asiParam.setNonEditable();
        this.asiParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.asiParam);
    }

    @Override
    protected void initSiteParams() {
    }

    @Override
    protected void initEqkRuptureParams() {
    }

    @Override
    protected void initPropagationEffectParams() {
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        this.parameterChange = true;
    }

    @Override
    public void resetParameterEventListeners() {
        this.attenRelToWrap.resetParameterEventListeners();
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
    }

    @Override
    public URL getInfoURL() throws MalformedURLException {
        return new URL(URL_INFO_STRING);
    }
}

