/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim.imr.attenRelImpl;

import java.util.HashMap;
import org.opensha.commons.data.Named;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.gcim.imr.param.IntensityMeasureParams.CAV_Param;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.EqkRuptureParams.DipParam;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupTopDepthParam;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistRupMinusJB_OverRupParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.imr.param.SiteParams.DepthTo2pt5kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;

public class CB_2010_CAV_AttenRel
extends AttenuationRelationship
implements ScalarIMR,
Named,
ParameterChangeListener {
    private static final String C = "CB_2010_CAV_AttenRel";
    private static final boolean D = false;
    public static final String SHORT_NAME = "CB2010";
    private static final long serialVersionUID = 1234567890987654358L;
    public static final String NAME = "Campbell & Bozorgnia (2010)";
    private static final String CB_2008_CoeffFile = "campbell_2008_coeff.txt";
    double[] c0;
    double[] c1;
    double[] c2;
    double[] c3;
    double[] c4;
    double[] c5;
    double[] c6;
    double[] c7;
    double[] c8;
    double[] c9;
    double[] c10;
    double[] c11;
    double[] c12;
    double[] k1;
    double[] k2;
    double[] k3;
    double[] s_lny;
    double[] t_lny;
    double[] s_c;
    double[] rho;
    double s_lnAF = 0.3;
    double n = 1.18;
    double c = 1.88;
    private HashMap indexFromPerHashMap;
    private double vs30;
    private double rJB;
    private double rRup;
    private double distRupMinusJB_OverRup;
    private double f_rv;
    private double f_nm;
    private double mag;
    private double depthTop;
    private double depthTo2pt5kmPerSec;
    private double dip;
    private String stdDevType;
    private Component component;
    private boolean magSaturation;
    private boolean parameterChange;
    protected static final Double MAG_WARN_MIN = 4.0;
    protected static final Double MAG_WARN_MAX = 8.5;
    protected static final Double DISTANCE_RUP_WARN_MIN = 0.0;
    protected static final Double DISTANCE_RUP_WARN_MAX = 200.0;
    protected static final Double DISTANCE_MINUS_WARN_MIN = 0.0;
    protected static final Double DISTANCE_MINUS_WARN_MAX = 50.0;
    protected static final Double VS30_WARN_MIN = 150.0;
    protected static final Double VS30_WARN_MAX = 1500.0;
    protected static final Double DEPTH_2pt5_WARN_MIN = 0.0;
    protected static final Double DEPTH_2pt5_WARN_MAX = 10.0;
    protected static final Double DIP_WARN_MIN = 15.0;
    protected static final Double DIP_WARN_MAX = 90.0;
    protected static final Double RUP_TOP_WARN_MIN = 0.0;
    protected static final Double RUP_TOP_WARN_MAX = 15.0;
    public static final String FLT_TYPE_STRIKE_SLIP = "Strike-Slip";
    public static final String FLT_TYPE_REVERSE = "Reverse";
    public static final String FLT_TYPE_NORMAL = "Normal";
    private transient ParameterChangeWarningListener warningListener = null;

    public CB_2010_CAV_AttenRel(ParameterChangeWarningListener warningListener) {
        this.warningListener = warningListener;
        this.getCoeffs();
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
    }

    public void getCoeffs() {
        this.c0 = new double[]{-4.354, -1.715};
        this.c1 = new double[]{0.942, 0.5};
        this.c2 = new double[]{-0.178, -0.53};
        this.c3 = new double[]{-0.346, -0.262};
        this.c4 = new double[]{-1.309, -2.118};
        this.c5 = new double[]{0.087, 0.17};
        this.c6 = new double[]{7.24, 5.6};
        this.c7 = new double[]{0.111, 0.28};
        this.c8 = new double[]{-0.108, -0.12};
        this.c9 = new double[]{0.362, 0.49};
        this.c10 = new double[]{2.549, 1.058};
        this.c11 = new double[]{0.09, 0.04};
        this.c12 = new double[]{1.277, 0.61};
        this.k1 = new double[]{400.0, 865.0};
        this.k2 = new double[]{-2.69, -1.186};
        this.k3 = new double[]{1.0, 1.839};
        this.s_lny = new double[]{0.371, 0.478};
        this.t_lny = new double[]{0.196, 0.219};
        this.s_c = new double[]{0.089, 0.166};
        this.rho = new double[]{0.735, 1.0};
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        double rake = eqkRupture.getAveRake();
        if (rake > 30.0 && rake < 150.0) {
            this.fltTypeParam.setValue(FLT_TYPE_REVERSE);
        } else if (rake > -150.0 && rake < -30.0) {
            this.fltTypeParam.setValue(FLT_TYPE_NORMAL);
        } else {
            this.fltTypeParam.setValue(FLT_TYPE_STRIKE_SLIP);
        }
        RuptureSurface surface = eqkRupture.getRuptureSurface();
        this.rupTopDepthParam.setValueIgnoreWarning(surface.getAveRupTopDepth());
        this.dipParam.setValueIgnoreWarning(surface.getAveDip());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.vs30Param.setValue((Double)site.getParameter("Vs30").getValue());
        this.depthTo2pt5kmPerSecParam.setValueIgnoreWarning((Double)site.getParameter("Depth 2.5 km/sec").getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
            double dist_jb = this.eqkRupture.getRuptureSurface().getDistanceJB(this.site.getLocation());
            if (this.rRup == 0.0) {
                this.distRupMinusJB_OverRupParam.setValueIgnoreWarning(0.0);
            } else {
                this.distRupMinusJB_OverRupParam.setValueIgnoreWarning((this.rRup - dist_jb) / this.rRup);
            }
        }
    }

    @Override
    public double getMean() {
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        this.rJB = this.rRup - this.distRupMinusJB_OverRup * this.rRup;
        if (Double.isNaN(this.depthTo2pt5kmPerSec)) {
            this.depthTo2pt5kmPerSec = this.vs30 <= 2500.0 ? 2.0 : 0.0;
        }
        double pga_rock = Math.exp(this.getMean(1, 1100.0, this.rRup, this.rJB, this.f_rv, this.f_nm, this.mag, this.dip, this.depthTop, this.depthTo2pt5kmPerSec, this.magSaturation, 0.0));
        double mean = this.getMean(0, this.vs30, this.rRup, this.rJB, this.f_rv, this.f_nm, this.mag, this.dip, this.depthTop, this.depthTo2pt5kmPerSec, this.magSaturation, pga_rock);
        return mean;
    }

    @Override
    public double getStdDev() {
        this.rJB = this.rRup - this.distRupMinusJB_OverRup * this.rRup;
        if (Double.isNaN(this.depthTo2pt5kmPerSec)) {
            this.depthTo2pt5kmPerSec = this.vs30 <= 2500.0 ? 2.0 : 0.0;
        }
        double pga_rock = Double.NaN;
        if (this.vs30 < this.k1[0]) {
            pga_rock = Math.exp(this.getMean(1, 1100.0, this.rRup, this.rJB, this.f_rv, this.f_nm, this.mag, this.dip, this.depthTop, this.depthTo2pt5kmPerSec, this.magSaturation, 0.0));
        }
        this.component = (Component)this.componentParam.getValue();
        double stdDev = this.getStdDev(0, this.stdDevType, this.component, this.vs30, pga_rock);
        return stdDev;
    }

    @Override
    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.fltTypeParam.setValueAsDefault();
        this.rupTopDepthParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.distRupMinusJB_OverRupParam.setValueAsDefault();
        this.cavParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
        this.depthTo2pt5kmPerSecParam.setValueAsDefault();
        this.dipParam.setValueAsDefault();
        this.vs30 = (Double)this.vs30Param.getValue();
        this.mag = (Double)this.magParam.getValue();
        this.stdDevType = (String)this.stdDevTypeParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.distRupMinusJB_OverRupParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.depthTo2pt5kmPerSecParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.rupTopDepthParam);
        this.meanIndependentParams.addParameter(this.dipParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameterList(this.meanIndependentParams);
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.stdDevIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(VS30_WARN_MIN, (double)VS30_WARN_MAX);
        this.depthTo2pt5kmPerSecParam = new DepthTo2pt5kmPerSecParam(DEPTH_2pt5_WARN_MIN, (double)DEPTH_2pt5_WARN_MAX, true);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
        this.siteParams.addParameter(this.depthTo2pt5kmPerSecParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        this.dipParam = new DipParam(DIP_WARN_MIN, (double)DIP_WARN_MAX);
        this.rupTopDepthParam = new RupTopDepthParam(RUP_TOP_WARN_MIN, (double)RUP_TOP_WARN_MAX);
        StringConstraint constraint = new StringConstraint();
        constraint.addString(FLT_TYPE_STRIKE_SLIP);
        constraint.addString(FLT_TYPE_NORMAL);
        constraint.addString(FLT_TYPE_REVERSE);
        constraint.setNonEditable();
        this.fltTypeParam = new FaultTypeParam(constraint, FLT_TYPE_STRIKE_SLIP);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
        this.eqkRuptureParams.addParameter(this.dipParam);
        this.eqkRuptureParams.addParameter(this.rupTopDepthParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.addParameterChangeWarningListener(this.warningListener);
        this.distanceRupParam.setNonEditable();
        this.distRupMinusJB_OverRupParam = new DistRupMinusJB_OverRupParameter(0.0);
        DoubleConstraint warnJB = new DoubleConstraint(DISTANCE_MINUS_WARN_MIN, DISTANCE_MINUS_WARN_MAX);
        this.distRupMinusJB_OverRupParam.addParameterChangeWarningListener(this.warningListener);
        warn.setNonEditable();
        this.distRupMinusJB_OverRupParam.setWarningConstraint(warnJB);
        this.distRupMinusJB_OverRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
        this.propagationEffectParams.addParameter(this.distRupMinusJB_OverRupParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        this.cavParam = new CAV_Param();
        this.cavParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.cavParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.GMRotI50, Component.GMRotI50, Component.RANDOM_HORZ);
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    public double getMean(int iper, double vs30, double rRup, double distJB, double f_rv, double f_nm, double mag, double dip, double depthTop, double depthTo2pt5kmPerSec, boolean magSaturation, double pga_rock) {
        double fmag = mag <= 5.5 ? this.c0[iper] + this.c1[iper] * mag : (mag > 5.5 && mag <= 6.5 ? this.c0[iper] + this.c1[iper] * mag + this.c2[iper] * (mag - 5.5) : this.c0[iper] + this.c1[iper] * mag + this.c2[iper] * (mag - 5.5) + this.c3[iper] * (mag - 6.5));
        double fdis = (this.c4[iper] + this.c5[iper] * mag) * Math.log(Math.sqrt(rRup * rRup + this.c6[iper] * this.c6[iper]));
        double ffltz = depthTop < 1.0 ? depthTop : 1.0;
        double fflt = this.c7[iper] * f_rv * ffltz + this.c8[iper] * f_nm;
        double fhngr = distJB == 0.0 ? 1.0 : (depthTop < 1.0 && distJB > 0.0 ? (Math.max(rRup, Math.sqrt(distJB * distJB + 1.0)) - distJB) / Math.max(rRup, Math.sqrt(distJB * distJB + 1.0)) : (rRup - distJB) / rRup);
        double fhngm = mag <= 6.0 ? 0.0 : (mag > 6.0 && mag < 6.5 ? 2.0 * (mag - 6.0) : 1.0);
        double fhngz = depthTop >= 20.0 ? 0.0 : (20.0 - depthTop) / 20.0;
        double fhngd = dip <= 70.0 ? 1.0 : (90.0 - dip) / 20.0;
        double fhng = this.c9[iper] * fhngr * fhngm * fhngz * fhngd;
        double fsite = vs30 < this.k1[iper] ? this.c10[iper] * Math.log(vs30 / this.k1[iper]) + this.k2[iper] * (Math.log(pga_rock + this.c * Math.pow(vs30 / this.k1[iper], this.n)) - Math.log(pga_rock + this.c)) : (vs30 < 1100.0 ? (this.c10[iper] + this.k2[iper] * this.n) * Math.log(vs30 / this.k1[iper]) : (this.c10[iper] + this.k2[iper] * this.n) * Math.log(1100.0 / this.k1[iper]));
        double fsed = depthTo2pt5kmPerSec < 1.0 ? this.c11[iper] * (depthTo2pt5kmPerSec - 1.0) : (depthTo2pt5kmPerSec <= 3.0 ? 0.0 : this.c12[iper] * this.k3[iper] * Math.exp(-0.75) * (1.0 - Math.exp(-0.25 * (depthTo2pt5kmPerSec - 3.0))));
        return fmag + fdis + fflt + fhng + fsite + fsed;
    }

    public double getStdDev(int iper, String stdDevType, Component component, double vs30, double rock_pga) {
        double sigma;
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        double tau = this.t_lny[iper];
        if (vs30 >= this.k1[iper]) {
            sigma = this.s_lny[iper];
        } else {
            double s_lnYb = Math.sqrt(this.s_lny[iper] * this.s_lny[iper] - this.s_lnAF * this.s_lnAF);
            double s_lnAb = Math.sqrt(this.s_lny[1] * this.s_lny[1] - this.s_lnAF * this.s_lnAF);
            double alpha = this.k2[iper] * rock_pga * (1.0 / (rock_pga + this.c * Math.pow(vs30 / this.k1[iper], this.n)) - 1.0 / (rock_pga + this.c));
            sigma = Math.sqrt(s_lnYb * s_lnYb + this.s_lnAF * this.s_lnAF + alpha * alpha * s_lnAb * s_lnAb + 2.0 * alpha * this.rho[iper] * s_lnYb * s_lnAb);
        }
        double sigma_total = Math.sqrt(tau * tau + sigma * sigma);
        double random_ratio = component == Component.RANDOM_HORZ ? Math.sqrt(1.0 + this.s_c[iper] * this.s_c[iper] / (sigma_total * sigma_total)) : 1.0;
        if (stdDevType.equals("Total")) {
            return sigma_total * random_ratio;
        }
        if (stdDevType.equals("Intra-Event")) {
            return sigma * random_ratio;
        }
        if (stdDevType.equals("Inter-Event")) {
            return tau * random_ratio;
        }
        return Double.NaN;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        this.parameterChange = true;
        if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals("(distRup-distJB)/distRup")) {
            this.distRupMinusJB_OverRup = (Double)val;
        } else if (pName.equals("Vs30")) {
            this.vs30 = (Double)val;
        } else if (pName.equals("Depth 2.5 km/sec")) {
            this.depthTo2pt5kmPerSec = val == null ? Double.NaN : (Double)val;
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("Fault Type")) {
            String fltType = (String)this.fltTypeParam.getValue();
            if (fltType.equals(FLT_TYPE_NORMAL)) {
                this.f_rv = 0.0;
                this.f_nm = 1.0;
            } else if (fltType.equals(FLT_TYPE_REVERSE)) {
                this.f_rv = 1.0;
                this.f_nm = 0.0;
            } else {
                this.f_rv = 0.0;
                this.f_nm = 0.0;
            }
        } else if (pName.equals("Rupture Top Depth")) {
            this.depthTop = (Double)val;
        } else if (pName.equals("Std Dev Type")) {
            this.stdDevType = (String)val;
        } else if (pName.equals("Dip")) {
            this.dip = (Double)val;
        } else if (pName.equals("Component")) {
            this.component = (Component)this.componentParam.getValue();
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.distanceRupParam.removeParameterChangeListener(this);
        this.distRupMinusJB_OverRupParam.removeParameterChangeListener(this);
        this.vs30Param.removeParameterChangeListener(this);
        this.depthTo2pt5kmPerSecParam.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.fltTypeParam.removeParameterChangeListener(this);
        this.rupTopDepthParam.removeParameterChangeListener(this);
        this.dipParam.removeParameterChangeListener(this);
        this.stdDevTypeParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceRupParam.addParameterChangeListener(this);
        this.distRupMinusJB_OverRupParam.addParameterChangeListener(this);
        this.vs30Param.addParameterChangeListener(this);
        this.depthTo2pt5kmPerSecParam.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.fltTypeParam.addParameterChangeListener(this);
        this.rupTopDepthParam.addParameterChangeListener(this);
        this.stdDevTypeParam.addParameterChangeListener(this);
        this.dipParam.addParameterChangeListener(this);
    }
}

