/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim.imr.attenRelImpl.DSI_WrapperAttenRel;

import org.opensha.commons.data.Site;
import org.opensha.commons.geo.Location;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.gcim.imr.attenRelImpl.DSI_WrapperAttenRel.BA_2008_DSI_AttenRel;

public class Test_BA08_DSI_AttenRel {
    public static void main(String[] args) {
        Location loc1 = new Location(-0.1, 0.0, 0.0);
        Location loc2 = new Location(0.1, 0.0, 0.0);
        FaultTrace faultTrace = new FaultTrace("test");
        faultTrace.add(loc1);
        faultTrace.add(loc2);
        StirlingGriddedSurface surface = new StirlingGriddedSurface(faultTrace, 45.0, 0.0, 10.0, 1.0);
        EqkRupture rup = new EqkRupture();
        rup.setMag(7.8);
        rup.setAveRake(90.0);
        rup.setRuptureSurface(surface);
        BA_2008_DSI_AttenRel attenRel = new BA_2008_DSI_AttenRel(null);
        attenRel.setParamDefaults();
        attenRel.setIntensityMeasure("DSI");
        attenRel.setEqkRupture(rup);
        Site site = new Site();
        site.addParameter(attenRel.getParameter("Vs30"));
        for (double dist = 0.0; dist <= 0.3; dist += 0.01) {
            Location loc = new Location(0.0, dist);
            site.setLocation(loc);
            attenRel.setSite(site);
            double mu = attenRel.getMean();
            double sigma = attenRel.getStdDev();
            System.out.println("  " + dist + " " + Math.exp(mu) + " " + sigma);
        }
    }
}

