/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim.imr.attenRelImpl;

import org.opensha.commons.data.Named;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.gcim.imr.param.IntensityMeasureParams.Ds575_Param;
import org.opensha.sha.gcim.imr.param.IntensityMeasureParams.Ds595_Param;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;

public class KS_2006_AttenRel
extends AttenuationRelationship
implements ScalarIMR,
Named,
ParameterChangeListener {
    private static final String C = "KS_2006_AttenRel";
    private static final boolean D = false;
    public static final String SHORT_NAME = "KS2006";
    private static final long serialVersionUID = 1234567890987654358L;
    public static final String NAME = "Kempton & Stewart (2006)";
    double beta = 3.2;
    double Mstar = 6.0;
    double[] b1 = new double[]{6.02, 2.79, 5.46, 1.53};
    double[] b2 = new double[]{0.0, 0.82, 0.0, 1.34};
    double[] c2 = new double[]{0.07, 0.15, 0.1, 0.15};
    double[] c4 = new double[]{0.82, 3.0, 1.4, 3.99};
    double[] c5 = new double[]{-0.0013, -0.0041, -0.0022, -0.0062};
    double[] tau = new double[]{0.32, 0.26, 0.45, 0.31};
    double[] sigma = new double[]{0.42, 0.36, 0.51, 0.39};
    double[] sigmaT = new double[]{0.53, 0.44, 0.68, 0.5};
    private int imIndex;
    private double vs30;
    private double rRup;
    private double mag;
    private String stdDevType;
    private boolean parameterChange;
    protected static final Double MAG_WARN_MIN = 5.0;
    protected static final Double MAG_WARN_MAX = 7.6;
    protected static final Double DISTANCE_RUP_WARN_MIN = 0.0;
    protected static final Double DISTANCE_RUP_WARN_MAX = 200.0;
    protected static final Double VS30_WARN_MIN = 150.0;
    protected static final Double VS30_WARN_MAX = 1500.0;
    private transient ParameterChangeWarningListener warningListener = null;

    public KS_2006_AttenRel(ParameterChangeWarningListener warningListener) {
        this.warningListener = warningListener;
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.vs30Param.setValue((Double)site.getParameter("Vs30").getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
        }
    }

    protected void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("KS_2006_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        if (this.im.getName().equalsIgnoreCase("Ds575")) {
            this.imIndex = 0;
        } else if (this.im.getName().equalsIgnoreCase("Ds595")) {
            this.imIndex = 1;
        }
        this.parameterChange = true;
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        double mean = this.getMean(this.imIndex, this.vs30, this.rRup, this.mag);
        return mean;
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        double stdDev = this.getStdDev(this.imIndex, this.stdDevType);
        return stdDev;
    }

    @Override
    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.ds575Param.setValueAsDefault();
        this.ds595Param.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
        this.vs30 = (Double)this.vs30Param.getValue();
        this.mag = (Double)this.magParam.getValue();
        this.stdDevType = (String)this.stdDevTypeParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(VS30_WARN_MIN, (double)VS30_WARN_MAX);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.addParameterChangeWarningListener(this.warningListener);
        this.distanceRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        this.ds575Param = new Ds575_Param();
        this.ds575Param.setNonEditable();
        this.ds595Param = new Ds595_Param();
        this.ds595Param.setNonEditable();
        this.ds575Param.addParameterChangeWarningListener(this.warningListener);
        this.ds595Param.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.ds575Param);
        this.supportedIMParams.addParameter(this.ds595Param);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.AVE_HORZ, Component.AVE_HORZ);
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    public double getMean(int imIndex, double vs30, double rRup, double mag) {
        double meanPart1 = Math.exp(this.b1[imIndex] + this.b2[imIndex] * (mag - this.Mstar)) / Math.pow(10.0, 1.5 * mag + 16.05);
        double meanPart2 = 4.9 * Math.pow(10.0, 6.0) * this.beta;
        double meanPart3 = rRup * this.c2[imIndex] + (this.c4[imIndex] + this.c5[imIndex] * vs30);
        double lnDs = Math.log(Math.pow(meanPart1, -0.3333333333333333) / meanPart2 + meanPart3);
        return lnDs;
    }

    public double getStdDev(int imIndex, String stdDevType) {
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        if (stdDevType.equals("Total")) {
            return this.sigmaT[imIndex];
        }
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        if (stdDevType.equals("Inter-Event")) {
            return this.tau[imIndex];
        }
        if (stdDevType.equals("Intra-Event")) {
            return this.sigma[imIndex];
        }
        return Double.NaN;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        this.parameterChange = true;
        if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals("Vs30")) {
            this.vs30 = (Double)val;
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("Std Dev Type")) {
            this.stdDevType = (String)val;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.distanceRupParam.removeParameterChangeListener(this);
        this.vs30Param.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.stdDevTypeParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceRupParam.addParameterChangeListener(this);
        this.vs30Param.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.stdDevTypeParam.addParameterChangeListener(this);
    }
}

