/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import org.opensha.commons.data.Site;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.gcim.Utils;
import org.opensha.sha.gcim.imCorrRel.ImCorrelationRelationship;
import org.opensha.sha.gcim.imCorrRel.event.IMCorrRelChangeEvent;
import org.opensha.sha.gcim.imCorrRel.event.IMCorrRelChangeListener;
import org.opensha.sha.gcim.ui.GcimControlPanel;
import org.opensha.sha.gcim.ui.GcimSite_GuiBean;
import org.opensha.sha.gcim.ui.IMCorrRel_MultiGuiBean;
import org.opensha.sha.gcim.ui.IMT_GcimGuiBean;
import org.opensha.sha.gcim.ui.infoTools.AttenuationRelationshipsInstance;
import org.opensha.sha.gcim.ui.infoTools.ImCorrelationRelationshipsInstance;
import org.opensha.sha.gui.beans.IMR_MultiGuiBean;
import org.opensha.sha.gui.beans.event.IMTChangeEvent;
import org.opensha.sha.gui.beans.event.IMTChangeListener;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.event.ScalarIMRChangeEvent;
import org.opensha.sha.imr.event.ScalarIMRChangeListener;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_InterpolatedParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.util.TRTUtils;
import org.opensha.sha.util.TectonicRegionType;

public class GcimEditIMiControlPanel
extends JFrame
implements ParameterChangeListener,
ActionListener,
ScalarIMRChangeListener,
IMTChangeListener,
IMCorrRelChangeListener {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "GcimEditIMiControlPanel";
    protected static final boolean D = false;
    protected ArrayList<Object> functionList = new ArrayList();
    GcimControlPanel parent;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JFrame frame;
    private Component parentComponent;
    private int imiIndex;
    private boolean guiInitialized = false;
    private JSplitPane imrImtSplitPane;
    private JSplitPane imCorrRelSiteSplitPane;
    protected IMR_MultiGuiBean imrGuiBean;
    protected IMCorrRel_MultiGuiBean imCorrRelGuiBean;
    private IMT_GcimGuiBean imtGuiBean;
    protected GcimSite_GuiBean siteGuiBean;
    private Site parentSite;
    private Site gcimSite;
    private Parameter<Double> parentIMj;
    private ArrayList<String> ParentIMiList;
    private ArrayList<String> ParentIMiListCurrentIMiRemoved;
    protected CalcProgressBar startAppProgressClass;
    protected static final String versionURL = "http://www.opensha.org/applications/hazCurvApp/HazardCurveApp_Version.txt";
    protected static final String appURL = "http://www.opensha.org/applications/hazCurvApp/HazardCurveServerModeApp.jar";
    protected static final String versionUpdateInfoURL = "http://www.opensha.org/applications/hazCurvApp/versionUpdate.html";

    public GcimEditIMiControlPanel(GcimControlPanel parent, Component parentComponent, int imiIndex) {
        super(NAME);
        this.parent = parent;
        this.parentComponent = parentComponent;
        this.imiIndex = imiIndex;
        this.getParentSite();
        this.getGcimSite();
        this.getParentIMjName();
        this.getParentIMiList();
    }

    public void init(int index) {
        double period;
        Map<TectonicRegionType, ImCorrelationRelationship> imijCorrRels = this.parent.getImijCorrRel(index);
        Map<TectonicRegionType, ScalarIMR> imiAttenRels = this.parent.getImiAttenRel(index);
        String imiType = this.parent.getImiType(index);
        try {
            this.initIMR_GuiBean();
            this.initIMCorrRel_GuiBean();
            this.initSiteGuiBean();
            this.ParentIMiListCurrentIMiRemoved = (ArrayList)this.ParentIMiList.clone();
            this.ParentIMiListCurrentIMiRemoved.remove(index);
            this.initIMT_GuiBean();
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ImCorrelationRelationship firstIMCorrRelFromMap = Utils.getFirstIMCorrRel(imijCorrRels);
        ScalarIMR firstIMRFromMap = TRTUtils.getFirstIMR(imiAttenRels);
        this.imtGuiBean.setSelectedIMT(imiType);
        if (imiType == "SA") {
            period = (Double)((SA_Param)firstIMRFromMap.getIntensityMeasure()).getPeriodParam().getValue();
            this.imtGuiBean.setSelectedIMTPeriod(period);
        } else if (imiType == "SA Interpolated") {
            period = (Double)((SA_InterpolatedParam)firstIMRFromMap.getIntensityMeasure()).getPeriodInterpolatedParam().getValue();
            this.imtGuiBean.setSelectedIMTPeriod(period);
        }
        int numTecRegionImijCorrRel = imijCorrRels.size();
        if (numTecRegionImijCorrRel == 1) {
            this.imCorrRelGuiBean.setSelectedSingleIMCorrRel(firstIMCorrRelFromMap.getName());
        } else {
            this.imCorrRelGuiBean.setMultipleIMCorrRels(true);
            for (TectonicRegionType trt : imijCorrRels.keySet()) {
                ImCorrelationRelationship imCorrRel = imijCorrRels.get(trt);
                this.imCorrRelGuiBean.setIMCorrRel(imCorrRel.getName(), trt);
            }
        }
        boolean setDefaultIMikCorrRelinGUIsuccess = this.setDefaultIMikCorrRelinGUI();
        int numTecRegionImiAttenRel = imiAttenRels.size();
        if (numTecRegionImiAttenRel == 1) {
            this.imrGuiBean.setSelectedSingleIMR(firstIMRFromMap.getName());
        } else {
            this.imrGuiBean.setMultipleIMRs(true);
            for (TectonicRegionType trt : imiAttenRels.keySet()) {
                ScalarIMR imr = imiAttenRels.get(trt);
                this.imrGuiBean.setIMR(imr.getName(), trt);
            }
        }
        this.guiInitialized = true;
        this.imtGuiBean.setIMTinIMRs(this.imrGuiBean.getIMRMap());
        this.imtGuiBean.setIMTsinIMCorrRels(this.imCorrRelGuiBean.getIMCorrRelMap(), this.parentIMj);
        int imiIndex = this.imiIndex;
        int numIMikCorrRelsToSet = (imiIndex + 1) * imiIndex / 2 - imiIndex * (imiIndex - 1) / 2;
        ArrayList<HashMap<TectonicRegionType, ImCorrelationRelationship>> IMikCorrRelMapList = null;
        if (numIMikCorrRelsToSet > 0) {
            IMikCorrRelMapList = this.imCorrRelGuiBean.getIMikCorrRelMap();
        }
        for (int m = 0; m < numIMikCorrRelsToSet; ++m) {
            Map IMikCorrRelMap = IMikCorrRelMapList.get(m);
            Parameter<Double> imi = this.parent.getImiParam(m);
            this.imtGuiBean.setIMTsinIMCorrRels(IMikCorrRelMap, imi);
        }
        this.parent.updateIMiDetailsInArrayLists(imiIndex);
        this.parent.updateIMiNames();
    }

    public void init() {
        try {
            this.initIMR_GuiBean();
            this.initIMCorrRel_GuiBean();
            this.initSiteGuiBean();
            this.ParentIMiListCurrentIMiRemoved = this.ParentIMiList;
            this.initIMT_GuiBean();
            this.jbInit();
            boolean setDefaultIMRinGUIsuccess = this.setDefaultIMRinGUI();
            boolean setDefaultIMCorrRelinGUIsuccess = this.setDefaultIMCorrRelinGUI();
            boolean setDefaultIMikCorrRelinGUIsuccess = this.setDefaultIMikCorrRelinGUI();
            boolean setDefaultIMTinGUIsuccess = this.setDefaultIMTinIMTGUI();
            this.guiInitialized = true;
            this.imtGuiBean.setIMTinIMRs(this.imrGuiBean.getIMRMap());
            this.imtGuiBean.setIMTsinIMCorrRels(this.imCorrRelGuiBean.getIMCorrRelMap(), this.parentIMj);
            int imiIndex = this.imiIndex;
            int numIMikCorrRelsToSet = (imiIndex + 1) * imiIndex / 2 - imiIndex * (imiIndex - 1) / 2;
            ArrayList<HashMap<TectonicRegionType, ImCorrelationRelationship>> IMikCorrRelMapList = null;
            if (numIMikCorrRelsToSet > 0) {
                IMikCorrRelMapList = this.imCorrRelGuiBean.getIMikCorrRelMap();
            }
            for (int m = 0; m < numIMikCorrRelsToSet; ++m) {
                Map IMikCorrRelMap = IMikCorrRelMapList.get(m);
                Parameter<Double> imi = this.parent.getImiParam(m);
                this.imtGuiBean.setIMTsinIMCorrRels(IMikCorrRelMap, imi);
            }
            this.parent.updateIMiDetailsInArrayLists(imiIndex);
            this.parent.updateIMiNames();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void jbInit() throws Exception {
        Color bg = new Color(220, 220, 220);
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.imrImtSplitPane = new JSplitPane(0, true, this.imtGuiBean, this.imrGuiBean);
        this.imrImtSplitPane.setResizeWeight(0.18);
        this.imrImtSplitPane.setBorder(null);
        this.imrImtSplitPane.setOpaque(false);
        this.imrImtSplitPane.setMinimumSize(new Dimension(80, 100));
        this.imrImtSplitPane.setPreferredSize(new Dimension(80, 100));
        this.imCorrRelSiteSplitPane = new JSplitPane(0, true, this.imCorrRelGuiBean, this.siteGuiBean);
        this.imCorrRelSiteSplitPane.setResizeWeight(0.18);
        this.imCorrRelSiteSplitPane.setBorder(null);
        this.imCorrRelSiteSplitPane.setOpaque(false);
        this.imCorrRelSiteSplitPane.setMinimumSize(new Dimension(80, 100));
        this.imCorrRelSiteSplitPane.setPreferredSize(new Dimension(80, 100));
        JSplitPane imrImtImCorrRelSiteSplitPane = new JSplitPane(1, true, this.imrImtSplitPane, this.imCorrRelSiteSplitPane);
        imrImtImCorrRelSiteSplitPane.setResizeWeight(0.5);
        imrImtImCorrRelSiteSplitPane.setBorder(BorderFactory.createEmptyBorder(2, 8, 8, 8));
        imrImtImCorrRelSiteSplitPane.setOpaque(false);
        imrImtImCorrRelSiteSplitPane.setMinimumSize(new Dimension(160, 100));
        imrImtImCorrRelSiteSplitPane.setPreferredSize(new Dimension(160, 100));
        imrImtImCorrRelSiteSplitPane.setBorder(null);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)imrImtImCorrRelSiteSplitPane, "Center");
        this.setTitle("Edit IMi : GCIM panel");
        this.setSize(500, 500);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int xPos = (dim.width - this.getWidth()) / 2;
        this.setLocation(xPos, 0);
    }

    public boolean setDefaultIMRinGUI() {
        AttenuationRelationshipsInstance instances = new AttenuationRelationshipsInstance();
        ArrayList<ScalarIMR> imrs = instances.createIMRClassInstance(null);
        for (ScalarIMR imr : imrs) {
            if (!imr.isIntensityMeasureSupported(this.imtGuiBean.getSelectedIMT())) continue;
            this.imrGuiBean.setSelectedSingleIMR(imr.getName());
            return true;
        }
        return false;
    }

    public boolean setDefaultIMikCorrRelinGUI() {
        int imiIndex = this.imiIndex;
        int numIMikCorrRelsToSet = (imiIndex + 1) * imiIndex / 2 - imiIndex * (imiIndex - 1) / 2;
        for (int m = 0; m < numIMikCorrRelsToSet; ++m) {
            boolean setDefaultIMikCorrRelinGUIsuccess = this.setDefaultIMikCorrRelinGUI(m, this.ParentIMiList.get(m));
            if (setDefaultIMikCorrRelinGUIsuccess) continue;
            return false;
        }
        return true;
    }

    public boolean setDefaultIMCorrRelinGUI() {
        ImCorrelationRelationshipsInstance imCorrRelInstances = new ImCorrelationRelationshipsInstance();
        ArrayList<ImCorrelationRelationship> imCorrRels = imCorrRelInstances.createImCorrRelClassInstance(null);
        for (ImCorrelationRelationship imCorrRel : imCorrRels) {
            ArrayList<Parameter<?>> imjParamList = imCorrRel.getSupportedIntensityMeasuresjList();
            for (int i = 0; i < imjParamList.size(); ++i) {
                ArrayList<Parameter<?>> imiParamList;
                Parameter<?> imiParam;
                Parameter<?> imjParam = imjParamList.get(i);
                if (imjParam.getName() != this.parentIMj.getName() || (imiParam = (imiParamList = imCorrRel.getSupportedIntensityMeasuresiList()).get(i)).getName() != this.imtGuiBean.getSelectedIMT()) continue;
                this.imCorrRelGuiBean.setSelectedSingleIMCorrRel(imCorrRel.getName());
                return true;
            }
        }
        return false;
    }

    public boolean setDefaultIMikCorrRelinGUI(int index, String imkName) {
        ImCorrelationRelationshipsInstance imCorrRelInstances = new ImCorrelationRelationshipsInstance();
        ArrayList<ImCorrelationRelationship> imCorrRels = imCorrRelInstances.createImCorrRelClassInstance(null);
        for (ImCorrelationRelationship imCorrRel : imCorrRels) {
            ArrayList<Parameter<?>> imkParamList = imCorrRel.getSupportedIntensityMeasuresjList();
            for (int i = 0; i < imkParamList.size(); ++i) {
                ArrayList<Parameter<?>> imiParamList;
                Parameter<?> imiParam;
                Parameter<?> imkParam = imkParamList.get(i);
                if (imkParam.getName() != imkName || (imiParam = (imiParamList = imCorrRel.getSupportedIntensityMeasuresiList()).get(i)).getName() != this.imtGuiBean.getSelectedIMT()) continue;
                this.imCorrRelGuiBean.setSelectedSingleIMikCorrRel(index, imCorrRel);
                return true;
            }
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    protected void setImtPanel(ParameterListEditor panel, double resizeWeight) {
        this.imrImtSplitPane.setTopComponent(panel);
        this.imrImtSplitPane.setResizeWeight(resizeWeight);
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String S = "GcimEditIMiControlPanel: parameterChange(): ";
        String e = event.getParameterName();
        if (e.equalsIgnoreCase("IMR")) {
            this.updateSiteParams();
        }
    }

    protected void initIMR_GuiBean() {
        AttenuationRelationshipsInstance instances = new AttenuationRelationshipsInstance();
        ArrayList<ScalarIMR> imrs = instances.createIMRClassInstance(null);
        for (ScalarIMR imr : imrs) {
            imr.setParamDefaults();
        }
        this.imrGuiBean = new IMR_MultiGuiBean(imrs);
        this.imrGuiBean.addIMRChangeListener(this);
        this.imrGuiBean.setMaxChooserChars(30);
        this.imrGuiBean.rebuildGUI();
        this.imrGuiBean.setTectonicRegions(this.parent.getIncludedTectonicRegionTypes());
    }

    private void initIMT_GuiBean() {
        this.imtGuiBean = new IMT_GcimGuiBean(this.imrGuiBean, this.imCorrRelGuiBean, this.parentIMj, this.ParentIMiListCurrentIMiRemoved);
        this.imtGuiBean.addIMTChangeListener(this);
        this.imtGuiBean.setMinimumSize(new Dimension(200, 90));
        this.imtGuiBean.setPreferredSize(new Dimension(290, 220));
    }

    private boolean setDefaultIMTinIMTGUI() {
        try {
            this.imtGuiBean.setSelectedIMT(this.imtGuiBean.getIMTParams().iterator().next().getName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    protected void initIMCorrRel_GuiBean() {
        ImCorrelationRelationshipsInstance instances = new ImCorrelationRelationshipsInstance();
        ArrayList<ImCorrelationRelationship> imCorrRels = instances.createImCorrRelClassInstance(null);
        this.imCorrRelGuiBean = new IMCorrRel_MultiGuiBean(imCorrRels, this.parentIMj);
        this.imCorrRelGuiBean.addIMCorrRelChangeListener(this);
        this.imCorrRelGuiBean.setMaxChooserChars(30);
        this.imCorrRelGuiBean.rebuildGUI();
        this.imCorrRelGuiBean.setTectonicRegions(this.parent.getIncludedTectonicRegionTypes());
    }

    protected void initSiteGuiBean() {
        this.siteGuiBean = new GcimSite_GuiBean(this, this.parentSite, this.gcimSite);
        this.siteGuiBean.addSiteParams(this.imrGuiBean.getMultiIMRSiteParamIterator());
    }

    public String getSelectedIMT() {
        return this.imtGuiBean.getSelectedIMT();
    }

    public Parameter<Double> getSelectedIM() {
        return this.imtGuiBean.getSelectedIM();
    }

    public Map<TectonicRegionType, ScalarIMR> getSelectedIMRMap() {
        return this.imrGuiBean.getIMRMap();
    }

    public Map<TectonicRegionType, ImCorrelationRelationship> getSelectedIMCorrRelMap() {
        return this.imCorrRelGuiBean.getIMCorrRelMap();
    }

    public ArrayList<? extends Map<TectonicRegionType, ImCorrelationRelationship>> getSelectedIMikjCorrRelMap() {
        return this.imCorrRelGuiBean.getIMikCorrRelMap();
    }

    public IMT_GcimGuiBean getIMTGuiBeanInstance() {
        return this.imtGuiBean;
    }

    public IMR_MultiGuiBean getIMRGuiBeanInstance() {
        return this.imrGuiBean;
    }

    public void updateSiteParams() {
        this.siteGuiBean.replaceSiteParams(this.imrGuiBean.getMultiIMRSiteParamIterator());
        this.siteGuiBean.validate();
        this.siteGuiBean.repaint();
    }

    @Override
    public void imrChange(ScalarIMRChangeEvent event) {
        this.updateSiteParams();
        if (this.guiInitialized) {
            this.imtGuiBean.setIMTinIMRs(this.imrGuiBean.getIMRMap());
            this.parent.updateIMiDetailsInArrayLists(this.imiIndex);
        }
    }

    @Override
    public void imCorrRelChange(IMCorrRelChangeEvent event) {
        if (this.guiInitialized) {
            this.imtGuiBean.setIMTsinIMCorrRels(this.imCorrRelGuiBean.getIMCorrRelMap(), this.parentIMj);
            this.parent.updateIMiDetailsInArrayLists(this.imiIndex);
        }
    }

    @Override
    public void imtChange(IMTChangeEvent e) {
        if (this.guiInitialized) {
            this.imtGuiBean.setIMTinIMRs(this.imrGuiBean.getIMRMap());
            this.imtGuiBean.setIMTsinIMCorrRels(this.imCorrRelGuiBean.getIMCorrRelMap(), this.parentIMj);
            boolean setDefaultIMikCorrRelinGUIsuccess = this.setDefaultIMikCorrRelinGUI();
            int imiIndex = this.imiIndex;
            int numIMikCorrRelsToSet = (imiIndex + 1) * imiIndex / 2 - imiIndex * (imiIndex - 1) / 2;
            ArrayList<HashMap<TectonicRegionType, ImCorrelationRelationship>> IMikCorrRelMapList = null;
            if (numIMikCorrRelsToSet > 0) {
                IMikCorrRelMapList = this.imCorrRelGuiBean.getIMikCorrRelMap();
            }
            for (int m = 0; m < numIMikCorrRelsToSet; ++m) {
                Map IMikCorrRelMap = IMikCorrRelMapList.get(m);
                Parameter<Double> imi = this.parent.getImiParam(m);
                this.imtGuiBean.setIMTsinIMCorrRels(IMikCorrRelMap, imi);
            }
            this.parent.updateIMiDetailsInArrayLists(imiIndex);
        }
        this.parent.updateIMiNames();
        this.parent.updateIMiListGuiDisplay();
        String blank = "blank";
        this.parent.setParamsVisible(blank);
    }

    public void getParentSite() {
        this.parentSite = this.parent.getSite();
    }

    public int getImiIndex() {
        return this.imiIndex;
    }

    public void getGcimSite() {
        this.gcimSite = this.parent.getGcimSite();
    }

    public void updateGcimSite(Site gcimSite) {
        this.gcimSite = gcimSite;
        this.parent.updateGcimSite(gcimSite);
    }

    public Parameter<Double> getParentIMjName() {
        this.parentIMj = this.parent.getParentIMj();
        return this.parentIMj;
    }

    public ArrayList<String> getParentIMiList() {
        this.ParentIMiList = this.parent.getImiTypes();
        return this.ParentIMiList;
    }

    public Parameter<Double> getIMTSelectedInIMTGUI() {
        return this.imtGuiBean.getSelectedIM();
    }
}

