/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.opensha.commons.gui.LabeledBoxPanel;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.util.ListUtils;
import org.opensha.commons.util.NtoNMap;
import org.opensha.sha.gcim.imCorrRel.ImCorrelationRelationship;
import org.opensha.sha.gcim.imCorrRel.event.IMCorrRelChangeEvent;
import org.opensha.sha.gcim.imCorrRel.event.IMCorrRelChangeListener;
import org.opensha.sha.gcim.ui.IMCorrRel_ParamEditor;
import org.opensha.sha.gui.beans.event.IMTChangeEvent;
import org.opensha.sha.gui.beans.event.IMTChangeListener;
import org.opensha.sha.util.TectonicRegionType;

public class IMCorrRel_MultiGuiBean
extends LabeledBoxPanel
implements ActionListener,
IMTChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Font trtFont = new Font("TRTFont", 1, 16);
    private ArrayList<IMCorrRelChangeListener> imCorrRelChangeListeners = new ArrayList();
    private JPanel checkPanel;
    protected JCheckBox singleIMCorrRelBox = new JCheckBox("Single IMCorrRel For All Tectonic Region Types");
    private ArrayList<ImCorrelationRelationship> imCorrRels;
    private ArrayList<Boolean> imCorrRelEnables;
    private ArrayList<TectonicRegionType> regions = null;
    private IMCorrRel_ParamEditor paramEdit = null;
    private int chooserForEditor = 0;
    private ArrayList<ShowHideButton> showHideButtons = null;
    private ArrayList<ChooserComboBox> chooserBoxes = null;
    private HashMap<TectonicRegionType, ImCorrelationRelationship> imCorrRelMap;
    private ArrayList<HashMap<TectonicRegionType, ImCorrelationRelationship>> imikCorrRelMap = new ArrayList();
    private Parameter<Double> imti = null;
    private Parameter<Double> imtj = null;
    private int maxChooserChars = Integer.MAX_VALUE;
    private int defaultIMCorrRelIndex = 0;
    private static String showParamsTitle = "Edit IMCorrRel Params";
    private static String hideParamsTitle = "Hide IMCorrRel Params";
    protected static final Font supportedTRTFont = new Font("supportedFont", 1, 12);
    protected static final Font unsupportedTRTFont = new Font("supportedFont", 2, 12);

    public IMCorrRel_MultiGuiBean(ArrayList<ImCorrelationRelationship> imCorrRels, Parameter<Double> imtj) {
        this.imCorrRels = imCorrRels;
        this.imtj = imtj;
        this.imCorrRelEnables = new ArrayList();
        for (int i = 0; i < imCorrRels.size(); ++i) {
            this.imCorrRelEnables.add(true);
        }
        this.initGUI();
        this.updateIMCorrRelMap();
    }

    private void initGUI() {
        this.setLayout(new BoxLayout(this.editorPanel, 1));
        this.singleIMCorrRelBox.setFont(new Font("My Font", 0, 10));
        this.singleIMCorrRelBox.addActionListener(this);
        this.paramEdit = new IMCorrRel_ParamEditor();
        this.setTitle("Set IMCorrRel");
        this.rebuildGUI();
    }

    public void rebuildGUI() {
        this.rebuildGUI(false);
    }

    private void rebuildGUI(boolean refreshOnly) {
        this.removeAll();
        if (this.regions == null || this.regions.size() <= 1) {
            this.singleIMCorrRelBox.setSelected(true);
        } else {
            this.checkPanel = new JPanel();
            this.checkPanel.setLayout(new BoxLayout(this.checkPanel, 0));
            this.checkPanel.add(this.singleIMCorrRelBox);
            this.add(this.checkPanel);
        }
        if (!refreshOnly) {
            this.chooserBoxes = new ArrayList();
            this.showHideButtons = null;
        }
        if (!this.singleIMCorrRelBox.isSelected()) {
            if (!refreshOnly) {
                this.showHideButtons = new ArrayList();
            }
            for (int i = 0; i < this.regions.size(); ++i) {
                ShowHideButton button;
                ChooserComboBox chooser;
                TectonicRegionType region = this.regions.get(i);
                JLabel label = new JLabel(region.toString());
                label.setFont(trtFont);
                this.add(IMCorrRel_MultiGuiBean.wrapInPanel(label));
                if (refreshOnly) {
                    chooser = this.chooserBoxes.get(i);
                    button = this.showHideButtons.get(i);
                } else {
                    chooser = new ChooserComboBox(i);
                    this.chooserBoxes.add(chooser);
                    button = new ShowHideButton(false);
                    button.addActionListener(this);
                    this.showHideButtons.add(button);
                }
                this.add(IMCorrRel_MultiGuiBean.wrapInPanel(chooser));
                this.add(IMCorrRel_MultiGuiBean.wrapInPanel(button));
                if (!button.isShowing()) continue;
                this.chooserForEditor = i;
                this.updateParamEdit(chooser);
                this.add(this.paramEdit);
            }
        } else {
            ChooserComboBox chooser;
            if (refreshOnly) {
                chooser = this.chooserBoxes.get(0);
            } else {
                chooser = new ChooserComboBox(0);
                chooser.setBackground(Color.WHITE);
                this.chooserBoxes.add(chooser);
            }
            this.add(IMCorrRel_MultiGuiBean.wrapInPanel(chooser));
            this.chooserForEditor = 0;
            this.updateParamEdit(chooser);
            this.add(this.paramEdit);
        }
        this.validate();
        this.paintAll(this.getGraphics());
    }

    private static JPanel wrapInPanel(JComponent comp) {
        JPanel panel = new JPanel();
        panel.add(comp);
        return panel;
    }

    public boolean isCheckBoxVisible() {
        if (this.checkPanel == null) {
            return false;
        }
        return this.checkPanel.isAncestorOf(this.singleIMCorrRelBox) && this.isAncestorOf(this.checkPanel);
    }

    public void setTectonicRegions(ArrayList<TectonicRegionType> regions) {
        boolean newSingle;
        boolean refreshOnly = (regions == null || regions.size() < 2) && !this.isCheckBoxVisible();
        this.regions = regions;
        boolean prevSingle = !this.isMultipleIMCorrRels();
        this.rebuildGUI(refreshOnly);
        boolean bl = newSingle = !this.isMultipleIMCorrRels();
        if (!(refreshOnly || prevSingle && newSingle)) {
            this.fireUpdateIMCorrRelMap();
        }
    }

    public ArrayList<TectonicRegionType> getTectonicRegions() {
        return this.regions;
    }

    protected ChooserComboBox getChooser(TectonicRegionType trt) {
        if (!this.isMultipleIMCorrRels()) {
            return this.chooserBoxes.get(0);
        }
        for (int i = 0; i < this.regions.size(); ++i) {
            if (!this.regions.get(i).toString().equals(trt.toString())) continue;
            return this.chooserBoxes.get(i);
        }
        return null;
    }

    private void updateParamEdit(ChooserComboBox chooser) {
        if (chooser.getIndex() == 0 && !this.isMultipleIMCorrRels()) {
            this.defaultIMCorrRelIndex = chooser.getSelectedIndex();
        }
        if (this.chooserForEditor == chooser.getIndex()) {
            ImCorrelationRelationship imCorrRel = this.imCorrRels.get(chooser.getSelectedIndex());
            this.paramEdit.setIMCorrRel(imCorrRel);
            this.paramEdit.setTRTParamVisible(!this.isMultipleIMCorrRels());
            this.paramEdit.setTitle("IMCorrRel Params: " + imCorrRel.getShortName());
            this.paramEdit.validate();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof ShowHideButton) {
            ShowHideButton button = (ShowHideButton)source;
            button.toggle();
            for (ShowHideButton theButton : this.showHideButtons) {
                if (theButton == button) continue;
                theButton.hideParams();
            }
            this.rebuildGUI(true);
        } else if (source == this.singleIMCorrRelBox) {
            this.rebuildGUI();
            this.fireUpdateIMCorrRelMap();
        }
    }

    private ImCorrelationRelationship getIMCorrRelForChooser(int chooserID) {
        ChooserComboBox chooser = this.chooserBoxes.get(chooserID);
        return this.imCorrRels.get(chooser.getSelectedIndex());
    }

    public boolean isMultipleIMCorrRels() {
        return !this.singleIMCorrRelBox.isSelected();
    }

    public void setMultipleIMCorrRelsEnabled(boolean enabled) {
        if (!enabled) {
            this.setMultipleIMCorrRels(false);
        }
        this.singleIMCorrRelBox.setEnabled(enabled);
    }

    public ImCorrelationRelationship getSelectedIMCorrRel() {
        if (this.isMultipleIMCorrRels()) {
            throw new RuntimeException("Cannot get single selected IMCorrRel when multiple selected!");
        }
        return this.getIMCorrRelForChooser(0);
    }

    public void showParamEditor(TectonicRegionType trt) {
        if (!this.isMultipleIMCorrRels()) {
            throw new RuntimeException("Cannot show param editor for TRT in single IMCorrRel mode!");
        }
        for (int i = 0; i < this.regions.size(); ++i) {
            if (!this.regions.get(i).toString().equals(trt.toString())) continue;
            ShowHideButton button = this.showHideButtons.get(i);
            if (button.isShowing()) {
                button.doClick();
            }
            return;
        }
        throw new RuntimeException("TRT '" + trt.toString() + "' not found!");
    }

    protected IMCorrRel_ParamEditor getParamEdit() {
        return this.paramEdit;
    }

    public HashMap<TectonicRegionType, ImCorrelationRelationship> getIMCorrRelMap() {
        return (HashMap)this.imCorrRelMap.clone();
    }

    public ArrayList<HashMap<TectonicRegionType, ImCorrelationRelationship>> getIMikCorrRelMap() {
        return (ArrayList)this.imikCorrRelMap.clone();
    }

    public void updateIMCorrRelMap() {
        HashMap<TectonicRegionType, ImCorrelationRelationship> map = new HashMap<TectonicRegionType, ImCorrelationRelationship>();
        if (!this.isMultipleIMCorrRels()) {
            ImCorrelationRelationship imCorrRel = this.getIMCorrRelForChooser(0);
            map.put(TectonicRegionType.ACTIVE_SHALLOW, imCorrRel);
        } else {
            for (int i = 0; i < this.regions.size(); ++i) {
                TectonicRegionType region = this.regions.get(i);
                map.put(region, this.getIMCorrRelForChooser(i));
            }
        }
        this.imCorrRelMap = map;
    }

    public void setMultipleIMCorrRels(boolean multipleIMCorrRels) {
        if (multipleIMCorrRels && (this.regions == null || this.regions.size() <= 1)) {
            throw new RuntimeException("Cannot be set to multiple IMCorrRels if < 2 tectonic regions sepcified");
        }
        boolean previous = this.isMultipleIMCorrRels();
        if (previous != multipleIMCorrRels) {
            this.singleIMCorrRelBox.setSelected(!multipleIMCorrRels);
            this.rebuildGUI(false);
            this.fireUpdateIMCorrRelMap();
        }
    }

    public void setMultipleIMikCorrRels(boolean multipleIMikCorrRels) {
        if (multipleIMikCorrRels && (this.regions == null || this.regions.size() <= 1)) {
            throw new RuntimeException("Cannot be set to multiple IMCorrRels if < 2 tectonic regions sepcified");
        }
        boolean previous = this.isMultipleIMCorrRels();
        if (previous != multipleIMikCorrRels) {
            this.singleIMCorrRelBox.setSelected(!multipleIMikCorrRels);
            this.rebuildGUI(false);
            this.fireUpdateIMCorrRelMap();
        }
    }

    public void setSelectedSingleIMCorrRel(String imCorrRelName) {
        this.setMultipleIMCorrRels(false);
        ChooserComboBox chooser = this.chooserBoxes.get(0);
        int index = ListUtils.getIndexByName(this.imCorrRels, imCorrRelName);
        if (index < 0) {
            throw new NoSuchElementException("IMR '" + imCorrRelName + "' not found");
        }
        ImCorrelationRelationship imCorrRel = this.imCorrRels.get(index);
        if (!this.shouldEnableIMCorrRel(imCorrRel)) {
            throw new RuntimeException("IMCorrRel '" + imCorrRelName + "' cannot be set because it is not supported by the current IMTs, '" + this.imti.getName() + "', and, '" + this.imtj.getName() + "'.");
        }
        chooser.setSelectedIndex(index);
    }

    public void setIMCorrRel(String imCorrRelName, TectonicRegionType trt) {
        if (!this.isMultipleIMCorrRels()) {
            throw new RuntimeException("IMCorrRel cannot be set for a Tectonic Region in single IMCorrRel mode");
        }
        if (trt == null) {
            throw new IllegalArgumentException("Tectonic Region Type cannot be null!");
        }
        for (int i = 0; i < this.regions.size(); ++i) {
            if (!trt.toString().equals(this.regions.get(i).toString())) continue;
            int index = ListUtils.getIndexByName(this.imCorrRels, imCorrRelName);
            if (index < 0) {
                throw new NoSuchElementException("IMCorrRel '" + imCorrRelName + "' not found");
            }
            ImCorrelationRelationship imCorrRel = this.imCorrRels.get(index);
            if (!this.shouldEnableIMCorrRel(imCorrRel)) {
                throw new RuntimeException("IMCorrRel '" + imCorrRelName + "' cannot be set because it is not supported by the current IMTs, '" + this.imti.getName() + "', and, '" + this.imti.getName() + "'.");
            }
            this.chooserBoxes.get(i).setSelectedIndex(index);
            return;
        }
        throw new RuntimeException("TRT '" + trt.toString() + "' not found!");
    }

    public void setSelectedSingleIMikCorrRel(int corrRelIndex, ImCorrelationRelationship imikCorrRel) {
        HashMap<TectonicRegionType, ImCorrelationRelationship> map = new HashMap<TectonicRegionType, ImCorrelationRelationship>();
        if (!this.isMultipleIMCorrRels()) {
            ImCorrelationRelationship imCorrRel = imikCorrRel;
            map.put(TectonicRegionType.ACTIVE_SHALLOW, imCorrRel);
        } else {
            for (int i = 0; i < this.regions.size(); ++i) {
                TectonicRegionType region = this.regions.get(i);
                map.put(region, imikCorrRel);
            }
        }
        int A = this.imikCorrRelMap.size();
        if (corrRelIndex + 1 > this.imikCorrRelMap.size()) {
            this.imikCorrRelMap.add(map);
        } else {
            this.imikCorrRelMap.set(corrRelIndex, map);
        }
    }

    public void addIMCorrRelChangeListener(IMCorrRelChangeListener listener) {
        this.imCorrRelChangeListeners.add(listener);
    }

    public void removeIMCorrRelChangeListener(IMCorrRelChangeListener listener) {
        this.imCorrRelChangeListeners.remove(listener);
    }

    private void fireUpdateIMCorrRelMap() {
        HashMap<TectonicRegionType, ImCorrelationRelationship> oldMap = this.imCorrRelMap;
        this.updateIMCorrRelMap();
        this.fireIMCorrRelChangeEvent(oldMap, this.imCorrRelMap);
    }

    private void fireIMCorrRelChangeEvent(HashMap<TectonicRegionType, ImCorrelationRelationship> oldMap, HashMap<TectonicRegionType, ImCorrelationRelationship> newMap) {
        IMCorrRelChangeEvent event = new IMCorrRelChangeEvent(this, oldMap, newMap);
        for (IMCorrRelChangeListener listener : this.imCorrRelChangeListeners) {
            listener.imCorrRelChange(event);
        }
    }

    public boolean isIMCorrRelEnabled(String imCorrRelName) {
        int index = ListUtils.getIndexByName(this.imCorrRels, imCorrRelName);
        if (index < 0) {
            throw new NoSuchElementException("IMCorrRel '" + imCorrRelName + "' not found!");
        }
        return this.imCorrRelEnables.get(index);
    }

    private boolean shouldEnableIMCorrRel(ImCorrelationRelationship imCorrRel) {
        if (this.imti == null) {
            return true;
        }
        ArrayList<Parameter<?>> imjImCorrRelParamList = imCorrRel.getSupportedIntensityMeasuresjList();
        for (int j = 0; j < imjImCorrRelParamList.size(); ++j) {
            ArrayList<Parameter<?>> imiImCorrRelParamList;
            Parameter<?> imiImCorrRelParam;
            Parameter<?> imjImCorrRelParam = imjImCorrRelParamList.get(j);
            if (imjImCorrRelParam.getName() != this.imtj.getName() || (imiImCorrRelParam = (imiImCorrRelParamList = imCorrRel.getSupportedIntensityMeasuresiList()).get(j)).getName() != this.imti.getName()) continue;
            return true;
        }
        return false;
    }

    public void setIMTi(Parameter<Double> newIMTi) {
        this.imti = newIMTi;
        for (int i = 0; i < this.imCorrRels.size(); ++i) {
            ImCorrelationRelationship imCorrRel = this.imCorrRels.get(i);
            Boolean enabled = this.shouldEnableIMCorrRel(imCorrRel);
            this.imCorrRelEnables.set(i, enabled);
        }
        for (ChooserComboBox chooser : this.chooserBoxes) {
            if (!this.imCorrRelEnables.get(chooser.getSelectedIndex()).booleanValue()) {
                for (int i = 0; i < chooser.getItemCount(); ++i) {
                    if (!this.imCorrRelEnables.get(i).booleanValue()) continue;
                    chooser.setSelectedIndex(i);
                    break;
                }
            }
            chooser.repaint();
        }
    }

    public ArrayList<ImCorrelationRelationship> getIMCorrRels() {
        return (ArrayList)this.imCorrRels.clone();
    }

    public NtoNMap<TectonicRegionType, ImCorrelationRelationship> getNtoNMap() {
        NtoNMap<TectonicRegionType, ImCorrelationRelationship> map = new NtoNMap<TectonicRegionType, ImCorrelationRelationship>();
        for (TectonicRegionType trt : this.imCorrRelMap.keySet()) {
            map.put(trt, this.imCorrRelMap.get(trt));
        }
        return map;
    }

    @Override
    public void imtChange(IMTChangeEvent e) {
        this.setIMTi(e.getNewIMT());
    }

    public void setMaxChooserChars(int maxChooserChars) {
        this.maxChooserChars = maxChooserChars;
    }

    public class ChooserComboBox
    extends JComboBox {
        private static final long serialVersionUID = 1L;
        private int comboBoxIndex;

        public ChooserComboBox(int index) {
            for (ImCorrelationRelationship imCorrRel : IMCorrRel_MultiGuiBean.this.imCorrRels) {
                String name = imCorrRel.getName();
                if (name.length() > IMCorrRel_MultiGuiBean.this.maxChooserChars) {
                    name = name.substring(0, IMCorrRel_MultiGuiBean.this.maxChooserChars);
                }
                this.addItem(name);
            }
            if (!IMCorrRel_MultiGuiBean.this.imCorrRelEnables.get(IMCorrRel_MultiGuiBean.this.defaultIMCorrRelIndex).booleanValue()) {
                for (int i = 0; i < IMCorrRel_MultiGuiBean.this.imCorrRelEnables.size(); ++i) {
                    if (!IMCorrRel_MultiGuiBean.this.imCorrRelEnables.get(i).booleanValue()) continue;
                    IMCorrRel_MultiGuiBean.this.defaultIMCorrRelIndex = i;
                    break;
                }
            }
            this.setSelectedIndex(IMCorrRel_MultiGuiBean.this.defaultIMCorrRelIndex);
            TectonicRegionType trt = null;
            if (IMCorrRel_MultiGuiBean.this.isMultipleIMCorrRels()) {
                trt = IMCorrRel_MultiGuiBean.this.regions.get(index);
            }
            this.setRenderer(new EnableableCellRenderer(trt));
            this.comboBoxIndex = index;
            this.addActionListener(new ComboListener(this));
            this.setMaximumSize(new Dimension(15, 150));
        }

        public int getIndex() {
            return this.comboBoxIndex;
        }
    }

    private class ShowHideButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        private boolean showing;

        public ShowHideButton(boolean initial) {
            this.showing = initial;
            this.updateText();
        }

        private void updateText() {
            if (this.showing) {
                this.setText(hideParamsTitle);
            } else {
                this.setText(showParamsTitle);
            }
        }

        private void hideParams() {
            this.showing = false;
            this.updateText();
        }

        public void toggle() {
            this.showing = !this.showing;
            this.updateText();
        }

        @Override
        public boolean isShowing() {
            return this.showing;
        }
    }

    class ComboListener
    implements ActionListener {
        ChooserComboBox combo;
        Object currentItem;

        ComboListener(ChooserComboBox combo) {
            this.combo = combo;
            this.currentItem = combo.getSelectedItem();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object tempItem = this.combo.getSelectedItem();
            if (!IMCorrRel_MultiGuiBean.this.imCorrRelEnables.get(this.combo.getSelectedIndex()).booleanValue()) {
                this.combo.setSelectedItem(this.currentItem);
                IMCorrRel_MultiGuiBean.this.updateParamEdit(this.combo);
            } else {
                this.currentItem = tempItem;
                IMCorrRel_MultiGuiBean.this.updateParamEdit(this.combo);
                IMCorrRel_MultiGuiBean.this.fireUpdateIMCorrRelMap();
            }
        }
    }

    public class EnableableCellRenderer
    extends BasicComboBoxRenderer {
        protected ArrayList<Boolean> trtSupported = null;
        private static final long serialVersionUID = 1L;

        public EnableableCellRenderer(TectonicRegionType trt) {
            if (trt != null) {
                this.trtSupported = new ArrayList();
                for (ImCorrelationRelationship imCorrRel : IMCorrRel_MultiGuiBean.this.imCorrRels) {
                    this.trtSupported.add(imCorrRel.isTectonicRegionSupported(trt));
                }
            }
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!isSelected) {
                comp.setBackground(Color.white);
            }
            if (index >= 0) {
                comp.setEnabled(IMCorrRel_MultiGuiBean.this.imCorrRelEnables.get(index));
                this.setFont(comp, index);
            } else {
                int selIndex = list.getSelectedIndex();
                this.setFont(comp, selIndex);
                comp.setEnabled(true);
            }
            return comp;
        }

        public void setFont(Component comp, int index) {
            if (this.trtSupported != null) {
                if (this.trtSupported.get(index).booleanValue()) {
                    comp.setFont(supportedTRTFont);
                } else {
                    comp.setFont(unsupportedTRTFont);
                }
            }
        }
    }
}

