/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim.ui.infoTools;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.param.Parameter;

public final class IMT_Info {
    private String S = "IMT_Info()";
    public static final double MIN_SA = 1.0E-4;
    public static final double MAX_SA = 10.0;
    public static final double NUM_SA = 51.0;
    public static final double DEFAULT_SA = 0.1;
    public static final double MIN_PGA = 1.0E-4;
    public static final double MAX_PGA = 10.0;
    public static final double NUM_PGA = 51.0;
    public static final double DEFAULT_PGA = 0.1;
    public static final double MIN_PGV = 0.01;
    public static final double MAX_PGV = 900.0;
    public static final double NUM_PGV = 51.0;
    public static final double DEFAULT_PGV = 50.0;
    public static final double MIN_FAULT_DISPL = 0.001;
    public static final double MAX_FAULT_DISPL = 100.0;
    public static final double NUM_FAULT_DISPL = 51.0;
    public static final double DEFAULT_FAULT_DISPL = 1.0;
    public static final double MIN_MMI = 1.0;
    public static final double MAX_MMI = 10.0;
    public static final double NUM_MMI = 51.0;
    public static final double DEFAULT_MMI = 7.0;
    public static final double MIN_IA = 1.0E-4;
    public static final double MAX_IA = 900.0;
    public static final double NUM_IA = 51.0;
    public static final double DEFAULT_IA = 0.1;
    public static final double MIN_SI = 0.001;
    public static final double MAX_SI = 900.0;
    public static final double NUM_SI = 51.0;
    public static final double DEFAULT_SI = 50.0;
    public static final double MIN_ASI = 5.0E-5;
    public static final double MAX_ASI = 5.0;
    public static final double NUM_ASI = 51.0;
    public static final double DEFAULT_ASI = 0.05;
    public static final double MIN_DSI = 0.05;
    public static final double MAX_DSI = 1000.0;
    public static final double NUM_DSI = 51.0;
    public static final double DEFAULT_DSI = 10.0;
    public static final double MIN_CAV = 0.001;
    public static final double MAX_CAV = 10.0;
    public static final double NUM_CAV = 51.0;
    public static final double DEFAULT_CAV = 0.3;
    public static final double MIN_Ds575 = 0.01;
    public static final double MAX_Ds575 = 300.0;
    public static final double NUM_Ds575 = 51.0;
    public static final double DEFAULT_Ds575 = 4.0;
    public static final double MIN_Ds595 = 0.01;
    public static final double MAX_Ds595 = 400.0;
    public static final double NUM_Ds595 = 51.0;
    public static final double DEFAULT_Ds595 = 5.0;
    public double discretization_pga;
    public double discretization_sa;
    public double discretization_pgv;
    public double discretization_fault_displ;
    public double discretization_mmi;
    public double discretization_ia;
    public double discretization_si;
    public double discretization_asi;
    public double discretization_dsi;
    public double discretization_cav;
    public double discretization_ds575;
    public double discretization_ds595;
    private NumberFormat format = DecimalFormat.getInstance(Locale.US);

    public IMT_Info() {
        this.format.setMaximumFractionDigits(7);
        this.format.setMinimumFractionDigits(5);
        this.discretization_pga = (Math.log(10.0) - Math.log(1.0E-4)) / 50.0;
        this.discretization_sa = (Math.log(10.0) - Math.log(1.0E-4)) / 50.0;
        this.discretization_pgv = (Math.log(900.0) - Math.log(0.01)) / 50.0;
        this.discretization_fault_displ = (Math.log(100.0) - Math.log(0.001)) / 50.0;
        this.discretization_mmi = (Math.log(10.0) - Math.log(1.0)) / 50.0;
        this.discretization_ia = (Math.log(900.0) - Math.log(1.0E-4)) / 50.0;
        this.discretization_si = (Math.log(900.0) - Math.log(0.001)) / 50.0;
        this.discretization_asi = (Math.log(5.0) - Math.log(5.0E-5)) / 50.0;
        this.discretization_dsi = (Math.log(1000.0) - Math.log(0.05)) / 50.0;
        this.discretization_cav = (Math.log(10.0) - Math.log(0.001)) / 50.0;
        this.discretization_ds575 = (Math.log(300.0) - Math.log(0.01)) / 50.0;
        this.discretization_ds595 = (Math.log(400.0) - Math.log(0.01)) / 50.0;
        this.format.setMaximumFractionDigits(5);
    }

    public ArbitrarilyDiscretizedFunc getDefaultHazardCurve(Parameter imtParam) {
        String paramVal = (String)imtParam.getValue();
        return this.getDefaultHazardCurve(paramVal);
    }

    public ArbitrarilyDiscretizedFunc getDefaultHazardCurve(String imtName) {
        ArbitrarilyDiscretizedFunc function = new ArbitrarilyDiscretizedFunc();
        if (imtName.equals("SA") || imtName.equals("SA Interpolated")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Double.parseDouble(this.format.format(Math.exp(Math.log(1.0E-4) + (double)i * this.discretization_sa)));
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("PGA")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Double.parseDouble(this.format.format(Math.exp(Math.log(1.0E-4) + (double)i * this.discretization_pga)));
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("PGV")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Double.parseDouble(this.format.format(Math.exp(Math.log(0.01) + (double)i * this.discretization_pgv)));
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("Fault Displacement")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Double.parseDouble(this.format.format(Math.exp(Math.log(0.001) + (double)i * this.discretization_fault_displ)));
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("MMI")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Double.parseDouble(this.format.format(Math.exp(Math.log(1.0) + (double)i * this.discretization_mmi)));
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("IA")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Double.parseDouble(this.format.format(Math.exp(Math.log(1.0E-4) + (double)i * this.discretization_ia)));
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("SI")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Double.parseDouble(this.format.format(Math.exp(Math.log(0.001) + (double)i * this.discretization_si)));
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("ASI")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Double.parseDouble(this.format.format(Math.exp(Math.log(5.0E-5) + (double)i * this.discretization_asi)));
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("DSI")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Double.parseDouble(this.format.format(Math.exp(Math.log(0.05) + (double)i * this.discretization_dsi)));
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("CAV")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Double.parseDouble(this.format.format(Math.exp(Math.log(0.001) + (double)i * this.discretization_cav)));
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("Ds575")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Double.parseDouble(this.format.format(Math.exp(Math.log(0.01) + (double)i * this.discretization_ds575)));
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("Ds595")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Double.parseDouble(this.format.format(Math.exp(Math.log(0.01) + (double)i * this.discretization_ds595)));
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        return null;
    }

    public static double getMinIMT_Val(String imt) {
        if (imt.equals("SA")) {
            return 1.0E-4;
        }
        if (imt.equals("PGA")) {
            return 1.0E-4;
        }
        if (imt.equals("PGV")) {
            return 0.01;
        }
        if (imt.equals("Fault Displacement")) {
            return 0.001;
        }
        if (imt.equals("MMI")) {
            return 1.0;
        }
        if (imt.equals("IA")) {
            return 1.0E-4;
        }
        if (imt.equals("SI")) {
            return 0.001;
        }
        if (imt.equals("ASI")) {
            return 5.0E-5;
        }
        if (imt.equals("DSI")) {
            return 0.05;
        }
        if (imt.equals("CAV")) {
            return 0.001;
        }
        if (imt.equals("Ds575")) {
            return 0.01;
        }
        if (imt.equals("Ds595")) {
            return 0.01;
        }
        return 0.0;
    }

    public static double getMaxIMT_Val(String imt) {
        if (imt.equals("SA")) {
            return 10.0;
        }
        if (imt.equals("PGA")) {
            return 10.0;
        }
        if (imt.equals("PGV")) {
            return 900.0;
        }
        if (imt.equals("Fault Displacement")) {
            return 100.0;
        }
        if (imt.equals("MMI")) {
            return 10.0;
        }
        if (imt.equals("IA")) {
            return 900.0;
        }
        if (imt.equals("SI")) {
            return 900.0;
        }
        if (imt.equals("ASI")) {
            return 5.0;
        }
        if (imt.equals("DSI")) {
            return 1000.0;
        }
        if (imt.equals("CAV")) {
            return 10.0;
        }
        if (imt.equals("Ds575")) {
            return 300.0;
        }
        if (imt.equals("Ds595")) {
            return 400.0;
        }
        return 0.0;
    }

    public static double getNumIMT_Val(String imt) {
        if (imt.equals("SA")) {
            return 51.0;
        }
        if (imt.equals("PGA")) {
            return 51.0;
        }
        if (imt.equals("PGV")) {
            return 51.0;
        }
        if (imt.equals("Fault Displacement")) {
            return 51.0;
        }
        if (imt.equals("MMI")) {
            return 51.0;
        }
        if (imt.equals("IA")) {
            return 51.0;
        }
        if (imt.equals("SI")) {
            return 51.0;
        }
        if (imt.equals("ASI")) {
            return 51.0;
        }
        if (imt.equals("DSI")) {
            return 51.0;
        }
        if (imt.equals("CAV")) {
            return 51.0;
        }
        if (imt.equals("Ds575")) {
            return 51.0;
        }
        if (imt.equals("Ds595")) {
            return 51.0;
        }
        return 0.0;
    }

    public static double getDefaultIMT_VAL(String imt) {
        if (imt.equals("SA")) {
            return 0.1;
        }
        if (imt.equals("PGA")) {
            return 0.1;
        }
        if (imt.equals("PGV")) {
            return 50.0;
        }
        if (imt.equals("Fault Displacement")) {
            return 1.0;
        }
        if (imt.equals("MMI")) {
            return 7.0;
        }
        if (imt.equals("IA")) {
            return 0.1;
        }
        if (imt.equals("SI")) {
            return 50.0;
        }
        if (imt.equals("ASI")) {
            return 0.05;
        }
        if (imt.equals("DSI")) {
            return 10.0;
        }
        if (imt.equals("CAV")) {
            return 0.3;
        }
        if (imt.equals("Ds575")) {
            return 4.0;
        }
        if (imt.equals("Ds595")) {
            return 5.0;
        }
        return 0.0;
    }

    public static boolean isIMT_LogNormalDist(String imt) {
        return imt.equalsIgnoreCase("PGA") || imt.equalsIgnoreCase("PGV") || imt.equalsIgnoreCase("SA") || imt.equalsIgnoreCase("SA Interpolated") || imt.equalsIgnoreCase("MMI") || imt.equalsIgnoreCase("Fault Displacement") || imt.equalsIgnoreCase("IA") || imt.equalsIgnoreCase("SI") || imt.equalsIgnoreCase("ASI") || imt.equalsIgnoreCase("DSI") || imt.equalsIgnoreCase("CAV") || imt.equalsIgnoreCase("Ds575") || imt.equalsIgnoreCase("Ds595");
    }

    public static ArbitrarilyDiscretizedFunc getUSGS_PGA_Function() {
        ArbitrarilyDiscretizedFunc function = new ArbitrarilyDiscretizedFunc();
        function.set(0.005, 1.0);
        function.set(0.007, 1.0);
        function.set(0.0098, 1.0);
        function.set(0.0137, 1.0);
        function.set(0.0192, 1.0);
        function.set(0.0269, 1.0);
        function.set(0.0376, 1.0);
        function.set(0.0527, 1.0);
        function.set(0.0738, 1.0);
        function.set(0.103, 1.0);
        function.set(0.145, 1.0);
        function.set(0.203, 1.0);
        function.set(0.284, 1.0);
        function.set(0.397, 1.0);
        function.set(0.556, 1.0);
        function.set(0.778, 1.0);
        function.set(1.09, 1.0);
        function.set(1.52, 1.0);
        function.set(2.13, 1.0);
        return function;
    }

    public static ArbitrarilyDiscretizedFunc getUSGS_SA_01_AND_02_Function() {
        ArbitrarilyDiscretizedFunc function = new ArbitrarilyDiscretizedFunc();
        function.set(0.005, 1.0);
        function.set(0.0075, 1.0);
        function.set(0.0113, 1.0);
        function.set(0.0169, 1.0);
        function.set(0.0253, 1.0);
        function.set(0.038, 1.0);
        function.set(0.057, 1.0);
        function.set(0.0854, 1.0);
        function.set(0.128, 1.0);
        function.set(0.192, 1.0);
        function.set(0.288, 1.0);
        function.set(0.432, 1.0);
        function.set(0.649, 1.0);
        function.set(0.973, 1.0);
        function.set(1.46, 1.0);
        function.set(2.19, 1.0);
        function.set(3.28, 1.0);
        function.set(4.92, 1.0);
        function.set(7.38, 1.0);
        return function;
    }

    public static ArbitrarilyDiscretizedFunc getUSGS_SA_Function() {
        ArbitrarilyDiscretizedFunc function = new ArbitrarilyDiscretizedFunc();
        function.set(0.0025, 1.0);
        function.set(0.00375, 1.0);
        function.set(0.00563, 1.0);
        function.set(0.00844, 1.0);
        function.set(0.0127, 1.0);
        function.set(0.019, 1.0);
        function.set(0.0285, 1.0);
        function.set(0.0427, 1.0);
        function.set(0.0641, 1.0);
        function.set(0.0961, 1.0);
        function.set(0.144, 1.0);
        function.set(0.216, 1.0);
        function.set(0.324, 1.0);
        function.set(0.487, 1.0);
        function.set(0.73, 1.0);
        function.set(1.09, 1.0);
        function.set(1.64, 1.0);
        function.set(2.46, 1.0);
        function.set(3.69, 1.0);
        function.set(5.54, 1.0);
        return function;
    }

    public static boolean isIMT_LogNormalDist(Parameter imtParam) {
        String paramVal = (String)imtParam.getValue();
        return IMT_Info.isIMT_LogNormalDist(paramVal);
    }

    public static void main(String[] args) {
        IMT_Info hazardCurve = new IMT_Info();
        ArbitrarilyDiscretizedFunc func = hazardCurve.getDefaultHazardCurve("SA");
        System.out.println("For SA and PGA: ");
        System.out.println("Dis: " + hazardCurve.discretization_pga);
        System.out.println(func.toString());
        func = hazardCurve.getDefaultHazardCurve("PGV");
        System.out.println("For PGV: ");
        System.out.println("Dis: " + hazardCurve.discretization_pgv);
        System.out.println(func.toString());
    }
}

