/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.beans;

import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.ApplicationVersion;
import org.opensha.commons.util.bugReports.BugReport;
import org.opensha.commons.util.bugReports.SimpleBugMessagePanel;
import org.opensha.sha.earthquake.BaseERF;
import org.opensha.sha.earthquake.ERF_Ref;
import org.opensha.sha.earthquake.EpistemicListERF;
import org.opensha.sha.gui.beans.TimeSpanGuiBean;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.param.MagFreqDistParameter;
import org.opensha.sha.param.SimpleFaultParameter;
import org.opensha.sha.param.editor.MagFreqDistParameterEditor;
import org.opensha.sha.param.editor.SimpleFaultParameterEditor;

public class ERF_GuiBean
extends JPanel
implements ParameterChangeFailListener,
ParameterChangeListener,
ChangeListener {
    private static final String C = "ERF_GuiBean";
    protected ArrayList<String> erfNamesVector = new ArrayList();
    private List<ERF_Ref> erfRefs;
    public static final String ERF_PARAM_NAME = "Eqk Rup Forecast";
    public static final String ERF_EDITOR_TITLE = "Set Forecast";
    StringParameter erfSelectionParam;
    boolean showProgressBar = true;
    private BaseERF fallbackERF;
    BaseERF eqkRupForecast = null;
    CalcProgressBar progress = null;
    private ParameterList parameterList;
    private ParameterListEditor listEditor;
    private TimeSpanGuiBean timeSpanGuiBean;
    private JPanel erfAndTimespanPanel;
    private boolean isNewERF_Instance;
    private HashMap<ERF_Ref, BaseERF> erfInstanceMap = new HashMap();

    protected static List<ERF_Ref> asList(Set<ERF_Ref> erfRefSet) {
        ArrayList<ERF_Ref> list = new ArrayList<ERF_Ref>();
        for (ERF_Ref erf : erfRefSet) {
            list.add(erf);
        }
        return list;
    }

    public ERF_GuiBean(ERF_Ref ... erfRefs) throws InvocationTargetException {
        this(Arrays.asList(erfRefs));
    }

    public ERF_GuiBean(Set<ERF_Ref> erfRefs) throws InvocationTargetException {
        this(ERF_GuiBean.asList(erfRefs));
    }

    public ERF_GuiBean(List<ERF_Ref> erfRefs) throws InvocationTargetException {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.erfRefs = erfRefs;
        this.init_erf_IndParamListAndEditor();
        this.setParamsInForecast();
        this.fallbackERF = this.eqkRupForecast;
    }

    private BaseERF getERFInstance(ERF_Ref erfRef) {
        if (!this.erfInstanceMap.containsKey((Object)erfRef)) {
            this.erfInstanceMap.put(erfRef, erfRef.instance());
        }
        return this.erfInstanceMap.get((Object)erfRef);
    }

    protected void init_erf_IndParamListAndEditor() throws InvocationTargetException {
        Preconditions.checkNotNull(this.erfRefs, (Object)"ERF list cannot be null!");
        Preconditions.checkArgument((!this.erfRefs.isEmpty() ? 1 : 0) != 0, (Object)"ERF list cannot be empty!");
        this.parameterList = new ParameterList();
        for (ERF_Ref erfRef : this.erfRefs) {
            String name = erfRef.toString();
            Preconditions.checkState((!this.erfNamesVector.contains(name) ? 1 : 0) != 0, (Object)("ERF list cannot contain 2 ERFs with the same name! Duplicate: " + name));
            this.erfNamesVector.add(name);
        }
        ERF_Ref erf = this.erfRefs.get(0);
        this.eqkRupForecast = this.getERFInstance(erf);
        this.erfSelectionParam = new StringParameter(ERF_PARAM_NAME, this.erfNamesVector, this.erfNamesVector.get(0));
        this.erfSelectionParam.addParameterChangeListener(this);
        this.parameterList.addParameter(this.erfSelectionParam);
    }

    private void setParamsInForecast() throws InvocationTargetException {
        Parameter chooseERF_Param = this.parameterList.getParameter(ERF_PARAM_NAME);
        this.parameterList = new ParameterList();
        this.parameterList.addParameter(chooseERF_Param);
        this.getSelectedERF_Instance();
        ParameterList paramList = this.eqkRupForecast.getAdjustableParameterList();
        paramList.addChangeListener(this);
        ListIterator<Parameter<?>> it = paramList.getParametersIterator();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            param.addParameterChangeListener(this);
            param.addParameterChangeFailListener(this);
            this.parameterList.addParameter(param);
        }
        if (this.listEditor != null) {
            this.erfAndTimespanPanel.remove(this.listEditor);
            this.listEditor = null;
        }
        this.listEditor = new ParameterListEditor(this.parameterList);
        this.erfAndTimespanPanel.add((Component)this.listEditor, "Center");
        this.listEditor.setTitle(ERF_EDITOR_TITLE);
        ParameterEditor edit = this.listEditor.getParameterEditor(ERF_PARAM_NAME);
        TitledBorder titledBorder1 = new TitledBorder(BorderFactory.createLineBorder(new Color(80, 80, 140), 3), ERF_PARAM_NAME);
        titledBorder1.setTitleColor(new Color(80, 80, 140));
        Font DEFAULT_LABEL_FONT = new Font("SansSerif", 1, 13);
        titledBorder1.setTitleFont(DEFAULT_LABEL_FONT);
        CompoundBorder border1 = BorderFactory.createCompoundBorder(titledBorder1, BorderFactory.createEmptyBorder(0, 0, 3, 0));
        edit.setEditorBorder(border1);
        this.createTimeSpanPanel();
        this.validate();
        this.repaint();
    }

    private void createTimeSpanPanel() {
        if (this.timeSpanGuiBean == null) {
            this.timeSpanGuiBean = new TimeSpanGuiBean(this.eqkRupForecast.getTimeSpan());
            this.timeSpanGuiBean.setOpaque(false);
            this.timeSpanGuiBean.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        } else {
            this.erfAndTimespanPanel.remove(this.timeSpanGuiBean);
        }
        this.timeSpanGuiBean.setTimeSpan(this.eqkRupForecast.getTimeSpan());
        this.erfAndTimespanPanel.add((Component)this.timeSpanGuiBean, "Last");
    }

    public MagFreqDistParameterEditor getMagDistEditor() {
        ListIterator<Parameter<?>> lit = this.parameterList.getParametersIterator();
        while (lit.hasNext()) {
            Parameter<?> param = lit.next();
            if (!(param instanceof MagFreqDistParameter)) continue;
            MagFreqDistParameterEditor magDistEditor = (MagFreqDistParameterEditor)this.listEditor.getParameterEditor(param.getName());
            return magDistEditor;
        }
        return null;
    }

    public SimpleFaultParameterEditor getSimpleFaultParamEditor() {
        ListIterator<Parameter<?>> lit = this.parameterList.getParametersIterator();
        while (lit.hasNext()) {
            Parameter<?> param = lit.next();
            if (!(param instanceof SimpleFaultParameter)) continue;
            SimpleFaultParameterEditor simpleFaultEditor = (SimpleFaultParameterEditor)this.listEditor.getParameterEditor(param.getName());
            return simpleFaultEditor;
        }
        return null;
    }

    public String getSelectedERF_Name() {
        return (String)this.parameterList.getValue(ERF_PARAM_NAME);
    }

    public BaseERF getSelectedERF_Instance() throws InvocationTargetException {
        this.updateMagDistParam();
        this.updateFaultParam();
        return this.eqkRupForecast;
    }

    public BaseERF getSelectedERF() throws InvocationTargetException {
        this.getSelectedERF_Instance();
        if (this.showProgressBar) {
            this.progress = new CalcProgressBar(this, null, "Updating forecast\u2026");
        }
        WeakReference<BaseERF> ref = new WeakReference<BaseERF>(this.eqkRupForecast);
        try {
            this.eqkRupForecast.updateForecast();
        }
        catch (OutOfMemoryError e) {
            this.eqkRupForecast = null;
            this.erfInstanceMap.clear();
            int count = 0;
            while (ref.get() != null) {
                System.gc();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (++count != 10) continue;
            }
            try {
                this.isNewERF_Instance = false;
                ERF_Ref fallbackRef = this.erfRefs.get(0);
                if (this.fallbackERF != null && this.fallbackERF.getName().equals(fallbackRef.toString())) {
                    this.erfInstanceMap.put(fallbackRef, this.fallbackERF);
                }
                System.gc();
                this.erfSelectionParam.setValue(fallbackRef.toString());
                this.erfSelectionParam.getEditor().refreshParamEditor();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        if (this.showProgressBar && this.progress != null) {
            this.progress.dispose();
            this.progress = null;
        }
        return this.eqkRupForecast;
    }

    public boolean isEpistemicList() {
        try {
            BaseERF eqkRupForecast = this.getSelectedERF_Instance();
            if (eqkRupForecast instanceof EpistemicListERF) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    protected void updateMagDistParam() {
        MagFreqDistParameterEditor magEditor = this.getMagDistEditor();
        if (magEditor != null) {
            ((MagFreqDistParameter)magEditor.getParameter()).setMagDist();
        }
    }

    protected void updateFaultParam() {
        SimpleFaultParameterEditor faultEditor = this.getSimpleFaultParamEditor();
        if (faultEditor != null) {
            faultEditor.getParameterEditorPanel().setEvenlyGriddedSurfaceFromParams();
        }
    }

    @Override
    public void parameterChangeFailed(ParameterChangeFailEvent e) {
        StringBuffer b = new StringBuffer();
        Parameter param = (Parameter)e.getSource();
        ParameterConstraint constraint = param.getConstraint();
        String oldValueStr = e.getOldValue().toString();
        String badValueStr = e.getBadValue().toString();
        String name = param.getName();
        b.append("The value ");
        b.append(badValueStr);
        b.append(" is not permitted for '");
        b.append(name);
        b.append("'.\n");
        b.append("Resetting to ");
        b.append(oldValueStr);
        b.append(". The constraints are: \n");
        b.append(constraint.toString());
        JOptionPane.showMessageDialog(this, b.toString(), "Cannot Change Value", 1);
    }

    private void showERFInstantiationError(Throwable t, String erfName) {
        ApplicationVersion version;
        t.printStackTrace();
        try {
            version = ApplicationVersion.loadBuildVersion();
        }
        catch (Exception e1) {
            version = null;
        }
        BugReport bug = new BugReport(t, "Problem occured in ERF_GuiBean when " + erfName + " is selected.", erfName, version, this);
        String title = "Error instantiating " + erfName;
        String message = "An error occured when instantiating " + erfName + "\n\nIt will be removed from the list. If you wish, you can submit a bug report by clicking below. To receive updates on the bug report, it is important that you leave your e-mail address in the 'reporter' field.";
        new SimpleBugMessagePanel(bug, message).showAsDialog(this, title);
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String name1 = event.getParameterName();
        if (name1.equals(ERF_PARAM_NAME) && !this.isNewERF_Instance) {
            String value = event.getNewValue().toString();
            int size = this.erfNamesVector.size();
            try {
                for (int i = 0; i < size; ++i) {
                    if (!value.equalsIgnoreCase(this.erfNamesVector.get(i))) continue;
                    try {
                        this.eqkRupForecast = this.getERFInstance(this.erfRefs.get(i));
                        break;
                    }
                    catch (Exception e) {
                        this.showERFInstantiationError(e, value);
                        ArrayList<ERF_Ref> removed = new ArrayList<ERF_Ref>();
                        removed.add(this.erfRefs.get(i));
                        this.removeERFs_FromList(removed);
                        this.erfSelectionParam.setValue((String)event.getOldValue());
                        this.erfSelectionParam.getEditor().refreshParamEditor();
                        return;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.refreshGUI();
    }

    public void refreshGUI() {
        try {
            this.setParamsInForecast();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        this.createTimeSpanPanel();
        this.validate();
        this.repaint();
    }

    public void showProgressBar(boolean show) {
        this.showProgressBar = show;
    }

    public void addERFs_ToList(ArrayList<ERF_Ref> newRefs) throws InvocationTargetException {
        int size = newRefs.size();
        for (ERF_Ref erfRef : newRefs) {
            if (this.erfRefs.contains((Object)erfRef)) continue;
            newRefs.add(erfRef);
        }
        this.erfNamesVector.clear();
        this.init_erf_IndParamListAndEditor();
        this.setParamsInForecast();
    }

    public void closeProgressBar() {
        if (this.showProgressBar && this.progress != null) {
            this.progress.dispose();
            this.progress = null;
        }
    }

    public void removeERFs_FromList(ArrayList<ERF_Ref> removed) throws InvocationTargetException {
        int size = removed.size();
        for (ERF_Ref erf : removed) {
            if (!this.erfRefs.contains((Object)erf)) continue;
            this.erfRefs.remove((Object)erf);
        }
        this.erfNamesVector.clear();
        this.init_erf_IndParamListAndEditor();
        this.setParamsInForecast();
    }

    public ParameterList getERFParameterList() {
        return this.parameterList;
    }

    public ParameterListEditor getERFParameterListEditor() {
        return this.listEditor;
    }

    public void setERF(BaseERF eqkRupForecast) {
        this.eqkRupForecast = eqkRupForecast;
        this.isNewERF_Instance = true;
        String erfName = eqkRupForecast.getName();
        int size = this.erfNamesVector.size();
        for (int i = 0; i < size; ++i) {
            if (!erfName.equalsIgnoreCase(this.erfNamesVector.get(i))) continue;
            try {
                this.listEditor.getParameterEditor(ERF_PARAM_NAME).setValue(erfName);
                this.setParamsInForecast();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.isNewERF_Instance = false;
            break;
        }
    }

    public TimeSpanGuiBean getSelectedERFTimespanGuiBean() {
        return this.timeSpanGuiBean;
    }

    public Parameter getParameter(String paramName) {
        if (this.parameterList.containsParameter(paramName)) {
            if (this.listEditor.getParameterEditor(paramName).isVisible()) {
                return this.parameterList.getParameter(paramName);
            }
        } else {
            this.timeSpanGuiBean.getParameterList().getParameter(paramName);
        }
        return null;
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.erfAndTimespanPanel = new JPanel(new BorderLayout());
        this.erfAndTimespanPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        this.erfAndTimespanPanel.setOpaque(false);
        JScrollPane erfScrollPane = new JScrollPane(this.erfAndTimespanPanel);
        erfScrollPane.setBorder(null);
        erfScrollPane.setOpaque(false);
        erfScrollPane.getViewport().setOpaque(false);
        this.add((Component)erfScrollPane, "Center");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refreshGUI();
    }

    private static class ERF_RefComparator
    implements Comparator<ERF_Ref> {
        private ERF_RefComparator() {
        }

        @Override
        public int compare(ERF_Ref o1, ERF_Ref o2) {
            int priorityComp = Integer.valueOf(o1.status().priority()).compareTo(o2.status().priority());
            if (priorityComp != 0) {
                return priorityComp;
            }
            return o1.toString().compareTo(o2.toString());
        }
    }
}

