/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.beans;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.BaseERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ERF_Ref;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.gui.beans.ERF_GuiBean;
import org.opensha.sha.gui.beans.EqkRupSelectorGuiBeanAPI;
import org.opensha.sha.gui.beans.EqkRuptureCreationPanel;
import org.opensha.sha.gui.beans.EqkRuptureFromERFSelectorPanel;

public class EqkRupSelectorGuiBean
extends JPanel
implements ParameterChangeListener {
    protected static final String C = "EqkRupSelectorGuiBean";
    protected static final boolean D = false;
    public static final String RUPTURE_SELECTOR_PARAM_NAME = "Select method of getting EqkRupture";
    private StringParameter ruptureSelectorParam;
    private static final String RUPTURE_SELECTOR_PARAM_INFO = "Toggles between methods to allow user to allow defining their own rupture or select one from the existing ERF's ";
    public static final String RUPTURE_FROM_EXISTING_ERF = "Select Eqk Rupture from an ERF";
    public static final String CREATE_RUPTURE = "Custom Eqk Rupture";
    private ConstrainedStringParameterEditor ruptureSelectorParamEditor;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JScrollPane eqkRuptureParameterScrollPane = new JScrollPane();
    private JPanel rupturePanel = new JPanel();
    private EqkRupSelectorGuiBeanAPI eqkRupturePanelFromERF = null;
    private EqkRupSelectorGuiBeanAPI eqkRupturePanelFromRupture = null;
    private EqkRupSelectorGuiBeanAPI eqkRupturePanel = null;
    private boolean isUserCreatedEqkRupture = false;
    private List<ERF_Ref> erfRefs;
    private BaseERF eqkRupForecast;

    public EqkRupSelectorGuiBean(BaseERF erf, ERF_Ref ... erfRefs) throws InvocationTargetException {
        this(erf, Arrays.asList(erfRefs));
    }

    public EqkRupSelectorGuiBean(BaseERF erf, Set<ERF_Ref> erfRefSet) throws InvocationTargetException {
        this(erf, ERF_GuiBean.asList(erfRefSet));
    }

    public EqkRupSelectorGuiBean(BaseERF erf, List<ERF_Ref> erfRefs) throws InvocationTargetException {
        this.eqkRupturePanelFromERF = new EqkRuptureFromERFSelectorPanel(erf, erfRefs);
        this.eqkRupForecast = erf;
        this.erfRefs = erfRefs;
        this.eqkRupturePanel = this.eqkRupturePanelFromERF;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.toggleRuptureSelectionMethods();
    }

    public EqkRupSelectorGuiBean(ERF_Ref ... erfRefs) throws InvocationTargetException {
        this(Arrays.asList(erfRefs));
    }

    public EqkRupSelectorGuiBean(Set<ERF_Ref> erfRefSet) throws InvocationTargetException {
        this(ERF_GuiBean.asList(erfRefSet));
    }

    public EqkRupSelectorGuiBean(List<ERF_Ref> erfRefs) throws InvocationTargetException {
        this.erfRefs = erfRefs;
        this.isUserCreatedEqkRupture = false;
        this.eqkRupturePanel = this.eqkRupturePanelFromERF = new EqkRuptureFromERFSelectorPanel(erfRefs);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.toggleRuptureSelectionMethods();
    }

    public EqkRupSelectorGuiBean() throws InvocationTargetException {
        this.eqkRupturePanel = this.eqkRupturePanelFromRupture = new EqkRuptureCreationPanel();
        this.isUserCreatedEqkRupture = true;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.rupturePanel.add((Component)((JPanel)((Object)this.eqkRupturePanel.getEqkRuptureSelectorPanel())), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.validate();
        this.repaint();
    }

    private void jbInit() throws Exception {
        ArrayList<String> ruptureSelectionMethodList = new ArrayList<String>();
        ruptureSelectionMethodList.add(RUPTURE_FROM_EXISTING_ERF);
        ruptureSelectionMethodList.add(CREATE_RUPTURE);
        this.ruptureSelectorParam = new StringParameter(RUPTURE_SELECTOR_PARAM_NAME, ruptureSelectionMethodList, (String)ruptureSelectionMethodList.get(0));
        this.ruptureSelectorParam.setInfo(RUPTURE_SELECTOR_PARAM_INFO);
        this.ruptureSelectorParam.addParameterChangeListener(this);
        this.ruptureSelectorParamEditor = new ConstrainedStringParameterEditor(this.ruptureSelectorParam);
        this.setLayout(this.gridBagLayout1);
        this.rupturePanel.setLayout(this.gridBagLayout2);
        this.setMinimumSize(new Dimension(0, 0));
        this.rupturePanel.setMinimumSize(new Dimension(0, 0));
        this.add((Component)this.eqkRuptureParameterScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 3, 5, 5), 0, 0));
        this.eqkRuptureParameterScrollPane.getViewport().add((Component)this.rupturePanel, null);
        this.rupturePanel.add((Component)this.ruptureSelectorParamEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.eqkRuptureParameterScrollPane.validate();
        this.eqkRuptureParameterScrollPane.repaint();
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String S = "EqkRupSelectorGuiBean: parameterChange(): ";
        String name1 = event.getParameterName();
        if (name1.equals(RUPTURE_SELECTOR_PARAM_NAME)) {
            String paramVal = (String)event.getNewValue();
            if (paramVal.equals(RUPTURE_FROM_EXISTING_ERF)) {
                this.isUserCreatedEqkRupture = false;
            } else if (paramVal.equals(CREATE_RUPTURE)) {
                this.isUserCreatedEqkRupture = true;
            }
            try {
                this.toggleRuptureSelectionMethods();
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public void setEqkRupForecastModel(BaseERF forecast) {
        this.eqkRupForecast = forecast;
        if (!this.isUserCreatedEqkRupture) {
            ((EqkRuptureFromERFSelectorPanel)this.eqkRupturePanel).setEqkRupForecast(forecast);
        }
    }

    private void toggleRuptureSelectionMethods() throws InvocationTargetException {
        this.rupturePanel.remove((JPanel)((Object)this.eqkRupturePanel));
        if (!this.isUserCreatedEqkRupture) {
            if (this.eqkRupturePanelFromERF == null) {
                this.eqkRupturePanelFromERF = this.eqkRupForecast == null ? new EqkRuptureFromERFSelectorPanel(this.erfRefs) : new EqkRuptureFromERFSelectorPanel(this.eqkRupForecast, this.erfRefs);
            }
            this.eqkRupturePanel = this.eqkRupturePanelFromERF;
        } else {
            if (this.eqkRupturePanelFromRupture == null) {
                this.eqkRupturePanelFromRupture = new EqkRuptureCreationPanel();
            }
            this.eqkRupturePanel = this.eqkRupturePanelFromRupture;
        }
        this.rupturePanel.add((Component)((JPanel)((Object)this.eqkRupturePanel.getEqkRuptureSelectorPanel())), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.validate();
        this.repaint();
    }

    public Location getHypocenterLocation() {
        return this.eqkRupturePanel.getHypocenterLocation();
    }

    public EqkRupture getRupture() {
        return this.eqkRupturePanel.getRupture();
    }

    public ProbEqkSource getSource() {
        if (this.eqkRupturePanel instanceof EqkRuptureFromERFSelectorPanel) {
            return ((EqkRuptureFromERFSelectorPanel)this.eqkRupturePanel).getSource();
        }
        return null;
    }

    public String getTimespanMetadataString() {
        return this.eqkRupturePanel.getTimespanMetadataString();
    }

    public String getParameterListMetadataString() {
        return this.eqkRupturePanel.getParameterListMetadataString();
    }

    public Parameter getParameter(String paramName) {
        if (paramName.equals(RUPTURE_SELECTOR_PARAM_NAME)) {
            return this.ruptureSelectorParam;
        }
        return this.eqkRupturePanel.getParameter(paramName);
    }

    public ParameterEditor getParameterEditor(String paramName) {
        if (paramName.equals(RUPTURE_SELECTOR_PARAM_NAME)) {
            return this.ruptureSelectorParamEditor;
        }
        return this.eqkRupturePanel.getParameterEditor(paramName);
    }

    public EqkRupSelectorGuiBeanAPI getEqkRuptureSelectorPanel() {
        return this.eqkRupturePanel;
    }

    public boolean isCustomRuptureSelected() {
        return this.isUserCreatedEqkRupture;
    }

    public ERF getSelectedEqkRupForecastModel() {
        return ((EqkRuptureFromERFSelectorPanel)this.eqkRupturePanel).getSelectedERF_Instance();
    }

    public ParameterList getVisibleParameterList() {
        return this.eqkRupturePanel.getVisibleParameterList();
    }

    public ParameterListEditor getVisibleParameterListEditor() {
        return this.eqkRupturePanel.getParameterListEditor();
    }
}

