/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.beans;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.region.SitesInGriddedRegion;
import org.opensha.commons.data.siteData.OrderedSiteDataProviderList;
import org.opensha.commons.data.siteData.gui.beans.OrderedSiteDataGUIBean;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.util.SiteTranslator;

public class SitesInGriddedRectangularRegionGuiBean
extends ParameterListEditor
implements ParameterChangeFailListener,
ParameterChangeListener,
Serializable {
    protected static final String C = "SiteParamList";
    public static final String MIN_LONGITUDE = "Min Longitude";
    public static final String MAX_LONGITUDE = "Max Longitude";
    public static final String MIN_LATITUDE = "Min  Latitude";
    public static final String MAX_LATITUDE = "Max  Latitude";
    public static final String GRID_SPACING = "Grid Spacing";
    public static final String SITE_PARAM_NAME = "Set Site Params";
    public static final String DEFAULT = "Default  ";
    public static final String GRIDDED_SITE_PARAMS = "Set Gridded Region Params";
    ArrayList<Parameter<?>> siteParams;
    public static final String SET_ALL_SITES = "Apply same site parameter(s) to all locations";
    public static final String USE_SITE_DATA = "Use site data providers";
    public static final String SET_SITE_USING_WILLS_SITE_TYPE = "Use the CGS Preliminary Site Conditions Map of CA (web service)";
    public static final String SET_SITES_USING_SCEC_CVM = "Use both CGS Map and SCEC Basin Depth (web services)";
    private DoubleParameter minLon = new DoubleParameter("Min Longitude", (Double)-360.0, (Double)360.0, (Double)-119.5);
    private DoubleParameter maxLon = new DoubleParameter("Max Longitude", (Double)-360.0, (Double)360.0, (Double)-117.0);
    private DoubleParameter minLat = new DoubleParameter("Min  Latitude", (Double)-90.0, (Double)90.0, (Double)33.5);
    private DoubleParameter maxLat = new DoubleParameter("Max  Latitude", (Double)-90.0, (Double)90.0, (Double)34.7);
    private DoubleParameter gridSpacing = new DoubleParameter("Grid Spacing", (Double)0.01666, (Double)1.0, new String("Degrees"), (Double)0.1);
    private StringParameter siteParam;
    SiteTranslator siteTrans = new SiteTranslator();
    private OrderedSiteDataGUIBean dataGuiBean;
    private OrderedSiteDataProviderList defaultProviderList = null;
    private SitesInGriddedRegion sites;

    public SitesInGriddedRectangularRegionGuiBean() {
        this((OrderedSiteDataGUIBean)null);
    }

    public SitesInGriddedRectangularRegionGuiBean(OrderedSiteDataGUIBean dataGuiBean) {
        this.dataGuiBean = dataGuiBean;
        if (dataGuiBean == null) {
            this.defaultProviderList = OrderedSiteDataProviderList.createCompatibilityProviders(false);
        }
        this.minLat.addParameterChangeFailListener(this);
        this.minLon.addParameterChangeFailListener(this);
        this.maxLat.addParameterChangeFailListener(this);
        this.maxLon.addParameterChangeFailListener(this);
        this.gridSpacing.addParameterChangeFailListener(this);
        ArrayList<String> siteOptions = new ArrayList<String>();
        siteOptions.add(SET_ALL_SITES);
        if (dataGuiBean == null) {
            siteOptions.add(SET_SITE_USING_WILLS_SITE_TYPE);
            siteOptions.add(SET_SITES_USING_SCEC_CVM);
        } else {
            siteOptions.add(USE_SITE_DATA);
        }
        this.siteParam = new StringParameter(SITE_PARAM_NAME, siteOptions, (String)siteOptions.get(0));
        this.siteParam.addParameterChangeListener(this);
        this.parameterList = new ParameterList();
        this.parameterList.addParameter(this.minLon);
        this.parameterList.addParameter(this.maxLon);
        this.parameterList.addParameter(this.minLat);
        this.parameterList.addParameter(this.maxLat);
        this.parameterList.addParameter(this.gridSpacing);
        this.parameterList.addParameter(this.siteParam);
        this.editorPanel.removeAll();
        this.addParameters();
        this.createAndUpdateSites();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addSiteParams(Iterator it) {
        ArrayList<AbstractParameter> siteTempVector = new ArrayList<AbstractParameter>();
        while (it.hasNext()) {
            AbstractParameter tempParam = (AbstractParameter)it.next();
            if (this.parameterList.containsParameter(tempParam)) continue;
            this.parameterList.addParameter(tempParam);
            siteTempVector.add(tempParam);
        }
        this.siteParams = siteTempVector;
        this.sites.addSiteParams(siteTempVector.iterator());
        this.setSiteParamsVisible();
    }

    public void addSiteParamsClone(Iterator it) {
        ArrayList<AbstractParameter> v = new ArrayList<AbstractParameter>();
        while (it.hasNext()) {
            AbstractParameter tempParam = (AbstractParameter)it.next();
            if (this.parameterList.containsParameter(tempParam)) continue;
            AbstractParameter cloneParam = (AbstractParameter)tempParam.clone();
            this.parameterList.addParameter(cloneParam);
            v.add(cloneParam);
        }
        this.sites.addSiteParams(v.iterator());
        this.setSiteParamsVisible();
    }

    public void replaceSiteParams(Iterator it) {
        ListIterator<String> siteIt = this.parameterList.getParameterNamesIterator();
        while (siteIt.hasNext()) {
            String paramName = (String)siteIt.next();
            if (paramName.equalsIgnoreCase(MIN_LATITUDE) || paramName.equalsIgnoreCase(MIN_LONGITUDE) || paramName.equalsIgnoreCase(MAX_LATITUDE) || paramName.equalsIgnoreCase(MAX_LONGITUDE) || paramName.equalsIgnoreCase(GRID_SPACING) || paramName.equalsIgnoreCase(SITE_PARAM_NAME)) continue;
            this.parameterList.removeParameter(paramName);
        }
        this.sites.removeSiteParams();
        this.addSiteParams(it);
    }

    public Iterator<Site> getSitesClone() {
        Iterator lIt = this.sites.getRegion().getNodeList().iterator();
        ArrayList<Site> newSiteVector = new ArrayList<Site>();
        while (lIt.hasNext()) {
            newSiteVector.add(new Site((Location)lIt.next()));
        }
        ListIterator<Parameter<?>> it = this.parameterList.getParametersIterator();
        while (it.hasNext()) {
            Parameter<?> tempParam = it.next();
            for (int i = 0; i < newSiteVector.size(); ++i) {
                if (((Site)newSiteVector.get(i)).containsParameter(tempParam)) continue;
                ((Site)newSiteVector.get(i)).addParameter((Parameter)tempParam.clone());
            }
        }
        return newSiteVector.iterator();
    }

    private void updateGriddedSiteParams() {
        ArrayList<Object> v = new ArrayList<Object>();
        this.createAndUpdateSites();
        Iterator<Parameter<?>> it = this.siteParams.iterator();
        while (it.hasNext()) {
            v.add(it.next().clone());
        }
        this.sites.addSiteParams(v.iterator());
    }

    @Override
    public void parameterChangeFailed(ParameterChangeFailEvent e) {
        String S = "SiteParamList : parameterChangeFailed(): ";
        StringBuffer b = new StringBuffer();
        Parameter param = (Parameter)e.getSource();
        ParameterConstraint constraint = param.getConstraint();
        String oldValueStr = e.getOldValue().toString();
        String badValueStr = e.getBadValue().toString();
        String name = param.getName();
        b.append("The value ");
        b.append(badValueStr);
        b.append(" is not permitted for '");
        b.append(name);
        b.append("'.\n");
        b.append("Resetting to ");
        b.append(oldValueStr);
        b.append(". The constraints are: \n");
        b.append(constraint.toString());
        JOptionPane.showMessageDialog(this, b.toString(), "Cannot Change Value", 1);
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        Parameter param = (Parameter)e.getSource();
        if (param.getName().equals(SITE_PARAM_NAME)) {
            this.setSiteParamsVisible();
        }
    }

    private void createAndUpdateSites() {
        double minLatitude = (Double)this.minLat.getValue();
        double maxLatitude = (Double)this.maxLat.getValue();
        double minLongitude = (Double)this.minLon.getValue();
        double maxLongitude = (Double)this.maxLon.getValue();
        GriddedRegion eggr = new GriddedRegion(new Location(minLatitude, minLongitude), new Location(maxLatitude, maxLongitude), (double)((Double)this.gridSpacing.getValue()), new Location(minLatitude, minLongitude));
        this.sites = new SitesInGriddedRegion(eggr);
    }

    public SitesInGriddedRegion getGriddedRegionSite() {
        this.updateGriddedSiteParams();
        if (((String)this.siteParam.getValue()).equals(SET_ALL_SITES)) {
            this.sites.setSameSiteParams();
        } else {
            try {
                this.setSiteParamsFromCVM();
            }
            catch (Exception e) {
                throw new RuntimeException("Server is down , please try again later", e);
            }
            ArrayList<Parameter> defaultSiteParams = new ArrayList<Parameter>();
            for (int i = 0; i < this.siteParams.size(); ++i) {
                Parameter tempParam = (Parameter)this.siteParams.get(i).clone();
                tempParam.setValue(this.parameterList.getParameter(DEFAULT + tempParam.getName()).getValue());
                defaultSiteParams.add(tempParam);
            }
            this.sites.setDefaultSiteParams(defaultSiteParams);
        }
        return this.sites;
    }

    private void setSiteParamsVisible() {
        Parameter tempParam;
        ListIterator<Parameter<?>> it = this.parameterList.getParametersIterator();
        if (((String)this.siteParam.getValue()).equals(SET_ALL_SITES)) {
            while (it.hasNext()) {
                tempParam = (Parameter)it.next();
                if (!tempParam.getName().startsWith(DEFAULT)) continue;
                this.parameterList.removeParameter(tempParam.getName());
            }
            ListIterator<Parameter<?>> it1 = this.siteParams.listIterator();
            while (it1.hasNext()) {
                Parameter<?> tempParam2 = it1.next();
                if (this.parameterList.containsParameter(tempParam2.getName())) continue;
                this.parameterList.addParameter(tempParam2);
            }
        } else {
            while (it.hasNext()) {
                tempParam = (Parameter)it.next();
                if (tempParam.getName().equalsIgnoreCase(MAX_LATITUDE)) continue;
                if (tempParam.getName().equalsIgnoreCase(MIN_LATITUDE)) continue;
                if (tempParam.getName().equalsIgnoreCase(MAX_LONGITUDE)) continue;
                if (tempParam.getName().equalsIgnoreCase(MIN_LONGITUDE)) continue;
                if (tempParam.getName().equalsIgnoreCase(GRID_SPACING)) continue;
                if (tempParam.getName().equalsIgnoreCase(SITE_PARAM_NAME)) continue;
                this.parameterList.removeParameter(tempParam.getName());
                if (!tempParam.getName().startsWith(DEFAULT)) {
                    this.siteTrans.setParameterValue(tempParam, "DE", Double.NaN);
                }
                Parameter newParam = (Parameter)tempParam.clone();
                if (!newParam.getName().startsWith(DEFAULT)) {
                    newParam.setName(DEFAULT + newParam.getName());
                }
                newParam.setNonEditable();
                newParam.addParameterChangeFailListener(this);
                if (this.parameterList.containsParameter(newParam.getName())) continue;
                this.parameterList.addParameter(newParam);
            }
        }
        if (this.dataGuiBean != null) {
            OrderedSiteDataProviderList list = this.dataGuiBean.getProviderList();
            this.dataGuiBean.refreshAll();
        }
        this.editorPanel.removeAll();
        this.addParameters();
        this.editorPanel.validate();
        this.editorPanel.repaint();
        this.setTitle(GRIDDED_SITE_PARAMS);
        this.refreshParamEditor();
    }

    private void setSiteParamsFromCVM() {
        Double lonMin = (Double)this.parameterList.getParameter(MIN_LONGITUDE).getValue();
        Double lonMax = (Double)this.parameterList.getParameter(MAX_LONGITUDE).getValue();
        Double latMin = (Double)this.parameterList.getParameter(MIN_LATITUDE).getValue();
        Double latMax = (Double)this.parameterList.getParameter(MAX_LATITUDE).getValue();
        Double gridSpacing = (Double)this.parameterList.getParameter(GRID_SPACING).getValue();
        if (lonMin == null || latMin == null) {
            JOptionPane.showMessageDialog(this, "Check the values in longitude and latitude");
            return;
        }
        OrderedSiteDataProviderList dataProviders = null;
        dataProviders = this.dataGuiBean != null ? this.dataGuiBean.getProviderList() : this.defaultProviderList;
        CalcProgressBar calcProgress = new CalcProgressBar("Setting Gridded Region sites", "Getting the site paramters from the CVM");
        if (((String)this.siteParam.getValue()).equals(SET_SITE_USING_WILLS_SITE_TYPE)) {
            dataProviders = dataProviders.clone();
            for (int i = 0; i < dataProviders.size(); ++i) {
                if (!dataProviders.getProvider(i).getDataType().equals("Depth to Vs = 2.5 km/sec")) continue;
                dataProviders.setEnabled(i, false);
            }
        }
        try {
            this.sites.setSiteParamsForRegion(dataProviders);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        calcProgress.dispose();
    }
}

