/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.opensha.commons.gui.ControlPanel;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.gui.HazardCurveApplication;

public class DisaggregationControlPanel
extends ControlPanel
implements ParameterChangeFailListener,
ParameterChangeListener {
    public static final String NAME = "Disaggregation";
    private static final String DISAGGREGATION_PROB_PARAM_NAME = "Disaggregation Prob";
    private static final String DISAGGREGATION_IML_PARAM_NAME = "Disaggregation IML";
    private DoubleParameter disaggregationProbParam = new DoubleParameter("Disaggregation Prob", 0.0, 1.0, (Double)0.01);
    private DoubleParameter disaggregationIMLParam = new DoubleParameter("Disaggregation IML", 0.0, 11.0, (Double)0.1);
    private StringParameter disaggregationParameter;
    private static final String DISAGGREGATION_PARAM_NAME = "Diasaggregate";
    public static final String NO_DISAGGREGATION = "No Disaggregation";
    public static final String DISAGGREGATE_USING_PROB = "Probability";
    public static final String DISAGGREGATE_USING_IML = "IML";
    private static final String SOURCE_DISAGGR_PARAM_NAME = "Show Source Disaggregation List";
    private BooleanParameter sourceDisaggregationParam = new BooleanParameter("Show Source Disaggregation List", false);
    private static final String NUM_SOURCE_PARAM_NAME = "Num Sources in List";
    private IntegerParameter numSourcesToShow = new IntegerParameter("Num Sources in List", 100);
    private static final String SHOW_DISTANCES_PARAM_NAME = "Include Source Distances";
    private BooleanParameter showDistancesParam = new BooleanParameter("Include Source Distances", false);
    private static final String SHOW_DISAGGR_BIN_RATE_PARAM_NAME = "Show Disaggregation Bin Rate Data";
    private BooleanParameter binRateDisaggregationParam = new BooleanParameter("Show Disaggregation Bin Rate Data", false);
    private static final String MIN_MAG_PARAM_NAME = "Min Mag (bin center)";
    private static final String NUM_MAG_PARAM_NAME = "Num Mag";
    private static final String DELTA_MAG_PARAM_NAME = "Delta Mag";
    private DoubleParameter minMagParam = new DoubleParameter("Min Mag (bin center)", 0.0, 10.0, (Double)5.0);
    private IntegerParameter numMagParam = new IntegerParameter("Num Mag", 10);
    private DoubleParameter deltaMagParam = new DoubleParameter("Delta Mag", 0.5);
    private static final String DIST_TYPE_PARAM_NAME = "Distance Binning Type";
    private static final String CUSTOM_DIST_PARAM_NAME = "Comma Separated Custom Bin Edges";
    private static final String CUSTOM_DIST_DEFAULT = "0,1,2,5,10,20,50,100,200";
    private StringParameter distBinTypeSelector = null;
    private StringParameter customDistBinParam = null;
    private static final String DIST_TYPE_EVEN = "Even";
    private static final String DIST_TYPE_CUSTOM = "Custom";
    private static final String MIN_DIST_PARAM_NAME = "Min Dist (bin center)";
    private static final String NUM_DIST_PARAM_NAME = "Num Dist";
    private static final String DELTA_DIST_PARAM_NAME = "Delta Dist";
    private DoubleParameter minDistParam = new DoubleParameter("Min Dist (bin center)", 5.0);
    private IntegerParameter numDistParam = new IntegerParameter("Num Dist", 11);
    private DoubleParameter deltaDistParam = new DoubleParameter("Delta Dist", 10.0);
    private static final String Z_AXIS_MAX_NAME = "Z-Axis Max";
    private static final String Z_AXIS_MAX_INFO = "Set the max value for the Z -Axis in percentage";
    private DoubleParameter zMaxParam = new DoubleParameter("Z-Axis Max", 0.0, 100.0, (Double)50.0);
    private StringParameter zMaxChoiceParam;
    private static final String Z_AXIS_MAX_CHOICE_NAME = "Set Z-Axis Max. from";
    private static final String Z_AXIS_MAX_CHOICE_INFO = "Allows to set the Z-Axis max either from data or manually";
    private static final String Z_AXIS_MAX_CHOICE_MANUALLY = "Manually";
    private static final String Z_AXIS_MAX_CHOICE_FROM_DATA = "From Data";
    private static final String USE_GMT_PLOTTER_NAME = "Use GMT Plotter";
    private BooleanParameter useGMTparam = new BooleanParameter("Use GMT Plotter", false);
    private ParameterListEditor paramListEditor;
    private boolean isDisaggregationSelected;
    HazardCurveApplication parent;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JFrame frame;
    private Component parentComponent;

    public DisaggregationControlPanel(HazardCurveApplication parent, Component parentComponent) {
        super(NAME);
        this.parent = parent;
        this.parentComponent = parentComponent;
    }

    @Override
    public void doinit() {
        this.frame = new JFrame();
        this.minMagParam.setInfo("The center of the first magnitude bin (for histogram & mode calcs)");
        this.minDistParam.setInfo("The center of the first distance bin (for histogram & mode calcs)");
        this.numMagParam.setInfo("The number of magnitude bins (for histogram & mode calcs)");
        this.numDistParam.setInfo("The number of distance bins (for histogram & mode calcs)");
        this.deltaMagParam.setInfo("The width of magnitude bins (for histogram & mode calcs)");
        this.deltaDistParam.setInfo("The width of distance bins (for histogram & mode calcs)");
        this.sourceDisaggregationParam.setInfo("To show a list of sources in descending order of their contribution to the hazard");
        this.numSourcesToShow.setInfo("The number of sources to show in the list");
        this.showDistancesParam.setInfo("Compute and display source distance metrics");
        this.zMaxParam.setInfo(Z_AXIS_MAX_INFO);
        this.useGMTparam.setInfo("If enabled, plots will be generated on the OpenSHA server via GMT.\nThis requires more time and an active internet connection, but may look better.");
        try {
            this.parent = this.parent;
            ArrayList<String> disaggregateList = new ArrayList<String>();
            disaggregateList.add(NO_DISAGGREGATION);
            disaggregateList.add(DISAGGREGATE_USING_PROB);
            disaggregateList.add(DISAGGREGATE_USING_IML);
            this.disaggregationParameter = new StringParameter(DISAGGREGATION_PARAM_NAME, disaggregateList, (String)disaggregateList.get(0));
            this.disaggregationParameter.addParameterChangeListener(this);
            this.disaggregationProbParam.addParameterChangeFailListener(this);
            this.disaggregationIMLParam.addParameterChangeFailListener(this);
            this.sourceDisaggregationParam.addParameterChangeListener(this);
            ArrayList<String> distBinTypes = new ArrayList<String>();
            distBinTypes.add(DIST_TYPE_EVEN);
            distBinTypes.add(DIST_TYPE_CUSTOM);
            this.distBinTypeSelector = new StringParameter(DIST_TYPE_PARAM_NAME, distBinTypes);
            this.distBinTypeSelector.setValue(DIST_TYPE_EVEN);
            this.distBinTypeSelector.addParameterChangeListener(this);
            this.customDistBinParam = new StringParameter(CUSTOM_DIST_PARAM_NAME);
            this.customDistBinParam.setValue(CUSTOM_DIST_DEFAULT);
            ArrayList<String> zAxisChoiceList = new ArrayList<String>();
            zAxisChoiceList.add(Z_AXIS_MAX_CHOICE_FROM_DATA);
            zAxisChoiceList.add(Z_AXIS_MAX_CHOICE_MANUALLY);
            this.zMaxChoiceParam = new StringParameter(Z_AXIS_MAX_CHOICE_NAME, zAxisChoiceList, (String)zAxisChoiceList.get(0));
            this.zMaxChoiceParam.setInfo(Z_AXIS_MAX_CHOICE_INFO);
            this.zMaxChoiceParam.addParameterChangeListener(this);
            ParameterList paramList = new ParameterList();
            paramList.addParameter(this.disaggregationParameter);
            paramList.addParameter(this.disaggregationProbParam);
            paramList.addParameter(this.disaggregationIMLParam);
            paramList.addParameter(this.sourceDisaggregationParam);
            paramList.addParameter(this.numSourcesToShow);
            paramList.addParameter(this.showDistancesParam);
            paramList.addParameter(this.binRateDisaggregationParam);
            paramList.addParameter(this.minMagParam);
            paramList.addParameter(this.numMagParam);
            paramList.addParameter(this.deltaMagParam);
            paramList.addParameter(this.distBinTypeSelector);
            paramList.addParameter(this.minDistParam);
            paramList.addParameter(this.numDistParam);
            paramList.addParameter(this.deltaDistParam);
            paramList.addParameter(this.customDistBinParam);
            paramList.addParameter(this.zMaxChoiceParam);
            paramList.addParameter(this.zMaxParam);
            paramList.addParameter(this.useGMTparam);
            this.paramListEditor = new ParameterListEditor(paramList);
            this.setParamsVisible((String)this.disaggregationParameter.getValue());
            this.jbInit();
            this.frame.setLocation(this.parentComponent.getX() + this.parentComponent.getWidth() / 2, 0);
            this.parent.setDisaggregationSelected(this.isDisaggregationSelected);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.frame.getContentPane().setLayout(this.gridBagLayout1);
        this.frame.getContentPane().add((Component)this.paramListEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.frame.setTitle("Disaggregation Control Panel");
        this.paramListEditor.setTitle("Set Disaggregation Params");
        this.frame.setSize(300, 200);
    }

    @Override
    public void parameterChangeFailed(ParameterChangeFailEvent e) {
        StringBuffer b = new StringBuffer();
        Parameter param = (Parameter)e.getSource();
        ParameterConstraint constraint = param.getConstraint();
        String oldValueStr = e.getOldValue().toString();
        String badValueStr = e.getBadValue().toString();
        String name = param.getName();
        b.append("The value ");
        b.append(badValueStr);
        b.append(" is not permitted for '");
        b.append(name);
        b.append("'.\n");
        b.append("Resetting to ");
        b.append(oldValueStr);
        b.append(". The constraints are: \n");
        b.append(constraint.toString());
        JOptionPane.showMessageDialog(this.frame, b.toString(), "Cannot Change Value", 1);
    }

    private void showNumSourcesParam(boolean paramToShow) {
        this.paramListEditor.getParameterEditor(NUM_SOURCE_PARAM_NAME).setVisible(paramToShow);
        this.paramListEditor.getParameterEditor(SHOW_DISTANCES_PARAM_NAME).setVisible(paramToShow);
    }

    private void showZMaxAxisParam() {
        String zAxisChoiceVal = (String)this.zMaxChoiceParam.getValue();
        if (zAxisChoiceVal.equals(Z_AXIS_MAX_CHOICE_FROM_DATA)) {
            this.paramListEditor.getParameterEditor(Z_AXIS_MAX_NAME).setVisible(false);
        } else {
            this.paramListEditor.getParameterEditor(Z_AXIS_MAX_NAME).setVisible(true);
        }
    }

    private void setCustomBinning(boolean custom) {
        this.paramListEditor.getParameterEditor(MIN_DIST_PARAM_NAME).setVisible(!custom);
        this.paramListEditor.getParameterEditor(NUM_DIST_PARAM_NAME).setVisible(!custom);
        this.paramListEditor.getParameterEditor(DELTA_DIST_PARAM_NAME).setVisible(!custom);
        this.paramListEditor.getParameterEditor(CUSTOM_DIST_PARAM_NAME).setVisible(custom);
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String paramName = e.getParameterName();
        if (paramName.equals(DISAGGREGATION_PARAM_NAME)) {
            this.setParamsVisible((String)this.disaggregationParameter.getValue());
        } else if (paramName.equals(SOURCE_DISAGGR_PARAM_NAME)) {
            this.showNumSourcesParam((Boolean)this.sourceDisaggregationParam.getValue());
        } else if (paramName.equals(Z_AXIS_MAX_CHOICE_NAME)) {
            this.showZMaxAxisParam();
        } else if (paramName.equals(DIST_TYPE_PARAM_NAME)) {
            String distType = (String)this.distBinTypeSelector.getValue();
            if (distType.equals(DIST_TYPE_EVEN)) {
                this.setCustomBinning(false);
            } else if (distType.equals(DIST_TYPE_CUSTOM)) {
                this.setCustomBinning(true);
            }
        }
    }

    public double getMinMag() {
        return (Double)this.minMagParam.getValue();
    }

    public int getNumMag() {
        return (Integer)this.numMagParam.getValue();
    }

    public double getdeltaMag() {
        return (Double)this.deltaMagParam.getValue();
    }

    public double getMinDist() {
        return (Double)this.minDistParam.getValue();
    }

    public int getNumDist() {
        return (Integer)this.numDistParam.getValue();
    }

    public double getdeltaDist() {
        return (Double)this.deltaDistParam.getValue();
    }

    public double getZAxisMax() {
        boolean isVisible = this.paramListEditor.getParameterEditor(Z_AXIS_MAX_NAME).isVisible();
        if (isVisible) {
            return (Double)this.zMaxParam.getValue();
        }
        return Double.NaN;
    }

    public boolean isUseGMT() {
        return (Boolean)this.useGMTparam.getValue();
    }

    private void setParamsVisible(String paramValue) {
        if (paramValue.equals(NO_DISAGGREGATION)) {
            this.paramListEditor.getParameterEditor(DISAGGREGATION_PROB_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(DISAGGREGATION_IML_PARAM_NAME).setVisible(false);
            this.isDisaggregationSelected = false;
            this.paramListEditor.getParameterEditor(MIN_MAG_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(NUM_MAG_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(DELTA_MAG_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(MIN_DIST_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(NUM_DIST_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(DELTA_DIST_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(SOURCE_DISAGGR_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(SHOW_DISAGGR_BIN_RATE_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(DIST_TYPE_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(CUSTOM_DIST_PARAM_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(Z_AXIS_MAX_CHOICE_NAME).setVisible(false);
            this.showNumSourcesParam(false);
            this.paramListEditor.getParameterEditor(Z_AXIS_MAX_NAME).setVisible(false);
            this.paramListEditor.getParameterEditor(USE_GMT_PLOTTER_NAME).setVisible(false);
            this.frame.setSize(300, 200);
        } else {
            if (paramValue.equals(DISAGGREGATE_USING_PROB)) {
                this.paramListEditor.getParameterEditor(DISAGGREGATION_PROB_PARAM_NAME).setVisible(true);
                this.paramListEditor.getParameterEditor(DISAGGREGATION_IML_PARAM_NAME).setVisible(false);
                this.isDisaggregationSelected = true;
            } else if (paramValue.equals(DISAGGREGATE_USING_IML)) {
                this.paramListEditor.getParameterEditor(DISAGGREGATION_PROB_PARAM_NAME).setVisible(false);
                this.paramListEditor.getParameterEditor(DISAGGREGATION_IML_PARAM_NAME).setVisible(true);
                this.isDisaggregationSelected = true;
            }
            this.paramListEditor.getParameterEditor(MIN_MAG_PARAM_NAME).setVisible(true);
            this.paramListEditor.getParameterEditor(NUM_MAG_PARAM_NAME).setVisible(true);
            this.paramListEditor.getParameterEditor(DELTA_MAG_PARAM_NAME).setVisible(true);
            this.paramListEditor.getParameterEditor(MIN_DIST_PARAM_NAME).setVisible(true);
            this.paramListEditor.getParameterEditor(NUM_DIST_PARAM_NAME).setVisible(true);
            this.paramListEditor.getParameterEditor(DELTA_DIST_PARAM_NAME).setVisible(true);
            this.paramListEditor.getParameterEditor(SOURCE_DISAGGR_PARAM_NAME).setVisible(true);
            this.paramListEditor.getParameterEditor(SHOW_DISAGGR_BIN_RATE_PARAM_NAME).setVisible(true);
            this.paramListEditor.getParameterEditor(DIST_TYPE_PARAM_NAME).setVisible(true);
            String distType = (String)this.distBinTypeSelector.getValue();
            this.setCustomBinning(distType.equals(DIST_TYPE_CUSTOM));
            this.paramListEditor.getParameterEditor(Z_AXIS_MAX_CHOICE_NAME).setVisible(true);
            this.paramListEditor.getParameterEditor(USE_GMT_PLOTTER_NAME).setVisible(true);
            this.showZMaxAxisParam();
            this.showNumSourcesParam((Boolean)this.sourceDisaggregationParam.getValue());
            Dimension curDims = this.frame.getSize();
            int width = 300;
            int height = 500;
            if (curDims.width > width) {
                width = curDims.width;
            }
            if (curDims.height > height) {
                height = curDims.height;
            }
            this.frame.setSize(width, height);
        }
        this.frame.repaint();
        this.frame.validate();
        this.parent.setDisaggregationSelected(this.isDisaggregationSelected);
    }

    public String getDisaggregationParamValue() {
        return (String)this.disaggregationParameter.getValue();
    }

    public double getDisaggregationVal() {
        if (this.isDisaggregationSelected) {
            String paramValue = this.getDisaggregationParamValue();
            if (paramValue.equals(DISAGGREGATE_USING_PROB)) {
                return (Double)this.disaggregationProbParam.getValue();
            }
            if (paramValue.equals(DISAGGREGATE_USING_IML)) {
                return (Double)this.disaggregationIMLParam.getValue();
            }
        }
        return -1.0;
    }

    public boolean isSourceDisaggregationSelected() {
        if (this.isDisaggregationSelected) {
            return (Boolean)this.sourceDisaggregationParam.getValue();
        }
        return false;
    }

    public int getNumSourcesForDisagg() {
        if (this.isDisaggregationSelected && this.isSourceDisaggregationSelected()) {
            return (Integer)this.numSourcesToShow.getValue();
        }
        return 0;
    }

    public boolean isShowSourceDistances() {
        return (Boolean)this.showDistancesParam.getValue();
    }

    public boolean isShowDisaggrBinDataSelected() {
        return (Boolean)this.binRateDisaggregationParam.getValue();
    }

    public boolean isCustomDistBinning() {
        String distType = (String)this.distBinTypeSelector.getValue();
        return distType.equals(DIST_TYPE_CUSTOM);
    }

    public double[] getCustomBinEdges() {
        String edgesStr = (String)this.customDistBinParam.getValue();
        StringTokenizer tok = new StringTokenizer(edgesStr, ", ;");
        ArrayList<Double> edgesList = new ArrayList<Double>();
        while (tok.hasMoreTokens()) {
            String tokStr = tok.nextToken();
            try {
                double val = Double.parseDouble(tokStr);
                edgesList.add(val);
            }
            catch (NumberFormatException e) {
                System.err.println("Bin Edge '" + tokStr + "' is not a number!");
            }
        }
        double[] edges = new double[edgesList.size()];
        for (int i = 0; i < edgesList.size(); ++i) {
            edges[i] = (Double)edgesList.get(i);
        }
        return edges;
    }

    @Override
    public Window getComponent() {
        return this.frame;
    }
}

