/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.Timer;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.gui.ControlPanel;
import org.opensha.sha.gui.ScenarioShakeMapApp;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;

public class GenerateHazusControlPanelForSingleMultipleIMRs
extends ControlPanel
implements Runnable {
    public static final String NAME = "Generate Hazus Shape files for Scenario";
    private JPanel jPanel1 = new JPanel();
    private JTextPane infoPanel = new JTextPane();
    private BorderLayout borderLayout1 = new BorderLayout();
    private ScenarioShakeMapApp application;
    private GeoDataSet sa03_xyzdata;
    private GeoDataSet sa10_xyzdata;
    private GeoDataSet pga_xyzdata;
    private GeoDataSet pgv_xyzdata;
    private String sa_03xyzDataString;
    private String sa_10xyzDataString;
    private String pga_xyzDataString;
    private String pgv_xyzDataString;
    private boolean calcOnServer = true;
    private String metadata = "";
    private JButton generateHazusShapeFilesButton = new JButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    boolean generatingXYZDataForShapeFiles = false;
    CalcProgressBar calcProgress;
    Timer timer;
    private int step;
    private Component parent;
    private JFrame frame;

    public GenerateHazusControlPanelForSingleMultipleIMRs(Component parent, ScenarioShakeMapApp api) {
        super(NAME);
        this.parent = parent;
        this.application = api;
    }

    @Override
    public void doinit() {
        this.frame = new JFrame();
        this.frame.setLocation(this.parent.getX() + this.parent.getWidth() / 2, this.parent.getY() + this.parent.getHeight() / 2);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.frame.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.frame.setTitle("Hazus Shapefiles Control");
        this.infoPanel.setBackground(SystemColor.menu);
        this.infoPanel.setEnabled(false);
        String info = new String("Info:\n\nClicking the above generates a set of Hazus shapefiles (0.3- and 1.0-sec SA, pga, and pgv) for the selected Earthquake Rupture and IMR.  Be sure to have selected the \"Average-Horizontal\" component, and note that PGV is in units of inches/sec in these files (as assumed by Hazus).  Note also that the following Map Attributes are temporarliy set for the calculation: \"Plot Log\" is deselected); \"Color Scale Limits\" is \"From Data\"; and \"Generate Hazus Shape Files\" is selected.");
        this.infoPanel.setPreferredSize(new Dimension(812, 24));
        this.infoPanel.setEditable(false);
        this.infoPanel.setText(info);
        this.jPanel1.setMinimumSize(new Dimension(350, 220));
        this.jPanel1.setPreferredSize(new Dimension(350, 300));
        this.generateHazusShapeFilesButton.setText("Generate Hazus Shape Files");
        this.generateHazusShapeFilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateHazusControlPanelForSingleMultipleIMRs.this.generateHazusShapeFilesButton_actionPerformed(e);
            }
        });
        this.frame.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.infoPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 42, 19, 41), 0, 0));
        this.jPanel1.add((Component)this.generateHazusShapeFilesButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(14, 49, 6, 54), 87, 8));
    }

    private void generateHazusFiles(ArrayList selectedAttenRels, ArrayList selectedAttenRelWts) throws ParameterException {
        this.metadata = "<br>Hazus Metadata: \n<br>-------------------\n<br>";
        this.application.getEqkRupture();
        this.hazusCalcForSA(selectedAttenRels, selectedAttenRelWts);
        this.doCalcForPGV(selectedAttenRels, selectedAttenRelWts);
        this.hazusCalcForPGA(selectedAttenRels, selectedAttenRelWts);
        this.step = 6;
        if (!this.calcOnServer) {
            this.application.makeMapForHazus(this.sa03_xyzdata, this.sa10_xyzdata, this.pga_xyzdata, this.pgv_xyzdata);
        } else {
            this.application.makeMapForHazus(this.sa_03xyzDataString, this.sa_10xyzDataString, this.pga_xyzDataString, this.pgv_xyzDataString);
        }
    }

    private void doCalcForPGV(ArrayList selectedAttenRels, ArrayList selectedAttenRelsWts) throws ParameterException {
        this.step = 4;
        this.metadata = this.metadata + "IMT = PGV<br>\n";
        ArrayList<AttenuationRelationship> attenRelListSupportingPGV = new ArrayList<AttenuationRelationship>();
        ArrayList<AttenuationRelationship> attenRelListNotSupportingPGV = new ArrayList<AttenuationRelationship>();
        ArrayList attenRelListPGV_Wts = new ArrayList();
        ArrayList attenRelListNot_PGV_Wts = new ArrayList();
        int size = selectedAttenRels.size();
        for (int i = 0; i < size; ++i) {
            AttenuationRelationship attenRel = (AttenuationRelationship)selectedAttenRels.get(i);
            if (attenRel.isIntensityMeasureSupported("PGV")) {
                attenRelListSupportingPGV.add(attenRel);
                attenRelListPGV_Wts.add(selectedAttenRelsWts.get(i));
                continue;
            }
            attenRelListNotSupportingPGV.add(attenRel);
            attenRelListNot_PGV_Wts.add(selectedAttenRelsWts.get(i));
        }
        if (!this.calcOnServer) {
            GeoDataSet xyzDataSet_PGV = null;
            GeoDataSet xyzDataSet = null;
            if (attenRelListSupportingPGV.size() > 0) {
                xyzDataSet_PGV = this.hazusCalcForPGV(attenRelListSupportingPGV, attenRelListPGV_Wts, true);
                size = xyzDataSet_PGV.size();
            }
            if (attenRelListNotSupportingPGV.size() > 0) {
                xyzDataSet = this.hazusCalcForPGV(attenRelListNotSupportingPGV, attenRelListNot_PGV_Wts, false);
                size = xyzDataSet.size();
            }
            if (xyzDataSet_PGV != null && xyzDataSet != null) {
                this.pgv_xyzdata = new ArbDiscrGeoDataSet(true);
                for (int i = 0; i < size; ++i) {
                    this.pgv_xyzdata.set(xyzDataSet_PGV.getLocation(i), xyzDataSet_PGV.get(i) + xyzDataSet.get(i));
                }
            } else if (xyzDataSet_PGV == null) {
                this.pgv_xyzdata = xyzDataSet;
            } else if (xyzDataSet == null) {
                this.pgv_xyzdata = xyzDataSet_PGV;
            }
        } else {
            this.doCalcForPGV_OnServer(attenRelListSupportingPGV, attenRelListNotSupportingPGV, attenRelListPGV_Wts, attenRelListNot_PGV_Wts);
        }
    }

    private void doCalcForPGV_OnServer(ArrayList attenRelsSupportingPGV, ArrayList attenRelsNotSupportingPGV, ArrayList attenRelListPGV_Wts, ArrayList attenRelListNot_PGV_Wts) throws ParameterException {
        int i;
        ArrayList<ScalarIMR> attenRelList = new ArrayList<ScalarIMR>();
        ArrayList attenRelWtList = new ArrayList();
        int size = attenRelsSupportingPGV.size();
        for (i = 0; i < size; ++i) {
            ((ScalarIMR)attenRelsSupportingPGV.get(i)).setIntensityMeasure("PGV");
            attenRelList.add((ScalarIMR)attenRelsSupportingPGV.get(i));
            attenRelWtList.add(attenRelListPGV_Wts.get(i));
        }
        size = attenRelsNotSupportingPGV.size();
        for (i = 0; i < size; ++i) {
            ((ScalarIMR)attenRelsNotSupportingPGV.get(i)).setIntensityMeasure("SA");
            attenRelList.add((ScalarIMR)attenRelsNotSupportingPGV.get(i));
            attenRelWtList.add(attenRelListNot_PGV_Wts.get(i));
        }
        this.setSA_PeriodForSelectedIMRs(attenRelsNotSupportingPGV, 1.0);
        this.pgv_xyzDataString = (String)this.application.generateShakeMap(attenRelList, attenRelWtList, "PGV");
    }

    private void hazusCalcForPGA(ArrayList selectedAttenRels, ArrayList selectedAttenRelsWt) throws ParameterException {
        this.step = 5;
        int size = selectedAttenRels.size();
        for (int i = 0; i < size; ++i) {
            ((ScalarIMR)selectedAttenRels.get(i)).setIntensityMeasure("PGA");
        }
        if (!this.calcOnServer) {
            this.pga_xyzdata = (GeoDataSet)this.application.generateShakeMap(selectedAttenRels, selectedAttenRelsWt, "PGA");
        } else {
            this.pga_xyzDataString = (String)this.application.generateShakeMap(selectedAttenRels, selectedAttenRelsWt, "PGA");
        }
        this.metadata = this.metadata + "IMT = PGA\n";
    }

    private void hazusCalcForSA(ArrayList selectedAttenRels, ArrayList selectedAttenRelsWt) throws ParameterException {
        this.step = 2;
        int size = selectedAttenRels.size();
        for (int i = 0; i < size; ++i) {
            ((ScalarIMR)selectedAttenRels.get(i)).setIntensityMeasure("SA");
        }
        this.setSA_PeriodForSelectedIMRs(selectedAttenRels, 0.3);
        if (!this.calcOnServer) {
            this.sa03_xyzdata = (GeoDataSet)this.application.generateShakeMap(selectedAttenRels, selectedAttenRelsWt, "SA");
        } else {
            this.sa_03xyzDataString = (String)this.application.generateShakeMap(selectedAttenRels, selectedAttenRelsWt, "SA");
        }
        this.metadata = this.metadata + "IMT = SA [ SA Damping = 5.0 ; SA Period = 0.3 ]<br>\n";
        this.step = 3;
        this.setSA_PeriodForSelectedIMRs(selectedAttenRels, 1.0);
        if (!this.calcOnServer) {
            this.sa10_xyzdata = (GeoDataSet)this.application.generateShakeMap(selectedAttenRels, selectedAttenRelsWt, "SA");
        } else {
            this.sa_10xyzDataString = (String)this.application.generateShakeMap(selectedAttenRels, selectedAttenRelsWt, "SA");
        }
        this.metadata = this.metadata + "IMT = SA [ SA Damping = 5.0 ; SA Period = 1.0 ]<br>\n";
    }

    private GeoDataSet hazusCalcForPGV(ArrayList attenRelList, ArrayList attenRelWtList, boolean pgvSupported) throws ParameterException {
        GeoDataSet pgvDataSet = null;
        int size = attenRelList.size();
        if (pgvSupported) {
            for (int i = 0; i < size; ++i) {
                ((ScalarIMR)attenRelList.get(i)).setIntensityMeasure("PGV");
            }
            pgvDataSet = (GeoDataSet)this.application.generateShakeMap(attenRelList, attenRelWtList, "PGV");
        } else {
            for (int i = 0; i < size; ++i) {
                ((ScalarIMR)attenRelList.get(i)).setIntensityMeasure("SA");
            }
            this.setSA_PeriodForSelectedIMRs(attenRelList, 1.0);
            pgvDataSet = (GeoDataSet)this.application.generateShakeMap(attenRelList, attenRelWtList, "SA");
            pgvDataSet.scale(94.5896);
        }
        return pgvDataSet;
    }

    private void setSA_PeriodForSelectedIMRs(ArrayList selectedAttenRels, double period) {
        int size = selectedAttenRels.size();
        for (int i = 0; i < size; ++i) {
            ((ScalarIMR)selectedAttenRels.get(i)).getParameter("SA Period").setValue(period);
        }
    }

    public String getIMT_Metadata() {
        return this.metadata;
    }

    public Object getXYZ_DataForSA_03() {
        if (!this.calcOnServer) {
            return this.sa03_xyzdata;
        }
        return this.sa_03xyzDataString;
    }

    public Object getXYZ_DataForSA_10() {
        if (!this.calcOnServer) {
            return this.sa10_xyzdata;
        }
        return this.sa_10xyzDataString;
    }

    public Object getXYZ_DataForPGA() {
        if (!this.calcOnServer) {
            return this.pga_xyzdata;
        }
        return this.pga_xyzDataString;
    }

    public Object getXYZ_DataForPGV() {
        if (!this.calcOnServer) {
            return this.pgv_xyzdata;
        }
        return this.pgv_xyzDataString;
    }

    @Override
    public void run() {
        try {
            this.runToGenerateShapeFilesAndMaps();
        }
        catch (RuntimeException ee) {
            ee.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, ee.getMessage(), "Input or Server Problem", 1);
            this.step = 0;
        }
        if (this.calcProgress != null) {
            this.calcProgress.dispose();
        }
    }

    public void runToGenerateShapeFilesAndMaps() {
        this.getRegionAndMapType();
        this.calcOnServer = false;
        this.generateShapeFilesForHazus();
    }

    void generateHazusShapeFilesButton_actionPerformed(ActionEvent e) {
        this.calcProgress = new CalcProgressBar("Hazus Shape file data", "Starting Calculation...");
        this.timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (GenerateHazusControlPanelForSingleMultipleIMRs.this.step == 1) {
                    GenerateHazusControlPanelForSingleMultipleIMRs.this.calcProgress.setProgressMessage("Doing Calculation for the Hazus ShapeFile Data...");
                } else if (GenerateHazusControlPanelForSingleMultipleIMRs.this.step == 2) {
                    GenerateHazusControlPanelForSingleMultipleIMRs.this.calcProgress.setProgressMessage("Doing Calculation for 0.3-sec SA (1 of 4)");
                } else if (GenerateHazusControlPanelForSingleMultipleIMRs.this.step == 3) {
                    GenerateHazusControlPanelForSingleMultipleIMRs.this.calcProgress.setProgressMessage("Doing Calculation for 1.0-sec SA (2 of 4)");
                } else if (GenerateHazusControlPanelForSingleMultipleIMRs.this.step == 4) {
                    GenerateHazusControlPanelForSingleMultipleIMRs.this.calcProgress.setProgressMessage("Doing Calculation for PGV (3 of 4)");
                } else if (GenerateHazusControlPanelForSingleMultipleIMRs.this.step == 5) {
                    GenerateHazusControlPanelForSingleMultipleIMRs.this.calcProgress.setProgressMessage("Doing Calculation for PGA (4 of 4)");
                } else if (GenerateHazusControlPanelForSingleMultipleIMRs.this.step == 6) {
                    GenerateHazusControlPanelForSingleMultipleIMRs.this.calcProgress.setProgressMessage("Generating the Map images for Hazus ...");
                } else if (GenerateHazusControlPanelForSingleMultipleIMRs.this.step == 0) {
                    GenerateHazusControlPanelForSingleMultipleIMRs.this.calcProgress.showProgress(false);
                    GenerateHazusControlPanelForSingleMultipleIMRs.this.calcProgress.dispose();
                    GenerateHazusControlPanelForSingleMultipleIMRs.this.calcProgress = null;
                    GenerateHazusControlPanelForSingleMultipleIMRs.this.timer.stop();
                }
            }
        });
        Thread t = new Thread(this);
        t.start();
    }

    public void generateShapeFilesForHazus() throws ParameterException {
        this.setGenerateShapeFilesForHazus(true);
        this.generateHazusFiles(this.application.getSelectedAttenuationRelationships(), this.application.getSelectedAttenuationRelationshipsWts());
        this.step = 0;
    }

    public void setGenerateShapeFilesForHazus(boolean generateHazusShapeFiles) {
        this.generatingXYZDataForShapeFiles = generateHazusShapeFiles;
    }

    public void getRegionAndMapType() {
        this.application.getGriddedSitesMapTypeAndSelectedAttenRels();
        this.step = 1;
        if (this.timer != null) {
            this.timer.start();
        }
    }

    public boolean isGenerateShapeFilesForHazus() {
        return this.generatingXYZDataForShapeFiles;
    }

    @Override
    public Window getComponent() {
        return this.frame;
    }
}

