/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.controls;

import java.util.ArrayList;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.gui.beans.AttenuationRelationshipGuiBean;
import org.opensha.sha.gui.beans.ERF_GuiBean;
import org.opensha.sha.gui.beans.EqkRupSelectorGuiBean;
import org.opensha.sha.gui.beans.EqkRuptureFromERFSelectorPanel;
import org.opensha.sha.gui.beans.MapGuiBean;
import org.opensha.sha.gui.beans.SitesInGriddedRectangularRegionGuiBean;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.magdist.SingleMagFreqDist;
import org.opensha.sha.param.MagFreqDistParameter;
import org.opensha.sha.param.SimpleFaultParameter;
import org.opensha.sha.param.editor.MagFreqDistParameterEditor;
import org.opensha.sha.param.editor.gui.SimpleFaultParameterEditorPanel;

public class PuenteHillsScenarioControlPanelForSingleMultipleAttenRel {
    protected static final boolean D = false;
    private EqkRupSelectorGuiBean erfGuiBean;
    private AttenuationRelationshipGuiBean imrGuiBean;
    private SitesInGriddedRectangularRegionGuiBean regionGuiBean;
    private MapGuiBean mapGuiBean;
    private FaultTrace faultTrace;
    private double aveDipDir;
    private double magnitude = 7.1;

    public PuenteHillsScenarioControlPanelForSingleMultipleAttenRel(EqkRupSelectorGuiBean erfGuiBean, AttenuationRelationshipGuiBean imrGuiBean, SitesInGriddedRectangularRegionGuiBean regionGuiBean, MapGuiBean mapGuiBean) {
        this.erfGuiBean = erfGuiBean;
        this.imrGuiBean = imrGuiBean;
        this.regionGuiBean = regionGuiBean;
        this.mapGuiBean = mapGuiBean;
        this.mkFaultTrace();
    }

    private void mkFaultTrace() {
        Location loc3;
        this.aveDipDir = 0.0;
        Location loc1 = new Location(33.97087, -118.12273, 2.97944);
        Location loc2 = new Location(34.15721, -118.04988, 14.5327);
        LocationVector dir1 = LocationUtils.vector(loc1, loc2);
        double dip = Math.tan(dir1.getVertDistance() / dir1.getHorzDistance());
        double vDist = 5.0 - loc1.getDepth();
        double hDist = vDist / Math.atan(dip);
        this.aveDipDir += dir1.getAzimuth();
        LocationVector dir2 = new LocationVector(dir1.getAzimuth(), hDist, vDist);
        Location tempLoc4 = loc3 = LocationUtils.location(loc1, dir2);
        vDist = 17.0 - loc1.getDepth();
        hDist = vDist / Math.atan(dip);
        dir2 = new LocationVector(dir1.getAzimuth(), hDist, vDist);
        loc3 = LocationUtils.location(loc1, dir2);
        loc1 = new Location(34.0344, -118.33585, 2.36339);
        loc2 = new Location(34.23723, -118.25737, 14.9653);
        dir1 = LocationUtils.vector(loc1, loc2);
        dip = Math.tan(dir1.getVertDistance() / dir1.getHorzDistance());
        vDist = 5.0 - loc1.getDepth();
        hDist = vDist / Math.atan(dip);
        this.aveDipDir += dir1.getAzimuth();
        dir2 = new LocationVector(dir1.getAzimuth(), hDist, vDist);
        Location finalLoc4 = loc3 = LocationUtils.location(loc1, dir2);
        vDist = 17.0 - loc1.getDepth();
        hDist = vDist / Math.atan(dip);
        dir2 = new LocationVector(dir1.getAzimuth(), hDist, vDist);
        loc3 = LocationUtils.location(loc1, dir2);
        loc1 = new Location(33.89952, -117.86819, 2.5);
        loc2 = new Location(34.13627, -117.86678, 15.4746);
        dir1 = LocationUtils.vector(loc1, loc2);
        dip = Math.tan(dir1.getVertDistance() / dir1.getHorzDistance());
        vDist = 5.0 - loc1.getDepth();
        hDist = vDist / Math.atan(dip);
        this.aveDipDir += dir1.getAzimuth();
        dir2 = new LocationVector(dir1.getAzimuth(), hDist, vDist);
        Location finalLoc1 = loc3 = LocationUtils.location(loc1, dir2);
        vDist = 17.0 - loc1.getDepth();
        hDist = vDist / Math.atan(dip);
        dir2 = new LocationVector(dir1.getAzimuth(), hDist, vDist);
        loc3 = LocationUtils.location(loc1, dir2);
        loc1 = new Location(33.89454, -118.04441, 3.44082);
        loc2 = new Location(34.09232, -118.0449, 14.485);
        dir1 = LocationUtils.vector(loc1, loc2);
        dip = Math.tan(dir1.getVertDistance() / dir1.getHorzDistance());
        vDist = 5.0 - loc1.getDepth();
        hDist = vDist / Math.atan(dip);
        this.aveDipDir += dir1.getAzimuth();
        dir2 = new LocationVector(dir1.getAzimuth(), hDist, vDist);
        Location tempLoc1 = loc3 = LocationUtils.location(loc1, dir2);
        vDist = 17.0 - loc1.getDepth();
        hDist = vDist / Math.atan(dip);
        dir2 = new LocationVector(dir1.getAzimuth(), hDist, vDist);
        loc3 = LocationUtils.location(loc1, dir2);
        loc1 = new Location(33.93282, -118.01871, 3.0);
        loc2 = new Location(34.10093, -118.01795, 14.4793);
        dir1 = LocationUtils.vector(loc1, loc2);
        dip = Math.tan(dir1.getVertDistance() / dir1.getHorzDistance());
        vDist = 5.0 - loc1.getDepth();
        hDist = vDist / Math.atan(dip);
        this.aveDipDir += dir1.getAzimuth();
        dir2 = new LocationVector(dir1.getAzimuth(), hDist, vDist);
        Location tempLoc2 = loc3 = LocationUtils.location(loc1, dir2);
        vDist = 17.0 - loc1.getDepth();
        hDist = vDist / Math.atan(dip);
        dir2 = new LocationVector(dir1.getAzimuth(), hDist, vDist);
        loc3 = LocationUtils.location(loc1, dir2);
        loc1 = new Location(33.90885, -118.1392, 2.75);
        loc2 = new Location(34.11061, -118.1472, 15.0683);
        dir1 = LocationUtils.vector(loc1, loc2);
        dip = Math.tan(dir1.getVertDistance() / dir1.getHorzDistance());
        vDist = 5.0 - loc1.getDepth();
        hDist = vDist / Math.atan(dip);
        this.aveDipDir += dir1.getAzimuth();
        dir2 = new LocationVector(dir1.getAzimuth(), hDist, vDist);
        Location tempLoc3 = loc3 = LocationUtils.location(loc1, dir2);
        vDist = 17.0 - loc1.getDepth();
        hDist = vDist / Math.atan(dip);
        dir2 = new LocationVector(dir1.getAzimuth(), hDist, vDist);
        loc3 = LocationUtils.location(loc1, dir2);
        Location finalLoc2 = new Location((tempLoc1.getLatitude() + tempLoc2.getLatitude()) / 2.0, (tempLoc1.getLongitude() + tempLoc2.getLongitude()) / 2.0, (tempLoc1.getDepth() + tempLoc2.getDepth()) / 2.0);
        Location finalLoc3 = new Location((tempLoc3.getLatitude() + tempLoc4.getLatitude()) / 2.0, (tempLoc3.getLongitude() + tempLoc4.getLongitude()) / 2.0, (tempLoc3.getDepth() + tempLoc4.getDepth()) / 2.0);
        this.faultTrace = new FaultTrace("Puente Hills Fault Trace");
        this.faultTrace.add(finalLoc1);
        this.faultTrace.add(finalLoc2);
        this.faultTrace.add(finalLoc3);
        this.faultTrace.add(finalLoc4);
        this.aveDipDir /= 6.0;
        FaultTrace tempTr = new FaultTrace("");
        tempTr.add(finalLoc1);
        tempTr.add(finalLoc2);
        tempTr = new FaultTrace("");
        tempTr.add(finalLoc2);
        tempTr.add(finalLoc3);
        tempTr = new FaultTrace("");
        tempTr.add(finalLoc3);
        tempTr.add(finalLoc4);
        tempTr = new FaultTrace("");
        tempTr.add(finalLoc1);
        tempTr.add(tempLoc1);
        tempTr = new FaultTrace("");
        tempTr.add(tempLoc2);
        tempTr.add(tempLoc3);
        tempTr = new FaultTrace("");
        tempTr.add(tempLoc4);
        tempTr.add(finalLoc4);
    }

    public void setParamsForPuenteHillsScenario() {
        ParameterEditor paramEditor = this.erfGuiBean.getParameterEditor("Select method of getting EqkRupture");
        paramEditor.setValue("Select Eqk Rupture from an ERF");
        paramEditor.refreshParamEditor();
        EqkRuptureFromERFSelectorPanel erfPanel = (EqkRuptureFromERFSelectorPanel)this.erfGuiBean.getEqkRuptureSelectorPanel();
        erfPanel.showAllParamsForForecast(false);
        paramEditor = erfPanel.getParameterEditor("Eqk Rup Forecast");
        paramEditor.setValue("Poisson Fault ERF");
        paramEditor.refreshParamEditor();
        ERF_GuiBean erfParamGuiBean = erfPanel.getERF_ParamEditor();
        erfParamGuiBean.getERFParameterList().getParameter("Rake").setValue(90.0);
        double dip = 27.0;
        double depth1 = 5.0;
        double depth2 = 17.0;
        SimpleFaultParameterEditorPanel faultPanel = erfParamGuiBean.getSimpleFaultParamEditor().getParameterEditorPanel();
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        for (int i = 0; i < this.faultTrace.getNumLocations(); ++i) {
            lats.add(((Location)this.faultTrace.get(i)).getLatitude());
            lons.add(((Location)this.faultTrace.get(i)).getLongitude());
        }
        ArrayList<Double> dips = new ArrayList<Double>();
        dips.add(dip);
        ArrayList<Double> depths = new ArrayList<Double>();
        depths.add(depth1);
        depths.add(depth2);
        SimpleFaultParameter cfr_ignored_0 = (SimpleFaultParameter)faultPanel.getParameter();
        SimpleFaultParameter cfr_ignored_1 = (SimpleFaultParameter)faultPanel.getParameter();
        faultPanel.setAll(1.0, lats, lons, dips, depths, "Stirling's");
        faultPanel.refreshParamEditor();
        faultPanel.setEvenlyGriddedSurfaceFromParams();
        MagFreqDistParameterEditor magEditor = erfParamGuiBean.getMagDistEditor();
        magEditor.getParameter("Distribution Type").setValue(SingleMagFreqDist.NAME);
        magEditor.getParameter(MagFreqDistParameter.SINGLE_PARAMS_TO_SET).setValue(MagFreqDistParameter.MAG_AND_MO_RATE);
        magEditor.getParameter(MagFreqDistParameter.MAG).setValue(this.magnitude);
        erfParamGuiBean.getERFParameterListEditor().refreshParamEditor();
        magEditor.setMagDistFromParams();
        erfPanel.setSelectedERF();
        erfPanel.setSourceFromSelectedERF(0);
        erfPanel.setRuptureForSelectedSource(0);
        erfPanel.getHypocenterLocationsForSelectedRupture();
        erfPanel.showAllParamsForForecast(true);
        boolean isSingleAttenRelSelected = this.imrGuiBean.isSingleAttenRelTypeSelected();
        if (!isSingleAttenRelSelected) {
            this.imrGuiBean.toggleBetweenSingleAndMultipleAttenRelGuiSelection();
        }
        ParameterListEditor editor = this.imrGuiBean.getIntensityMeasureParamEditor();
        editor.getParameterList().getParameter("IMT").setValue("PGA");
        editor.refreshParamEditor();
        this.imrGuiBean.setIMR_Selected("ShakeMap (2003)");
        this.imrGuiBean.getSelectedIMR_Instance().getParameter("Component").setValue(Component.AVE_HORZ);
        this.imrGuiBean.getSingleAttenRelParamListEditor().refreshParamEditor();
        this.regionGuiBean.getParameterList().getParameter("Min  Latitude").setValue(33.2);
        this.regionGuiBean.getParameterList().getParameter("Max  Latitude").setValue(35.0);
        this.regionGuiBean.getParameterList().getParameter("Min Longitude").setValue(-119.5);
        this.regionGuiBean.getParameterList().getParameter("Max Longitude").setValue(-116.18);
        this.regionGuiBean.getParameterList().getParameter("Grid Spacing").setValue(0.016667);
        this.regionGuiBean.getParameterList().getParameter("Set Site Params").setValue("Use both CGS Map and SCEC Basin Depth (web services)");
        this.mapGuiBean.getParameterList().getParameter("Use GMT WebService").setValue(true);
        this.mapGuiBean.getParameterList().getParameter("Plot Log").setValue(false);
        this.mapGuiBean.refreshParamEditor();
    }
}

