/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.infoTools;

import java.awt.Color;
import java.util.ArrayList;
import org.opensha.commons.data.estimate.DiscreteValueEstimate;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;

public class EstimateViewer {
    private static final String X_AXIS_LABEL = "X Values";
    private static final String Y_AXIS_LABEL = "Probability";
    private Estimate estimate;
    private String xAxisLabel;
    private String yAxisLabel;
    private GraphWindow graphWindow;
    private final PlotCurveCharacterstics PDF_PLOT_CHAR_HISTOGRAM = new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 2.0f, null, 4.0f, Color.RED);
    private final PlotCurveCharacterstics CDF_PLOT_CHAR = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 4.0f, Color.BLUE);
    private final PlotCurveCharacterstics CDF_USING_FRACTILE_PLOT_CHAR = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 4.0f, Color.BLACK);
    private final PlotCurveCharacterstics DISCRETE_VAL_CDF_USING_FRACTILE_PLOT_CHAR = new PlotCurveCharacterstics(null, 2.0f, PlotSymbol.CROSS, 6.0f, Color.BLACK);

    public EstimateViewer(Estimate estimate) {
        this.setEstimate(estimate);
        this.graphWindow = new GraphWindow(this.getCurveFunctionList(), estimate.getName(), this.getPlottingFeatures());
        this.graphWindow.setX_AxisLabel(X_AXIS_LABEL);
        this.graphWindow.setY_AxisLabel(Y_AXIS_LABEL);
        this.graphWindow.setVisible(true);
    }

    public void setEstimate(Estimate estimate) {
        this.estimate = estimate;
    }

    public ArrayList getCurveFunctionList() {
        ArrayList<AbstractDiscretizedFunc> list = new ArrayList<AbstractDiscretizedFunc>();
        AbstractDiscretizedFunc func = this.estimate.getPDF_Test();
        list.add(func);
        list.add(this.estimate.getCDF_Test());
        list.add(this.estimate.getCDF_TestUsingFractile());
        return list;
    }

    public ArrayList getPlottingFeatures() {
        ArrayList<PlotCurveCharacterstics> list = new ArrayList<PlotCurveCharacterstics>();
        list.add(this.PDF_PLOT_CHAR_HISTOGRAM);
        list.add(this.CDF_PLOT_CHAR);
        if (this.estimate instanceof DiscreteValueEstimate) {
            list.add(this.DISCRETE_VAL_CDF_USING_FRACTILE_PLOT_CHAR);
        } else {
            list.add(this.CDF_USING_FRACTILE_PLOT_CHAR);
        }
        return list;
    }
}

