/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.infoTools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Calendar;
import org.opensha.commons.util.MailUtil;

public class HazardMapCalcPostProcessing {
    static final String FROM = "OpenSHA-CME";
    static final String HOST = "email.usc.edu";

    public HazardMapCalcPostProcessing(String fileName, int expectedNumOfFiles, String emailAddr, String datasetId, String startTime) {
        try {
            FileReader file = new FileReader(fileName);
            BufferedReader reader = new BufferedReader(file);
            int actualFiles = Integer.parseInt(reader.readLine().trim());
            reader.close();
            file.close();
            String mailSubject = "Grid Job Status";
            String mailMessage = "THIS IS A AUTOMATED GENERATED EMAIL. PLEASE DO NOT REPLY BACK TO THIS ADDRESS.\n\n\nGrid Computation complete\nExpected Num of Files=" + expectedNumOfFiles + "\nFiles Generated=" + actualFiles + "\nDataset Id=" + datasetId + "\nSimulation Start Time=" + startTime + "\nSimulation End Time=" + Calendar.getInstance().getTime().toString().replaceAll(" ", "_");
            MailUtil.sendMail(HOST, FROM, emailAddr, mailSubject, mailMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HazardMapCalcPostProcessing(int expectedNumOfFiles, String emailAddr, String datasetId, String startTime) {
        try {
            String mailSubject = "Grid Job Status";
            String mailMessage = "THIS IS A AUTOMATED GENERATED EMAIL. PLEASE DO NOT REPLY BACK TO THIS ADDRESS.\n\n\nGrid Computation complete\nExpected Num of Files=" + expectedNumOfFiles + "\nDataset Id=" + datasetId + "\nSimulation Start Time=" + startTime + "\nSimulation End Time=" + Calendar.getInstance().getTime().toString().replaceAll(" ", "_");
            MailUtil.sendMail(HOST, FROM, emailAddr, mailSubject, mailMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        HazardMapCalcPostProcessing hazardMapCalcPostProcessing1 = new HazardMapCalcPostProcessing(args[0], Integer.parseInt(args[1]), args[2], args[3], args[4]);
    }
}

