/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.infoTools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.opensha.commons.util.BrowserUtils;
import org.opensha.commons.util.FileUtils;

public class MessageDialog
extends JDialog
implements HyperlinkListener {
    JPanel panel1 = new JPanel();
    private JLabel imgLabel = new JLabel(new ImageIcon(FileUtils.loadImage("icons/error_icon.png")));
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    JEditorPane messageEditor = new JEditorPane();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    BorderLayout borderLayout1 = new BorderLayout();

    public MessageDialog(String message, String title, Component parent) {
        try {
            this.jbInit();
            this.setDefaultCloseOperation(2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setTitle(title);
        this.messageEditor.setText(message);
        this.setLocation(parent.getX() + parent.getWidth() / 2, parent.getY() + parent.getHeight() / 2);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        HyperlinkEvent.EventType type = e.getEventType();
        if (type == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                BrowserUtils.launch(e.getURL().toURI());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jbInit() throws Exception {
        this.setModal(true);
        this.panel1.setLayout(this.gridBagLayout1);
        this.getContentPane().setLayout(this.borderLayout1);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MessageDialog.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.messageEditor.setBackground(UIManager.getColor("ProgressBar.background"));
        this.messageEditor.setContentType("text/html");
        this.messageEditor.setEditable(false);
        this.messageEditor.setMinimumSize(new Dimension(0, 0));
        this.okButton.setText("OK");
        this.panel1.add((Component)this.messageEditor, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(4, 20, 4, 4), 0, 0));
        this.panel1.add((Component)this.imgLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 15, 1, 1), 0, 0));
        this.getContentPane().add((Component)this.panel1, "Center");
        this.panel1.add((Component)this.okButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(4, 70, 4, 0), 22, -3));
        this.panel1.add((Component)this.cancelButton, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(4, 5, 4, 80), 22, -3));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MessageDialog.this.okButton_actionPerformed(actionEvent);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MessageDialog.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.messageEditor.addHyperlinkListener(this);
        this.setSize(360, 140);
    }

    public void okButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    public void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }
}

