/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.imr.ScalarIMR;

public class HazardCurveCalcServlet
extends HttpServlet {
    public static final boolean D = false;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("HazardCurveCalcServlet: Handling GET");
        try {
            ObjectInputStream inputFromApplet = new ObjectInputStream((InputStream)request.getInputStream());
            Site site = (Site)inputFromApplet.readObject();
            ScalarIMR imr = (ScalarIMR)inputFromApplet.readObject();
            Object obj = inputFromApplet.readObject();
            String eqkRupForecastLocation = (String)obj;
            ArbitrarilyDiscretizedFunc function = (ArbitrarilyDiscretizedFunc)inputFromApplet.readObject();
            double maxDistance = (Double)inputFromApplet.readObject();
            System.out.println("ERF Location: " + eqkRupForecastLocation);
            ERF eqkRupForecast = (ERF)FileUtils.loadObject(eqkRupForecastLocation);
            this.getHazardCurve(imr, eqkRupForecast, site, function, maxDistance);
            ObjectOutputStream outputToApplet = new ObjectOutputStream((OutputStream)response.getOutputStream());
            outputToApplet.writeObject(function);
            outputToApplet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getHazardCurve(ScalarIMR imr, ERF eqkRupForecast, Site site, ArbitrarilyDiscretizedFunc function, double maxDistance) {
        HazardCurveCalculator calc = new HazardCurveCalculator();
        calc.setMaxSourceDistance(maxDistance);
        calc.getHazardCurve((DiscretizedFunc)function, site, imr, eqkRupForecast);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

