/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.mapping.GMT_MapGeneratorForShakeMaps;

public class ScenarioShakeMapForHazusGeneratorServlet
extends HttpServlet {
    public static final String SERVLET_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "ScenarioShakeMapForHazusGeneratorServlet";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("ScenarioShakeMapForHazusGeneratorServlet: Handling GET");
        try {
            ObjectInputStream inputFromApplet = new ObjectInputStream((InputStream)request.getInputStream());
            GMT_MapGeneratorForShakeMaps gmtMap = (GMT_MapGeneratorForShakeMaps)inputFromApplet.readObject();
            String sa_03xyzDataFileName = (String)inputFromApplet.readObject();
            String sa_10xyzDataFileName = (String)inputFromApplet.readObject();
            String pga_xyzDataFileName = (String)inputFromApplet.readObject();
            String pgv_xyzDataFileName = (String)inputFromApplet.readObject();
            EqkRupture rupture = (EqkRupture)inputFromApplet.readObject();
            String metadata = (String)inputFromApplet.readObject();
            String dirName = (String)inputFromApplet.readObject();
            GeoDataSet sa_03xyzData = (GeoDataSet)FileUtils.loadObject(sa_03xyzDataFileName);
            GeoDataSet sa_10xyzData = (GeoDataSet)FileUtils.loadObject(sa_10xyzDataFileName);
            GeoDataSet pga_xyzData = (GeoDataSet)FileUtils.loadObject(pga_xyzDataFileName);
            GeoDataSet pgvxyzData = (GeoDataSet)FileUtils.loadObject(pgv_xyzDataFileName);
            String[] webaddr = gmtMap.makeHazusFileSetUsingServlet(sa_03xyzData, sa_10xyzData, pga_xyzData, pgvxyzData, rupture, metadata, dirName);
            sa_03xyzData = null;
            sa_10xyzData = null;
            pga_xyzData = null;
            pgvxyzData = null;
            ObjectOutputStream outputToApplet = new ObjectOutputStream((OutputStream)response.getOutputStream());
            outputToApplet.writeObject(webaddr);
            outputToApplet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

