/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.servlets.siteEffect;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;

public final class BasinDepthClass {
    ArrayList<Location> locations;
    String basinDepthFile;
    boolean loadFromJar = false;

    public BasinDepthClass(double minLon, double maxLon, double minLat, double maxLat, double gridSpacing, String fileName) {
        this.prepareSitesInput(minLon, maxLon, minLat, maxLat, gridSpacing);
        this.basinDepthFile = fileName;
    }

    public BasinDepthClass(LocationList locList, String fileName) {
        int numLocations = locList.size();
        this.basinDepthFile = fileName;
        this.locations = new ArrayList();
        for (int i = 0; i < numLocations; ++i) {
            this.locations.add((Location)locList.get(i));
        }
    }

    private void prepareSitesInput(double minLon, double maxLon, double minLat, double maxLat, double gridSpacing) {
        this.locations = new ArrayList();
        GriddedRegion region = new GriddedRegion(new Location(minLat, minLon), new Location(maxLat, maxLon), gridSpacing, new Location(0.0, 0.0));
        Iterator it = region.getNodeList().iterator();
        while (it.hasNext()) {
            this.locations.add((Location)it.next());
        }
    }

    public void setLoadFromJar(boolean jar) {
        this.loadFromJar = jar;
    }

    public ArrayList getBasinDepth() {
        double gridSpacingForBasinDepthInFile = 0.01001;
        try {
            InputStreamReader input = this.loadFromJar ? new InputStreamReader(this.getClass().getResourceAsStream(this.basinDepthFile)) : new FileReader(this.basinDepthFile);
            BufferedReader iBuf = new BufferedReader(input);
            String str = iBuf.readLine();
            int size = this.locations.size();
            ArrayList<Double> bd = new ArrayList<Double>();
            for (int i = 0; i < size; ++i) {
                bd.add(Double.NaN);
            }
            double prevLat = Double.NaN;
            block3: for (int i = 0; i < size; ++i) {
                double lat = this.locations.get(i).getLatitude();
                double lon = this.locations.get(i).getLongitude();
                boolean latFlag = false;
                while (str != null) {
                    StringTokenizer st = new StringTokenizer(str);
                    double valLat = Double.parseDouble(st.nextToken());
                    double valLon = Double.parseDouble(st.nextToken());
                    if (valLat - lat > gridSpacingForBasinDepthInFile / 2.0) continue block3;
                    if (Math.abs(lat - valLat) <= gridSpacingForBasinDepthInFile / 2.0) {
                        latFlag = true;
                    }
                    if (Math.abs(lon - valLon) <= gridSpacingForBasinDepthInFile / 2.0 && latFlag) {
                        bd.set(i, Double.valueOf(st.nextToken()));
                        continue block3;
                    }
                    if (valLon - lon > gridSpacingForBasinDepthInFile / 2.0 && latFlag) continue block3;
                    str = iBuf.readLine();
                }
            }
            return bd;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

