/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.servlets.user_auth_db;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Random;
import oracle.jdbc.rowset.OracleCachedRowSet;
import org.opensha.commons.util.MailUtil;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.sha.gui.servlets.user_auth_db.OpenSHA_UsersDAO;
import org.opensha.sha.gui.servlets.user_auth_db.OpenSHA_UsersVO;

public class OpenSHA_UsersDBDAO
implements OpenSHA_UsersDAO {
    private static final String DB_SERVER = "gravity.usc.edu";
    private static final String DB_NAME = "OpenSHA_users";
    private static final String TABLE_NAME = "users";
    private DB_ConnectionPool connect;
    private static final String SMTP_HOST = "email.usc.edu";
    private static final String FROM = "OpenSHA-CME@scec.usc.edu";
    private static final String MAIL_SUBJECT = "Your account information on OpenSHA-CME system";
    private static final String SCEC_ADMIN_MAIL_SUBJECT = "New account added on OpenSHA-CME system";

    public OpenSHA_UsersDBDAO() {
        try {
            this.connect = new DB_ConnectionPool("org.gjt.mm.mysql.Driver", "jdbc:mysql://gravity.usc.edu:3306/OpenSHA_users", "cmeutils", "level3", 1, 15, "opensha_db.log", 0.5);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean insertNewUser(OpenSHA_UsersVO newUserVO) {
        Calendar calendar = Calendar.getInstance();
        String datetime = new String(calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + "  " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13));
        String insertDataQuery = "insert into users (first_name, last_name, email, phone_number, organization, username, password, approved, creation_date, role)values (\"" + newUserVO.getFirstName() + "\",\"" + newUserVO.getLastName() + "\",\"" + newUserVO.getEmail() + "\",\"" + newUserVO.getPhone() + "\",\"" + newUserVO.getOrganization() + "\",\"" + newUserVO.getUsername() + "\",MD5(\"" + newUserVO.getPassword() + "\"),'" + newUserVO.getApprovalStatus() + "',\"" + datetime + "\",\"" + newUserVO.getRole() + "\")";
        try {
            this.connect.insertUpdateOrDeleteData(insertDataQuery);
            String message = "New account has been created on OpenSHA-CME system for user " + newUserVO.getFirstName() + " " + newUserVO.getFirstName() + "\n username = " + newUserVO.getUsername() + ", email=" + newUserVO.getEmail() + "\n\n Go to http://gravity.usc.edu:8080/usermanagement to approve/disapprove the user";
            Object toEmailList = "";
            ArrayList emailList = this.getAdminEmailList();
            for (int i = 0; i < emailList.size(); ++i) {
                toEmailList = (String)toEmailList + "," + emailList.get(i).toString();
            }
            MailUtil.sendMail(SMTP_HOST, FROM, (String)toEmailList, SCEC_ADMIN_MAIL_SUBJECT, message);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private ArrayList getAdminEmailList() {
        ArrayList approvedUsers = this.getApprovedUsers();
        ArrayList<String> emails = new ArrayList<String>();
        for (int i = 0; i < approvedUsers.size(); ++i) {
            OpenSHA_UsersVO vo = (OpenSHA_UsersVO)approvedUsers.get(i);
            if (!vo.getRole().equalsIgnoreCase("admin")) continue;
            emails.add(vo.getEmail());
        }
        return emails;
    }

    @Override
    public void updateUser(OpenSHA_UsersVO updatedUserVO) {
        Calendar calendar = Calendar.getInstance();
        String datetime = new String(calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + "  " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13));
        OpenSHA_UsersVO currentUser = this.getUser(updatedUserVO.getEmail());
        String approvalDate = currentUser.getApprovalDate();
        if (currentUser.getApprovalStatus() == 'N' && updatedUserVO.getApprovalStatus() == 'Y') {
            approvalDate = datetime;
            String message = "Your account on OpenSHA-CME system has been Approved";
            MailUtil.sendMail(SMTP_HOST, FROM, updatedUserVO.getEmail(), MAIL_SUBJECT, message);
        }
        String update = new String("update users set first_name=\"" + updatedUserVO.getFirstName() + "\", last_name=\"" + updatedUserVO.getLastName() + "\", phone_number=\"" + updatedUserVO.getPhone() + "\", organization=\"" + updatedUserVO.getOrganization() + "\", approved='" + updatedUserVO.getApprovalStatus() + "', modification_date=\"" + datetime + "\", approval_date=\"" + approvalDate + "\", role=\"" + updatedUserVO.getRole() + "\" where email=\"" + updatedUserVO.getEmail() + "\"");
        try {
            this.connect.insertUpdateOrDeleteData(update);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updatePassword(String email, String newPassword) {
        Calendar calendar = Calendar.getInstance();
        String datetime = new String(calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + "  " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13));
        String update = new String("update users set password=MD5(\"" + newPassword + "\")  where email=\"" + email + "\"");
        try {
            this.connect.insertUpdateOrDeleteData(update);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void resetAndEmailPassword(String email) {
        Random random = new Random();
        String password = "" + random.nextLong();
        this.updatePassword(email, password);
        String message = "Your username on OpenSHA-CME system is : " + this.getUser(email).getUsername() + "\nYour password on OpenSHA-CME system is : " + password;
        MailUtil.sendMail(SMTP_HOST, FROM, email, MAIL_SUBJECT, message);
    }

    @Override
    public void deleteUser(String email) {
        String delete = new String("delete from users where email=\"" + email + "\"");
        try {
            this.connect.insertUpdateOrDeleteData(delete);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public OpenSHA_UsersVO getUserInfo(String userName, String password) {
        String query = new String("select first_name, last_name, email, phone_number,organization, username, Approved, creation_date,approval_date,modification_date,role  from " + TABLE_NAME + " where username=\"" + userName + "\" and password=MD5(\"" + password + "\")");
        try {
            OracleCachedRowSet queryResult = this.connect.queryData(query);
            if (queryResult.next()) {
                return this.getOpenSHA_UsersVO(queryResult.getString("first_name"), queryResult.getString("last_name"), queryResult.getString("email"), queryResult.getString("phone_number"), queryResult.getString("organization"), queryResult.getString("username"), queryResult.getString("creation_date"), queryResult.getString("approval_date"), queryResult.getString("modification_date"), queryResult.getString("approved"), queryResult.getString("role"));
            }
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isUserAuthorized(OpenSHA_UsersVO userVO) {
        return userVO.getApprovalStatus() == 'Y';
    }

    @Override
    public ArrayList getAllUsers() {
        String query = new String("select first_name, last_name, email, phone_number,organization, username, Approved, creation_date,approval_date,modification_date,role  from " + TABLE_NAME);
        ArrayList<OpenSHA_UsersVO> users = new ArrayList<OpenSHA_UsersVO>();
        try {
            OracleCachedRowSet queryResult = this.connect.queryData(query);
            while (queryResult.next()) {
                users.add(this.getOpenSHA_UsersVO(queryResult.getString("first_name"), queryResult.getString("last_name"), queryResult.getString("email"), queryResult.getString("phone_number"), queryResult.getString("organization"), queryResult.getString("username"), queryResult.getString("creation_date"), queryResult.getString("approval_date"), queryResult.getString("modification_date"), queryResult.getString("approved"), queryResult.getString("role")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return users;
    }

    private OpenSHA_UsersVO getOpenSHA_UsersVO(String firstName, String lastName, String email, String phoneNumber, String organization, String username, String creationDate, String approvalDate, String modificationDate, String approved, String role) {
        OpenSHA_UsersVO vo = new OpenSHA_UsersVO();
        vo.setFirstName(firstName);
        vo.setLastName(lastName);
        vo.setEmail(email);
        vo.setPhone(phoneNumber);
        vo.setOrganization(organization);
        vo.setUsername(username);
        vo.setCreationDate(creationDate);
        vo.setApprovalDate(approvalDate);
        vo.setModificationDate(modificationDate);
        vo.setApprovalStatus(approved.charAt(0));
        vo.setRole(role);
        return vo;
    }

    @Override
    public ArrayList getApprovedUsers() {
        String query = new String("select first_name, last_name, email, phone_number,organization, username, Approved, creation_date,approval_date,modification_date,role  from " + TABLE_NAME + " where Approved='Y'");
        ArrayList<OpenSHA_UsersVO> users = new ArrayList<OpenSHA_UsersVO>();
        try {
            OracleCachedRowSet queryResult = this.connect.queryData(query);
            while (queryResult.next()) {
                users.add(this.getOpenSHA_UsersVO(queryResult.getString("first_name"), queryResult.getString("last_name"), queryResult.getString("email"), queryResult.getString("phone_number"), queryResult.getString("organization"), queryResult.getString("username"), queryResult.getString("creation_date"), queryResult.getString("approval_date"), queryResult.getString("modification_date"), queryResult.getString("approved"), queryResult.getString("role")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return users;
    }

    @Override
    public ArrayList getUnapprovedUsers() {
        String query = new String("select first_name, last_name, email, phone_number,organization, username, Approved, creation_date,approval_date,modification_date,role  from " + TABLE_NAME + " where Approved='N'");
        ArrayList<OpenSHA_UsersVO> users = new ArrayList<OpenSHA_UsersVO>();
        try {
            OracleCachedRowSet queryResult = this.connect.queryData(query);
            while (queryResult.next()) {
                users.add(this.getOpenSHA_UsersVO(queryResult.getString("first_name"), queryResult.getString("last_name"), queryResult.getString("email"), queryResult.getString("phone_number"), queryResult.getString("organization"), queryResult.getString("username"), queryResult.getString("creation_date"), queryResult.getString("approval_date"), queryResult.getString("modification_date"), queryResult.getString("approved"), queryResult.getString("role")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return users;
    }

    @Override
    public boolean isNameUsed(String userName) {
        String query = new String("select first_name, last_name, email, phone_number,organization, username, Approved, creation_date,approval_date,modification_date from " + TABLE_NAME + " where username=\"" + userName + "\"");
        try {
            OracleCachedRowSet queryResult = this.connect.queryData(query);
            return queryResult.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public OpenSHA_UsersVO getUser(String email) {
        String query = new String("select first_name, last_name, email, phone_number,organization, username, Approved, creation_date,approval_date,modification_date,role  from " + TABLE_NAME + " where email=\"" + email + "\"");
        try {
            OracleCachedRowSet queryResult = this.connect.queryData(query);
            if (queryResult.next()) {
                return this.getOpenSHA_UsersVO(queryResult.getString("first_name"), queryResult.getString("last_name"), queryResult.getString("email"), queryResult.getString("phone_number"), queryResult.getString("organization"), queryResult.getString("username"), queryResult.getString("creation_date"), queryResult.getString("approval_date"), queryResult.getString("modification_date"), queryResult.getString("approved"), queryResult.getString("role"));
            }
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void emailUserName(String email) {
        OpenSHA_UsersVO vo = this.getUser(email);
        if (vo != null) {
            String message = "Your username on OpenSHA-CME system is : " + vo.getUsername();
            MailUtil.sendMail(SMTP_HOST, FROM, email, MAIL_SUBJECT, message);
        }
    }

    public void makeEmptyForTesting() {
    }

    public static void main(String[] args) {
    }
}

