/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.util;

import com.google.common.base.Stopwatch;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.commons.util.ServerPrefs;
import org.opensha.sha.gui.util.JNLPGen;

public class IconFetcher {
    private static final boolean D = false;

    public static ArrayList<BufferedImage> fetchIcons(String appShortName) {
        return IconFetcher.fetchIcons(appShortName, ServerPrefUtils.SERVER_PREFS);
    }

    public static ArrayList<BufferedImage> fetchIcons(String appShortName, ServerPrefs prefs) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        String localBase = "/images/icons/";
        for (int size : JNLPGen.icon_sizes) {
            URL url = null;
            String fileName = JNLPGen.getIconName(appShortName, size);
            try {
                url = IconFetcher.class.getResource(localBase + fileName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (url == null) {
                try {
                    String addy = "http://opensha.usc.edu/apps/opensha/" + appShortName + "/" + prefs.getBuildType().getBuildDirName() + "/icons/" + fileName;
                    url = new URL(addy);
                }
                catch (Throwable addy) {
                    // empty catch block
                }
            }
            if (url == null) continue;
            BufferedImage img = IconFetcher.loadWithTimeout(url, 2000L);
            if (img == null) break;
            images.add(img);
        }
        if (images.size() == 0) {
            try {
                BufferedImage fallback = ImageIO.read(IconFetcher.class.getResourceAsStream("/images/logos/opensha_64.png"));
                images.add(fallback);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return images;
    }

    private static BufferedImage loadWithTimeout(URL url, long timeout) {
        ImageReadThread t = new ImageReadThread(url);
        Stopwatch watch = Stopwatch.createStarted();
        t.start();
        while (t.isAlive() && watch.elapsed(TimeUnit.MILLISECONDS) < timeout) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (t.isAlive()) {
            try {
                t.interrupt();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
        return t.img;
    }

    public static void main(String[] args) throws IOException {
        ArrayList<BufferedImage> icons = new ArrayList<BufferedImage>();
        icons.add(ImageIO.read(new URL("http://opensha.usc.edu/apps/opensha/HazardCurveLocal/nightly/icons/HazardCurveLocal_16x16.png")));
        icons.add(ImageIO.read(new URL("http://opensha.usc.edu/apps/opensha/HazardCurveLocal/nightly/icons/HazardCurveLocal_32x32.png")));
        icons.add(ImageIO.read(new URL("http://opensha.usc.edu/apps/opensha/HazardCurveLocal/nightly/icons/HazardCurveLocal_48x48.png")));
        icons.add(ImageIO.read(new URL("http://opensha.usc.edu/apps/opensha/HazardCurveLocal/nightly/icons/HazardCurveLocal_128x128.png")));
        JFrame frame = new JFrame();
        frame.setSize(400, 400);
        frame.setIconImages(icons);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private static class ImageReadThread
    extends Thread {
        BufferedImage img;
        URL url;

        public ImageReadThread(URL url) {
            this.url = url;
        }

        @Override
        public void run() {
            try {
                this.img = ImageIO.read(this.url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

