/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.AftershockParam;
import org.opensha.sha.imr.param.EqkRuptureParams.DipParam;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupTopDepthParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupWidthParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGV_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistRupMinusDistX_OverRupParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistRupMinusJB_OverRupParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.HangingWallFlagParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.imr.param.SiteParams.Vs30_TypeParam;

public class AS_2008_AttenRel
extends AttenuationRelationship
implements ParameterChangeListener {
    public static final String NAME = "Abrahamson & Silva (2008)";
    private static final String AS_2008_CoeffFile = "as_2008_coeff.txt";
    private static final String C = "AS_2008_CG_AttenRel";
    private static final boolean D = false;
    public static final String SHORT_NAME = "AS2008";
    private static final long serialVersionUID = 1234567890987654358L;
    private static final String URL_INFO_STRING = "http://www.opensha.org/glossary-attenuationRelation-ABRAHAM_SILVA_2008";
    public static final String FLT_TYPE_STRIKE_SLIP = "Strike-Slip";
    public static final String FLT_TYPE_REVERSE = "Reverse";
    public static final String FLT_TYPE_NORMAL = "Normal";
    private int iper;
    double mag;
    double f_rv;
    double f_nm;
    double depthTop;
    double rupWidth;
    double dip;
    double f_as;
    double f_hw;
    double vs30;
    double vsm;
    double depthTo1pt0kmPerSec;
    double pga_rock;
    private double rRup;
    private double distRupMinusJB_OverRup;
    private double distRupMinusDistX_OverRup;
    private Component component;
    private String stdDevType;
    private boolean rock_pga_is_not_fresh;
    double c1 = 6.75;
    double c4 = 4.5;
    double a3 = 0.265;
    double a4 = -0.231;
    double a5 = -0.398;
    double N = 1.18;
    double c = 1.88;
    double c2 = 50.0;
    private HashMap indexFromPerHashMap;
    private static final double MAG_WARN_MIN = 4.0;
    private static final double MAG_WARN_MAX = 8.5;
    private static final double DISTANCE_RUP_WARN_MIN = 0.0;
    private static final double DISTANCE_RUP_WARN_MAX = 200.0;
    private static final double DISTANCE_JB_WARN_MIN = 0.0;
    private static final double DISTANCE_JB_WARN_MAX = 200.0;
    private static final double DISTANCE_MINUS_WARN_MIN = 0.0;
    private static final double DISTANCE_MINUS_WARN_MAX = 50.0;
    private static final double DISTANCE_X_WARN_MIN = -300.0;
    private static final double DISTANCE_X_WARN_MAX = 300.0;
    private static final double VS30_WARN_MIN = 150.0;
    private static final double VS30_WARN_MAX = 1500.0;
    private static final double DEPTH_1pt0_WARN_MIN = 0.0;
    private static final double DEPTH_1pt0_WARN_MAX = 10000.0;
    private static final double DIP_WARN_MIN = 15.0;
    private static final double DIP_WARN_MAX = 90.0;
    private static final double RUP_TOP_WARN_MIN = 0.0;
    private static final double RUP_TOP_WARN_MAX = 15.0;
    private static final double RUP_WIDTH_WARN_MIN = 0.0;
    private static final double RUP_WIDTH_WARN_MAX = 100.0;
    private double[] per = new double[]{-1.0, 0.0, 0.01, 0.02, 0.03, 0.04, 0.05, 0.075, 0.1, 0.15, 0.2, 0.25, 0.3, 0.4, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 5.0, 7.5, 10.0};
    private double[] VLIN = new double[]{400.0, 865.1, 865.1, 865.1, 907.8, 994.5, 1053.5, 1085.7, 1032.5, 877.6, 748.2, 654.3, 587.1, 503.0, 456.6, 410.5, 400.0, 400.0, 400.0, 400.0, 400.0, 400.0, 400.0, 400.0};
    private double[] b = new double[]{-1.955, -1.186, -1.186, -1.219, -1.273, -1.308, -1.346, -1.471, -1.624, -1.931, -2.188, -2.381, -2.518, -2.657, -2.669, -2.401, -1.955, -1.025, -0.299, 0.0, 0.0, 0.0, 0.0, 0.0};
    private double[] a1 = new double[]{5.7578, 0.804, 0.8111, 0.855, 0.962, 1.037, 1.133, 1.375, 1.563, 1.716, 1.687, 1.646, 1.601, 1.511, 1.397, 1.137, 0.915, 0.51, 0.192, -0.28, -0.639, -0.936, -1.527, -1.993};
    private double[] a2 = new double[]{-0.9046, -0.9679, -0.9679, -0.9774, -1.0024, -1.0289, -1.0508, -1.081, -1.0833, -1.0357, -0.97, -0.9202, -0.8974, -0.8677, -0.8475, -0.8206, -0.8088, -0.7995, -0.796, -0.796, -0.796, -0.796, -0.796, -0.796};
    private double[] a8 = new double[]{-0.12, -0.0372, -0.0372, -0.0372, -0.0372, -0.0315, -0.0271, -0.0191, -0.0166, -0.0254, -0.0396, -0.0539, -0.0656, -0.0807, -0.0924, -0.1137, -0.1289, -0.1534, -0.1708, -0.1954, -0.2128, -0.2263, -0.2509, -0.2683};
    private double[] a10 = new double[]{1.539, 0.9445, 0.9445, 0.9834, 1.0471, 1.0884, 1.1333, 1.2808, 1.4613, 1.8071, 2.0773, 2.2794, 2.4201, 2.551, 2.5395, 2.1493, 1.5705, 0.3991, -0.6072, -0.96, -0.96, -0.9208, -0.77, -0.663};
    private double[] a12 = new double[]{0.08, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0181, 0.0309, 0.0409, 0.0491, 0.0619, 0.0719, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08};
    private double[] a13 = new double[]{-0.06, -0.06, -0.06, -0.06, -0.06, -0.06, -0.06, -0.06, -0.06, -0.06, -0.06, -0.06, -0.06, -0.06, -0.06, -0.06, -0.06, -0.06, -0.06, -0.06, -0.06, -0.06, -0.06, -0.06};
    private double[] a14 = new double[]{0.7, 1.08, 1.08, 1.08, 1.1331, 1.1708, 1.2, 1.2, 1.2, 1.1683, 1.1274, 1.0956, 1.0697, 1.0288, 0.9971, 0.9395, 0.8985, 0.8409, 0.8, 0.4793, 0.2518, 0.0754, 0.0, 0.0};
    private double[] a15 = new double[]{-0.39, -0.35, -0.35, -0.35, -0.35, -0.35, -0.35, -0.35, -0.35, -0.35, -0.35, -0.35, -0.35, -0.35, -0.3191, -0.2629, -0.223, -0.1668, -0.127, -0.0708, -0.0309, 0.0, 0.0, 0.0};
    private double[] a16 = new double[]{0.63, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.8423, 0.7458, 0.5704, 0.446, 0.2707, 0.1463, -0.0291, -0.1535, -0.25, -0.25, -0.25};
    private double[] a18 = new double[]{0.0, -0.0067, -0.0067, -0.0067, -0.0067, -0.0067, -0.0076, -0.0093, -0.0093, -0.0093, -0.0083, -0.0069, -0.0057, -0.0039, -0.0025, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private double[] s1e = new double[]{0.59, 0.59, 0.59, 0.59, 0.605, 0.615, 0.623, 0.63, 0.63, 0.63, 0.63, 0.63, 0.63, 0.63, 0.63, 0.63, 0.63, 0.615, 0.604, 0.589, 0.578, 0.57, 0.611, 0.64};
    private double[] s2e = new double[]{0.47, 0.47, 0.47, 0.47, 0.478, 0.483, 0.488, 0.495, 0.501, 0.509, 0.514, 0.518, 0.522, 0.527, 0.532, 0.539, 0.545, 0.552, 0.558, 0.565, 0.57, 0.587, 0.618, 0.64};
    private double[] s1m = new double[]{0.576, 0.576, 0.576, 0.576, 0.591, 0.602, 0.61, 0.617, 0.617, 0.616, 0.614, 0.612, 0.611, 0.608, 0.606, 0.602, 0.594, 0.566, 0.544, 0.527, 0.515, 0.51, 0.572, 0.612};
    private double[] s2m = new double[]{0.453, 0.453, 0.453, 0.453, 0.461, 0.466, 0.471, 0.479, 0.485, 0.491, 0.495, 0.497, 0.499, 0.501, 0.504, 0.506, 0.503, 0.497, 0.491, 0.5, 0.505, 0.529, 0.579, 0.612};
    private double[] s3 = new double[]{0.42, 0.47, 0.42, 0.42, 0.462, 0.492, 0.515, 0.55, 0.55, 0.55, 0.52, 0.497, 0.479, 0.449, 0.426, 0.385, 0.35, 0.35, 0.35, 0.35, 0.35, 0.35, 0.35, 0.35};
    private double[] s4 = new double[]{0.3, 0.3, 0.3, 0.3, 0.305, 0.309, 0.312, 0.317, 0.321, 0.326, 0.329, 0.332, 0.335, 0.338, 0.341, 0.346, 0.35, 0.35, 0.35, 0.35, 0.35, 0.35, 0.35, 0.35};
    private double[] rho = new double[]{0.74, 1.0, 1.0, 1.0, 0.991, 0.982, 0.973, 0.952, 0.929, 0.896, 0.874, 0.856, 0.841, 0.818, 0.783, 0.68, 0.607, 0.504, 0.431, 0.328, 0.255, 0.2, 0.2, 0.2};

    public AS_2008_AttenRel(ParameterChangeWarningListener listener) {
        this.listener = listener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = new HashMap();
        for (int i = 2; i < this.per.length; ++i) {
            this.indexFromPerHashMap.put(this.per[i], i);
        }
        this.initEqkRuptureParams();
        this.initSiteParams();
        this.initPropagationEffectParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
        this.setParamDefaults();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.eqkRupture = eqkRupture;
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.setFaultTypeFromRake(eqkRupture.getAveRake());
        RuptureSurface surface = eqkRupture.getRuptureSurface();
        this.rupTopDepthParam.setValueIgnoreWarning(surface.getAveRupTopDepth());
        this.dipParam.setValueIgnoreWarning(surface.getAveDip());
        this.rupWidthParam.setValue(surface.getAveWidth());
        this.aftershockParam.setValue(false);
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.site = site;
        this.vs30Param.setValueIgnoreWarning((Double)site.getParameter("Vs30").getValue());
        this.depthTo1pt0kmPerSecParam.setValueIgnoreWarning((Double)site.getParameter("Depth 1.0 km/sec").getValue());
        this.vs30_TypeParam.setValue((String)site.getParameter("Vs30 Type").getValue());
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.propEffectUpdate();
        }
    }

    private void propEffectUpdate() {
        this.distanceRupParam.setValue(this.eqkRupture, this.site);
        double dist_jb = this.eqkRupture.getRuptureSurface().getDistanceJB(this.site.getLocation());
        double distX = this.eqkRupture.getRuptureSurface().getDistanceX(this.site.getLocation());
        if (this.rRup > 0.0) {
            this.distRupMinusJB_OverRupParam.setValueIgnoreWarning((this.rRup - dist_jb) / this.rRup);
            if (distX >= 0.0) {
                this.distRupMinusDistX_OverRupParam.setValue((this.rRup - distX) / this.rRup);
                this.hangingWallFlagParam.setValue(true);
            } else {
                this.distRupMinusDistX_OverRupParam.setValue((this.rRup + distX) / this.rRup);
                this.hangingWallFlagParam.setValue(false);
            }
        } else {
            this.distRupMinusJB_OverRupParam.setValueIgnoreWarning(0.0);
            this.distRupMinusDistX_OverRupParam.setValue(0.0);
            this.hangingWallFlagParam.setValue(true);
        }
    }

    protected void setFaultTypeFromRake(double rake) {
        if (rake > 30.0 && rake < 150.0) {
            this.fltTypeParam.setValue(FLT_TYPE_REVERSE);
        } else if (rake > -150.0 && rake < -30.0) {
            this.fltTypeParam.setValue(FLT_TYPE_NORMAL);
        } else {
            this.fltTypeParam.setValue(FLT_TYPE_STRIKE_SLIP);
        }
    }

    protected void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("AS_2008_CG_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        if (this.im.getName().equalsIgnoreCase("SA")) {
            this.iper = (Integer)this.indexFromPerHashMap.get(this.saPeriodParam.getValue());
        } else if (this.im.getName().equalsIgnoreCase("PGV")) {
            this.iper = 0;
        } else if (this.im.getName().equalsIgnoreCase("PGA")) {
            this.iper = 1;
        }
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        double rJB = this.rRup - this.distRupMinusJB_OverRup * this.rRup;
        double rX = this.rRup - this.distRupMinusDistX_OverRup * this.rRup;
        double Td = Math.pow(10.0, -1.25 + 0.3 * this.mag);
        int iTd = this.searchTdIndex(Td);
        this.computeRockPGA(rJB, rX);
        double basinDepth = Double.isNaN(this.depthTo1pt0kmPerSec) ? (this.vs30 < 180.0 ? Math.exp(6.745) : (this.vs30 > 500.0 ? Math.exp(5.394 - 4.48 * Math.log(this.vs30 / 500.0)) : Math.exp(6.745 - 1.35 * Math.log(this.vs30 / 180.0)))) : this.depthTo1pt0kmPerSec;
        double f10 = this.getf10(this.iper, this.vs30, basinDepth);
        double mean = 0.0;
        if (this.per[this.iper] < Td || Td >= 10.0 && iTd == 22) {
            mean = this.getMean(this.iper, 0, this.vs30, this.rRup, rJB, this.f_as, rX, this.f_rv, this.f_nm, this.mag, this.dip, this.rupWidth, this.depthTop, this.pga_rock) + f10;
        } else {
            double medSa1100WithTdMinus = Math.exp(this.getMean(iTd, 0, 1100.0, this.rRup, rJB, this.f_as, rX, this.f_rv, this.f_nm, this.mag, this.dip, this.rupWidth, this.depthTop, this.pga_rock));
            double medSa1100WithTdPlus = Math.exp(this.getMean(iTd + 1, 0, 1100.0, this.rRup, rJB, this.f_as, rX, this.f_rv, this.f_nm, this.mag, this.dip, this.rupWidth, this.depthTop, this.pga_rock));
            double f5 = this.getf5(this.iper, this.vs30, this.pga_rock);
            double medSa1100AtTd0 = Math.exp(Math.log(medSa1100WithTdPlus / medSa1100WithTdMinus) / Math.log(this.per[iTd + 1] / this.per[iTd]) * Math.log(Math.pow(10.0, -1.25 + 0.3 * this.mag) / this.per[iTd]) + Math.log(medSa1100WithTdMinus));
            double mean1100AtTd = medSa1100AtTd0 * Math.pow(Math.pow(10.0, -1.25 + 0.3 * this.mag) / this.per[this.iper], 2.0);
            double f51100 = this.getf5(this.iper, 1100.0, this.pga_rock);
            f5 = this.getf5(this.iper, this.vs30, this.pga_rock);
            mean = Math.log(mean1100AtTd) - f51100 + f5 + f10;
        }
        return mean;
    }

    private void computeRockPGA(double rJB, double rX) {
        if (this.rock_pga_is_not_fresh) {
            this.pga_rock = Math.exp(this.getMean(1, 0, 1100.0, this.rRup, rJB, this.f_as, rX, this.f_rv, this.f_nm, this.mag, this.dip, this.rupWidth, this.depthTop, 0.0));
            this.rock_pga_is_not_fresh = false;
        }
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        double rJB = this.rRup - this.distRupMinusJB_OverRup * this.rRup;
        double rX = this.rRup - this.distRupMinusDistX_OverRup * this.rRup;
        this.computeRockPGA(rJB, rX);
        double stdDev = this.getStdDev(this.iper, this.stdDevType, this.component, this.vs30, this.pga_rock, this.vsm);
        return stdDev;
    }

    @Override
    public void setParamDefaults() {
        this.magParam.setValueAsDefault();
        this.fltTypeParam.setValueAsDefault();
        this.rupTopDepthParam.setValueAsDefault();
        this.dipParam.setValueAsDefault();
        this.rupWidthParam.setValueAsDefault();
        this.aftershockParam.setValueAsDefault();
        this.vs30Param.setValueAsDefault();
        this.vs30_TypeParam.setValueAsDefault();
        this.depthTo1pt0kmPerSecParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.distRupMinusJB_OverRupParam.setValueAsDefault();
        this.distRupMinusDistX_OverRupParam.setValueAsDefault();
        this.hangingWallFlagParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.rupTopDepthParam);
        this.meanIndependentParams.addParameter(this.dipParam);
        this.meanIndependentParams.addParameter(this.rupWidthParam);
        this.meanIndependentParams.addParameter(this.aftershockParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.depthTo1pt0kmPerSecParam);
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.distRupMinusJB_OverRupParam);
        this.meanIndependentParams.addParameter(this.distRupMinusDistX_OverRupParam);
        this.meanIndependentParams.addParameter(this.hangingWallFlagParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameterList(this.meanIndependentParams);
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.vs30_TypeParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.stdDevIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(150.0, 1500.0);
        this.vs30_TypeParam = new Vs30_TypeParam();
        this.depthTo1pt0kmPerSecParam = new DepthTo1pt0kmPerSecParam(0.0, 10000.0);
        this.depthTo1pt0kmPerSecParam.setValue(null);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
        this.siteParams.addParameter(this.vs30_TypeParam);
        this.siteParams.addParameter(this.depthTo1pt0kmPerSecParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(4.0, 8.5);
        this.aftershockParam = new AftershockParam();
        this.dipParam = new DipParam(15.0, 90.0);
        this.rupTopDepthParam = new RupTopDepthParam(0.0, 15.0);
        this.rupWidthParam = new RupWidthParam(0.0, 100.0);
        StringConstraint constraint = new StringConstraint();
        constraint.addString(FLT_TYPE_STRIKE_SLIP);
        constraint.addString(FLT_TYPE_NORMAL);
        constraint.addString(FLT_TYPE_REVERSE);
        constraint.setNonEditable();
        this.fltTypeParam = new FaultTypeParam(constraint, FLT_TYPE_STRIKE_SLIP);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
        this.eqkRuptureParams.addParameter(this.rupTopDepthParam);
        this.eqkRuptureParams.addParameter(this.dipParam);
        this.eqkRuptureParams.addParameter(this.rupWidthParam);
        this.eqkRuptureParams.addParameter(this.aftershockParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        DoubleConstraint warn = new DoubleConstraint(0.0, 200.0);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.addParameterChangeWarningListener(this.listener);
        this.distanceRupParam.setNonEditable();
        this.distRupMinusJB_OverRupParam = new DistRupMinusJB_OverRupParameter(0.0);
        DoubleConstraint warnJB = new DoubleConstraint(0.0, 50.0);
        warnJB.setNonEditable();
        this.distRupMinusJB_OverRupParam.setWarningConstraint(warnJB);
        this.distRupMinusJB_OverRupParam.addParameterChangeWarningListener(this.listener);
        this.distRupMinusJB_OverRupParam.setNonEditable();
        this.distRupMinusDistX_OverRupParam = new DistRupMinusDistX_OverRupParam();
        this.hangingWallFlagParam = new HangingWallFlagParam();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
        this.propagationEffectParams.addParameter(this.distRupMinusJB_OverRupParam);
        this.propagationEffectParams.addParameter(this.distRupMinusDistX_OverRupParam);
        this.propagationEffectParams.addParameter(this.hangingWallFlagParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        for (int i = 2; i < this.per.length; ++i) {
            periodConstraint.addDouble((Double)this.per[i]);
        }
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.pgvParam = new PGV_Param();
        this.pgvParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.listener);
        this.pgaParam.addParameterChangeWarningListener(this.listener);
        this.pgvParam.addParameterChangeWarningListener(this.listener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
        this.supportedIMParams.addParameter(this.pgvParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.GMRotI50, Component.GMRotI50);
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    private int searchTdIndex(double Td) {
        int iTd = 22;
        for (int i = 2; i <= 22; ++i) {
            if (!(Td >= this.per[i]) || !(Td < this.per[i + 1])) continue;
            iTd = i;
            break;
        }
        return iTd;
    }

    public double getf5(int iper, double vs30, double pga_rock) {
        double v1 = this.per[iper] == -1.0 ? 862.0 : (this.per[iper] <= 0.5 && this.per[iper] > -1.0 ? 1500.0 : (this.per[iper] > 0.5 && this.per[iper] <= 1.0 ? Math.exp(8.0 - 0.795 * Math.log(this.per[iper] / 0.21)) : (this.per[iper] > 1.0 && this.per[iper] < 2.0 ? Math.exp(6.76 - 0.297 * Math.log(this.per[iper])) : 700.0)));
        double vs30Star = vs30 < v1 ? vs30 : v1;
        double f5 = vs30 < this.VLIN[iper] ? this.a10[iper] * Math.log(vs30Star / this.VLIN[iper]) - this.b[iper] * Math.log(pga_rock + this.c) + this.b[iper] * Math.log(pga_rock + this.c * Math.pow(vs30Star / this.VLIN[iper], this.N)) : (this.a10[iper] + this.b[iper] * this.N) * Math.log(vs30Star / this.VLIN[iper]);
        return f5;
    }

    public double getf10(int iper, double vs30, double depthTo1pt0kmPerSec) {
        double v1 = this.per[iper] == -1.0 ? 862.0 : (this.per[iper] <= 0.5 && this.per[iper] > -1.0 ? 1500.0 : (this.per[iper] > 0.5 && this.per[iper] <= 1.0 ? Math.exp(8.0 - 0.795 * Math.log(this.per[iper] / 0.21)) : (this.per[iper] > 1.0 && this.per[iper] < 2.0 ? Math.exp(6.76 - 0.297 * Math.log(this.per[iper])) : 700.0)));
        double vs30Star = vs30 < v1 ? vs30 : v1;
        double z1Hat = vs30 < 180.0 ? Math.exp(6.745) : (vs30 >= 180.0 && vs30 <= 500.0 ? Math.exp(6.745 - 1.35 * Math.log(vs30 / 180.0)) : Math.exp(5.394 - 4.48 * Math.log(vs30 / 500.0)));
        double e2 = this.per[iper] < 0.35 && this.per[iper] > -1.0 || vs30 > 1000.0 ? 0.0 : (this.per[iper] >= 0.35 && this.per[iper] < 2.0 ? -0.25 * Math.log(vs30 / 1000.0) * Math.log(this.per[iper] / 0.35) : (this.per[iper] == -1.0 ? -0.25 * Math.log(vs30 / 1000.0) * Math.log(2.857142857142857) : -0.25 * Math.log(vs30 / 1000.0) * Math.log(5.714285714285714)));
        double a21test = (this.a10[iper] + this.b[iper] * this.N) * Math.log(vs30Star / Math.min(v1, 1000.0)) + e2 * Math.log((depthTo1pt0kmPerSec + this.c2) / (z1Hat + this.c2));
        double a21 = vs30 >= 1000.0 ? 0.0 : (a21test < 0.0 && vs30 < 1000.0 ? -(this.a10[iper] + this.b[iper] * this.N) * Math.log(vs30Star / Math.min(v1, 1000.0)) / Math.log((depthTo1pt0kmPerSec + this.c2) / (z1Hat + this.c2)) : e2);
        double a22 = this.per[iper] < 2.0 ? 0.0 : 0.0625 * (this.per[iper] - 2.0);
        double f10 = depthTo1pt0kmPerSec >= 200.0 ? a21 * Math.log((depthTo1pt0kmPerSec + this.c2) / (z1Hat + this.c2)) + a22 * Math.log(depthTo1pt0kmPerSec / 200.0) : a21 * Math.log((depthTo1pt0kmPerSec + this.c2) / (z1Hat + this.c2));
        return f10;
    }

    private double getMean(int iper, int iTd, double vs30, double rRup, double rJB, double f_as, double rX, double f_rv, double f_nm, double mag, double dip, double rupWidth, double depthTop, double pga_rock) {
        boolean hw = (Boolean)this.hangingWallFlagParam.getValue();
        double f4 = 0.0;
        double rR = Math.sqrt(Math.pow(rRup, 2.0) + Math.pow(this.c4, 2.0));
        double f1 = mag <= this.c1 ? this.a1[iper] + this.a4 * (mag - this.c1) + this.a8[iper] * Math.pow(8.5 - mag, 2.0) + (this.a2[iper] + this.a3 * (mag - this.c1)) * Math.log(rR) : this.a1[iper] + this.a5 * (mag - this.c1) + this.a8[iper] * Math.pow(8.5 - mag, 2.0) + (this.a2[iper] + this.a3 * (mag - this.c1)) * Math.log(rR);
        double v1 = this.per[iper] == -1.0 ? 862.0 : (this.per[iper] <= 0.5 && this.per[iper] > -1.0 ? 1500.0 : (this.per[iper] > 0.5 && this.per[iper] <= 1.0 ? Math.exp(8.0 - 0.795 * Math.log(this.per[iper] / 0.21)) : (this.per[iper] > 1.0 && this.per[iper] < 2.0 ? Math.exp(6.76 - 0.297 * Math.log(this.per[iper])) : 700.0)));
        double vs30Star = vs30 < v1 ? vs30 : v1;
        double f5 = vs30 < this.VLIN[iper] ? this.a10[iper] * Math.log(vs30Star / this.VLIN[iper]) - this.b[iper] * Math.log(pga_rock + this.c) + this.b[iper] * Math.log(pga_rock + this.c * Math.pow(vs30Star / this.VLIN[iper], this.N)) : (this.a10[iper] + this.b[iper] * this.N) * Math.log(vs30Star / this.VLIN[iper]);
        if (hw) {
            double T1 = rJB < 30.0 ? 1.0 - rJB / 30.0 : 0.0;
            double rXtest = rupWidth * Math.cos(Math.toRadians(dip));
            double T2 = rX >= rXtest || dip == 90.0 ? 1.0 : 0.5 + rX / (2.0 * rXtest);
            double T3 = rX >= depthTop ? 1.0 : rX / depthTop;
            double T4 = mag <= 6.0 ? 0.0 : (mag >= 7.0 ? 1.0 : mag - 6.0);
            double T5 = dip >= 70.0 ? 1.0 - (dip - 70.0) / 20.0 : 1.0;
            f4 = this.a14[iper] * T1 * T2 * T3 * T4 * T5;
        }
        double f6 = depthTop < 10.0 ? this.a16[iper] * depthTop / 10.0 : this.a16[iper];
        double T6 = mag < 5.5 ? 1.0 : (mag > 6.5 ? 0.5 : 0.5 * (6.5 - mag) + 0.5);
        double f8 = rRup < 100.0 ? 0.0 : this.a18[iper] * (rRup - 100.0) * T6;
        double cgMean = f1 + this.a12[iper] * f_rv + this.a13[iper] * f_nm + this.a15[iper] * f_as + f4 + f5 + f6 + f8;
        return cgMean;
    }

    public double getStdDev(int iper, String stdDevType, Component component, double vs30, double pga_rock, double vsm) {
        double tau0PGA;
        double tau0;
        double sigma0PGA;
        double sigma0;
        double s2;
        double s1;
        double s2PGA;
        double s1PGA;
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        double v1 = this.per[iper] == -1.0 ? 862.0 : (this.per[iper] <= 0.5 && this.per[iper] > -1.0 ? 1500.0 : (this.per[iper] > 0.5 && this.per[iper] <= 1.0 ? Math.exp(8.0 - 0.795 * Math.log(this.per[iper] / 0.21)) : (this.per[iper] > 1.0 && this.per[iper] < 2.0 ? Math.exp(6.76 - 0.297 * Math.log(this.per[iper])) : 700.0)));
        double vs30Star = vs30 < v1 ? vs30 : v1;
        double sigmaamp = 0.3;
        double dterm = 0.0;
        if (vs30 < this.VLIN[iper]) {
            dterm = this.b[iper] * pga_rock * (-1.0 / (pga_rock + this.c) + 1.0 / (pga_rock + this.c * Math.pow(vs30Star / this.VLIN[iper], this.N)));
        }
        if (vsm == 1.0) {
            s1PGA = this.s1m[1];
            s2PGA = this.s2m[1];
            s1 = this.s1m[iper];
            s2 = this.s2m[iper];
        } else {
            s1PGA = this.s1e[1];
            s2PGA = this.s2e[1];
            s1 = this.s1e[iper];
            s2 = this.s2e[iper];
        }
        if (this.mag < 5.0) {
            sigma0 = s1;
            sigma0PGA = s1PGA;
        } else if (this.mag > 7.0) {
            sigma0 = s2;
            sigma0PGA = s2PGA;
        } else {
            sigma0 = s1 + 0.5 * (s2 - s1) * (this.mag - 5.0);
            sigma0PGA = s1PGA + 0.5 * (s2PGA - s1PGA) * (this.mag - 5.0);
        }
        double sigmaB = Math.sqrt(Math.pow(sigma0, 2.0) - Math.pow(sigmaamp, 2.0));
        double sigmaBPGA = Math.sqrt(Math.pow(sigma0PGA, 2.0) - Math.pow(sigmaamp, 2.0));
        if (this.mag < 5.0) {
            tau0 = this.s3[iper];
            tau0PGA = this.s3[1];
        } else if (this.mag > 7.0) {
            tau0 = this.s4[iper];
            tau0PGA = this.s4[1];
        } else {
            tau0 = this.s3[iper] + 0.5 * (this.s4[iper] - this.s3[iper]) * (this.mag - 5.0);
            tau0PGA = this.s3[1] + 0.5 * (this.s4[1] - this.s3[1]) * (this.mag - 5.0);
        }
        double tauB = tau0;
        double tauBPGA = tau0PGA;
        double sigma = Math.sqrt(Math.pow(sigmaB, 2.0) + Math.pow(sigmaamp, 2.0) + Math.pow(dterm, 2.0) * Math.pow(sigmaBPGA, 2.0) + 2.0 * dterm * sigmaB * sigmaBPGA * this.rho[iper]);
        double tau = Math.sqrt(Math.pow(tau0, 2.0) + Math.pow(dterm, 2.0) * Math.pow(tauBPGA, 2.0) + 2.0 * dterm * tauB * tauBPGA * this.rho[iper]);
        double sigma_total = Math.sqrt(tau * tau + sigma * sigma);
        if (stdDevType.equals("Total")) {
            return sigma_total;
        }
        if (stdDevType.equals("Intra-Event")) {
            return sigma;
        }
        if (stdDevType.equals("Inter-Event")) {
            return tau;
        }
        return Double.NaN;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        this.rock_pga_is_not_fresh = true;
        if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("Fault Type")) {
            String fltType = (String)this.fltTypeParam.getValue();
            if (fltType.equals(FLT_TYPE_NORMAL)) {
                this.f_rv = 0.0;
                this.f_nm = 1.0;
            } else if (fltType.equals(FLT_TYPE_REVERSE)) {
                this.f_rv = 1.0;
                this.f_nm = 0.0;
            } else {
                this.f_rv = 0.0;
                this.f_nm = 0.0;
            }
        } else if (pName.equals("Rupture Top Depth")) {
            this.depthTop = (Double)val;
        } else if (pName.equals("Dip")) {
            this.dip = (Double)val;
        } else if (pName.equals("Down-Dip Width")) {
            this.rupWidth = (Double)val;
        } else if (pName.equals("Aftershock")) {
            this.f_as = ((Boolean)val).booleanValue() ? 1.0 : 0.0;
        } else if (pName.equals("Vs30")) {
            this.vs30 = (Double)val;
        } else if (pName.equals("Vs30 Type")) {
            this.vsm = ((String)val).equals("Measured") ? 1.0 : 0.0;
        } else if (pName.equals("Depth 1.0 km/sec")) {
            this.depthTo1pt0kmPerSec = val == null ? Double.NaN : (Double)val;
        } else if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals("(distRup-distJB)/distRup")) {
            this.distRupMinusJB_OverRup = (Double)val;
        } else if (pName.equals(this.distRupMinusDistX_OverRupParam.getName())) {
            this.distRupMinusDistX_OverRup = (Double)val;
        } else if (pName.equals("Site on Hanging Wall")) {
            this.f_hw = ((Boolean)val).booleanValue() ? 1.0 : 0.0;
        } else if (pName.equals("Std Dev Type")) {
            this.stdDevType = (String)val;
        } else if (pName.equals("Component")) {
            this.component = (Component)this.componentParam.getValue();
        } else if (pName.equals("SA Period")) {
            this.intensityMeasureChanged = true;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.magParam.removeParameterChangeListener(this);
        this.fltTypeParam.removeParameterChangeListener(this);
        this.rupTopDepthParam.removeParameterChangeListener(this);
        this.dipParam.removeParameterChangeListener(this);
        this.rupWidthParam.removeParameterChangeListener(this);
        this.aftershockParam.removeParameterChangeListener(this);
        this.vs30Param.removeParameterChangeListener(this);
        this.vs30_TypeParam.removeParameterChangeListener(this);
        this.depthTo1pt0kmPerSecParam.removeParameterChangeListener(this);
        this.distanceRupParam.removeParameterChangeListener(this);
        this.distRupMinusJB_OverRupParam.removeParameterChangeListener(this);
        this.distRupMinusDistX_OverRupParam.removeParameterChangeListener(this);
        this.hangingWallFlagParam.removeParameterChangeListener(this);
        this.componentParam.removeParameterChangeListener(this);
        this.stdDevTypeParam.removeParameterChangeListener(this);
        this.saPeriodParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.magParam.addParameterChangeListener(this);
        this.fltTypeParam.addParameterChangeListener(this);
        this.rupTopDepthParam.addParameterChangeListener(this);
        this.dipParam.addParameterChangeListener(this);
        this.rupWidthParam.addParameterChangeListener(this);
        this.aftershockParam.addParameterChangeListener(this);
        this.vs30Param.addParameterChangeListener(this);
        this.vs30_TypeParam.addParameterChangeListener(this);
        this.depthTo1pt0kmPerSecParam.addParameterChangeListener(this);
        this.distanceRupParam.addParameterChangeListener(this);
        this.distRupMinusJB_OverRupParam.addParameterChangeListener(this);
        this.distRupMinusDistX_OverRupParam.addParameterChangeListener(this);
        this.hangingWallFlagParam.addParameterChangeListener(this);
        this.componentParam.addParameterChangeListener(this);
        this.stdDevTypeParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
    }

    @Override
    public URL getInfoURL() throws MalformedURLException {
        return new URL(URL_INFO_STRING);
    }

    public static void main(String[] args) {
        Location loc1 = new Location(-0.1, 0.0, 0.0);
        Location loc2 = new Location(0.1, 0.0, 0.0);
        FaultTrace faultTrace = new FaultTrace("test");
        faultTrace.add(loc1);
        faultTrace.add(loc2);
        StirlingGriddedSurface surface = new StirlingGriddedSurface(faultTrace, 45.0, 0.0, 10.0, 1.0);
        EqkRupture rup = new EqkRupture();
        rup.setMag(7.0);
        rup.setAveRake(90.0);
        rup.setRuptureSurface(surface);
        AS_2008_AttenRel attenRel = new AS_2008_AttenRel(null);
        attenRel.setParamDefaults();
        attenRel.setIntensityMeasure("PGA");
        attenRel.setEqkRupture(rup);
        Site site = new Site();
        site.addParameter(attenRel.getParameter("Vs30"));
        site.addParameter(attenRel.getParameter("Depth 1.0 km/sec"));
        site.addParameter(attenRel.getParameter("Vs30 Type"));
        for (double dist = -0.3; dist <= 0.3; dist += 0.01) {
            Location loc = new Location(0.0, dist);
            site.setLocation(loc);
            attenRel.setSite(site);
            attenRel.getMean();
        }
    }
}

