/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGV_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceJBParameter;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;

@Deprecated
public class BA_2006_AttenRel
extends AttenuationRelationship
implements ParameterChangeListener {
    private static final String C = "BA_2006_AttenRel";
    private static final boolean D = false;
    public static final String SHORT_NAME = "Boore2006";
    private static final long serialVersionUID = 1234567890987654353L;
    public static final String NAME = "Boore & Atkinson (2006)";
    double[] period = new double[]{-2.0, -1.0, 0.0, 0.05, 0.1, 0.2, 0.3, 0.5, 1.0, 2.0, 3.0, 4.0, 5.0};
    double[] e01 = new double[]{-0.96402, 4.30814, -1.11599, -0.8604, -0.4966, -0.18575, -0.31699, -0.62784, -1.27487, -2.06005, -2.60576, -2.93734, -2.26498};
    double[] e02 = new double[]{-0.96402, 4.37031, -1.07915, -0.78212, -0.45054, -0.16733, -0.31009, -0.62094, -1.24033, -1.98637, -2.52057, -2.84754, -2.1913};
    double[] e03 = new double[]{-0.96402, 3.94064, -1.34556, -1.06833, -0.67845, -0.35388, -0.5065, -0.81194, -1.59746, -2.41603, -3.0071, -3.28664, -2.49017};
    double[] e04 = new double[]{-0.96402, 4.34942, -1.08589, -0.9418, -0.50546, -0.14161, -0.233, -0.54956, -1.19819, -2.10691, -2.69448, -3.07123, -2.39245};
    double[] e05 = new double[]{0.29795, 0.43312, 0.38983, 0.41009, 0.21582, 0.41055, 0.5091, 0.6514, 0.69377, 0.72117, 0.74903, 1.11952, 0.10516};
    double[] e06 = new double[]{-0.20341, -0.1128, -0.11736, -0.0957, -0.14218, -0.16809, -0.18428, -0.14354, -0.19885, -0.31499, -0.42298, -0.35897, -0.39006};
    double[] e07 = new double[]{0.0, 0.0, 0.0, 0.01804, 0.0, 0.0, 0.00632, 0.0, 5.8E-4, 0.32628, 0.6963, 0.68456, 0.0};
    double[] e08 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    double[] mh = new double[]{7.0, 8.5, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 8.5};
    double[] c01 = new double[]{-0.55, -0.7933, -0.6603, -0.5352, -0.6518, -0.5833, -0.5543, -0.6917, -0.8182, -0.8286, -0.7846, -0.6851, -0.5068};
    double[] c02 = new double[]{0.0, 0.1111, 0.1196, 0.1544, 0.1188, 0.04287, 0.01955, 0.06091, 0.1027, 0.09436, 0.07288, 0.03746, -0.02355};
    double[] c03 = new double[]{-0.01151, -0.00622, -0.01151, -0.01873, -0.01367, -0.00952, -0.0075, -0.0054, -0.00334, -0.00217, -0.00191, -0.00191, -0.00202};
    double[] c04 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    double[] mref = new double[]{6.0, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5};
    double[] rref = new double[]{5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0};
    double[] h = new double[]{3.0, 2.54, 1.35, 1.35, 1.68, 1.98, 2.14, 2.32, 2.54, 2.73, 2.83, 2.89, 2.93};
    double[] blin = new double[]{0.0, -0.6, -0.36, -0.29, -0.25, -0.31, -0.44, -0.6, -0.7, -0.73, -0.74, -0.75, -0.75};
    double[] vref = new double[]{0.0, 760.0, 760.0, 760.0, 760.0, 760.0, 760.0, 760.0, 760.0, 760.0, 760.0, 760.0, 760.0};
    double[] b1 = new double[]{0.0, -0.5, -0.64, -0.64, -0.6, -0.52, -0.52, -0.5, -0.44, -0.38, -0.34, -0.31, -0.3};
    double[] b2 = new double[]{0.0, -0.06, -0.14, -0.11, -0.13, -0.19, -0.14, -0.06, 0.0, 0.0, 0.0, 0.0, 0.0};
    double[] v1 = new double[]{0.0, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0};
    double[] v2 = new double[]{0.0, 300.0, 300.0, 300.0, 300.0, 300.0, 300.0, 300.0, 300.0, 300.0, 300.0, 300.0, 300.0};
    double[] a1 = new double[]{0.0, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03};
    double[] pga_low = new double[]{0.0, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06};
    double[] a2 = new double[]{0.0, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09};
    double[] sig1 = new double[]{0.0, 0.513, 0.502, 0.576, 0.53, 0.523, 0.546, 0.555, 0.573, 0.58, 0.566, 0.583, 0.603};
    double[] sig2u = new double[]{0.0, 0.286, 0.262, 0.368, 0.325, 0.286, 0.269, 0.262, 0.313, 0.396, 0.41, 0.389, 0.414};
    double[] sigtu = new double[]{0.0, 0.587, 0.566, 0.684, 0.622, 0.596, 0.608, 0.612, 0.654, 0.702, 0.7, 0.702, 0.732};
    double[] sig2m = new double[]{0.0, 0.256, 0.256, 0.366, 0.327, 0.288, 0.269, 0.262, 0.297, 0.389, 0.401, 0.38, 0.437};
    double[] sigtm = new double[]{0.0, 0.573, 0.562, 0.682, 0.622, 0.596, 0.608, 0.612, 0.645, 0.698, 0.693, 0.695, 0.744};
    private HashMap indexFromPerHashMap;
    private int iper;
    private double vs30;
    private double rjb;
    private double mag;
    private String stdDevType;
    private String fltType;
    private boolean parameterChange;
    protected static final Double MAG_WARN_MIN = 4.5;
    protected static final Double MAG_WARN_MAX = 8.5;
    protected static final Double DISTANCE_JB_WARN_MIN = 0.0;
    protected static final Double DISTANCE_JB_WARN_MAX = 200.0;
    protected static final Double VS30_WARN_MIN = 120.0;
    protected static final Double VS30_WARN_MAX = 2000.0;
    public static final String FLT_TYPE_UNKNOWN = "Unknown";
    public static final String FLT_TYPE_STRIKE_SLIP = "Strike-Slip";
    public static final String FLT_TYPE_REVERSE = "Reverse";
    public static final String FLT_TYPE_NORMAL = "Normal";

    public BA_2006_AttenRel(ParameterChangeWarningListener listener) {
        this.listener = listener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = new HashMap();
        for (int i = 3; i < this.period.length; ++i) {
            this.indexFromPerHashMap.put(this.period[i], i);
        }
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.setFaultTypeFromRake(eqkRupture.getAveRake());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.vs30Param.setValue((Double)site.getParameter("Vs30").getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceJBParam.setValue(this.eqkRupture, this.site);
        }
    }

    protected void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("BA_2006_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        this.iper = this.im.getName().equalsIgnoreCase("PGV") ? 1 : (this.im.getName().equalsIgnoreCase("PGA") ? 2 : (Integer)this.indexFromPerHashMap.get(this.saPeriodParam.getValue()));
        this.parameterChange = true;
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rjb > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        double pga4nl = Math.exp(this.getMean(0, this.vs30, this.rjb, this.mag, this.fltType, 0.0));
        return this.getMean(this.iper, this.vs30, this.rjb, this.mag, this.fltType, pga4nl);
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getStdDev(this.iper, this.stdDevType, this.fltType);
    }

    protected void setFaultTypeFromRake(double rake) throws InvalidRangeException {
        if (rake <= 30.0 && rake >= -30.0) {
            this.fltTypeParam.setValue(FLT_TYPE_STRIKE_SLIP);
        } else if (rake <= -150.0 || rake >= 150.0) {
            this.fltTypeParam.setValue(FLT_TYPE_STRIKE_SLIP);
        } else if (rake > 30.0 && rake < 150.0) {
            this.fltTypeParam.setValue(FLT_TYPE_REVERSE);
        } else if (rake > -150.0 && rake < -30.0) {
            this.fltTypeParam.setValue(FLT_TYPE_NORMAL);
        } else {
            this.fltTypeParam.setValue(FLT_TYPE_UNKNOWN);
        }
    }

    @Override
    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.distanceJBParam.setValueAsDefault();
        this.fltTypeParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.pgvParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.vs30 = (Double)this.vs30Param.getValue();
        this.rjb = (Double)this.distanceJBParam.getValue();
        this.mag = (Double)this.magParam.getValue();
        this.fltType = (String)this.fltTypeParam.getValue();
        this.stdDevType = (String)this.stdDevTypeParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceJBParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(VS30_WARN_MIN, (double)VS30_WARN_MAX);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        StringConstraint constraint = new StringConstraint();
        constraint.addString(FLT_TYPE_UNKNOWN);
        constraint.addString(FLT_TYPE_STRIKE_SLIP);
        constraint.addString(FLT_TYPE_NORMAL);
        constraint.addString(FLT_TYPE_REVERSE);
        constraint.setNonEditable();
        this.fltTypeParam = new FaultTypeParam(constraint, FLT_TYPE_UNKNOWN);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceJBParam = new DistanceJBParameter(0.0);
        this.distanceJBParam.addParameterChangeWarningListener(this.listener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_JB_WARN_MIN, DISTANCE_JB_WARN_MAX);
        warn.setNonEditable();
        this.distanceJBParam.setWarningConstraint(warn);
        this.distanceJBParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceJBParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        for (int i = 3; i < this.period.length; ++i) {
            periodConstraint.addDouble((Double)this.period[i]);
        }
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.pgvParam = new PGV_Param();
        this.pgvParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.listener);
        this.pgaParam.addParameterChangeWarningListener(this.listener);
        this.pgvParam.addParameterChangeWarningListener(this.listener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
        this.supportedIMParams.addParameter(this.pgvParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.GMRotI50, Component.GMRotI50);
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    public double getMean(int iper, double vs30, double rjb, double mag, String fltType, double pga4nl) {
        double Fs;
        boolean U = false;
        boolean S = false;
        boolean N = false;
        boolean R = false;
        if (fltType.equals(FLT_TYPE_UNKNOWN)) {
            U = true;
        } else if (fltType.equals(FLT_TYPE_NORMAL)) {
            N = true;
        } else if (fltType.equals(FLT_TYPE_STRIKE_SLIP)) {
            S = true;
        } else {
            R = true;
        }
        double magDiff = mag - this.mh[iper];
        double Fm = mag <= this.mh[iper] ? this.e01[iper] * (double)U + this.e02[iper] * (double)S + this.e03[iper] * (double)N + this.e04[iper] * (double)R + this.e05[iper] * magDiff + this.e06[iper] * magDiff * magDiff : this.e01[iper] * (double)U + this.e02[iper] * (double)S + this.e03[iper] * (double)N + this.e04[iper] * (double)R + this.e07[iper] * (mag - this.mh[iper]) + this.e08[iper] * magDiff * magDiff;
        double r = Math.sqrt(rjb * rjb + this.h[iper] * this.h[iper]);
        double Fd = (this.c01[iper] + this.c02[iper] * (mag - this.mref[iper])) * Math.log(r / this.rref[iper]) + (this.c03[iper] + this.c04[iper] * (mag - this.mref[iper])) * (r - this.rref[iper]);
        if (pga4nl == 0.0) {
            Fs = 0.0;
        } else {
            double Flin = this.blin[iper] * Math.log(vs30 / this.vref[iper]);
            double bnl = 0.0;
            if (vs30 <= this.v1[iper]) {
                bnl = this.b1[iper];
            } else if (vs30 <= this.v2[iper] && vs30 > this.v1[iper]) {
                bnl = (this.b1[iper] - this.b2[iper]) * Math.log(vs30 / this.v2[iper]) / Math.log(this.v1[iper] / this.v2[iper]) + this.b2[iper];
            } else if (vs30 <= this.vref[iper] && vs30 > this.v2[iper]) {
                bnl = this.b2[iper] * Math.log(vs30 / this.vref[iper]) / Math.log(this.v2[iper] / this.vref[iper]);
            } else if (vs30 > this.vref[iper]) {
                bnl = 0.0;
            }
            double dX = Math.log(this.a2[iper] / this.a1[iper]);
            double dY = bnl * Math.log(this.a2[iper] / this.pga_low[iper]);
            double c = (3.0 * dY - bnl * dX) / (dX * dX);
            double d = -(2.0 * dY - bnl * dX) / (dX * dX * dX);
            double Fnl = pga4nl <= this.a1[iper] ? bnl * Math.log(this.pga_low[iper] / 0.1) : (pga4nl <= this.a2[iper] & pga4nl > this.a1[iper] ? bnl * Math.log(this.pga_low[iper] / 0.1) + c * Math.pow(Math.log(pga4nl / this.a1[iper]), 2.0) + d * Math.pow(Math.log(pga4nl / this.a1[iper]), 3.0) : bnl * Math.log(pga4nl / 0.1));
            Fs = Flin + Fnl;
        }
        return Fm + Fd + Fs;
    }

    public double getStdDev(int iper, String stdDevType, String fltType) {
        if (fltType.equals(FLT_TYPE_UNKNOWN)) {
            if (stdDevType.equals("Total")) {
                return this.sigtu[iper];
            }
            if (stdDevType.equals("None (zero)")) {
                return 0.0;
            }
            if (stdDevType.equals("Inter-Event")) {
                return this.sig2u[iper];
            }
            if (stdDevType.equals("Intra-Event")) {
                return this.sig1[iper];
            }
            return Double.NaN;
        }
        if (stdDevType.equals("Total")) {
            return this.sigtm[iper];
        }
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        if (stdDevType.equals("Inter-Event")) {
            return this.sig2m[iper];
        }
        if (stdDevType.equals("Intra-Event")) {
            return this.sig1[iper];
        }
        return Double.NaN;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        this.parameterChange = true;
        if (pName.equals("DistanceJB")) {
            this.rjb = (Double)val;
        } else if (pName.equals("Vs30")) {
            this.vs30 = (Double)val;
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("Fault Type")) {
            this.fltType = (String)this.fltTypeParam.getValue();
        } else if (pName.equals("Std Dev Type")) {
            this.stdDevType = (String)val;
        } else if (pName.equals("SA Period")) {
            this.intensityMeasureChanged = true;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.distanceJBParam.removeParameterChangeListener(this);
        this.vs30Param.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.fltTypeParam.addParameterChangeListener(this);
        this.stdDevTypeParam.removeParameterChangeListener(this);
        this.saPeriodParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceJBParam.addParameterChangeListener(this);
        this.vs30Param.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.fltTypeParam.addParameterChangeListener(this);
        this.stdDevTypeParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
    }

    @Override
    public URL getInfoURL() throws MalformedURLException {
        return new URL("http://www.opensha.org/documentation/modelsImplemented/attenRel/BA_2006.html");
    }
}

