/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGV_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceJBParameter;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;

public class BA_2008_AttenRel
extends AttenuationRelationship
implements ParameterChangeListener {
    private static final String C = "BA_2008_AttenRel";
    public static final String SHORT_NAME = "Boore2008";
    private static final long serialVersionUID = 1L;
    public static final String NAME = "Boore & Atkinson (2008)";
    private static final String URL_INFO_STRING = "http://www.opensha.org/glossary-attenuationRelation-BOORE_ATKIN_2008";
    protected double[] period = new double[]{-2.0, -1.0, 0.0, 0.01, 0.02, 0.03, 0.05, 0.075, 0.1, 0.15, 0.2, 0.25, 0.3, 0.4, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 5.0, 7.5, 10.0};
    protected double[] b_lin = new double[]{-0.36, -0.6, -0.36, -0.36, -0.34, -0.33, -0.29, -0.23, -0.25, -0.28, -0.31, -0.39, -0.44, -0.5, -0.6, -0.69, -0.7, -0.72, -0.73, -0.74, -0.75, -0.75, -0.692, -0.65};
    protected double[] b1 = new double[]{-0.64, -0.5, -0.64, -0.64, -0.63, -0.62, -0.64, -0.64, -0.6, -0.53, -0.52, -0.52, -0.52, -0.51, -0.5, -0.47, -0.44, -0.4, -0.38, -0.34, -0.31, -0.291, -0.247, -0.215};
    protected double[] b2 = new double[]{-0.14, -0.06, -0.14, -0.14, -0.12, -0.11, -0.11, -0.11, -0.13, -0.18, -0.19, -0.16, -0.14, -0.1, -0.06, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    protected double[] c1 = new double[]{-0.6605, -0.8737, -0.6605, -0.6622, -0.666, -0.6901, -0.717, -0.7205, -0.7081, -0.6961, -0.583, -0.5726, -0.5543, -0.6443, -0.6914, -0.7408, -0.8183, -0.8303, -0.8285, -0.7844, -0.6854, -0.5096, -0.3724, -0.09824};
    protected double[] c2 = new double[]{0.1197, 0.1006, 0.1197, 0.12, 0.1228, 0.1283, 0.1317, 0.1237, 0.1117, 0.09884, 0.04273, 0.02977, 0.01955, 0.04394, 0.0608, 0.07518, 0.1027, 0.09793, 0.09432, 0.07282, 0.03758, -0.02391, -0.06568, -0.138};
    protected double[] c3 = new double[]{-0.01151, -0.00334, -0.01151, -0.01151, -0.01151, -0.01151, -0.01151, -0.01151, -0.01151, -0.01113, -0.00952, -0.00837, -0.0075, -0.00626, -0.0054, -0.00409, -0.00334, -0.00255, -0.00217, -0.00191, -0.00191, -0.00191, -0.00191, -0.00191};
    protected double[] h = new double[]{1.35, 2.54, 1.35, 1.35, 1.35, 1.35, 1.35, 1.55, 1.68, 1.86, 1.98, 2.07, 2.14, 2.24, 2.32, 2.46, 2.54, 2.66, 2.73, 2.83, 2.89, 2.93, 3.0, 3.04};
    protected double[] e1 = new double[]{-0.53804, 5.00121, -0.53804, -0.52883, -0.52192, -0.45285, -0.28476, 0.00767, 0.20109, 0.46128, 0.5718, 0.51884, 0.43825, 0.3922, 0.18957, -0.21338, -0.46896, -0.86271, -1.22652, -1.82979, -2.24656, -1.28408, -1.43145, -2.15446};
    protected double[] e2 = new double[]{-0.5035, 5.04727, -0.5035, -0.49429, -0.48508, -0.41831, -0.25022, 0.04912, 0.23102, 0.48661, 0.59253, 0.53496, 0.44516, 0.40602, 0.19878, -0.19496, -0.43443, -0.79593, -1.15514, -1.7469, -2.15906, -1.2127, -1.31632, -2.16137};
    protected double[] e3 = new double[]{-0.75472, 4.63188, -0.75472, -0.74551, -0.73906, -0.66722, -0.48462, -0.20578, 0.03058, 0.30185, 0.4086, 0.3388, 0.25356, 0.21398, 0.00967, -0.49176, -0.78465, -1.20902, -1.57697, -2.22584, -2.58228, -1.50904, -1.81022, -2.53323};
    protected double[] e4 = new double[]{-0.5097, 5.0821, -0.5097, -0.49966, -0.48895, -0.42229, -0.26092, 0.02706, 0.22193, 0.49328, 0.61472, 0.57747, 0.5199, 0.4608, 0.26337, -0.10813, -0.3933, -0.88085, -1.27669, -1.91814, -2.38168, -1.41093, -1.59217, -2.14635};
    protected double[] e5 = new double[]{0.28805, 0.18322, 0.28805, 0.28897, 0.25144, 0.17976, 0.06369, 0.0117, 0.04697, 0.1799, 0.52729, 0.6088, 0.64472, 0.7861, 0.76837, 0.75179, 0.6788, 0.70689, 0.77989, 0.77966, 1.24961, 0.14271, 0.52407, 0.40387};
    protected double[] e6 = new double[]{-0.10164, -0.12736, -0.10164, -0.10019, -0.11006, -0.12858, -0.15752, -0.17051, -0.15948, -0.14539, -0.12964, -0.13843, -0.15694, -0.07843, -0.09054, -0.14053, -0.18257, -0.2595, -0.29657, -0.45384, -0.35874, -0.39006, -0.37578, -0.48492};
    protected double[] e7 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00102, 0.08607, 0.10601, 0.02262, 0.0, 0.10302, 0.05393, 0.19082, 0.29888, 0.67466, 0.79508, 0.0, 0.0, 0.0};
    protected double[] mh = new double[]{6.75, 8.5, 6.75, 6.75, 6.75, 6.75, 6.75, 6.75, 6.75, 6.75, 6.75, 6.75, 6.75, 6.75, 6.75, 6.75, 6.75, 6.75, 6.75, 6.75, 6.75, 8.5, 8.5, 8.5};
    protected double[] s = new double[]{0.0, 0.5, 0.502, 0.502, 0.502, 0.507, 0.516, 0.513, 0.52, 0.518, 0.523, 0.527, 0.546, 0.541, 0.555, 0.571, 0.573, 0.566, 0.58, 0.566, 0.583, 0.601, 0.626, 0.645};
    protected double[] t_u = new double[]{0.0, 0.286, 0.265, 0.267, 0.267, 0.276, 0.286, 0.322, 0.313, 0.288, 0.283, 0.267, 0.272, 0.267, 0.265, 0.311, 0.318, 0.382, 0.398, 0.41, 0.394, 0.414, 0.465, 0.355};
    protected double[] s_tu = new double[]{0.0, 0.576, 0.566, 0.569, 0.569, 0.578, 0.589, 0.606, 0.608, 0.592, 0.596, 0.592, 0.608, 0.603, 0.615, 0.649, 0.654, 0.684, 0.702, 0.7, 0.702, 0.73, 0.781, 0.735};
    protected double[] t_m = new double[]{0.0, 0.256, 0.26, 0.262, 0.262, 0.274, 0.286, 0.32, 0.318, 0.29, 0.288, 0.267, 0.269, 0.267, 0.265, 0.299, 0.302, 0.373, 0.389, 0.401, 0.385, 0.437, 0.477, 0.477};
    protected double[] s_tm = new double[]{0.0, 0.56, 0.564, 0.566, 0.566, 0.576, 0.589, 0.606, 0.608, 0.594, 0.596, 0.592, 0.608, 0.603, 0.615, 0.645, 0.647, 0.679, 0.7, 0.695, 0.698, 0.744, 0.787, 0.801};
    protected double a1 = 0.03;
    protected double pgalow = 0.06;
    protected double a2 = 0.09;
    protected double v1 = 180.0;
    protected double v2 = 300.0;
    protected double v_ref = 760.0;
    protected double m_ref = 4.5;
    protected double r_ref = 1.0;
    private HashMap indexFromPerHashMap;
    private int iper;
    private double vs30;
    private double rjb;
    private double mag;
    private String stdDevType;
    private String fltType;
    protected static final Double MAG_WARN_MIN = 5.0;
    protected static final Double MAG_WARN_MAX = 8.0;
    protected static final Double DISTANCE_JB_WARN_MIN = 0.0;
    protected static final Double DISTANCE_JB_WARN_MAX = 200.0;
    protected static final Double VS30_WARN_MIN = 180.0;
    protected static final Double VS30_WARN_MAX = 1300.0;
    public static final String FLT_TYPE_UNKNOWN = "Unknown";
    public static final String FLT_TYPE_STRIKE_SLIP = "Strike-Slip";
    public static final String FLT_TYPE_REVERSE = "Reverse";
    public static final String FLT_TYPE_NORMAL = "Normal";

    public BA_2008_AttenRel(ParameterChangeWarningListener listener) {
        this.listener = listener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = new HashMap();
        for (int i = 3; i < this.period.length; ++i) {
            this.indexFromPerHashMap.put(this.period[i], i);
        }
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.eqkRupture = eqkRupture;
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.setFaultTypeFromRake(eqkRupture.getAveRake());
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.site = site;
        this.vs30Param.setValueIgnoreWarning((Double)site.getParameter("Vs30").getValue());
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceJBParam.getValue(this.eqkRupture, this.site);
        }
    }

    protected void setFaultTypeFromRake(double rake) {
        if (rake > 30.0 && rake < 150.0) {
            this.fltTypeParam.setValue(FLT_TYPE_REVERSE);
        } else if (rake > -150.0 && rake < -30.0) {
            this.fltTypeParam.setValue(FLT_TYPE_NORMAL);
        } else if (rake > 180.0 || rake < -180.0 || rake == Double.NaN) {
            this.fltTypeParam.setValue(FLT_TYPE_UNKNOWN);
        } else {
            this.fltTypeParam.setValue(FLT_TYPE_STRIKE_SLIP);
        }
    }

    protected void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("BA_2008_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        this.iper = this.im.getName().equalsIgnoreCase("PGV") ? 1 : (this.im.getName().equalsIgnoreCase("PGA") ? 2 : (Integer)this.indexFromPerHashMap.get(this.saPeriodParam.getValue()));
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rjb > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        double pga4nl = Math.exp(this.getMean(0, 760.0, this.rjb, this.mag, this.fltType, 0.0));
        return this.getMean(this.iper, this.vs30, this.rjb, this.mag, this.fltType, pga4nl);
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getStdDev(this.iper, this.stdDevType, this.fltType);
    }

    @Override
    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.distanceJBParam.setValueAsDefault();
        this.fltTypeParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.pgvParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.vs30 = (Double)this.vs30Param.getValue();
        this.rjb = (Double)this.distanceJBParam.getValue();
        this.mag = (Double)this.magParam.getValue();
        this.fltType = (String)this.fltTypeParam.getValue();
        this.stdDevType = (String)this.stdDevTypeParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceJBParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(VS30_WARN_MIN, (double)VS30_WARN_MAX);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        StringConstraint constraint = new StringConstraint();
        constraint.addString(FLT_TYPE_UNKNOWN);
        constraint.addString(FLT_TYPE_STRIKE_SLIP);
        constraint.addString(FLT_TYPE_NORMAL);
        constraint.addString(FLT_TYPE_REVERSE);
        constraint.setNonEditable();
        this.fltTypeParam = new FaultTypeParam(constraint, FLT_TYPE_UNKNOWN);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceJBParam = new DistanceJBParameter(0.0);
        this.distanceJBParam.addParameterChangeWarningListener(this.listener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_JB_WARN_MIN, DISTANCE_JB_WARN_MAX);
        warn.setNonEditable();
        this.distanceJBParam.setWarningConstraint(warn);
        this.distanceJBParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceJBParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        for (int i = 3; i < this.period.length; ++i) {
            periodConstraint.addDouble((Double)this.period[i]);
        }
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.pgvParam = new PGV_Param();
        this.pgvParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.listener);
        this.pgaParam.addParameterChangeWarningListener(this.listener);
        this.pgvParam.addParameterChangeWarningListener(this.listener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
        this.supportedIMParams.addParameter(this.pgvParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.GMRotI50, Component.GMRotI50);
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    public double getMean(int iper, double vs30, double rjb, double mag, String fltType, double pga4nl) {
        double Fs;
        boolean U = false;
        boolean S = false;
        boolean N = false;
        boolean R = false;
        if (fltType.equals(FLT_TYPE_UNKNOWN)) {
            U = true;
        } else if (fltType.equals(FLT_TYPE_NORMAL)) {
            N = true;
        } else if (fltType.equals(FLT_TYPE_STRIKE_SLIP)) {
            S = true;
        } else {
            R = true;
        }
        double magDiff = mag - this.mh[iper];
        double Fm = mag <= this.mh[iper] ? this.e1[iper] * (double)U + this.e2[iper] * (double)S + this.e3[iper] * (double)N + this.e4[iper] * (double)R + this.e5[iper] * magDiff + this.e6[iper] * magDiff * magDiff : this.e1[iper] * (double)U + this.e2[iper] * (double)S + this.e3[iper] * (double)N + this.e4[iper] * (double)R + this.e7[iper] * (mag - this.mh[iper]);
        double r = Math.sqrt(rjb * rjb + this.h[iper] * this.h[iper]);
        double Fd = (this.c1[iper] + this.c2[iper] * (mag - this.m_ref)) * Math.log(r / this.r_ref) + this.c3[iper] * (r - this.r_ref);
        if (iper == 0) {
            Fs = 0.0;
        } else {
            double Fnl;
            double Flin = this.b_lin[iper] * Math.log(vs30 / this.v_ref);
            double bnl = 0.0;
            bnl = vs30 <= this.v1 ? this.b1[iper] : (vs30 <= this.v2 && vs30 > this.v1 ? (this.b1[iper] - this.b2[iper]) * Math.log(vs30 / this.v2) / Math.log(this.v1 / this.v2) + this.b2[iper] : (vs30 < this.v_ref && vs30 > this.v2 ? this.b2[iper] * Math.log(vs30 / this.v_ref) / Math.log(this.v2 / this.v_ref) : 0.0));
            if (pga4nl <= this.a1) {
                Fnl = bnl * Math.log(this.pgalow / 0.1);
            } else if (pga4nl <= this.a2 & pga4nl > this.a1) {
                double dX = Math.log(this.a2 / this.a1);
                double dY = bnl * Math.log(this.a2 / this.pgalow);
                double c = (3.0 * dY - bnl * dX) / (dX * dX);
                double d = -(2.0 * dY - bnl * dX) / (dX * dX * dX);
                Fnl = bnl * Math.log(this.pgalow / 0.1) + c * Math.pow(Math.log(pga4nl / this.a1), 2.0) + d * Math.pow(Math.log(pga4nl / this.a1), 3.0);
            } else {
                Fnl = bnl * Math.log(pga4nl / 0.1);
            }
            Fs = Flin + Fnl;
        }
        return Fm + Fd + Fs;
    }

    public double getStdDev(int iper, String stdDevType, String fltType) {
        if (fltType.equals(FLT_TYPE_UNKNOWN)) {
            if (stdDevType.equals("Total")) {
                return this.s_tu[iper];
            }
            if (stdDevType.equals("None (zero)")) {
                return 0.0;
            }
            if (stdDevType.equals("Inter-Event")) {
                return this.t_u[iper];
            }
            if (stdDevType.equals("Intra-Event")) {
                return this.s[iper];
            }
            return Double.NaN;
        }
        if (stdDevType.equals("Total")) {
            return this.s_tm[iper];
        }
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        if (stdDevType.equals("Inter-Event")) {
            return this.t_m[iper];
        }
        if (stdDevType.equals("Intra-Event")) {
            return this.s[iper];
        }
        return Double.NaN;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        if (pName.equals("DistanceJB")) {
            this.rjb = (Double)val;
        } else if (pName.equals("Vs30")) {
            this.vs30 = (Double)val;
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("Fault Type")) {
            this.fltType = (String)this.fltTypeParam.getValue();
        } else if (pName.equals("Std Dev Type")) {
            this.stdDevType = (String)val;
        } else if (pName.equals("SA Period")) {
            this.intensityMeasureChanged = true;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.distanceJBParam.removeParameterChangeListener(this);
        this.vs30Param.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.fltTypeParam.addParameterChangeListener(this);
        this.stdDevTypeParam.removeParameterChangeListener(this);
        this.saPeriodParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceJBParam.addParameterChangeListener(this);
        this.vs30Param.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.fltTypeParam.addParameterChangeListener(this);
        this.stdDevTypeParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
    }

    @Override
    public URL getInfoURL() throws MalformedURLException {
        return new URL(URL_INFO_STRING);
    }
}

