/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.DipParam;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupTopDepthParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGD_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGV_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistRupMinusJB_OverRupParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.imr.param.SiteParams.DepthTo2pt5kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;

@Deprecated
public class CB_2006_AttenRel
extends AttenuationRelationship
implements ParameterChangeListener {
    private static final String C = "CB_2006_AttenRel";
    private static final boolean D = false;
    public static final String SHORT_NAME = "CB2006";
    private static final long serialVersionUID = 1234567890987654358L;
    public static final String NAME = "Campbell & Bozorgnia (2006)";
    private static final String CB_2006_CoeffFile = "campbell_2006_coeff.txt";
    double[] per = new double[]{-2.0, -1.0, 0.0, 0.01, 0.02, 0.03, 0.05, 0.075, 0.1, 0.15, 0.2, 0.25, 0.3, 0.4, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 5.0, 7.5, 10.0};
    double[] c0 = new double[]{-5.27, 0.954, -1.715, -1.715, -1.68, -1.552, -1.209, -0.657, -0.314, -0.133, -0.486, -0.89, -1.171, -1.466, -2.569, -4.844, -6.406, -8.692, -9.701, -10.556, -11.212, -11.684, -12.505, -13.087};
    double[] c1 = new double[]{1.6, 0.696, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.656, 0.972, 1.196, 1.513, 1.6, 1.6, 1.6, 1.6, 1.6, 1.6};
    double[] c2 = new double[]{-0.07, -0.309, -0.53, -0.53, -0.53, -0.53, -0.53, -0.53, -0.53, -0.53, -0.446, -0.362, -0.294, -0.186, -0.304, -0.578, -0.772, -1.046, -0.978, -0.638, -0.316, -0.07, -0.07, -0.07};
    double[] c3 = new double[]{0.0, -0.019, -0.262, -0.262, -0.262, -0.262, -0.267, -0.302, -0.324, -0.339, -0.398, -0.458, -0.511, -0.592, -0.536, -0.406, -0.314, -0.185, -0.236, -0.491, -0.77, -0.986, -0.656, -0.422};
    double[] c4 = new double[]{-2.0, -2.016, -2.118, -2.118, -2.123, -2.145, -2.199, -2.277, -2.318, -2.309, -2.22, -2.146, -2.095, -2.066, -2.041, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0};
    double[] c5 = new double[]{0.17, 0.17, 0.17, 0.17, 0.17, 0.17, 0.17, 0.17, 0.17, 0.17, 0.17, 0.17, 0.17, 0.17, 0.17, 0.17, 0.17, 0.17, 0.17, 0.17, 0.17, 0.17, 0.17, 0.17};
    double[] c6 = new double[]{4.0, 4.0, 5.6, 5.6, 5.6, 5.6, 5.74, 7.09, 8.05, 8.79, 7.6, 6.58, 6.04, 5.3, 4.73, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0};
    double[] c7 = new double[]{0.0, 0.245, 0.28, 0.28, 0.28, 0.28, 0.28, 0.28, 0.28, 0.28, 0.28, 0.28, 0.28, 0.28, 0.28, 0.28, 0.255, 0.161, 0.094, 0.0, 0.0, 0.0, 0.0, 0.0};
    double[] c8 = new double[]{0.0, 0.0, -0.12, -0.12, -0.12, -0.12, -0.12, -0.12, -0.099, -0.048, -0.012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    double[] c9 = new double[]{0.0, 0.358, 0.49, 0.49, 0.49, 0.49, 0.49, 0.49, 0.49, 0.49, 0.49, 0.49, 0.49, 0.49, 0.49, 0.49, 0.49, 0.49, 0.371, 0.154, 0.0, 0.0, 0.0, 0.0};
    double[] c10 = new double[]{-0.82, 1.694, 1.058, 1.058, 1.102, 1.174, 1.272, 1.438, 1.604, 1.928, 2.194, 2.351, 2.46, 2.587, 2.544, 2.133, 1.571, 0.406, -0.456, -0.82, -0.82, -0.82, -0.82, -0.82};
    double[] c11 = new double[]{0.3, 0.092, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.077, 0.15, 0.253, 0.3, 0.3, 0.3, 0.3, 0.3, 0.3};
    double[] c12 = new double[]{1.0, 1.0, 0.61, 0.61, 0.61, 0.61, 0.61, 0.61, 0.61, 0.61, 0.61, 0.61, 0.61, 0.61, 0.883, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    double[] k1 = new double[]{400.0, 400.0, 865.0, 865.0, 865.0, 908.0, 1054.0, 1086.0, 1032.0, 878.0, 748.0, 654.0, 587.0, 503.0, 457.0, 410.0, 400.0, 400.0, 400.0, 400.0, 400.0, 400.0, 400.0, 400.0};
    double[] k2 = new double[]{0.0, -1.955, -1.186, -1.186, -1.219, -1.273, -1.346, -1.471, -1.624, -1.931, -2.188, -2.381, -2.518, -2.657, -2.669, -2.401, -1.955, -1.025, -0.299, 0.0, 0.0, 0.0, 0.0, 0.0};
    double[] k3 = new double[]{2.744, 1.929, 1.839, 1.839, 1.84, 1.841, 1.843, 1.845, 1.847, 1.852, 1.856, 1.861, 1.865, 1.874, 1.883, 1.906, 1.929, 1.974, 2.019, 2.11, 2.2, 2.291, 2.517, 2.744};
    double[] s_lny = new double[]{0.667, 0.484, 0.478, 0.478, 0.48, 0.489, 0.51, 0.52, 0.531, 0.532, 0.534, 0.534, 0.544, 0.541, 0.55, 0.568, 0.568, 0.564, 0.571, 0.558, 0.576, 0.601, 0.628, 0.667};
    double[] t_lny = new double[]{0.485, 0.203, 0.219, 0.219, 0.219, 0.235, 0.258, 0.292, 0.286, 0.28, 0.249, 0.24, 0.215, 0.217, 0.214, 0.227, 0.255, 0.296, 0.296, 0.326, 0.297, 0.359, 0.428, 0.485};
    double[] c_lny = new double[]{0.309, 0.206, 0.181, 0.181, 0.181, 0.181, 0.179, 0.177, 0.19, 0.201, 0.207, 0.208, 0.216, 0.224, 0.223, 0.236, 0.24, 0.237, 0.241, 0.244, 0.252, 0.253, 0.288, 0.309};
    double[] rho_s = new double[]{0.174, 0.691, 1.0, 1.0, 0.999, 0.989, 0.963, 0.922, 0.898, 0.89, 0.871, 0.852, 0.831, 0.785, 0.735, 0.628, 0.534, 0.411, 0.331, 0.289, 0.261, 0.2, 0.174, 0.174};
    double[] rho_t = new double[]{0.29, 0.538, 1.0, 1.0, 0.994, 0.979, 0.927, 0.88, 0.871, 0.885, 0.913, 0.873, 0.848, 0.756, 0.631, 0.442, 0.29, 0.29, 0.29, 0.29, 0.29, 0.29, 0.29, 0.29};
    private HashMap indexFromPerHashMap;
    private int iper;
    private double vs30;
    private double rJB;
    private double rRup;
    private double distRupMinusJB_OverRup;
    private double f_rv;
    private double f_nm;
    private double mag;
    private double depthTop;
    private double depthTo2pt5kmPerSec;
    private double dip;
    private String stdDevType;
    private Component component;
    private boolean magSaturation;
    private boolean parameterChange;
    protected static final Double MAG_WARN_MIN = 4.0;
    protected static final Double MAG_WARN_MAX = 8.5;
    protected static final Double DISTANCE_RUP_WARN_MIN = 0.0;
    protected static final Double DISTANCE_RUP_WARN_MAX = 200.0;
    protected static final Double DISTANCE_MINUS_WARN_MIN = 0.0;
    protected static final Double DISTANCE_MINUS_WARN_MAX = 50.0;
    protected static final Double VS30_WARN_MIN = 180.0;
    protected static final Double VS30_WARN_MAX = 1500.0;
    protected static final Double DEPTH_2pt5_WARN_MIN = 0.0;
    protected static final Double DEPTH_2pt5_WARN_MAX = 6.0;
    protected static final Double DIP_WARN_MIN = 15.0;
    protected static final Double DIP_WARN_MAX = 90.0;
    protected static final Double RUP_TOP_WARN_MIN = 0.0;
    protected static final Double RUP_TOP_WARN_MAX = 20.0;
    public static final String FLT_TYPE_STRIKE_SLIP = "Strike-Slip";
    public static final String FLT_TYPE_REVERSE = "Reverse";
    public static final String FLT_TYPE_NORMAL = "Normal";

    public CB_2006_AttenRel(ParameterChangeWarningListener listener) {
        this.listener = listener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = new HashMap();
        for (int i = 3; i < this.per.length; ++i) {
            this.indexFromPerHashMap.put(this.per[i], i);
        }
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
    }

    private void readCoeffFile() {
        try {
            ArrayList<String> coeff = FileUtils.loadFile(this.getClass().getResource(CB_2006_CoeffFile));
            String perLine = coeff.get(0);
            ArrayList<Double> period = new ArrayList<Double>();
            StringTokenizer st = new StringTokenizer(perLine);
            int size = this.loadCoeffInArray(st, period);
            this.per = new double[size];
            this.createCoeffArray(period, this.per);
            period = null;
            String c0Line = coeff.get(1);
            ArrayList<Double> c0List = new ArrayList<Double>();
            st = new StringTokenizer(c0Line);
            size = this.loadCoeffInArray(st, c0List);
            this.c0 = new double[size];
            this.createCoeffArray(c0List, this.c0);
            c0List = null;
            String c1Line = coeff.get(2);
            ArrayList<Double> c1List = new ArrayList<Double>();
            st = new StringTokenizer(c1Line);
            size = this.loadCoeffInArray(st, c1List);
            this.c1 = new double[size];
            this.createCoeffArray(c1List, this.c1);
            c1List = null;
            String c2Line = coeff.get(3);
            ArrayList<Double> c2List = new ArrayList<Double>();
            st = new StringTokenizer(c2Line);
            size = this.loadCoeffInArray(st, c2List);
            this.c2 = new double[size];
            this.createCoeffArray(c2List, this.c2);
            c2List = null;
            String c3Line = coeff.get(4);
            ArrayList<Double> c3List = new ArrayList<Double>();
            st = new StringTokenizer(c3Line);
            size = this.loadCoeffInArray(st, c3List);
            this.c3 = new double[size];
            this.createCoeffArray(c3List, this.c3);
            c3List = null;
            String c4Line = coeff.get(5);
            ArrayList<Double> c4List = new ArrayList<Double>();
            st = new StringTokenizer(c4Line);
            size = this.loadCoeffInArray(st, c4List);
            this.c4 = new double[size];
            this.createCoeffArray(c4List, this.c4);
            c4List = null;
            String c5Line = coeff.get(6);
            ArrayList<Double> c5List = new ArrayList<Double>();
            st = new StringTokenizer(c5Line);
            size = this.loadCoeffInArray(st, c5List);
            this.c5 = new double[size];
            this.createCoeffArray(c5List, this.c5);
            c5List = null;
            String c6Line = coeff.get(7);
            ArrayList<Double> c6List = new ArrayList<Double>();
            st = new StringTokenizer(c6Line);
            size = this.loadCoeffInArray(st, c6List);
            this.c6 = new double[size];
            this.createCoeffArray(c6List, this.c6);
            c6List = null;
            String c7Line = coeff.get(8);
            ArrayList<Double> c7List = new ArrayList<Double>();
            st = new StringTokenizer(c7Line);
            size = this.loadCoeffInArray(st, c7List);
            this.c7 = new double[size];
            this.createCoeffArray(c7List, this.c7);
            c7List = null;
            String c8Line = coeff.get(9);
            ArrayList<Double> c8List = new ArrayList<Double>();
            st = new StringTokenizer(c8Line);
            size = this.loadCoeffInArray(st, c8List);
            this.c8 = new double[size];
            this.createCoeffArray(c8List, this.c8);
            c8List = null;
            String c9Line = coeff.get(10);
            ArrayList<Double> c9List = new ArrayList<Double>();
            st = new StringTokenizer(c9Line);
            size = this.loadCoeffInArray(st, c9List);
            this.c9 = new double[size];
            this.createCoeffArray(c9List, this.c9);
            c9List = null;
            String c10Line = coeff.get(11);
            ArrayList<Double> c10List = new ArrayList<Double>();
            st = new StringTokenizer(c10Line);
            size = this.loadCoeffInArray(st, c10List);
            this.c10 = new double[size];
            this.createCoeffArray(c10List, this.c10);
            c10List = null;
            String c11Line = coeff.get(12);
            ArrayList<Double> c11List = new ArrayList<Double>();
            st = new StringTokenizer(c11Line);
            size = this.loadCoeffInArray(st, c11List);
            this.c11 = new double[size];
            this.createCoeffArray(c11List, this.c11);
            c11List = null;
            String c12Line = coeff.get(13);
            ArrayList<Double> c12List = new ArrayList<Double>();
            st = new StringTokenizer(c12Line);
            size = this.loadCoeffInArray(st, c12List);
            this.c12 = new double[size];
            this.createCoeffArray(c12List, this.c12);
            c12List = null;
            String k1Line = coeff.get(14);
            ArrayList<Double> k1List = new ArrayList<Double>();
            st = new StringTokenizer(k1Line);
            size = this.loadCoeffInArray(st, k1List);
            this.k1 = new double[size];
            this.createCoeffArray(k1List, this.k1);
            k1List = null;
            String k2Line = coeff.get(15);
            ArrayList<Double> k2List = new ArrayList<Double>();
            st = new StringTokenizer(k2Line);
            size = this.loadCoeffInArray(st, k2List);
            this.k2 = new double[size];
            this.createCoeffArray(k2List, this.k2);
            k2List = null;
            String k3Line = coeff.get(16);
            ArrayList<Double> k3List = new ArrayList<Double>();
            st = new StringTokenizer(k3Line);
            size = this.loadCoeffInArray(st, k3List);
            this.k3 = new double[size];
            this.createCoeffArray(k3List, this.k3);
            k3List = null;
            String s_lnyLine = coeff.get(17);
            ArrayList<Double> s_lnyList = new ArrayList<Double>();
            st = new StringTokenizer(s_lnyLine);
            size = this.loadCoeffInArray(st, s_lnyList);
            this.s_lny = new double[size];
            this.createCoeffArray(s_lnyList, this.s_lny);
            s_lnyList = null;
            String t_lnyLine = coeff.get(18);
            ArrayList<Double> t_lnyList = new ArrayList<Double>();
            st = new StringTokenizer(t_lnyLine);
            size = this.loadCoeffInArray(st, t_lnyList);
            this.t_lny = new double[size];
            this.createCoeffArray(t_lnyList, this.t_lny);
            t_lnyList = null;
            String c_lnyLine = coeff.get(19);
            ArrayList<Double> c_lnyList = new ArrayList<Double>();
            st = new StringTokenizer(c_lnyLine);
            size = this.loadCoeffInArray(st, c_lnyList);
            this.c_lny = new double[size];
            this.createCoeffArray(c_lnyList, this.c_lny);
            c_lnyList = null;
            String rho_sLine = coeff.get(20);
            ArrayList<Double> rho_sList = new ArrayList<Double>();
            st = new StringTokenizer(rho_sLine);
            size = this.loadCoeffInArray(st, rho_sList);
            this.rho_s = new double[size];
            this.createCoeffArray(rho_sList, this.rho_s);
            rho_sList = null;
            String rho_tLine = coeff.get(21);
            ArrayList<Double> rho_tList = new ArrayList<Double>();
            st = new StringTokenizer(rho_tLine);
            size = this.loadCoeffInArray(st, rho_tList);
            this.rho_t = new double[size];
            this.createCoeffArray(rho_tList, this.rho_t);
            rho_tList = null;
        }
        catch (Exception e) {
            System.out.println("campbell_2006_coeff.txt file Not Found");
            e.printStackTrace();
        }
    }

    private int loadCoeffInArray(StringTokenizer st, ArrayList<Double> coeff) {
        st.nextToken();
        while (st.hasMoreTokens()) {
            coeff.add(Double.parseDouble(st.nextToken().trim()));
        }
        return coeff.size();
    }

    private void createCoeffArray(ArrayList<Double> coeff, double[] c) {
        for (int i = 0; i < c.length; ++i) {
            c[i] = coeff.get(i);
        }
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        double rake = eqkRupture.getAveRake();
        if (rake > 30.0 && rake < 150.0) {
            this.fltTypeParam.setValue(FLT_TYPE_REVERSE);
        } else if (rake > -150.0 && rake < -30.0) {
            this.fltTypeParam.setValue(FLT_TYPE_NORMAL);
        } else {
            this.fltTypeParam.setValue(FLT_TYPE_STRIKE_SLIP);
        }
        RuptureSurface surface = eqkRupture.getRuptureSurface();
        this.rupTopDepthParam.setValueIgnoreWarning(surface.getAveRupTopDepth());
        this.dipParam.setValueIgnoreWarning(surface.getAveDip());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.vs30Param.setValue((Double)site.getParameter("Vs30").getValue());
        this.depthTo2pt5kmPerSecParam.setValueIgnoreWarning((Double)site.getParameter("Depth 2.5 km/sec").getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
            this.distRupMinusJB_OverRupParam.setValue(this.eqkRupture, this.site);
        }
    }

    protected void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("CB_2006_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        if (this.im.getName().equalsIgnoreCase("SA")) {
            this.iper = (Integer)this.indexFromPerHashMap.get(this.saPeriodParam.getValue());
        } else if (this.im.getName().equalsIgnoreCase("PGV")) {
            this.iper = 1;
        } else if (this.im.getName().equalsIgnoreCase("PGA")) {
            this.iper = 2;
        } else if (this.im.getName().equalsIgnoreCase("PGD")) {
            this.iper = 0;
        }
        this.parameterChange = true;
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        this.rJB = this.rRup - this.distRupMinusJB_OverRup * this.rRup;
        if (Double.isNaN(this.depthTo2pt5kmPerSec)) {
            this.depthTo2pt5kmPerSec = this.vs30 <= 2500.0 ? 2.0 : 0.0;
        }
        double pgar = Math.exp(this.getMean(2, 1100.0, this.rRup, this.rJB, this.f_rv, this.f_nm, this.mag, this.depthTop, this.depthTo2pt5kmPerSec, this.magSaturation, 0.0));
        double mean = this.getMean(this.iper, this.vs30, this.rRup, this.rJB, this.f_rv, this.f_nm, this.mag, this.depthTop, this.depthTo2pt5kmPerSec, this.magSaturation, pgar);
        if (this.iper < 4 || this.iper > 9) {
            return mean;
        }
        double pga_mean = this.getMean(2, this.vs30, this.rRup, this.rJB, this.f_rv, this.f_nm, this.mag, this.depthTop, this.depthTo2pt5kmPerSec, this.magSaturation, pgar);
        return Math.max(mean, pga_mean);
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        this.component = (Component)this.componentParam.getValue();
        return this.getStdDev(this.iper, this.stdDevType, this.component);
    }

    @Override
    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.fltTypeParam.setValueAsDefault();
        this.rupTopDepthParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.distRupMinusJB_OverRupParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.pgvParam.setValueAsDefault();
        this.pgdParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
        this.depthTo2pt5kmPerSecParam.setValueAsDefault();
        this.dipParam.setValueAsDefault();
        this.vs30 = (Double)this.vs30Param.getValue();
        this.mag = (Double)this.magParam.getValue();
        this.stdDevType = (String)this.stdDevTypeParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.distRupMinusJB_OverRupParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.depthTo2pt5kmPerSecParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.rupTopDepthParam);
        this.meanIndependentParams.addParameter(this.dipParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(VS30_WARN_MIN, (double)VS30_WARN_MAX);
        this.depthTo2pt5kmPerSecParam = new DepthTo2pt5kmPerSecParam(DEPTH_2pt5_WARN_MIN, (double)DEPTH_2pt5_WARN_MAX, true);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
        this.siteParams.addParameter(this.depthTo2pt5kmPerSecParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        this.dipParam = new DipParam(DIP_WARN_MIN, (double)DIP_WARN_MAX);
        this.rupTopDepthParam = new RupTopDepthParam(RUP_TOP_WARN_MIN, (double)RUP_TOP_WARN_MAX);
        StringConstraint constraint = new StringConstraint();
        constraint.addString(FLT_TYPE_STRIKE_SLIP);
        constraint.addString(FLT_TYPE_NORMAL);
        constraint.addString(FLT_TYPE_REVERSE);
        constraint.setNonEditable();
        this.fltTypeParam = new FaultTypeParam(constraint, FLT_TYPE_STRIKE_SLIP);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
        this.eqkRuptureParams.addParameter(this.dipParam);
        this.eqkRuptureParams.addParameter(this.rupTopDepthParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.addParameterChangeWarningListener(this.listener);
        this.distanceRupParam.setNonEditable();
        this.distRupMinusJB_OverRupParam = new DistRupMinusJB_OverRupParameter(0.0);
        DoubleConstraint warnJB = new DoubleConstraint(DISTANCE_MINUS_WARN_MIN, DISTANCE_MINUS_WARN_MAX);
        this.distRupMinusJB_OverRupParam.addParameterChangeWarningListener(this.listener);
        warn.setNonEditable();
        this.distRupMinusJB_OverRupParam.setWarningConstraint(warnJB);
        this.distRupMinusJB_OverRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
        this.propagationEffectParams.addParameter(this.distRupMinusJB_OverRupParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        for (int i = 3; i < this.per.length; ++i) {
            periodConstraint.addDouble((Double)this.per[i]);
        }
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.pgvParam = new PGV_Param();
        this.pgvParam.setNonEditable();
        this.pgdParam = new PGD_Param();
        this.pgdParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.listener);
        this.pgaParam.addParameterChangeWarningListener(this.listener);
        this.pgvParam.addParameterChangeWarningListener(this.listener);
        this.pgdParam.addParameterChangeWarningListener(this.listener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
        this.supportedIMParams.addParameter(this.pgvParam);
        this.supportedIMParams.addParameter(this.pgdParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.GMRotI50, Component.GMRotI50, Component.RANDOM_HORZ);
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    public double getMean(int iper, double vs30, double rRup, double distJB, double f_rv, double f_nm, double mag, double depthTop, double depthTo2pt5kmPerSec, boolean magSaturation, double pgar) {
        double n = 1.18;
        double c = 1.88;
        double fmag = mag <= 5.5 ? this.c0[iper] + this.c1[iper] * mag : (mag > 5.5 && mag <= 6.5 ? this.c0[iper] + this.c1[iper] * mag + this.c2[iper] * (mag - 5.5) : this.c0[iper] + this.c1[iper] * mag + this.c2[iper] * (mag - 5.5) + this.c3[iper] * (mag - 6.5));
        double fdis = (this.c4[iper] + this.c5[iper] * mag) * Math.log(Math.sqrt(Math.pow(rRup, 2.0) + Math.pow(this.c6[iper], 2.0)));
        double ffltz = depthTop < 1.0 ? depthTop : 1.0;
        double fflt = this.c7[iper] * f_rv * ffltz + this.c8[iper] * f_nm;
        double fhngr = distJB == 0.0 ? 1.0 : (depthTop < 1.0 && distJB > 0.0 ? (Math.max(rRup, Math.sqrt(Math.pow(distJB, 2.0) + 1.0)) - distJB) / Math.max(rRup, Math.sqrt(Math.pow(distJB, 2.0) + 1.0)) : (rRup - distJB) / rRup);
        double fhngm = mag <= 6.0 ? 0.0 : (mag > 6.0 && mag < 6.5 ? 2.0 * (mag - 6.0) : 1.0);
        double fhngz = depthTop >= 20.0 ? 0.0 : (20.0 - depthTop) / 20.0;
        double fhngd = this.dip <= 70.0 ? 1.0 : (90.0 - this.dip) / 20.0;
        double fhng = this.c9[iper] * fhngr * fhngm * fhngz * fhngd;
        double fsite = vs30 < this.k1[iper] ? this.c10[iper] * Math.log(vs30 / this.k1[iper]) + this.k2[iper] * (Math.log(pgar + c * Math.pow(vs30 / this.k1[iper], n)) - Math.log(pgar + c)) : (this.c10[iper] + this.k2[iper] * n) * Math.log(vs30 / this.k1[iper]);
        double fsed = depthTo2pt5kmPerSec < 1.0 ? this.c11[iper] * (depthTo2pt5kmPerSec - 1.0) : (depthTo2pt5kmPerSec <= 3.0 ? 0.0 : this.c12[iper] * this.k3[iper] * Math.exp(-0.75) * (1.0 - Math.exp(-0.25 * (depthTo2pt5kmPerSec - 3.0))));
        return fmag + fdis + fflt + fhng + fsite + fsed;
    }

    public double getStdDev(int iper, String stdDevType, Component component) {
        double s = this.s_lny[iper];
        double t = this.t_lny[iper];
        double c = this.c_lny[iper];
        double k = component == Component.GMRotI50 ? 0.0 : (component == Component.RANDOM_HORZ ? 1.0 : Double.NaN);
        if (stdDevType.equals("Total")) {
            return Math.sqrt(t * t + s * s + k * c * c);
        }
        if (stdDevType.equals("Intra-Event")) {
            return Math.sqrt(s * s + k * c * c);
        }
        if (stdDevType.equals("Inter-Event")) {
            return Math.sqrt(t * t + k * c * c);
        }
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        return Double.NaN;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        this.parameterChange = true;
        if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals("(distRup-distJB)/distRup")) {
            this.distRupMinusJB_OverRup = (Double)val;
        } else if (pName.equals("Vs30")) {
            this.vs30 = (Double)val;
        } else if (pName.equals("Depth 2.5 km/sec")) {
            this.depthTo2pt5kmPerSec = val == null ? Double.NaN : (Double)val;
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("Fault Type")) {
            String fltType = (String)this.fltTypeParam.getValue();
            if (fltType.equals(FLT_TYPE_NORMAL)) {
                this.f_rv = 0.0;
                this.f_nm = 1.0;
            } else if (fltType.equals(FLT_TYPE_REVERSE)) {
                this.f_rv = 1.0;
                this.f_nm = 0.0;
            } else {
                this.f_rv = 0.0;
                this.f_nm = 0.0;
            }
        } else if (pName.equals("Rupture Top Depth")) {
            this.depthTop = (Double)val;
        } else if (pName.equals("Std Dev Type")) {
            this.stdDevType = (String)val;
        } else if (pName.equals("Dip")) {
            this.dip = (Double)val;
        } else if (pName.equals("Component")) {
            this.component = (Component)this.componentParam.getValue();
        } else if (pName.equals("SA Period")) {
            this.intensityMeasureChanged = true;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.distanceRupParam.removeParameterChangeListener(this);
        this.distRupMinusJB_OverRupParam.removeParameterChangeListener(this);
        this.vs30Param.removeParameterChangeListener(this);
        this.depthTo2pt5kmPerSecParam.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.fltTypeParam.removeParameterChangeListener(this);
        this.rupTopDepthParam.removeParameterChangeListener(this);
        this.dipParam.removeParameterChangeListener(this);
        this.stdDevTypeParam.removeParameterChangeListener(this);
        this.saPeriodParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceRupParam.addParameterChangeListener(this);
        this.distRupMinusJB_OverRupParam.addParameterChangeListener(this);
        this.vs30Param.addParameterChangeListener(this);
        this.depthTo2pt5kmPerSecParam.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.fltTypeParam.addParameterChangeListener(this);
        this.rupTopDepthParam.addParameterChangeListener(this);
        this.stdDevTypeParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
        this.dipParam.addParameterChangeListener(this);
    }

    @Override
    public URL getInfoURL() throws MalformedURLException {
        return new URL("http://www.opensha.org/documentation/modelsImplemented/attenRel/CB_2006.html");
    }
}

