/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.util.Hashtable;
import java.util.ListIterator;
import org.opensha.commons.data.Named;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.attenRelImpl.AS_1997_AttenRel;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncLevelParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncTypeParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;

public class CS_2005_AttenRel
extends AttenuationRelationship {
    private static final String C = "CS_2005_AttenRel";
    private static final boolean D = false;
    public static final String NAME = "Choi & Stewart (2005)";
    public static final String SHORT_NAME = "CS2005";
    private static final long serialVersionUID = 1234567890987654359L;
    protected static final Double VS30_WARN_MIN = 50.0;
    protected static final Double VS30_WARN_MAX = 3500.0;
    private BooleanParameter softSoilParam = null;
    public static final String SOFT_SOIL_NAME = "Soft Soil Case";
    public static final String SOFT_SOIL_INFO = "Indicates that site is considered NEHRP E regardless of Vs30.\n\nConditions required are undrained shear strength < 24 kPa, PI > 20, water content > 40%, and thickness of clay exceeds 3 m.";
    public static final Boolean SOFT_SOIL_DEFAULT = false;
    private AS_1997_AttenRel as_1997_attenRel;
    private CS_2005_AttenRelCoefficients coeffs = null;
    protected Hashtable horzCoeffs = new Hashtable();

    public CS_2005_AttenRel(ParameterChangeWarningListener listener) {
        this.listener = listener;
        this.as_1997_attenRel = new AS_1997_AttenRel(listener);
        this.as_1997_attenRel.getParameter("AS Site Type").setValue("Rock/Shallow-Soil");
        this.as_1997_attenRel.getParameter("Component").setValue(Component.AVE_HORZ);
        this.sigmaTruncTypeParam = (SigmaTruncTypeParam)this.as_1997_attenRel.getParameter("Gaussian Truncation");
        this.sigmaTruncLevelParam = (SigmaTruncLevelParam)this.as_1997_attenRel.getParameter("Truncation Level");
        this.exceedProbParam = (DoubleParameter)this.as_1997_attenRel.getParameter("Exceed. Prob.");
        this.stdDevTypeParam = (StdDevTypeParam)this.as_1997_attenRel.getParameter("Std Dev Type");
        this.saPeriodParam = (PeriodParam)this.as_1997_attenRel.getParameter("SA Period");
        this.initCoefficients();
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
    }

    @Override
    protected void setPropagationEffectParams() {
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.as_1997_attenRel.setEqkRupture(eqkRupture);
        this.eqkRupture = eqkRupture;
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.vs30Param.setValueIgnoreWarning((Double)site.getParameter("Vs30").getValue());
        this.softSoilParam.setValue((Boolean)site.getParameter(SOFT_SOIL_NAME).getValue());
        this.site = site;
        this.as_1997_attenRel.setSiteLocation(site.getLocation());
    }

    protected void updateCoefficients() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("CS_2005_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        StringBuffer key = new StringBuffer(this.im.getName());
        if (this.im.getName().equalsIgnoreCase("SA")) {
            key.append("/" + String.valueOf(this.saPeriodParam.getValue()));
        }
        if (!this.horzCoeffs.containsKey(key.toString())) {
            throw new ParameterException("CS_2005_AttenRel: setIntensityMeasureType(): Unable to locate coefficients with key = " + String.valueOf(key));
        }
        this.coeffs = (CS_2005_AttenRelCoefficients)this.horzCoeffs.get(key.toString());
    }

    @Override
    public double getMean() throws IMRException {
        double vs30;
        if (((Boolean)this.softSoilParam.getValue()).booleanValue()) {
            vs30 = 174.0;
        } else {
            try {
                vs30 = (Double)this.vs30Param.getValue();
            }
            catch (NullPointerException e) {
                throw new IMRException("CS_2005_AttenRel: getMean(): Not all parameters have been set");
            }
        }
        this.as_1997_attenRel.setIntensityMeasure("PGA");
        double asRockPGA = this.as_1997_attenRel.getMean();
        double lnAF = this.getLnAmpFactor(vs30, asRockPGA);
        this.as_1997_attenRel.setIntensityMeasure(this.im);
        return lnAF + this.as_1997_attenRel.getMean();
    }

    private double getLnAmpFactor(double vs30, double lnRockPGA) {
        double bv = 300.0;
        this.updateCoefficients();
        double b = vs30 < 180.0 ? this.coeffs.b1 : (vs30 < bv ? this.coeffs.b2 + (vs30 - bv) * (vs30 - bv) * (this.coeffs.b1 - this.coeffs.b2) / ((180.0 - bv) * (180.0 - bv)) : (vs30 < 520.0 ? this.coeffs.b2 : (vs30 < 760.0 ? this.coeffs.b2 - (vs30 - 520.0) * this.coeffs.b2 / 240.0 : 0.0)));
        return this.coeffs.c * Math.log(vs30 / this.coeffs.vRef) + b * (lnRockPGA - Math.log(0.1));
    }

    @Override
    public double getStdDev() throws IMRException {
        double vs30;
        String stdDevType = ((String)this.stdDevTypeParam.getValue()).toString();
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        if (((Boolean)this.softSoilParam.getValue()).booleanValue()) {
            vs30 = 174.0;
        } else {
            try {
                vs30 = (Double)this.vs30Param.getValue();
            }
            catch (NullPointerException e) {
                throw new IMRException("CS_2005_AttenRel: getMean(): Not all parameters have been set");
            }
        }
        this.updateCoefficients();
        double sigmaV = vs30 < 260.0 ? this.coeffs.e1 : (vs30 < 360.0 ? this.coeffs.e1 + (this.coeffs.e3 - this.coeffs.e1) / Math.log(1.3846153846153846) * Math.log(vs30 / 260.0) : this.coeffs.e3);
        return Math.sqrt(sigmaV * sigmaV + this.coeffs.tau * this.coeffs.tau);
    }

    @Override
    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.softSoilParam.setValue(false);
        this.as_1997_attenRel.setParamDefaults();
        this.as_1997_attenRel.getParameter("AS Site Type").setValue("Rock/Shallow-Soil");
        this.as_1997_attenRel.getParameter("Component").setValue(Component.AVE_HORZ);
        this.componentParam.setValueAsDefault();
    }

    protected void initIndependentParamLists() {
        AbstractParameter param;
        this.meanIndependentParams.clear();
        ListIterator<Parameter<?>> it = this.as_1997_attenRel.getMeanIndependentParamsIterator();
        String ignoreStr1 = "AS Site Type";
        String ignoreStr2 = "Component";
        while (it.hasNext()) {
            param = (AbstractParameter)it.next();
            if (ignoreStr1.equals(param.getName()) || ignoreStr2.equals(param.getName())) continue;
            this.meanIndependentParams.addParameter(param);
        }
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.softSoilParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.vs30Param);
        this.stdDevIndependentParams.addParameter(this.softSoilParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        it = this.as_1997_attenRel.getStdDevIndependentParamsIterator();
        while (it.hasNext()) {
            param = (AbstractParameter)it.next();
            if (ignoreStr1.equals(param.getName()) || ignoreStr2.equals(param.getName())) continue;
            this.stdDevIndependentParams.addParameter(param);
        }
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameter(this.vs30Param);
        this.exceedProbIndependentParams.addParameter(this.softSoilParam);
        this.exceedProbIndependentParams.addParameter(this.componentParam);
        it = this.as_1997_attenRel.getExceedProbIndependentParamsIterator();
        while (it.hasNext()) {
            param = (AbstractParameter)it.next();
            if (ignoreStr1.equals(param.getName()) || ignoreStr2.equals(param.getName())) continue;
            this.exceedProbIndependentParams.addParameter(param);
        }
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(VS30_WARN_MIN, (double)VS30_WARN_MAX);
        this.softSoilParam = new BooleanParameter(SOFT_SOIL_NAME, SOFT_SOIL_DEFAULT);
        this.softSoilParam.setInfo(SOFT_SOIL_INFO);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
        this.siteParams.addParameter(this.softSoilParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.eqkRuptureParams.clear();
        ListIterator<Parameter<?>> it = this.as_1997_attenRel.getEqkRuptureParamsIterator();
        while (it.hasNext()) {
            this.eqkRuptureParams.addParameter((AbstractParameter)it.next());
        }
    }

    @Override
    protected void initPropagationEffectParams() {
        this.propagationEffectParams.clear();
        ListIterator<Parameter<?>> it = this.as_1997_attenRel.getPropagationEffectParamsIterator();
        while (it.hasNext()) {
            this.propagationEffectParams.addParameter((AbstractParameter)it.next());
        }
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        this.supportedIMParams.clear();
        ListIterator<Parameter<?>> it = this.as_1997_attenRel.getSupportedIntensityMeasuresIterator();
        while (it.hasNext()) {
            this.supportedIMParams.addParameter((AbstractParameter)it.next());
        }
    }

    @Override
    protected void initOtherParams() {
        this.componentParam = new ComponentParam(Component.AVE_HORZ, Component.AVE_HORZ);
        this.otherParams.clear();
        this.otherParams.addParameter(this.componentParam);
        ListIterator<Parameter<?>> it = this.as_1997_attenRel.getOtherParamsIterator();
        while (it.hasNext()) {
            AbstractParameter param = (AbstractParameter)it.next();
            if ("Component".equals(param.getName())) continue;
            this.otherParams.addParameter(param);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    protected void initCoefficients() {
        String S = "CS_2005_AttenRel: initCoefficients():";
        this.horzCoeffs.clear();
        CS_2005_AttenRelCoefficients coeff = new CS_2005_AttenRelCoefficients("PGA", 0.0, -0.64, 418.0, -0.36, -0.14, 0.27, 0.44, 0.5);
        CS_2005_AttenRelCoefficients coeff0 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.01"), 0.01, -0.64, 418.0, -0.36, -0.14, 0.27, 0.44, 0.5);
        CS_2005_AttenRelCoefficients coeff1 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.02"), 0.02, -0.63, 490.0, -0.34, -0.12, 0.26, 0.45, 0.51);
        CS_2005_AttenRelCoefficients coeff2 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.03"), 0.03, -0.62, 324.0, -0.33, -0.11, 0.26, 0.46, 0.51);
        CS_2005_AttenRelCoefficients coeff3 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.04"), 0.04, -0.61, 233.0, -0.31, -0.11, 0.26, 0.47, 0.51);
        CS_2005_AttenRelCoefficients coeff4 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.05"), 0.05, -0.64, 192.0, -0.29, -0.11, 0.25, 0.47, 0.52);
        CS_2005_AttenRelCoefficients coeff5 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.06"), 0.06, -0.64, 181.0, -0.25, -0.11, 0.25, 0.48, 0.52);
        CS_2005_AttenRelCoefficients coeff6 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.075"), 0.075, -0.64, 196.0, -0.23, -0.11, 0.24, 0.48, 0.52);
        CS_2005_AttenRelCoefficients coeff7 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.09"), 0.09, -0.64, 239.0, -0.23, -0.12, 0.23, 0.49, 0.52);
        CS_2005_AttenRelCoefficients coeff8 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.10"), 0.1, -0.6, 257.0, -0.25, -0.13, 0.23, 0.49, 0.53);
        CS_2005_AttenRelCoefficients coeff9 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.12"), 0.12, -0.56, 299.0, -0.26, -0.14, 0.24, 0.49, 0.53);
        CS_2005_AttenRelCoefficients coeff10 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.15"), 0.15, -0.53, 357.0, -0.28, -0.18, 0.25, 0.49, 0.54);
        CS_2005_AttenRelCoefficients coeff11 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.17"), 0.17, -0.53, 406.0, -0.29, -0.19, 0.26, 0.48, 0.55);
        CS_2005_AttenRelCoefficients coeff12 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.20"), 0.2, -0.52, 453.0, -0.31, -0.19, 0.27, 0.47, 0.56);
        CS_2005_AttenRelCoefficients coeff13 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.24"), 0.24, -0.52, 493.0, -0.38, -0.16, 0.29, 0.47, 0.56);
        CS_2005_AttenRelCoefficients coeff14 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.30"), 0.3, -0.52, 532.0, -0.44, -0.14, 0.35, 0.46, 0.57);
        CS_2005_AttenRelCoefficients coeff15 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.36"), 0.36, -0.51, 535.0, -0.48, -0.11, 0.38, 0.46, 0.57);
        CS_2005_AttenRelCoefficients coeff16 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.40"), 0.4, -0.51, 535.0, -0.5, -0.1, 0.4, 0.46, 0.57);
        CS_2005_AttenRelCoefficients coeff17 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.46"), 0.46, -0.5, 535.0, -0.55, -0.08, 0.42, 0.45, 0.58);
        CS_2005_AttenRelCoefficients coeff18 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.50"), 0.5, -0.5, 535.0, -0.6, -0.06, 0.42, 0.45, 0.59);
        CS_2005_AttenRelCoefficients coeff19 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.60"), 0.6, -0.49, 535.0, -0.66, -0.03, 0.42, 0.44, 0.6);
        CS_2005_AttenRelCoefficients coeff20 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.75"), 0.75, -0.47, 535.0, -0.69, 0.0, 0.42, 0.44, 0.63);
        CS_2005_AttenRelCoefficients coeff21 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.85"), 0.85, -0.46, 535.0, -0.69, 0.0, 0.42, 0.44, 0.63);
        CS_2005_AttenRelCoefficients coeff22 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("1.00"), 1.0, -0.44, 535.0, -0.7, 0.0, 0.42, 0.44, 0.64);
        CS_2005_AttenRelCoefficients coeff23 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("1.50"), 1.5, -0.4, 535.0, -0.72, 0.0, 0.42, 0.44, 0.67);
        CS_2005_AttenRelCoefficients coeff24 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("2.00"), 2.0, -0.38, 535.0, -0.73, 0.0, 0.43, 0.44, 0.69);
        CS_2005_AttenRelCoefficients coeff25 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("3.00"), 3.0, -0.34, 535.0, -0.74, 0.0, 0.45, 0.44, 0.71);
        CS_2005_AttenRelCoefficients coeff26 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("4.00"), 4.0, -0.31, 535.0, -0.75, 0.0, 0.47, 0.44, 0.73);
        CS_2005_AttenRelCoefficients coeff27 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("5.00"), 5.0, -0.3, 535.0, -0.75, 0.0, 0.49, 0.44, 0.75);
        CS_2005_AttenRelCoefficients coeff28 = new CS_2005_AttenRelCoefficients("SA/" + Double.valueOf("0.0"), 0.0, -0.64, 418.0, -0.36, -0.14, 0.27, 0.44, 0.5);
        this.horzCoeffs.put(coeff.getName(), coeff);
        this.horzCoeffs.put(coeff0.getName(), coeff0);
        this.horzCoeffs.put(coeff1.getName(), coeff1);
        this.horzCoeffs.put(coeff2.getName(), coeff2);
        this.horzCoeffs.put(coeff3.getName(), coeff3);
        this.horzCoeffs.put(coeff4.getName(), coeff4);
        this.horzCoeffs.put(coeff5.getName(), coeff5);
        this.horzCoeffs.put(coeff6.getName(), coeff6);
        this.horzCoeffs.put(coeff7.getName(), coeff7);
        this.horzCoeffs.put(coeff8.getName(), coeff8);
        this.horzCoeffs.put(coeff9.getName(), coeff9);
        this.horzCoeffs.put(coeff10.getName(), coeff10);
        this.horzCoeffs.put(coeff11.getName(), coeff11);
        this.horzCoeffs.put(coeff12.getName(), coeff12);
        this.horzCoeffs.put(coeff13.getName(), coeff13);
        this.horzCoeffs.put(coeff14.getName(), coeff14);
        this.horzCoeffs.put(coeff15.getName(), coeff15);
        this.horzCoeffs.put(coeff16.getName(), coeff16);
        this.horzCoeffs.put(coeff17.getName(), coeff17);
        this.horzCoeffs.put(coeff18.getName(), coeff18);
        this.horzCoeffs.put(coeff19.getName(), coeff19);
        this.horzCoeffs.put(coeff20.getName(), coeff20);
        this.horzCoeffs.put(coeff21.getName(), coeff21);
        this.horzCoeffs.put(coeff22.getName(), coeff22);
        this.horzCoeffs.put(coeff23.getName(), coeff23);
        this.horzCoeffs.put(coeff24.getName(), coeff24);
        this.horzCoeffs.put(coeff25.getName(), coeff25);
        this.horzCoeffs.put(coeff26.getName(), coeff26);
        this.horzCoeffs.put(coeff27.getName(), coeff27);
        this.horzCoeffs.put(coeff28.getName(), coeff28);
    }

    public static void main(String[] args) {
    }

    class CS_2005_AttenRelCoefficients
    implements Named {
        protected static final String C = "CS_2005_AttenRelCoefficients";
        protected static final boolean D = false;
        private static final long serialVersionUID = 1234567890987654399L;
        protected String name;
        protected double period = -1.0;
        protected double b1;
        protected double vRef;
        protected double c;
        protected double b2;
        protected double tau;
        protected double e1;
        protected double e3;

        public CS_2005_AttenRelCoefficients(String name, double period, double b1, double vRef, double c, double b2, double tau, double e1, double e3) {
            this.name = name;
            this.period = period;
            this.b1 = b1;
            this.vRef = vRef;
            this.c = c;
            this.b2 = b2;
            this.tau = tau;
            this.e1 = e1;
            this.e3 = e3;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(C);
            b.append("\n  Period = " + this.period);
            b.append("\n  b1 = " + this.b1);
            b.append("\n  vRef = " + this.vRef);
            b.append("\n  c = " + this.c);
            b.append("\n  b2 = " + this.b2);
            b.append("\n  tau = " + this.tau);
            b.append("\n  e1 = " + this.e1);
            b.append("\n e3 = " + this.e3);
            return b.toString();
        }
    }
}

