/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.WarningDoubleParameter;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;

public class WC94_DisplMagRel
extends AttenuationRelationship {
    private static final String C = "WC94_DisplMagRel";
    private static final boolean D = false;
    public static final String NAME = "Wells & Coppersmith (1994)";
    public static final String SHORT_NAME = "WC_1994";
    private static final long serialVersionUID = 1234567890987654371L;
    private static final double MAX_DIST = 1.0;
    protected WarningDoubleParameter faultDisplParam = null;
    public static final String FAULT_DISPL_NAME = "Fault Displacement";
    public static final String FAULT_DISPL_UNITS = "m";
    protected static final Double FAULT_DISPL_DEFAULT = Math.log(1.0);
    public static final String FAULT_DISPL_INFO = "Average Fault Displacement";
    protected static final Double FAULT_DISPL_MIN = Math.log(Double.MIN_VALUE);
    protected static final Double FAULT_DISPL_MAX = Double.MAX_VALUE;
    protected static final Double FAULT_DISPL_WARN_MIN = Math.log(Double.MIN_VALUE);
    protected static final Double FAULT_DISPL_WARN_MAX = Math.log(50.0);
    public static final String FLT_TYPE_SS = "Strike Slip";
    public static final String FLT_TYPE_ALL = "Any Type";
    protected static final Double MAG_WARN_MIN = 5.0;
    protected static final Double MAG_WARN_MAX = 9.0;
    protected static final Double DISTANCE_RUP_WARN_MIN = 0.0;
    protected static final Double DISTANCE_RUP_WARN_MAX = 200.0;

    protected void setFaultTypeFromRake(double rake) throws InvalidRangeException {
        FaultUtils.assertValidRake(rake);
        if (rake >= 45.0 && rake <= 135.0) {
            this.fltTypeParam.setValue(FLT_TYPE_ALL);
        } else if (rake <= -45.0 && rake >= -135.0) {
            this.fltTypeParam.setValue(FLT_TYPE_ALL);
        } else {
            this.fltTypeParam.setValue(FLT_TYPE_SS);
        }
    }

    protected void initCoefficients() {
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.setFaultTypeFromRake(eqkRupture.getAveRake());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) {
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
        }
    }

    protected void updateCoefficients() throws ParameterException {
    }

    public WC94_DisplMagRel(ParameterChangeWarningListener listener) {
        this.listener = listener;
        this.initCoefficients();
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
    }

    public WC94_DisplMagRel() {
        this.initCoefficients();
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public double getMean() throws IMRException {
        String fltTypeValue;
        double dist;
        double mag;
        try {
            mag = (Double)this.magParam.getValue();
            dist = (Double)this.distanceRupParam.getValue();
            fltTypeValue = ((String)this.fltTypeParam.getValue()).toString();
        }
        catch (NullPointerException e) {
            throw new IMRException("WC94_DisplMagRel: getMean(): Not all parameters have been set");
        }
        if (dist > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (dist < 1.0) {
            double mean = fltTypeValue.equals(FLT_TYPE_SS) ? 0.9 * mag - 6.32 : 0.69 * mag - 4.8;
        } else {
            return FAULT_DISPL_MIN;
        }
        return mean *= 2.3026;
    }

    @Override
    public double getStdDev() throws IMRException {
        String fltTypeValue;
        String stdDevType = ((String)this.stdDevTypeParam.getValue()).toString();
        try {
            fltTypeValue = ((String)this.fltTypeParam.getValue()).toString();
        }
        catch (NullPointerException e) {
            throw new IMRException("WC94_DisplMagRel: getStdDev(): Not all parameters have been set");
        }
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        if (fltTypeValue.equals(FLT_TYPE_SS)) {
            return 1.2894560000000002;
        }
        return 1.657872;
    }

    @Override
    public void setParamDefaults() {
        this.magParam.setValueAsDefault();
        this.fltTypeParam.setValue(FLT_TYPE_SS);
        this.distanceRupParam.setValueAsDefault();
        this.faultDisplParam.setValue(FAULT_DISPL_DEFAULT);
        this.stdDevTypeParam.setValue("Total");
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.fltTypeParam);
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameter(this.magParam);
        this.exceedProbIndependentParams.addParameter(this.fltTypeParam);
        this.exceedProbIndependentParams.addParameter(this.distanceRupParam);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        StringConstraint constraint = new StringConstraint();
        constraint.addString(FLT_TYPE_SS);
        constraint.addString(FLT_TYPE_ALL);
        constraint.setNonEditable();
        this.fltTypeParam = new FaultTypeParam(constraint, FLT_TYPE_SS);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        this.distanceRupParam.addParameterChangeWarningListener(this.listener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleConstraint fDisplConstraint = new DoubleConstraint(FAULT_DISPL_MIN, FAULT_DISPL_MAX);
        fDisplConstraint.setNonEditable();
        this.faultDisplParam = new WarningDoubleParameter(FAULT_DISPL_NAME, fDisplConstraint, FAULT_DISPL_UNITS);
        this.faultDisplParam.setInfo(FAULT_DISPL_INFO);
        DoubleConstraint warn2 = new DoubleConstraint(FAULT_DISPL_WARN_MIN, FAULT_DISPL_WARN_MAX);
        warn2.setNonEditable();
        this.faultDisplParam.setWarningConstraint(warn2);
        this.faultDisplParam.setNonEditable();
        this.faultDisplParam.addParameterChangeWarningListener(this.listener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.faultDisplParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    public static void main(String[] args) {
        WC94_DisplMagRel testRel = new WC94_DisplMagRel();
        testRel.setIntensityMeasure(FAULT_DISPL_NAME);
        Site site = new Site(new Location(30.01, 30.0), "test");
        testRel.setSite(site);
        EqkRupture rup = new EqkRupture();
        rup.setPointSurface(new Location(30.0, 30.0), 90.0);
        rup.setAveRake(0.0);
        rup.setMag(5.0);
        testRel.setEqkRupture(rup);
        System.out.println("Mag 5: " + testRel.getMean() + "; " + testRel.getStdDev());
        rup.setMag(6.0);
        testRel.setEqkRupture(rup);
        System.out.println("Mag 6: " + testRel.getMean() + "; " + testRel.getStdDev());
        rup.setMag(7.0);
        testRel.setEqkRupture(rup);
        System.out.println("Mag 7: " + testRel.getMean() + "; " + testRel.getStdDev());
        rup.setMag(8.0);
        testRel.setEqkRupture(rup);
        System.out.println("Mag 8: " + testRel.getMean() + "; " + testRel.getStdDev());
        rup.setMag(9.0);
        testRel.setEqkRupture(rup);
        System.out.println("Mag 9: " + testRel.getMean() + "; " + testRel.getStdDev());
        rup.setAveRake(90.0);
        rup.setMag(5.0);
        testRel.setEqkRupture(rup);
        System.out.println("Mag 5: " + testRel.getMean() + "; " + testRel.getStdDev());
        rup.setMag(6.0);
        testRel.setEqkRupture(rup);
        System.out.println("Mag 6: " + testRel.getMean() + "; " + testRel.getStdDev());
        rup.setMag(7.0);
        testRel.setEqkRupture(rup);
        System.out.println("Mag 7: " + testRel.getMean() + "; " + testRel.getStdDev());
        rup.setMag(8.0);
        testRel.setEqkRupture(rup);
        System.out.println("Mag 8: " + testRel.getMean() + "; " + testRel.getStdDev());
        rup.setMag(9.0);
        testRel.setEqkRupture(rup);
        System.out.println("Mag 9: " + testRel.getMean() + "; " + testRel.getStdDev());
    }
}

