/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.calc;

import com.google.common.base.Preconditions;

public final class Wald_MMI_Calc {
    static double sma = 3.6598;
    static double ba = -1.6582;
    static double sma_low = 2.1987;
    static double ba_low = 1.0;
    static double smv = 3.4709;
    static double bv = 2.3478;
    static double smv_low = 2.0951;
    static double bv_low = 3.3991;

    public static double getMMI(double pga, double pgv) {
        String S = ".getMMI()";
        double ammi = Wald_MMI_Calc.getAMMI(pga);
        double vmmi = Wald_MMI_Calc.getVMMI(pgv);
        double scale = Wald_MMI_Calc.getWeightVMMI(ammi);
        double mmi = (1.0 - scale) * ammi + scale * vmmi;
        if (mmi < 1.0) {
            mmi = 1.0;
        }
        if (mmi > 10.0) {
            mmi = 10.0;
        }
        return mmi;
    }

    public static double getAMMI(double pga) {
        double ammi = 0.43429 * Math.log(pga *= 980.0) * sma + ba;
        if (ammi <= 5.0) {
            ammi = 0.43429 * Math.log(pga) * sma_low + ba_low;
        }
        if (ammi < 1.0) {
            ammi = 1.0;
        }
        return ammi;
    }

    public static double getPGA(double ammi) {
        Preconditions.checkState((ammi >= 1.0 ? 1 : 0) != 0, (Object)"Only valid for AMMI>=1");
        double pga = ammi <= 5.0 ? Math.exp((ammi - ba_low) / (0.43429 * sma_low)) : Math.exp((ammi - ba) / (0.43429 * sma));
        return pga / 980.0;
    }

    public static double getVMMI(double pgv) {
        double vmmi = 0.43429 * Math.log(pgv) * smv + bv;
        if (vmmi <= 5.0) {
            vmmi = 0.43429 * Math.log(pgv) * smv_low + bv_low;
        }
        if (vmmi < 1.0) {
            vmmi = 1.0;
        }
        return vmmi;
    }

    public static double getPGV(double vmmi) {
        Preconditions.checkState((vmmi >= 1.0 ? 1 : 0) != 0, (Object)"Only valid for VMMI>=1");
        if (vmmi < 1.0) {
            vmmi = 1.0;
        }
        if (vmmi <= 5.0) {
            return Math.exp((vmmi - bv_low) / (0.43429 * smv_low));
        }
        return Math.exp((vmmi - bv) / (0.43429 * smv));
    }

    public static double getWeightVMMI(double ammi) {
        double scale = (ammi - 5.0) / 2.0;
        if (scale > 1.0) {
            scale = 1.0;
        }
        if (scale < 0.0) {
            scale = 0.0;
        }
        return scale;
    }

    public static void main(String[] args) {
        double diff;
        for (double vmmi = 0.0; vmmi < 11.0; vmmi += 0.1) {
            double pgv = Wald_MMI_Calc.getPGV(vmmi);
            double calcVMMI = Wald_MMI_Calc.getVMMI(pgv);
            diff = calcVMMI - vmmi;
            System.out.println("VMMI: " + (float)vmmi + "\tPGV: " + (float)pgv + "\tCalc: " + (float)calcVMMI + "\tDiff: " + (float)diff);
        }
        for (double ammi = 0.0; ammi < 11.0; ammi += 0.1) {
            double pga = Wald_MMI_Calc.getPGA(ammi);
            double calcAMMI = Wald_MMI_Calc.getAMMI(pga);
            diff = calcAMMI - ammi;
            System.out.println("AMMI: " + (float)ammi + "\tPGA: " + (float)pga + "\tCalc: " + (float)calcAMMI + "\tDiff: " + (float)diff);
        }
        System.out.println(Wald_MMI_Calc.getMMI(0.1262741, 11.278339));
    }
}

