/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.gui;

import java.awt.geom.Point2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.opensha.commons.data.Named;
import org.opensha.commons.data.function.ArbDiscrFuncWithParams;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.WarningParameter;
import org.opensha.commons.param.constraint.DiscreteParameterConstraint;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleDiscreteParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.param.impl.TranslatedWarningDoubleParameter;
import org.opensha.commons.param.impl.WarningDoubleParameter;
import org.opensha.commons.util.ParamUtils;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.attenRelImpl.gui.AttenuationRelationshipApplet;

public class AttenuationRelationshipGuiBean
implements Named,
ParameterChangeListener,
ParameterChangeFailListener {
    protected static final String C = "AttenuationRelationshipGuiBean";
    protected static final boolean D = false;
    public static final String IM_NAME = "Intensity Measure Type";
    public static final String X_AXIS_NAME = "X-Axis";
    public static final String Y_AXIS_NAME = "Y-Axis";
    public static final String Y_AXIS_V1 = "Median";
    public static final String Y_AXIS_V2 = "Std. Dev.";
    public static final String Y_AXIS_V3 = "Exceed Prob.";
    public static final String Y_AXIS_V4 = "IML at Exceed Prob.";
    public static final String X_AXIS_SINGLE_VAL = "Individual Value";
    public static final int MEAN = 1;
    public static final int STD_DEV = 2;
    public static final int EXCEED_PROB = 3;
    public static final int IML_AT_EXCEED_PROB = 4;
    public static final int IM = 10;
    public static final int Y_AXIS = 11;
    public static final int X_AXIS = 12;
    protected static HashMap yAxisMap = new HashMap();
    static final String SPECIAL_EDITORS_PACKAGE = "org.opensha.sha.propagation";
    protected ScalarIMR attenRel = null;
    protected ParameterListEditor controlsEditor = null;
    protected ParameterListEditor independentsEditor = null;
    protected String name;
    protected ParameterList controlsParamList = null;
    protected Parameter selectedIM = null;
    protected ParameterList independentParams = new ParameterList();
    AttenuationRelationshipApplet applet = null;
    protected ArrayList translatedList = new ArrayList();
    private boolean translateAttenRel = true;
    private static final String LOG_X_SPACING_PARAM_NAME = "Log X Spacing";
    private static final Boolean LOG_X_SPACING_DEFAULT = false;
    private BooleanParameter logXSpacingParam = new BooleanParameter("Log X Spacing", LOG_X_SPACING_DEFAULT);
    private static final String NUM_X_POINTS_PARAM_NAME = "Num. X Values";
    private static final Integer NUM_X_POINTS_MIN = 2;
    private static final Integer NUM_X_POINTS_MAX = 1000;
    private static final Integer NUM_X_POINTS_DEFAULT = 401;
    private IntegerParameter numXPointsParam = new IntegerParameter("Num. X Values", NUM_X_POINTS_MIN, NUM_X_POINTS_MAX, NUM_X_POINTS_DEFAULT);

    public AttenuationRelationshipGuiBean(String className, String name, AttenuationRelationshipApplet applet) {
        String S = "AttenuationRelationshipGuiBean: Constructor(): ";
        this.name = name;
        this.applet = applet;
        if (className == null || className.equals("")) {
            throw new ParameterException(S + "AttenRel Class name cannot be empty or null");
        }
        this.attenRel = (ScalarIMR)AttenuationRelationshipGuiBean.createAttenRelClassInstance(className, applet);
        this.attenRel.setParamDefaults();
        this.initControlsParamListAndEditor(applet);
        this.initIndependentParamListAndEditor(applet);
        this.synchRequiredVisibleParameters();
    }

    public URL getInfoURL() throws MalformedURLException {
        return this.attenRel.getInfoURL();
    }

    public static Object createAttenRelClassInstance(String className, ParameterChangeWarningListener listener) {
        String S = "AttenuationRelationshipGuiBean: createAttenRelClassInstance(): ";
        try {
            Class<?> listenerClass = Class.forName("org.opensha.commons.param.event.ParameterChangeWarningListener");
            Object[] paramObjects = new Object[]{listener};
            Class[] params = new Class[]{listenerClass};
            Class<?> attenRelClass = Class.forName(className);
            Constructor<?> con = attenRelClass.getConstructor(params);
            Object obj = con.newInstance(paramObjects);
            return obj;
        }
        catch (ClassCastException e) {
            System.out.println(S + e.toString());
            throw new RuntimeException(S + e.toString());
        }
        catch (ClassNotFoundException e) {
            System.out.println(S + e.toString());
            throw new RuntimeException(S + e.toString());
        }
        catch (NoSuchMethodException e) {
            System.out.println(S + e.toString());
            throw new RuntimeException(S + e.toString());
        }
        catch (InvocationTargetException e) {
            System.out.println(S + e.toString());
            e.printStackTrace();
            throw new RuntimeException(S + e.toString());
        }
        catch (IllegalAccessException e) {
            System.out.println(S + e.toString());
            throw new RuntimeException(S + e.toString());
        }
        catch (InstantiationException e) {
            System.out.println(S + e.toString());
            throw new RuntimeException(S + e.toString());
        }
    }

    public void setName(String newName) {
        this.name = newName;
    }

    private void setParamsVisible(ParameterList params) {
        for (Parameter<?> param : params) {
            String name = param.getName();
            this.independentsEditor.setParameterVisible(name, true);
        }
    }

    public ListIterator getControlsIterator() {
        return this.controlsParamList.getParametersIterator();
    }

    public Parameter getSelectedIMParam() {
        this.selectedIM = this.controlsParamList.getParameter(IM_NAME);
        return this.selectedIM;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ScalarIMR getAttenRel() {
        return this.attenRel;
    }

    public ParameterListEditor getControlsEditor() {
        return this.controlsEditor;
    }

    public ParameterListEditor getIndependentsEditor() {
        return this.independentsEditor;
    }

    protected String getGraphControlsParamValue(int type) throws ParameterException {
        String paramName = null;
        switch (type) {
            case 10: {
                paramName = IM_NAME;
                break;
            }
            case 11: {
                paramName = Y_AXIS_NAME;
                break;
            }
            case 12: {
                paramName = X_AXIS_NAME;
                break;
            }
            default: {
                throw new ParameterException("AttenuationRelationshipGuiBean: getGraphControlsParamValue(): Unsupported graph control type.");
            }
        }
        return this.controlsParamList.getParameter(paramName).getValue().toString();
    }

    public String getGraphIMYAxisLabel() {
        String S = "AttenuationRelationshipGuiBean: getGraphIMYAxisLabel():";
        Object label = "";
        String yAxisName = this.getGraphControlsParamValue(11);
        String xAxisName = this.getGraphControlsParamValue(12);
        String imName = this.getGraphControlsParamValue(10);
        Parameter imParam = this.attenRel.getParameter(imName);
        String imUnits = imParam.getUnits();
        label = !yAxisName.equals(Y_AXIS_V4) ? yAxisName + " " + imName : imName;
        if ((yAxisName.equals(Y_AXIS_V1) || yAxisName.equals(Y_AXIS_V4)) && StringUtils.isNotEmpty((CharSequence)imUnits)) {
            label = (String)label + " (" + imUnits + ")";
        }
        return label;
    }

    public String getGraphXAxisLabel() {
        Object xAxisName = this.getGraphControlsParamValue(12);
        Parameter param = this.attenRel.getParameter((String)xAxisName);
        String units = param.getUnits();
        if (StringUtils.isNotEmpty((CharSequence)units)) {
            xAxisName = (String)xAxisName + " (" + units + ")";
        }
        return xAxisName;
    }

    public String getGraphXYAxisTitle() throws ConstraintException {
        return this.getGraphControlsParamValue(11) + " vs. " + this.getGraphControlsParamValue(12);
    }

    protected void setIgnoreWarnings(boolean ignoreWarning) {
        if (!this.translateAttenRel) {
            return;
        }
        ListIterator it = this.translatedList.listIterator();
        while (it.hasNext()) {
            ((TranslatedWarningDoubleParameter)it.next()).setIgnoreWarning(ignoreWarning);
        }
    }

    public DiscretizedFunc getChoosenFunction() throws ConstraintException {
        Parameter imParam;
        String S = "AttenuationRelationshipGuiBean: getChoosenFunction():";
        String yAxisName = this.getGraphControlsParamValue(11);
        String xAxisName = this.getGraphControlsParamValue(12);
        this.setIgnoreWarnings(true);
        this.attenRel.setIntensityMeasure(this.getGraphControlsParamValue(10));
        this.setIgnoreWarnings(false);
        if (!yAxisMap.containsKey(yAxisName)) {
            throw new ConstraintException(S + "Invalid choice choosen for y-axis.");
        }
        int type = (Integer)yAxisMap.get(yAxisName);
        Parameter xAxisParam = this.attenRel.getParameter(xAxisName);
        if (!ParamUtils.isDoubleOrDoubleDiscreteConstraint(xAxisParam)) {
            throw new ConstraintException(S + "X-Axis must contain double or double discrete constraint.");
        }
        DiscretizedFunc function = this.getFunctionForXAxis(xAxisParam, type);
        ParameterList clones = this.independentsEditor.getVisibleParametersCloned();
        if (this.translateAttenRel && (imParam = (Parameter)this.attenRel.getIntensityMeasure().clone()) instanceof WarningDoubleParameter) {
            WarningDoubleParameter warnParam = (WarningDoubleParameter)imParam;
            TranslatedWarningDoubleParameter transParam = new TranslatedWarningDoubleParameter(warnParam);
            transParam.setTranslate(true);
            if (clones.containsParameter(warnParam.getName())) {
                clones.removeParameter(warnParam.getName());
                clones.addParameter(transParam);
            }
        }
        if (function != null) {
            ((ArbDiscrFuncWithParams)function).setParameterList(clones);
            function.setName(this.attenRel.getName());
        }
        return function;
    }

    public double getChosenValue() {
        Parameter imParam;
        String S = "AttenuationRelationshipGuiBean: getChoosenFunction():";
        String yAxisName = this.getGraphControlsParamValue(11);
        String xAxisName = this.getGraphControlsParamValue(12);
        this.setIgnoreWarnings(true);
        this.attenRel.setIntensityMeasure(this.getGraphControlsParamValue(10));
        this.setIgnoreWarnings(false);
        if (!yAxisMap.containsKey(yAxisName)) {
            throw new ConstraintException(S + "Invalid choice choosen for y-axis.");
        }
        int type = (Integer)yAxisMap.get(yAxisName);
        ParameterList clones = this.independentsEditor.getVisibleParametersCloned();
        if (this.translateAttenRel && (imParam = (Parameter)this.attenRel.getIntensityMeasure().clone()) instanceof WarningDoubleParameter) {
            WarningDoubleParameter warnParam = (WarningDoubleParameter)imParam;
            TranslatedWarningDoubleParameter transParam = new TranslatedWarningDoubleParameter(warnParam);
            transParam.setTranslate(true);
            if (clones.containsParameter(warnParam.getName())) {
                clones.removeParameter(warnParam.getName());
                clones.addParameter(transParam);
            }
        }
        return this.getCalculation(type);
    }

    private DiscretizedFunc getFunctionForXAxis(Parameter xAxisParam, int type) throws ConstraintException {
        String S = "AttenuationRelationshipGuiBean: getFunctionForXAxis():";
        ArbDiscrFuncWithParams function = new ArbDiscrFuncWithParams();
        String s = "";
        if (ParamUtils.isDoubleDiscreteConstraint(xAxisParam)) {
            String paramName = xAxisParam.getName();
            DoubleDiscreteParameter ddParam = (DoubleDiscreteParameter)this.attenRel.getParameter(paramName);
            DoubleDiscreteConstraint constraint = (DoubleDiscreteConstraint)ddParam.getConstraint();
            Double oldVal = (Double)ddParam.getValue();
            ListIterator<Double> it = constraint.listIterator();
            while (it.hasNext()) {
                Double val = it.next();
                ddParam.setValue(val);
                this.attenRel.setIntensityMeasure(this.getGraphControlsParamValue(10));
                Point2D.Double point = new Point2D.Double(val, this.getCalculation(type));
                function.set(point);
            }
            ddParam.setValue(oldVal);
            this.attenRel.setIntensityMeasure(this.getGraphControlsParamValue(10));
        } else if (ParamUtils.isWarningParameterAPI(xAxisParam)) {
            if (this.translateAttenRel) {
                String imName;
                Parameter imParam = (Parameter)this.attenRel.getIntensityMeasure().clone();
                String xAxisName = xAxisParam.getName();
                if (xAxisName.equalsIgnoreCase(imName = imParam.getName()) && xAxisParam instanceof WarningDoubleParameter) {
                    WarningDoubleParameter warnParam = (WarningDoubleParameter)xAxisParam;
                    TranslatedWarningDoubleParameter transParam = new TranslatedWarningDoubleParameter(warnParam);
                    transParam.setTranslate(true);
                    MinMaxDelta minmaxdelta = new MinMaxDelta(transParam);
                    function = this.buildFunction(transParam, type, function, minmaxdelta);
                } else {
                    MinMaxDelta minmaxdelta = new MinMaxDelta((WarningParameter)xAxisParam);
                    function = this.buildFunction(xAxisParam, type, function, minmaxdelta);
                }
            } else {
                MinMaxDelta minmaxdelta = new MinMaxDelta((WarningParameter)xAxisParam);
                function = this.buildFunction(xAxisParam, type, function, minmaxdelta);
            }
        } else if (ParamUtils.isDoubleConstraint(xAxisParam)) {
            MinMaxDelta minmaxdelta = new MinMaxDelta(xAxisParam);
            function = this.buildFunction(xAxisParam, type, function, minmaxdelta);
        } else {
            throw new ConstraintException(S + "Not supported as an independent parameter: " + this.name);
        }
        return function;
    }

    private ArbDiscrFuncWithParams buildFunction(Parameter xAxisParam, int type, ArbDiscrFuncWithParams function, MinMaxDelta minmaxdelta) {
        Parameter independentParam = this.attenRel.getParameter(xAxisParam.getName());
        Object oldVal = independentParam.getValue();
        int index = 0;
        Parameter paramToSet = null;
        if (independentParam instanceof WarningDoubleParameter && xAxisParam instanceof TranslatedWarningDoubleParameter) {
            ((TranslatedWarningDoubleParameter)xAxisParam).setParameter((WarningDoubleParameter)independentParam);
            paramToSet = xAxisParam;
        } else {
            paramToSet = independentParam;
        }
        boolean log = (Boolean)this.logXSpacingParam.getValue();
        double min = minmaxdelta.min;
        double max = minmaxdelta.max;
        double delta = minmaxdelta.delta;
        double val = minmaxdelta.min;
        int num = (Integer)this.numXPointsParam.getValue();
        if (log) {
            if (min == 0.0) {
                val = min = 1.0E-40;
            } else if (min < 0.0) {
                throw new RuntimeException("Log spacing cannot be used with values < 0");
            }
            min = Math.log(min);
            max = Math.log(max);
            delta = (max - min) / (double)(num - 1);
        }
        while (index < num) {
            if (val > minmaxdelta.max) {
                val = minmaxdelta.max;
            }
            paramToSet.setValue(val);
            Point2D.Double point = new Point2D.Double(val, this.getCalculation(type));
            function.set(point);
            if (log) {
                val = Math.log(val);
                val += delta;
                val = Math.exp(val);
            } else {
                val += minmaxdelta.delta;
            }
            ++index;
        }
        if (ParamUtils.isWarningParameterAPI(independentParam)) {
            ((WarningParameter)independentParam).setValueIgnoreWarning(oldVal);
        } else {
            independentParam.setValue(oldVal);
        }
        return function;
    }

    private double getCalculation(int type) {
        double result = 0.0;
        switch (type) {
            case 1: {
                result = Math.exp(this.attenRel.getMean());
                break;
            }
            case 3: {
                result = this.attenRel.getExceedProbability();
                break;
            }
            case 2: {
                result = this.attenRel.getStdDev();
                break;
            }
            case 4: {
                result = Math.exp(this.attenRel.getIML_AtExceedProb());
            }
        }
        return result;
    }

    public void refreshParamEditor() {
        this.independentsEditor.refreshParamEditor();
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String S = "AttenuationRelationshipGuiBean: parameterChange(): ";
        String name1 = event.getParameterName();
        if (this.controlsParamList.containsParameter(name1)) {
            this.synchRequiredVisibleParameters();
        } else if (name1.equals("Gaussian Truncation")) {
            String value = event.getNewValue().toString();
            this.toggleSigmaLevelBasedOnTypeValue(value);
        }
    }

    protected void toggleSigmaLevelBasedOnTypeValue(String value) {
        if (value.equalsIgnoreCase("none")) {
            this.independentsEditor.setParameterVisible("Truncation Level", false);
        } else {
            this.independentsEditor.setParameterVisible("Truncation Level", true);
        }
    }

    protected void initControlsParamListAndEditor(AttenuationRelationshipApplet applet) {
        String S = "AttenuationRelationshipGuiBean: initControlsParamListAndEditor(): ";
        if (this.attenRel == null) {
            throw new ParameterException(S + "AttenRel is null, unable to continue.");
        }
        if (applet == null) {
            throw new ParameterException(S + "Applet is null, unable to continue.");
        }
        ListIterator<Parameter<?>> supportedIntensityMeasureIterator = this.attenRel.getSupportedIntensityMeasuresIterator();
        ListIterator meanIndependentParamsIterator = this.attenRel.getMeanIndependentParamsIterator();
        StringConstraint yaxisConstraint = new StringConstraint();
        yaxisConstraint.addString(Y_AXIS_V1);
        yaxisConstraint.addString(Y_AXIS_V2);
        yaxisConstraint.addString(Y_AXIS_V3);
        yaxisConstraint.addString(Y_AXIS_V4);
        StringParameter yaxis = new StringParameter(Y_AXIS_NAME, yaxisConstraint, Y_AXIS_V1);
        yaxis.addParameterChangeListener(this);
        boolean first = true;
        Parameter<?> imParam = null;
        String name = "";
        StringConstraint imConstraint = new StringConstraint();
        while (supportedIntensityMeasureIterator.hasNext()) {
            Parameter<?> param = supportedIntensityMeasureIterator.next();
            name = param.getName();
            if (first) {
                first = false;
                imParam = param;
            }
            imConstraint.addString(name);
        }
        StringParameter im = new StringParameter(IM_NAME, imConstraint, "", imParam.getName());
        im.addParameterChangeListener(this);
        StringConstraint xAxisConstraint = new StringConstraint();
        first = true;
        String val = null;
        name = null;
        while (meanIndependentParamsIterator.hasNext()) {
            Parameter param = (Parameter)meanIndependentParamsIterator.next();
            if (param instanceof StringParameter) continue;
            name = param.getName();
            if (first) {
                first = false;
                val = name;
            }
            if (xAxisConstraint.containsString(name)) continue;
            xAxisConstraint.addString(name);
        }
        for (Parameter param : imParam.getIndependentParameterList()) {
            if (param instanceof StringParameter || xAxisConstraint.containsString(name = param.getName())) continue;
            xAxisConstraint.addString(name);
        }
        if (!xAxisConstraint.containsString(X_AXIS_SINGLE_VAL)) {
            xAxisConstraint.addString(X_AXIS_SINGLE_VAL);
        }
        StringParameter xaxis = new StringParameter(X_AXIS_NAME, xAxisConstraint, val);
        this.controlsParamList = new ParameterList();
        this.controlsParamList.addParameter(im);
        this.controlsParamList.addParameter(yaxis);
        this.controlsParamList.addParameter(xaxis);
        this.controlsParamList.addParameter(this.numXPointsParam);
        this.controlsParamList.addParameter(this.logXSpacingParam);
        this.numXPointsParam.addParameterChangeFailListener(this);
        this.controlsEditor = new ParameterListEditor(this.controlsParamList);
        this.controlsEditor.setTitle("Plot Choices");
        this.attenRel.setIntensityMeasure(this.getGraphControlsParamValue(10));
    }

    private void initIndependentParamListAndEditor(AttenuationRelationshipApplet applet) throws ParameterException {
        String S = "AttenuationRelationshipGuiBean: initIndependentParamEditor(): ";
        if (this.attenRel == null) {
            throw new ParameterException(S + "AttenRel is null, unable to init independent parameters.");
        }
        this.independentParams = new ParameterList();
        for (Parameter<?> param : this.attenRel.getMeanIndependentParams()) {
            param.addParameterChangeListener(this);
            param.addParameterChangeFailListener(applet);
            if (this.independentParams.containsParameter(param.getName())) continue;
            this.independentParams.addParameter(param);
        }
        for (Parameter<?> param : this.attenRel.getStdDevIndependentParams()) {
            param.addParameterChangeListener(this);
            param.addParameterChangeFailListener(applet);
            if (this.independentParams.containsParameter(param.getName())) continue;
            this.independentParams.addParameter(param);
        }
        for (Parameter<?> param : this.attenRel.getExceedProbIndependentParams()) {
            param.addParameterChangeListener(this);
            param.addParameterChangeFailListener(applet);
            if (this.independentParams.containsParameter(param.getName())) continue;
            this.independentParams.addParameter(param);
        }
        for (Parameter<?> param : this.attenRel.getIML_AtExceedProbIndependentParams()) {
            param.addParameterChangeListener(this);
            param.addParameterChangeFailListener(applet);
            if (this.independentParams.containsParameter(param.getName())) continue;
            this.independentParams.addParameter(param);
        }
        for (Parameter<?> param : this.attenRel.getSupportedIntensityMeasures()) {
            param.addParameterChangeListener(this);
            param.addParameterChangeFailListener(applet);
            if (!this.independentParams.containsParameter(param.getName())) {
                if (this.translateAttenRel && param instanceof WarningDoubleParameter) {
                    TranslatedWarningDoubleParameter transParam = new TranslatedWarningDoubleParameter((WarningDoubleParameter)param);
                    this.independentParams.addParameter(transParam);
                    this.translatedList.add(transParam);
                } else {
                    this.independentParams.addParameter(param);
                }
            }
            for (Parameter<?> param2 : param.getIndependentParameterList()) {
                if (this.independentParams.containsParameter(param2.getName())) continue;
                this.independentParams.addParameter(param2);
            }
        }
        this.independentsEditor = new ParameterListEditor(this.independentParams);
        this.independentsEditor.setTitle("Adjustable Parameters");
    }

    protected void synchRequiredVisibleParameters() throws ParameterException {
        String value;
        ParameterEditor paramEditor;
        String S = "AttenuationRelationshipGuiBean: getGraphIMYAxisLabel():";
        String imName = this.getGraphControlsParamValue(10);
        String xAxisName = this.getGraphControlsParamValue(12);
        String yAxisName = this.getGraphControlsParamValue(11);
        if (this.attenRel == null) {
            throw new ParameterException(S + "AttenRel is null, unable to continue.");
        }
        ListIterator<Parameter<?>> it = this.independentParams.getParametersIterator();
        while (it.hasNext()) {
            this.independentsEditor.setParameterVisible(it.next().getName(), false);
        }
        Parameter imParam = null;
        imParam = this.attenRel.getParameter(imName);
        this.setParamsVisible(imParam.getIndependentParameterList());
        if (yAxisName.equals(Y_AXIS_V1)) {
            this.setParamsVisible(this.attenRel.getMeanIndependentParams());
        } else if (yAxisName.equals(Y_AXIS_V2)) {
            this.setParamsVisible(this.attenRel.getStdDevIndependentParams());
        } else if (yAxisName.equals(Y_AXIS_V3)) {
            this.setParamsVisible(this.attenRel.getExceedProbIndependentParams());
            paramEditor = this.independentsEditor.getParameterEditor("Gaussian Truncation");
            if (paramEditor != null) {
                value = paramEditor.getParameter().getValue().toString();
                this.toggleSigmaLevelBasedOnTypeValue(value);
            }
        } else if (yAxisName.equals(Y_AXIS_V4)) {
            this.setParamsVisible(this.attenRel.getIML_AtExceedProbIndependentParams());
            paramEditor = this.independentsEditor.getParameterEditor("Gaussian Truncation");
            if (paramEditor != null) {
                value = paramEditor.getParameter().getValue().toString();
                this.toggleSigmaLevelBasedOnTypeValue(value);
            }
        } else {
            throw new ParameterException(S + "Invalid Y Axis choice");
        }
        StringConstraint xAxisConstraint = new StringConstraint();
        xAxisConstraint = this.addToXAxisConstraint(this.attenRel.getMeanIndependentParams(), xAxisConstraint);
        xAxisConstraint = this.addToXAxisConstraint(this.attenRel.getStdDevIndependentParams(), xAxisConstraint);
        xAxisConstraint = this.addToXAxisConstraint(imParam.getIndependentParameterList(), xAxisConstraint);
        String val = xAxisConstraint.listIterator().next().toString();
        if (yAxisName.equals(Y_AXIS_V3)) {
            xAxisConstraint.addString(imParam.getName());
        }
        if (yAxisName.equals(Y_AXIS_V4)) {
            xAxisConstraint.addString("Exceed. Prob.");
        }
        if (!xAxisConstraint.containsString(X_AXIS_SINGLE_VAL)) {
            xAxisConstraint.addString(X_AXIS_SINGLE_VAL);
        }
        if (xAxisConstraint.isAllowed(xAxisName)) {
            val = xAxisName;
        }
        ConstrainedStringParameterEditor editor = (ConstrainedStringParameterEditor)this.controlsEditor.getParameterEditor(X_AXIS_NAME);
        StringParameter param = (StringParameter)editor.getParameter();
        StringParameter param2 = new StringParameter(param.getName(), xAxisConstraint, param.getUnits(), val);
        param2.addParameterChangeListener(this);
        this.controlsEditor.replaceParameterForEditor(param.getName(), param2);
        if (yAxisName.equals(Y_AXIS_V3)) {
            this.independentsEditor.setParameterVisible(imName, true);
        }
        this.independentsEditor.setParameterVisible(val, false);
        this.controlsEditor.validate();
        this.controlsEditor.repaint();
        this.independentsEditor.validate();
        this.independentsEditor.repaint();
    }

    private StringConstraint addToXAxisConstraint(ParameterList params, StringConstraint xAxisConstraint) {
        boolean add = true;
        for (Parameter<?> param : params) {
            int size;
            add = true;
            if (param instanceof StringParameter || param instanceof BooleanParameter) continue;
            ParameterConstraint constraint = param.getConstraint();
            if (constraint instanceof DiscreteParameterConstraint && (size = ((DiscreteParameterConstraint)constraint).getAllowedValues().size()) < 2) {
                add = false;
            }
            if (!add) continue;
            this.name = param.getName();
            if (xAxisConstraint.containsString(this.name)) continue;
            xAxisConstraint.addString(this.name);
        }
        return xAxisConstraint;
    }

    public void setTranslateAttenRel(boolean translateAttenRel) {
        this.translateAttenRel = translateAttenRel;
    }

    public boolean isTranslateAttenRel() {
        return this.translateAttenRel;
    }

    @Override
    public void parameterChangeFailed(ParameterChangeFailEvent event) {
        if (event.getParameterName().equals(NUM_X_POINTS_PARAM_NAME)) {
            JOptionPane.showMessageDialog(this.applet, "Num X poits must be with the range " + NUM_X_POINTS_MIN + "=>" + NUM_X_POINTS_MAX + ".", "Incorrect Parameter Input", 0);
            this.numXPointsParam.getEditor().setParameter(this.numXPointsParam);
        }
    }

    static {
        yAxisMap.put(Y_AXIS_V1, 1);
        yAxisMap.put(Y_AXIS_V2, 2);
        yAxisMap.put(Y_AXIS_V3, 3);
        yAxisMap.put(Y_AXIS_V4, 4);
    }

    class MinMaxDelta {
        protected double min;
        protected double max;
        protected double delta;
        private static final String C = "MinMaxDelta";

        public MinMaxDelta(Parameter param) throws ConstraintException {
            if (!ParamUtils.isDoubleOrDoubleDiscreteConstraint(param)) {
                throw new ConstraintException("MinMaxDelta: Constructor(): Parameter must have Double or DoubleDiscrete Constraint, unable to calculate");
            }
            this.min = 0.0;
            this.max = 1.0;
            if (param instanceof TranslatedWarningDoubleParameter) {
                try {
                    TranslatedWarningDoubleParameter param1 = (TranslatedWarningDoubleParameter)param;
                    this.min = param1.getWarningMin();
                    this.max = param1.getWarningMax();
                }
                catch (Exception e) {
                    throw new ConstraintException(e.toString());
                }
            } else {
                DoubleDiscreteConstraint con;
                int size;
                ParameterConstraint constraint = param.getConstraint();
                if (ParamUtils.isDoubleConstraint(param)) {
                    this.min = ((DoubleConstraint)constraint).getMin();
                    this.max = ((DoubleConstraint)constraint).getMax();
                } else if (ParamUtils.isDoubleDiscreteConstraint(param) && (size = (con = (DoubleDiscreteConstraint)constraint).size()) > 0) {
                    ListIterator<Double> it = con.listIterator();
                    Double DD = it.next();
                    this.min = DD;
                    this.max = this.max;
                    while (it.hasNext()) {
                        Double DD2 = it.next();
                        double val = DD2;
                        if (val > this.max) {
                            this.max = val;
                            continue;
                        }
                        if (!(val < this.min)) continue;
                        this.min = val;
                    }
                }
            }
            this.delta = (this.max - this.min) / (double)((Integer)AttenuationRelationshipGuiBean.this.numXPointsParam.getValue() - 1);
        }

        public MinMaxDelta(WarningParameter param) throws ConstraintException {
            this.min = 0.0;
            this.max = 1.0;
            if (param instanceof TranslatedWarningDoubleParameter) {
                try {
                    TranslatedWarningDoubleParameter param1 = (TranslatedWarningDoubleParameter)param;
                    this.min = param1.getWarningMin();
                    this.max = param1.getWarningMax();
                }
                catch (Exception e) {
                    throw new ConstraintException(e.toString());
                }
            } else {
                DoubleDiscreteConstraint con;
                int size;
                ParameterConstraint constraint = param.getWarningConstraint();
                if (constraint == null) {
                    constraint = param.getConstraint();
                }
                if (ParamUtils.isDoubleConstraint(param)) {
                    this.min = ((DoubleConstraint)constraint).getMin();
                    this.max = ((DoubleConstraint)constraint).getMax();
                } else if (ParamUtils.isDoubleDiscreteConstraint(param) && (size = (con = (DoubleDiscreteConstraint)constraint).size()) > 0) {
                    ListIterator<Double> it = con.listIterator();
                    Double DD = it.next();
                    this.min = DD;
                    this.max = this.max;
                    while (it.hasNext()) {
                        Double DD2 = it.next();
                        double val = DD2;
                        if (val > this.max) {
                            this.max = val;
                            continue;
                        }
                        if (!(val < this.min)) continue;
                        this.min = val;
                    }
                }
            }
            this.delta = (this.max - this.min) / (double)((Integer)AttenuationRelationshipGuiBean.this.numXPointsParam.getValue() - 1);
        }
    }
}

