/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.ngaw2;

import java.util.Collection;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.util.Interpolate;
import org.opensha.sha.imr.attenRelImpl.ngaw2.Coefficients;
import org.opensha.sha.imr.attenRelImpl.ngaw2.DefaultGroundMotion;
import org.opensha.sha.imr.attenRelImpl.ngaw2.FaultStyle;
import org.opensha.sha.imr.attenRelImpl.ngaw2.IMT;
import org.opensha.sha.imr.attenRelImpl.ngaw2.NGAW2_GMM;
import org.opensha.sha.imr.attenRelImpl.ngaw2.ScalarGroundMotion;
import org.opensha.sha.util.TectonicRegionType;

public class ASK_2014
implements NGAW2_GMM {
    public static final String NAME = "Abrahamson, Silva & Kamai (2014)";
    public static final String SHORT_NAME = "ASK2014";
    private final Coeffs coeffs;
    private static final double A3 = 0.275;
    private static final double A4 = -0.1;
    private static final double A5 = -0.41;
    private static final double M2 = 5.0;
    private static final double N = 1.5;
    private static final double C4 = 4.5;
    private static final double A = Math.pow(610.0, 4.0);
    private static final double B = Math.pow(1360.0, 4.0) + A;
    private static final double VS_RK = 1180.0;
    private static final double A2_HW = 0.2;
    private static final double H1 = 0.25;
    private static final double H2 = 1.5;
    private static final double H3 = -0.75;
    private static final double PHI_AMP_SQ = 0.16;
    private IMT imt = null;
    private double Mw = Double.NaN;
    private double rJB = Double.NaN;
    private double rRup = Double.NaN;
    private double rX = Double.NaN;
    private double rY0 = -1.0;
    private double dip = Double.NaN;
    private double width = Double.NaN;
    private double zTop = Double.NaN;
    private double vs30 = Double.NaN;
    private boolean vsInf = true;
    private double z1p0 = Double.NaN;
    private FaultStyle style = FaultStyle.UNKNOWN;
    private static final double[] VS_BINS = new double[]{150.0, 250.0, 400.0, 700.0, 1000.0};

    public ASK_2014() {
        this.coeffs = new Coeffs();
    }

    @Override
    public ScalarGroundMotion calc() {
        return this.calc(this.imt, this.Mw, this.rJB, this.rRup, this.rX, this.rY0, this.dip, this.width, this.zTop, this.vs30, this.vsInf, this.z1p0, this.style);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void set_IMT(IMT imt) {
        this.imt = imt;
    }

    @Override
    public void set_Mw(double Mw) {
        this.Mw = Mw;
    }

    @Override
    public void set_rJB(double rJB) {
        this.rJB = rJB;
    }

    @Override
    public void set_rRup(double rRup) {
        this.rRup = rRup;
    }

    @Override
    public void set_rX(double rX) {
        this.rX = rX;
    }

    @Override
    public void set_dip(double dip) {
        this.dip = dip;
    }

    @Override
    public void set_width(double width) {
        this.width = width;
    }

    @Override
    public void set_zTop(double zTop) {
        this.zTop = zTop;
    }

    @Override
    public void set_zHyp(double zHyp) {
    }

    @Override
    public void set_vs30(double vs30) {
        this.vs30 = vs30;
    }

    @Override
    public void set_vsInf(boolean vsInf) {
        this.vsInf = vsInf;
    }

    @Override
    public void set_z2p5(double z2p5) {
    }

    @Override
    public void set_z1p0(double z1p0) {
        this.z1p0 = z1p0;
    }

    @Override
    public void set_fault(FaultStyle style) {
        this.style = style;
    }

    @Override
    public TectonicRegionType get_TRT() {
        return TectonicRegionType.ACTIVE_SHALLOW;
    }

    @Override
    public Collection<IMT> getSupportedIMTs() {
        return this.coeffs.getSupportedIMTs();
    }

    public final ScalarGroundMotion calc(IMT imt, double Mw, double rJB, double rRup, double rX, double rY0, double dip, double width, double zTop, double vs30, boolean vsInferred, double z1p0, FaultStyle style) {
        this.coeffs.set(imt);
        return this.calcValues(this.coeffs, Mw, rJB, rRup, rX, rY0, dip, width, zTop, vs30, vsInferred, z1p0, style);
    }

    private DefaultGroundMotion calcValues(Coeffs c, double Mw, double rJB, double rRup, double rX, double rY0, double dip, double width, double zTop, double vs30, boolean vsInferred, double z1p0, FaultStyle style) {
        double c4mag = Mw > 5.0 ? 4.5 : (Mw > 4.0 ? 4.5 - 3.5 * (5.0 - Mw) : 1.0);
        double R = Math.sqrt(rRup * rRup + c4mag * c4mag);
        double MaxMwSq = (8.5 - Mw) * (8.5 - Mw);
        double MwM1 = Mw - c.M1;
        double f1 = c.a1 + c.a17 * rRup;
        if (Mw > c.M1) {
            f1 += -0.41 * MwM1 + c.a8 * MaxMwSq + (c.a2 + 0.275 * MwM1) * Math.log(R);
        } else if (Mw >= 5.0) {
            f1 += -0.1 * MwM1 + c.a8 * MaxMwSq + (c.a2 + 0.275 * MwM1) * Math.log(R);
        } else {
            double M2M1 = 5.0 - c.M1;
            double MaxM2Sq = 12.25;
            double MwM2 = Mw - 5.0;
            f1 += -0.1 * M2M1 + c.a8 * MaxM2Sq + c.a6 * MwM2 + (c.a2 + 0.275 * M2M1) * Math.log(R);
        }
        double f4 = 0.0;
        if (rJB < 30.0 && rX >= 0.0 && Mw > 5.5 && zTop <= 10.0) {
            double T1 = dip > 30.0 ? (90.0 - dip) / 45.0 : 1.33333333;
            double dM = Mw - 6.5;
            double T2 = Mw >= 6.5 ? 1.0 + 0.2 * dM : 1.0 + 0.2 * dM - 0.8 * dM * dM;
            double T3 = 0.0;
            double r1 = width * Math.cos(dip * GeoTools.TO_RAD);
            double r2 = 3.0 * r1;
            if (rX <= r1) {
                double rXr1 = rX / r1;
                T3 = 0.25 + 1.5 * rXr1 + -0.75 * rXr1 * rXr1;
            } else if (rX <= r2) {
                T3 = 1.0 - (rX - r1) / (r2 - r1);
            }
            double T4 = 1.0 - zTop * zTop / 100.0;
            double T5 = rJB == 0.0 ? 1.0 : 1.0 - rJB / 30.0;
            f4 = c.a13 * T1 * T2 * T3 * T4 * T5;
        }
        double f6 = c.a15;
        if (zTop < 20.0) {
            f6 *= zTop / 20.0;
        }
        double f78 = style == FaultStyle.NORMAL ? (Mw > 5.0 ? c.a12 : (Mw >= 4.0 ? c.a12 * (Mw - 4.0) : 0.0)) : 0.0;
        double f10 = ASK_2014.calcSoilTerm(c, vs30, z1p0);
        double f5 = 0.0;
        double v1 = ASK_2014.getV1(c.imt());
        double vs30s = vs30 < v1 ? vs30 : v1;
        double saRock = 0.0;
        if (vs30 < c.Vlin) {
            double vs30s_rk = 1180.0 < v1 ? 1180.0 : v1;
            double f5_rk = (c.a10 + c.b * 1.5) * Math.log(vs30s_rk / c.Vlin);
            saRock = Math.exp(f1 + f78 + f5_rk + f4 + f6);
            f5 = c.a10 * Math.log(vs30s / c.Vlin) - c.b * Math.log(saRock + c.c) + c.b * Math.log(saRock + c.c * Math.pow(vs30s / c.Vlin, 1.5));
        } else {
            f5 = (c.a10 + c.b * 1.5) * Math.log(vs30s / c.Vlin);
        }
        double mean = f1 + f78 + f5 + f4 + f6 + f10;
        double phiAsq = vsInferred ? ASK_2014.getPhiA(Mw, c.s1e, c.s2e) : ASK_2014.getPhiA(Mw, c.s1m, c.s2m);
        phiAsq *= phiAsq;
        double tauB = ASK_2014.getTauA(Mw, c.s3, c.s4);
        double phiBsq = phiAsq - 0.16;
        double dAmp_p1 = ASK_2014.get_dAmp(c.b, c.c, c.Vlin, vs30, saRock) + 1.0;
        double phiSq = phiBsq * dAmp_p1 * dAmp_p1 + 0.16;
        double tau = tauB * dAmp_p1;
        double stdDev = Math.sqrt(phiSq + tau * tau);
        return new DefaultGroundMotion(mean, stdDev, Math.sqrt(phiSq), tau);
    }

    private static final double getV1(IMT imt) {
        Double T = imt.getPeriod();
        if (T == null) {
            return 1500.0;
        }
        if (T >= 3.0) {
            return 800.0;
        }
        if (T > 0.5) {
            return Math.exp(-0.35 * Math.log(T / 0.5) + Math.log(1500.0));
        }
        return 1500.0;
    }

    private static final double calcSoilTerm(Coeffs c, double vs30, double z1p0) {
        if (Double.isNaN(z1p0)) {
            return 0.0;
        }
        double z1ref = ASK_2014.calcZ1ref(vs30);
        double[] vsCoeff = new double[]{c.a43, c.a44, c.a45, c.a46, c.a46};
        double z1c = Interpolate.findY(VS_BINS, vsCoeff, vs30);
        return z1c * Math.log((z1p0 + 0.01) / (z1ref + 0.01));
    }

    public static final double calcZ1ref(double vs30) {
        double vsPow4 = vs30 * vs30 * vs30 * vs30;
        return Math.exp(-1.9175 * Math.log((vsPow4 + A) / B)) / 1000.0;
    }

    private static final double getPhiA(double Mw, double s1, double s2) {
        return Mw < 4.0 ? s1 : (Mw > 6.0 ? s2 : s1 + (s2 - s1) / 2.0 * (Mw - 4.0));
    }

    private static final double getTauA(double Mw, double s3, double s4) {
        return Mw < 5.0 ? s3 : (Mw > 7.0 ? s4 : s3 + (s4 - s3) / 2.0 * (Mw - 5.0));
    }

    private static final double get_dAmp(double b, double c, double vLin, double vs30, double saRock) {
        if (vs30 >= vLin) {
            return 0.0;
        }
        return -b * saRock / (saRock + c) + b * saRock / (saRock + c * Math.pow(vs30 / vLin, 1.5));
    }

    private class Coeffs
    extends Coefficients {
        double a1;
        double a2;
        double a6;
        double a8;
        double a10;
        double a12;
        double a13;
        double a14;
        double a15;
        double a17;
        double a43;
        double a44;
        double a45;
        double a46;
        double b;
        double c;
        double s1e;
        double s2e;
        double s3;
        double s4;
        double s1m;
        double s2m;
        double s5;
        double s6;
        double M1;
        double Vlin;
        double a3;
        double a4;
        double a5;
        double c4;
        double n;
        double a7;
        double a11;
        double a16;
        double a25;
        double a28;
        double a29;
        double a31;
        double a36;
        double a37;
        double a38;
        double a39;
        double a40;
        double a41;
        double a42;

        Coeffs() {
            super("ASK14.csv");
            this.set(IMT.PGA);
        }
    }
}

