/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.ngaw2;

import org.apache.commons.math3.util.Precision;

public enum IMT {
    PGA,
    PGV,
    PGD,
    SA0P01,
    SA0P02,
    SA0P03,
    SA0P04,
    SA0P05,
    SA0P075,
    SA0P1,
    SA0P12,
    SA0P15,
    SA0P17,
    SA0P2,
    SA0P25,
    SA0P3,
    SA0P4,
    SA0P5,
    SA0P75,
    SA1P0,
    SA1P5,
    SA2P0,
    SA3P0,
    SA4P0,
    SA5P0,
    SA6P0,
    SA7P5,
    SA10P0;

    private Double period;

    private IMT() {
        if (this.name().startsWith("P")) {
            this.period = null;
        } else {
            String valStr = this.name().replace("SA", "").replace("P", ".");
            this.period = Double.parseDouble(valStr);
        }
    }

    public Double getPeriod() {
        return this.period;
    }

    public static IMT getSA(double period) {
        for (IMT imt : IMT.values()) {
            double saPeriod;
            if (!imt.name().startsWith("SA") || !Precision.equals((double)(saPeriod = imt.getPeriod().doubleValue()), (double)period, (double)1.0E-6)) continue;
            return imt;
        }
        return null;
    }

    public boolean isSA() {
        return this.ordinal() > 2;
    }

    public static IMT parseIMT(String s) {
        if ((s = s.trim().toUpperCase()).equals("PGA") || s.equals("PGV") || s.equals("PGD")) {
            return IMT.valueOf(s);
        }
        try {
            double period = Double.parseDouble(s);
            return IMT.getSA(period);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static void main(String[] args) {
        IMT imt = PGA;
        System.out.println((Object)imt);
        IMT currentIMT = imt;
        System.out.println((Object)currentIMT);
        imt = SA1P0;
        System.out.println((Object)currentIMT);
    }
}

