/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.ngaw2;

import java.util.Collection;
import org.opensha.sha.imr.attenRelImpl.ngaw2.Coefficients;
import org.opensha.sha.imr.attenRelImpl.ngaw2.DefaultGroundMotion;
import org.opensha.sha.imr.attenRelImpl.ngaw2.FaultStyle;
import org.opensha.sha.imr.attenRelImpl.ngaw2.IMT;
import org.opensha.sha.imr.attenRelImpl.ngaw2.NGAW2_GMM;
import org.opensha.sha.imr.attenRelImpl.ngaw2.ScalarGroundMotion;
import org.opensha.sha.util.TectonicRegionType;

public class Idriss_2014
implements NGAW2_GMM {
    public static final String NAME = "Idriss (2014)";
    public static final String SHORT_NAME = "Idriss2014";
    private final Coeffs coeffs;
    private IMT imt = null;
    private double Mw = Double.NaN;
    private double rRup = Double.NaN;
    private double vs30 = Double.NaN;
    private FaultStyle style = FaultStyle.UNKNOWN;

    public Idriss_2014() {
        this.coeffs = new Coeffs("Idriss14.csv");
        this.coeffs.set(IMT.PGA);
    }

    @Override
    public ScalarGroundMotion calc() {
        return this.calc(this.imt, this.Mw, this.rRup, this.vs30, this.style);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void set_IMT(IMT imt) {
        this.imt = imt;
    }

    @Override
    public void set_Mw(double Mw) {
        this.Mw = Mw;
    }

    @Override
    public void set_rJB(double rJB) {
    }

    @Override
    public void set_rRup(double rRup) {
        this.rRup = rRup;
    }

    @Override
    public void set_rX(double rX) {
    }

    @Override
    public void set_dip(double dip) {
    }

    @Override
    public void set_width(double width) {
    }

    @Override
    public void set_zTop(double zTop) {
    }

    @Override
    public void set_zHyp(double zHyp) {
    }

    @Override
    public void set_vs30(double vs30) {
        this.vs30 = vs30;
    }

    @Override
    public void set_vsInf(boolean vsInf) {
    }

    @Override
    public void set_z2p5(double z2p5) {
    }

    @Override
    public void set_z1p0(double z1p0) {
    }

    @Override
    public void set_fault(FaultStyle style) {
        this.style = style;
    }

    @Override
    public TectonicRegionType get_TRT() {
        return TectonicRegionType.ACTIVE_SHALLOW;
    }

    @Override
    public Collection<IMT> getSupportedIMTs() {
        return this.coeffs.getSupportedIMTs();
    }

    public final ScalarGroundMotion calc(IMT imt, double Mw, double rRup, double vs30, FaultStyle style) {
        this.coeffs.set(imt);
        double mean = Idriss_2014.calcMean(this.coeffs, Mw, rRup, style, vs30);
        double stdDev = Idriss_2014.calcStdDev(this.coeffs, Mw);
        return new DefaultGroundMotion(mean, stdDev);
    }

    private static final double calcMean(Coeffs c, double Mw, double rRup, FaultStyle style, double vs30) {
        double a1 = c.a1_lo;
        double a2 = c.a2_lo;
        double b1 = c.b1_lo;
        double b2 = c.b2_lo;
        if (Mw > 6.75) {
            a1 = c.a1_hi;
            a2 = c.a2_hi;
            b1 = c.b1_hi;
            b2 = c.b2_hi;
        }
        return a1 + a2 * Mw + c.a3 * (8.5 - Mw) * (8.5 - Mw) - (b1 + b2 * Mw) * Math.log(rRup + 10.0) + c.xi * Math.log(Math.min(vs30, 1200.0)) + c.gamma * rRup + (style == FaultStyle.REVERSE ? c.phi : 0.0);
    }

    private static final double calcStdDev(Coeffs c, double Mw) {
        double s1 = 0.035;
        double s2 = 0.06;
        Double T = c.imt().getPeriod();
        return 1.18 + (s1 *= T == null || T <= 0.05 ? Math.log(0.05) : (T < 3.0 ? Math.log(T) : Math.log(3.0))) - (s2 *= Mw <= 5.0 ? 5.0 : (Mw < 7.5 ? Mw : 7.5));
    }

    private static class Coeffs
    extends Coefficients {
        double a1_lo;
        double a2_lo;
        double a1_hi;
        double a2_hi;
        double a3;
        double b1_lo;
        double b2_lo;
        double b1_hi;
        double b2_hi;
        double xi;
        double gamma;
        double phi;

        Coeffs(String cName) {
            super(cName);
        }
    }
}

