/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.nshmp;

import com.google.common.base.Preconditions;
import gov.usgs.earthquake.nshmp.gmm.GmmInput;
import java.util.EnumMap;
import java.util.EnumSet;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.WarningParameter;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.imr.attenRelImpl.nshmp.MutableGmmInputBuilder;

class FieldParameterValueManager {
    static final EnumSet<GmmInput.Field> SUPPORTED_FIELDS = EnumSet.of(GmmInput.Field.DIP, new GmmInput.Field[]{GmmInput.Field.MW, GmmInput.Field.RAKE, GmmInput.Field.RJB, GmmInput.Field.RRUP, GmmInput.Field.RX, GmmInput.Field.VS30, GmmInput.Field.WIDTH, GmmInput.Field.Z1P0, GmmInput.Field.Z2P5, GmmInput.Field.ZHYP, GmmInput.Field.ZSED, GmmInput.Field.ZTOR});
    private ParameterChangeListener listener;
    private EnumMap<GmmInput.Field, Parameter<Double>> fieldParamMap;
    private EnumMap<GmmInput.Field, FieldParameterChangeListener> fieldParamListenerMap;
    private MutableGmmInputBuilder gmmInputBuilder;

    static void ensureSupported(GmmInput.Field field) {
        Preconditions.checkState((boolean)SUPPORTED_FIELDS.contains(field), (String)"Field is not supported by the OpenSHA<->nshmp-lib wrapper: %s", (Object)field);
    }

    static Double nshmpToOpenSHA(GmmInput.Field field, double nshmpVal) {
        FieldParameterValueManager.ensureSupported(field);
        switch (field) {
            case Z1P0: {
                if (Double.isNaN(nshmpVal)) {
                    return null;
                }
                return nshmpVal * 1000.0;
            }
            case Z2P5: {
                if (Double.isNaN(nshmpVal)) {
                    return null;
                }
                return nshmpVal;
            }
            case ZSED: {
                if (Double.isNaN(nshmpVal)) {
                    return null;
                }
                return nshmpVal;
            }
        }
        return nshmpVal;
    }

    static Double openshaToNSHMP(GmmInput.Field field, Double openshaVal) {
        FieldParameterValueManager.ensureSupported(field);
        switch (field) {
            case Z1P0: {
                if (openshaVal == null) {
                    return Double.NaN;
                }
                return openshaVal * 0.001;
            }
            case Z2P5: {
                if (openshaVal == null) {
                    return Double.NaN;
                }
                return openshaVal;
            }
            case ZSED: {
                if (openshaVal == null) {
                    return Double.NaN;
                }
                return openshaVal;
            }
            case WIDTH: {
                if (openshaVal == 0.0) {
                    return 0.1;
                }
                return openshaVal;
            }
        }
        return openshaVal;
    }

    FieldParameterValueManager(ParameterChangeListener listener) {
        this.listener = listener;
        this.fieldParamMap = new EnumMap(GmmInput.Field.class);
        this.fieldParamListenerMap = new EnumMap(GmmInput.Field.class);
        this.gmmInputBuilder = new MutableGmmInputBuilder();
    }

    void addParameterMapping(GmmInput.Field field, Parameter<Double> param) {
        Preconditions.checkState((!this.fieldParamMap.containsKey(field) ? 1 : 0) != 0);
        Preconditions.checkNotNull(param);
        this.fieldParamMap.put(field, param);
        this.fieldParamListenerMap.put(field, new FieldParameterChangeListener(field, param));
        this.gmmInputBuilder.setValue(field, FieldParameterValueManager.openshaToNSHMP(field, param.getValue()));
    }

    void setParameterValue(GmmInput.Field field, Double value) {
        this.gmmInputBuilder.setValue(field, FieldParameterValueManager.openshaToNSHMP(field, value));
        Parameter<Double> param = this.fieldParamMap.get(field);
        if (param == null) {
            return;
        }
        FieldParameterChangeListener listener = this.fieldParamListenerMap.get(field);
        listener.valueChangeInternal = value;
        if (param instanceof WarningParameter) {
            ((WarningParameter)param).setValueIgnoreWarning(value);
        } else {
            param.setValue(value);
        }
    }

    void setGmmInput(GmmInput externalInput) {
        this.gmmInputBuilder.setAll(externalInput);
        for (GmmInput.Field field : this.fieldParamMap.keySet()) {
            Double value = FieldParameterValueManager.nshmpToOpenSHA(field, MutableGmmInputBuilder.valueForField(externalInput, field));
            Parameter<Double> param = this.fieldParamMap.get(field);
            FieldParameterChangeListener listener = this.fieldParamListenerMap.get(field);
            listener.valueChangeInternal = value;
            if (param instanceof WarningParameter) {
                ((WarningParameter)param).setValueIgnoreWarning(value);
                continue;
            }
            param.setValue(value);
        }
    }

    GmmInput getGmmInput() {
        return this.gmmInputBuilder.build();
    }

    private class FieldParameterChangeListener
    implements ParameterChangeListener {
        private GmmInput.Field field;
        private Parameter<Double> param;
        private Double valueChangeInternal;

        FieldParameterChangeListener(GmmInput.Field field, Parameter<Double> param) {
            this.field = field;
            this.param = param;
        }

        @Override
        public void parameterChange(ParameterChangeEvent event) {
            Object newVal = event.getNewValue();
            if (this.valueChangeInternal != null && this.valueChangeInternal.equals(newVal)) {
                this.valueChangeInternal = null;
            } else {
                this.valueChangeInternal = null;
                FieldParameterValueManager.this.gmmInputBuilder.setValue(this.field, FieldParameterValueManager.openshaToNSHMP(this.field, this.param.getValue()));
                if (FieldParameterValueManager.this.listener != null) {
                    FieldParameterValueManager.this.listener.parameterChange(event);
                }
            }
        }
    }
}

