/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.nshmp;

import com.google.common.base.Preconditions;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import gov.usgs.earthquake.nshmp.gmm.GroundMotion;
import gov.usgs.earthquake.nshmp.tree.Branch;
import gov.usgs.earthquake.nshmp.tree.LogicTree;
import java.io.IOException;
import java.util.ArrayList;

public interface GroundMotionLogicTreeFilter {
    public LogicTree<GroundMotion> filter(LogicTree<GroundMotion> var1);

    public static class StringMatchingAdapter
    extends TypeAdapter<StringMatching> {
        public void write(JsonWriter out, StringMatching value) throws IOException {
            out.beginArray();
            for (String string : value.required) {
                out.value(string);
            }
            out.endArray();
        }

        public StringMatching read(JsonReader in) throws IOException {
            in.beginArray();
            ArrayList<String> required = new ArrayList<String>();
            while (in.hasNext()) {
                required.add(in.nextString());
            }
            in.endArray();
            return new StringMatching(required.toArray(new String[0]));
        }
    }

    @JsonAdapter(value=StringMatchingAdapter.class)
    public static class StringMatching
    implements GroundMotionLogicTreeFilter {
        private String[] required;
        private int expectedSize = -1;

        public StringMatching(String ... required) {
            Preconditions.checkArgument((required != null && required.length > 0 ? 1 : 0) != 0);
            this.required = required;
        }

        public String[] getRequired() {
            return this.required;
        }

        @Override
        public LogicTree<GroundMotion> filter(LogicTree<GroundMotion> tree) {
            ArrayList<Branch> matches = new ArrayList<Branch>(this.expectedSize < 0 ? tree.size() : this.expectedSize);
            double sumWeight = 0.0;
            for (Branch branch : tree) {
                boolean match = true;
                String id = branch.id();
                for (int r = 0; match && r < this.required.length; ++r) {
                    match = id.contains(this.required[r]);
                }
                if (!match) continue;
                matches.add(branch);
                sumWeight += branch.weight();
            }
            Preconditions.checkState((!matches.isEmpty() && sumWeight > 0.0 ? 1 : 0) != 0);
            this.expectedSize = matches.size();
            if (matches.size() == 1) {
                Branch branch = (Branch)matches.get(0);
                return LogicTree.singleton((String)tree.name(), (String)branch.id(), (Object)((GroundMotion)branch.value()));
            }
            LogicTree.Builder builder = LogicTree.builder((String)tree.name());
            for (Branch branch : matches) {
                builder.addBranch(branch.id(), (Object)((GroundMotion)branch.value()), branch.weight() / sumWeight);
            }
            return builder.build();
        }

        public String toString() {
            StringBuilder ret = new StringBuilder("StringMatching[");
            for (int i = 0; i < this.required.length; ++i) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append("'").append(this.required[i]).append("'");
            }
            ret.append("]");
            return ret.toString();
        }
    }
}

