/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.nshmp;

import com.google.common.base.Preconditions;
import gov.usgs.earthquake.nshmp.gmm.Imt;
import java.util.Arrays;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class NSHMP_Config {
    static final double[] IMLS_SA0P01 = new double[]{0.00233, 0.0035, 0.00524, 0.00786, 0.0118, 0.0177, 0.0265, 0.0398, 0.0597, 0.0896, 0.134, 0.202, 0.302, 0.454, 0.68, 1.02, 1.53, 2.3, 3.44, 5.17};
    static final double[] IMLS_SA0P02 = new double[]{0.00283, 0.00424, 0.00637, 0.00955, 0.0143, 0.0215, 0.0322, 0.0483, 0.0725, 0.109, 0.163, 0.245, 0.367, 0.551, 0.826, 1.24, 1.86, 2.79, 4.18, 6.27};
    static final double[] IMLS_SA0P5 = new double[]{0.00333, 0.00499, 0.00749, 0.0112, 0.0169, 0.0253, 0.0379, 0.0569, 0.0853, 0.128, 0.192, 0.288, 0.432, 0.648, 0.972, 1.46, 2.19, 3.28, 4.92, 7.38};
    static final double[] IMLS_SA2P0 = new double[]{0.0025, 0.00375, 0.00562, 0.00843, 0.0126, 0.019, 0.0284, 0.0427, 0.064, 0.096, 0.144, 0.216, 0.324, 0.486, 0.729, 1.09, 1.64, 2.46, 3.69, 5.54};
    static final double[] IMLS_SA3P0 = new double[]{0.002, 0.003, 0.00449, 0.00674, 0.0101, 0.0152, 0.0228, 0.0341, 0.0512, 0.0768, 0.115, 0.173, 0.259, 0.389, 0.583, 0.875, 1.31, 1.97, 2.95, 4.43};
    static final double[] IMLS_SA4P0 = new double[]{0.00133, 0.002, 0.003, 0.00449, 0.00674, 0.0101, 0.0152, 0.0228, 0.0341, 0.0512, 0.0768, 0.115, 0.173, 0.259, 0.389, 0.583, 0.875, 1.31, 1.97, 2.95};
    static final double[] IMLS_SA5P0 = new double[]{9.99E-4, 0.0015, 0.00225, 0.00337, 0.00506, 0.00758, 0.0114, 0.0171, 0.0256, 0.0384, 0.0576, 0.0864, 0.13, 0.194, 0.292, 0.437, 0.656, 0.984, 1.48, 2.21};
    static final double[] IMLS_SA7P5 = new double[]{4.99E-4, 7.49E-4, 0.00112, 0.00169, 0.00253, 0.00379, 0.00569, 0.00853, 0.0128, 0.0192, 0.0288, 0.0432, 0.0648, 0.0972, 0.146, 0.219, 0.328, 0.492, 0.738, 1.11};
    static final double[] IMLS_SA10P0 = new double[]{3.33E-4, 4.99E-4, 7.49E-4, 0.00112, 0.00169, 0.00253, 0.00379, 0.00569, 0.00853, 0.0128, 0.0192, 0.0288, 0.0432, 0.0648, 0.0972, 0.146, 0.219, 0.328, 0.492, 0.738};
    static final double[] IMLS_PGV = new double[]{0.237, 0.355, 0.532, 0.798, 1.19, 1.8, 2.69, 4.04, 6.06, 9.09, 13.6, 20.5, 30.7, 46.0, 69.0, 103.0, 155.0, 233.0, 349.0, 525.0};
    static final NavigableMap<Imt, double[]> imlMap = new TreeMap<Imt, double[]>(Map.of(Imt.SA0P01, IMLS_SA0P01, Imt.SA0P02, IMLS_SA0P02, Imt.SA0P5, IMLS_SA0P5, Imt.SA2P0, IMLS_SA2P0, Imt.SA3P0, IMLS_SA3P0, Imt.SA4P0, IMLS_SA4P0, Imt.SA5P0, IMLS_SA5P0, Imt.SA7P5, IMLS_SA7P5, Imt.SA10P0, IMLS_SA10P0));

    public static double[] imlsFor(double period) {
        if (period == 0.0) {
            return NSHMP_Config.imlsFor(Imt.PGA);
        }
        if (period == -1.0) {
            return NSHMP_Config.imlsFor(Imt.PGV);
        }
        Preconditions.checkState((period > 0.0 ? 1 : 0) != 0);
        return NSHMP_Config.imlsFor(Imt.fromPeriod((double)period));
    }

    public static double[] imlsFor(Imt imt) {
        if (imt.isSA() || imt == Imt.PGA) {
            return imlMap.ceilingEntry(imt).getValue();
        }
        if (imt == Imt.PGV) {
            return IMLS_PGV;
        }
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        System.out.println(Arrays.toString(NSHMP_Config.imlsFor(Imt.PGA)));
    }
}

