/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.nshmp.util;

import gov.usgs.earthquake.nshmp.gmm.Gmm;
import gov.usgs.earthquake.nshmp.gmm.GmmInput;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.WarningParameter;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupMFDsModule;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.attenRelImpl.nshmp.NSHMP_GMM_Wrapper;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.util.NEHRP_TestCity;
import scratch.UCERF3.erf.FaultSystemSolutionERF;

class CompareWithPrevImpl {
    CompareWithPrevImpl() {
    }

    public static void main(String[] args) throws IOException {
        File solFile = new File("/data/kevin/nshm23/batch_inversions/2023_01_17-nshm23_branches-NSHM23_v2-CoulombRupSet-TotNuclRate-NoRed-ThreshAvgIterRelGR/results_NSHM23_v2_CoulombRupSet_branch_averaged_gridded.zip");
        FaultSystemSolution fss = FaultSystemSolution.load(solFile);
        fss.removeAvailableModuleInstances(RupMFDsModule.class);
        boolean fullParams = false;
        boolean paramDebug = true;
        ScalarIMR gmpePrevImpl = AttenRelRef.CB_2008.get();
        NSHMP_GMM_Wrapper.Single gmpeNewWrapper = new NSHMP_GMM_Wrapper.Single(Gmm.CB_08_BASE, fullParams);
        double period = 0.2;
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(fss);
        erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.INCLUDE);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        erf.getTimeSpan().setDuration(1.0);
        erf.updateForecast();
        gmpePrevImpl.setParamDefaults();
        gmpeNewWrapper.setParamDefaults();
        if (period > 0.0) {
            gmpePrevImpl.setIntensityMeasure("SA");
            gmpeNewWrapper.setIntensityMeasure("SA");
            SA_Param.setPeriodInSA_Param(gmpePrevImpl.getIntensityMeasure(), period);
            SA_Param.setPeriodInSA_Param(gmpeNewWrapper.getIntensityMeasure(), period);
        } else if (period == 0.0) {
            gmpePrevImpl.setIntensityMeasure("PGA");
            gmpeNewWrapper.setIntensityMeasure("PGA");
        } else {
            throw new IllegalStateException();
        }
        ArbitrarilyDiscretizedFunc xVals = new IMT_Info().getDefaultHazardCurve(gmpePrevImpl.getIntensityMeasure());
        ArbitrarilyDiscretizedFunc logXVals = new ArbitrarilyDiscretizedFunc();
        for (Point2D pt : xVals) {
            logXVals.set(Math.log(pt.getX()), 0.0);
        }
        System.out.println("Current IMT: " + gmpeNewWrapper.getIntensityMeasure().getName());
        System.out.println("Translated IMT: " + String.valueOf(gmpeNewWrapper.getCurrentIMT()));
        System.out.println("Fields: " + String.valueOf(gmpeNewWrapper.getFieldsUsed()));
        System.out.println("GMM Params:");
        CompareWithPrevImpl.printGMMParams(gmpeNewWrapper);
        HazardCurveCalculator calc = new HazardCurveCalculator();
        NEHRP_TestCity[] cities = new NEHRP_TestCity[]{NEHRP_TestCity.LOS_ANGELES};
        Random rand = new Random();
        for (NEHRP_TestCity city : cities) {
            int i;
            System.out.println("City: " + String.valueOf((Object)city));
            ScalarIMR[] gmms = new ScalarIMR[]{gmpePrevImpl, gmpeNewWrapper};
            DiscretizedFunc[] curves = new DiscretizedFunc[2];
            ProbEqkSource randSource = null;
            ProbEqkRupture randRup = null;
            if (paramDebug) {
                randSource = erf.getSource(rand.nextInt(erf.getNumSources()));
                randRup = randSource.getRupture(rand.nextInt(randSource.getNumRuptures()));
            }
            for (i = 0; i < gmms.length; ++i) {
                ScalarIMR gmm = gmms[i];
                Site site = new Site(city.location());
                site.addParameterList(gmpePrevImpl.getSiteParams());
                calc.getHazardCurve((DiscretizedFunc)logXVals, site, gmm, (ERF)erf);
                ArbitrarilyDiscretizedFunc curve = new ArbitrarilyDiscretizedFunc();
                for (int j = 0; j < xVals.size(); ++j) {
                    curve.set(xVals.getX(j), logXVals.getY(j));
                }
                curves[i] = curve;
                if (!paramDebug) continue;
                System.out.println("Parameter debug for " + gmm.getName() + ", " + String.valueOf((Object)city));
                System.out.println("\tRandom source: " + randSource.getName());
                System.out.println("\tRandom rupture is an M" + (float)randRup.getMag());
                gmm.setEqkRupture(randRup);
                CompareWithPrevImpl.printGMMParams(gmm);
                if (gmm instanceof NSHMP_GMM_Wrapper) {
                    GmmInput input = ((NSHMP_GMM_Wrapper)gmm).getCurrentGmmInput();
                    System.out.println("GmmInput:\t" + String.valueOf(input));
                }
                System.out.println("\tMean: " + (float)gmm.getMean());
                System.out.println("\tStd. Dev.: " + (float)gmm.getStdDev());
            }
            System.out.println("IML\tPrevous\tWrapped\tDifference\t% Diff");
            for (i = 0; i < xVals.size(); ++i) {
                double iml = xVals.getX(i);
                double prevVal = curves[0].getY(i);
                double newVal = curves[1].getY(i);
                double diff = newVal - prevVal;
                double pDiff = 100.0 * diff / prevVal;
                System.out.println((float)iml + "\t" + (float)prevVal + "\t" + (float)newVal + "\t" + (float)diff + "\t" + (float)pDiff + " %");
            }
        }
    }

    private static void printGMMParams(ScalarIMR gmm) {
        System.out.println("\tEqk Rup Params:");
        for (Parameter<?> param : gmm.getEqkRuptureParams()) {
            System.out.println("\t\t" + CompareWithPrevImpl.paramNameValueRange(param));
        }
        System.out.println("\tProp Effect Params:");
        for (Parameter<?> param : gmm.getPropagationEffectParams()) {
            System.out.println("\t\t" + CompareWithPrevImpl.paramNameValueRange(param));
        }
        System.out.println("\tSite Params:");
        for (Parameter<?> param : gmm.getSiteParams()) {
            System.out.println("\t\t" + CompareWithPrevImpl.paramNameValueRange(param));
        }
        System.out.println("\tOther Params:");
        for (Parameter<?> param : gmm.getOtherParams()) {
            System.out.println("\t\t" + CompareWithPrevImpl.paramNameValueRange(param));
        }
    }

    private static String paramNameValueRange(Parameter<?> param) {
        String ret = param.getName() + ":\t" + String.valueOf(param.getValue());
        if (param instanceof WarningParameter) {
            WarningParameter warn = (WarningParameter)param;
            ret = ret + "\t[" + String.valueOf(warn.getWarningMin()) + ", " + String.valueOf(warn.getWarningMax()) + "]";
        }
        return ret;
    }
}

