/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.nshmp.util;

import gov.usgs.earthquake.nshmp.gmm.Gmm;
import gov.usgs.earthquake.nshmp.gmm.GmmInput;
import gov.usgs.earthquake.nshmp.gmm.GroundMotion;
import gov.usgs.earthquake.nshmp.gmm.GroundMotionModel;
import gov.usgs.earthquake.nshmp.tree.Branch;
import gov.usgs.earthquake.nshmp.tree.LogicTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.opensha.commons.param.Parameter;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.attenRelImpl.nshmp.GroundMotionLogicTreeFilter;
import org.opensha.sha.imr.attenRelImpl.nshmp.NSHMP_GMM_Wrapper;

class InitialTests {
    InitialTests() {
    }

    public static void main(String[] args) {
        GroundMotionLogicTreeFilter filter = null;
        Gmm[] gmms = new Gmm[]{Gmm.PRVI_2025_ACTIVE_CRUST, Gmm.PRVI_2025_ACTIVE_CRUST_ADJUSTED, Gmm.PRVI_2025_INTERFACE, Gmm.PRVI_2025_INTERFACE_ADJUSTED, Gmm.PRVI_2025_INTRASLAB, Gmm.PRVI_2025_INTRASLAB_ADJUSTED, Gmm.TOTAL_TREE_PRVI_ACTIVE_CRUST_2025, Gmm.TOTAL_TREE_PRVI_INTERFACE_2025, Gmm.TOTAL_TREE_PRVI_INTRASLAB_2025, Gmm.COMBINED_PRVI_ACTIVE_CRUST_2025, Gmm.COMBINED_PRVI_INTERFACE_2025, Gmm.COMBINED_PRVI_INTRASLAB_2025};
        ArrayList<NSHMP_GMM_Wrapper> wrappers = new ArrayList<NSHMP_GMM_Wrapper>();
        for (Gmm gmm : gmms) {
            try {
                wrappers.add(new NSHMP_GMM_Wrapper.Single(gmm));
                System.out.println("GMM: " + String.valueOf(gmm));
                GmmInput.Constraints constraints = gmm.constraints();
                for (GmmInput.Field field : GmmInput.Field.values()) {
                    Optional fieldConstr = constraints.get(field);
                    if (fieldConstr.isPresent()) {
                        System.out.println("\t" + String.valueOf(field) + ":\t" + String.valueOf(fieldConstr.get()));
                        continue;
                    }
                    System.out.println("\t" + String.valueOf(field) + ":\t(missing)");
                }
            }
            catch (Exception e) {
                System.out.flush();
                System.err.println("FAILED for " + String.valueOf(gmm) + ": " + e.getMessage());
                System.err.flush();
                System.out.println();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        System.exit(0);
        wrappers.add((NSHMP_GMM_Wrapper)AttenRelRef.USGS_NSHM23_ACTIVE.get());
        GmmInput input = GmmInput.builder().withDefaults().build();
        for (NSHMP_GMM_Wrapper wrapper : wrappers) {
            LogicTree<GroundMotion> result;
            System.out.println("GMM: " + wrapper.getName());
            wrapper.setParamDefaults();
            if (filter != null) {
                wrapper.setGroundMotionTreeFilter(filter);
            }
            if (wrapper instanceof NSHMP_GMM_Wrapper.Single) {
                GroundMotionModel instance = ((NSHMP_GMM_Wrapper.Single)wrapper).getCurrentGMM_Instance();
                System.out.println("\tInstance class: " + instance.getClass().getName());
                Class superclass = instance.getClass().getSuperclass();
                while (InitialTests.getAllInterfaces(superclass).contains(GroundMotionModel.class)) {
                    System.out.println("\t\tSuperclass:\t" + superclass.getName());
                    if ((superclass = superclass.getSuperclass()) != null) continue;
                }
            }
            System.out.println("\tParameter List:");
            System.out.println("\tRupture Parms:");
            for (Parameter param : wrapper.getEqkRuptureParams()) {
                System.out.println("\t\t" + param.getName() + ":\tdefault=" + String.valueOf(param.getValue()));
            }
            System.out.println("\tProp Effect Parms:");
            for (Parameter param : wrapper.getPropagationEffectParams()) {
                System.out.println("\t\t" + param.getName() + ":\tdefault=" + String.valueOf(param.getValue()));
            }
            System.out.println("\tOther Parms:");
            for (Parameter param : wrapper.getOtherParams()) {
                System.out.println("\t\t" + param.getName() + ":\tdefault=" + String.valueOf(param.getValue()));
            }
            System.out.println("\tSite Parms:");
            for (Parameter param : wrapper.getSiteParams()) {
                System.out.println("\t\t" + param.getName() + ":\tdefault=" + String.valueOf(param.getValue()));
            }
            System.out.print("\tCalculating for " + wrapper.getIntensityMeasure().getName() + " defaults...");
            try {
                result = wrapper.getGroundMotionTree();
                System.out.println("Success!");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.flush();
                System.err.println("FAILED: " + e.getMessage());
                System.err.flush();
                System.out.println();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException param) {}
                continue;
            }
            System.out.println("\tReturned LogicTree:");
            for (Branch gmBranch : result) {
                double weight = gmBranch.weight();
                GroundMotion value = (GroundMotion)gmBranch.value();
                String id = gmBranch.id();
                System.out.println("\t\t" + id + " (weight=" + (float)weight + "): " + String.valueOf(value));
            }
            System.out.println();
        }
        NSHMP_GMM_Wrapper listGMM = (NSHMP_GMM_Wrapper)AttenRelRef.USGS_NSHM23_ACTIVE.get();
        listGMM.setParamDefaults();
        System.out.println("Testing list GMM: " + listGMM.getName());
        LogicTree<GroundMotion> result = listGMM.getGroundMotionTree();
        System.out.println("\tReturned LogicTree:");
        for (Branch gmBranch : result) {
            double weight = gmBranch.weight();
            GroundMotion value = (GroundMotion)gmBranch.value();
            String id = gmBranch.id();
            System.out.println("\t\t" + id + " (weight=" + (float)weight + "): " + String.valueOf(value));
        }
    }

    static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        Set<Class<?>> res = InitialTests.getAllDirectInterfaces(clazz);
        for (Class<?> superclass = clazz.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            res.addAll(InitialTests.getAllDirectInterfaces(superclass));
        }
        return res;
    }

    static Set<Class<?>> getAllDirectInterfaces(Class<?> clazz) {
        HashSet res = new HashSet();
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces.length > 0) {
            res.addAll(Arrays.asList(interfaces));
            for (Class<?> interfaze : interfaces) {
                res.addAll(InitialTests.getAllDirectInterfaces(interfaze));
            }
        }
        return res;
    }
}

