/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.mod;

import org.opensha.commons.data.ShortNamed;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncLevelParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncTypeParam;

public abstract class AbstractAttenRelMod
implements ShortNamed {
    public abstract void setIMRParams(ScalarIMR var1);

    public void setIMRSiteParams(ScalarIMR imr, Site site) {
        imr.setSite(site);
    }

    public void setIMRRupParams(ScalarIMR imr, EqkRupture rup) {
        imr.setEqkRupture(rup);
    }

    public void setIMT_IMT(ScalarIMR imr, Parameter<Double> imt) {
        imr.setIntensityMeasure(imt);
    }

    public abstract double getModMean(ScalarIMR var1);

    public abstract double getModStdDev(ScalarIMR var1);

    public DiscretizedFunc getModExceedProbabilities(ScalarIMR imr, DiscretizedFunc intensityMeasureLevels) throws ParameterException {
        SigmaTruncLevelParam sigmaTruncLevelParam;
        SigmaTruncTypeParam sigmaTruncTypeParam;
        double stdDev = this.getModStdDev(imr);
        double mean = this.getModMean(imr);
        Parameter truncParam = imr.getParameter("Gaussian Truncation");
        if (truncParam != null && truncParam instanceof SigmaTruncTypeParam) {
            sigmaTruncTypeParam = (SigmaTruncTypeParam)truncParam;
            sigmaTruncLevelParam = (SigmaTruncLevelParam)imr.getParameter("Truncation Level");
        } else {
            sigmaTruncTypeParam = null;
            sigmaTruncLevelParam = null;
        }
        for (int i = 0; i < intensityMeasureLevels.size(); ++i) {
            double x = intensityMeasureLevels.getX(i);
            double y = AttenuationRelationship.getExceedProbability(mean, stdDev, x, sigmaTruncTypeParam, sigmaTruncLevelParam);
            intensityMeasureLevels.set(i, y);
        }
        return intensityMeasureLevels;
    }

    public abstract ParameterList getModParams();
}

