/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.mod.impl.stewartSiteSpecific;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jfree.data.Range;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.Interpolate;
import org.opensha.sha.imr.mod.impl.stewartSiteSpecific.NonErgodicSiteResponseMod;
import org.opensha.sha.imr.mod.impl.stewartSiteSpecific.PeriodDependentParamSetEditor;

public class PeriodDependentParamSet<E extends Enum<E>> {
    private E[] params;
    private Map<E, Integer> paramToIndexMap;
    private List<Double> periods;
    private List<double[]> values;
    static final Joiner j = Joiner.on((String)"\t");

    public PeriodDependentParamSet(E[] params) {
        Preconditions.checkArgument((params.length > 0 ? 1 : 0) != 0);
        this.params = params;
        this.paramToIndexMap = Maps.newHashMap();
        for (int i = 0; i < params.length; ++i) {
            this.paramToIndexMap.put(params[i], i);
        }
        this.periods = Lists.newArrayList();
        this.values = Lists.newArrayList();
    }

    public synchronized void set(double period, double[] vals) {
        Preconditions.checkState((vals.length == this.params.length ? 1 : 0) != 0);
        int index = Collections.binarySearch(this.periods, period);
        if (index >= 0) {
            this.values.set(index, vals);
        } else {
            index = -(index + 1);
            this.periods.add(index, period);
            this.values.add(index, vals);
        }
    }

    public synchronized void set(double period, E param, double value) {
        int periodIndex = Collections.binarySearch(this.periods, period);
        if (periodIndex < 0) {
            periodIndex = -(periodIndex + 1);
            this.periods.add(periodIndex, period);
            this.values.add(periodIndex, new double[this.params.length]);
        }
        this.set(periodIndex, param, value);
    }

    public synchronized void set(int periodIndex, E param, double value) {
        int paramIndex = this.paramToIndexMap.get(param);
        Preconditions.checkState((paramIndex >= 0 ? 1 : 0) != 0, (String)"param not found: %s", param);
        this.values.get((int)periodIndex)[paramIndex] = value;
    }

    public synchronized void remove(double period) {
        int index = this.periodToIndex(period);
        Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"period not found: %s", (Object)period);
        this.remove(index);
    }

    public synchronized void remove(int index) {
        Preconditions.checkState((index >= 0 && index < this.periods.size() ? 1 : 0) != 0, (String)"bad index: %s", (int)index);
        this.periods.remove(index);
        this.values.remove(index);
    }

    public synchronized void clear() {
        this.periods.clear();
        this.values.clear();
    }

    public int size() {
        return this.periods.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public E[] getParams() {
        return (Enum[])Arrays.copyOf(this.params, this.params.length);
    }

    public List<Double> getPeriods() {
        return Collections.unmodifiableList(this.periods);
    }

    public double getPeriod(int index) {
        return this.periods.get(index);
    }

    public int periodToIndex(double period) {
        return this.periods.indexOf(period);
    }

    public double[] getValues(double period) {
        int index = this.periodToIndex(period);
        Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"period not found: %s", (Object)period);
        return this.getValues(index);
    }

    public double[] getValues(int index) {
        int size = this.size();
        Preconditions.checkArgument((index >= 0 && index < size ? 1 : 0) != 0, (String)"bad index: %s, size: %s", (int)index, (int)size);
        return Arrays.copyOf(this.values.get(index), this.params.length);
    }

    public double[] getValues(E[] params, int index) {
        int size = this.size();
        Preconditions.checkArgument((index >= 0 && index < size ? 1 : 0) != 0, (String)"bad index: %s, size: %s", (int)index, (int)size);
        double[] ret = new double[params.length];
        for (int i = 0; i < params.length; ++i) {
            ret[i] = this.get(params[i], index);
        }
        return ret;
    }

    public int getParamIndex(E param) {
        return this.paramToIndexMap.get(param);
    }

    public double get(E param, double period) {
        int periodIndex = this.periodToIndex(period);
        Preconditions.checkState((periodIndex >= 0 ? 1 : 0) != 0, (String)"period not found: %s", (Object)period);
        return this.get(param, periodIndex);
    }

    public double get(E param, int periodIndex) {
        int paramIndex = this.paramToIndexMap.get(param);
        Preconditions.checkState((paramIndex >= 0 ? 1 : 0) != 0, (String)"param not found: %s", param);
        return this.values.get(periodIndex)[paramIndex];
    }

    public double[] get(E[] params, int periodIndex) {
        double[] ret = new double[params.length];
        for (int i = 0; i < params.length; ++i) {
            E param = params[i];
            int paramIndex = this.paramToIndexMap.get(param);
            Preconditions.checkState((paramIndex >= 0 ? 1 : 0) != 0, (String)"param not found: %s", param);
            ret[i] = this.values.get(periodIndex)[paramIndex];
        }
        return ret;
    }

    public double getInterpolated(E param, double period) {
        return this.doGetInterpolated(period, new Enum[]{param})[0];
    }

    public double[] getInterpolated(E[] param, double period) {
        return this.doGetInterpolated(period, (Enum[])this.params);
    }

    private double[] doGetInterpolated(double period, E ... params) {
        int periodIndex = Collections.binarySearch(this.periods, period);
        if (periodIndex >= 0) {
            return this.get((Enum[])params, periodIndex);
        }
        if (period < this.periods.get(0)) {
            return this.get((Enum[])params, 0);
        }
        if (period > this.periods.get(this.periods.size() - 1)) {
            return this.get((Enum[])params, this.periods.size() - 1);
        }
        int insertionIndex = -(periodIndex + 1);
        Preconditions.checkState((insertionIndex > 0 && insertionIndex < this.periods.size() ? 1 : 0) != 0);
        double x1 = this.periods.get(insertionIndex - 1);
        double x2 = this.periods.get(insertionIndex);
        double[] ret = new double[params.length];
        for (int i = 0; i < params.length; ++i) {
            double y1 = this.get(params[i], insertionIndex - 1);
            double y2 = this.get(params[i], insertionIndex);
            ret[i] = x1 > 0.0 ? Interpolate.findY(Math.log(x1), y1, Math.log(x2), y2, Math.log(period)) : Interpolate.findY(x1, y1, x2, y2, period);
        }
        return ret;
    }

    public static <E extends Enum<E>> PeriodDependentParamSet<E> loadCSV(E[] params, File csvFile) throws IOException {
        PeriodDependentParamSet data = new PeriodDependentParamSet(params);
        data.loadCSV(csvFile);
        return data;
    }

    public static <E extends Enum<E>> PeriodDependentParamSet<E> loadCSV(E[] params, InputStream csvStream) throws IOException {
        PeriodDependentParamSet data = new PeriodDependentParamSet(params);
        data.loadCSV(csvStream);
        return data;
    }

    private static String nameStrip(String name) {
        return name.trim().replaceAll(" ", "").replaceAll("_", "").toLowerCase();
    }

    private static double csvValParse(String str) {
        if (str.trim().toLowerCase().startsWith("na")) {
            return Double.NaN;
        }
        return Double.parseDouble(str);
    }

    public void loadCSV(File csvFile) throws IOException {
        this.loadCSV(CSVFile.readFile(csvFile, true));
    }

    public void loadCSV(InputStream csvStream) throws IOException {
        this.loadCSV(CSVFile.readStream(csvStream, true));
    }

    public void loadCSV(CSVFile<String> csv) throws IOException {
        Preconditions.checkState((csv.getNumCols() == this.params.length + 1 ? 1 : 0) != 0, (String)"Param count mismatch: %s cols, %s params", (int)csv.getNumCols(), (int)this.params.length);
        for (int i = 0; i < this.params.length; ++i) {
            String paramName = ((Enum)this.params[i]).name().trim();
            String inputName = csv.get(0, i + 1).trim();
            Preconditions.checkState((boolean)PeriodDependentParamSet.nameStrip(paramName).equals(PeriodDependentParamSet.nameStrip(inputName)), (String)"Parameter mismatch at column %s. Expected: %s, Actual: %s", (Object)i, (Object)paramName, (Object)inputName);
        }
        this.clear();
        for (int row = 1; row < csv.getNumRows(); ++row) {
            List<String> line = csv.getLine(row);
            String periodStr = line.get(0);
            if (periodStr == null || periodStr.isEmpty()) continue;
            double period = PeriodDependentParamSetEditor.getPeriodFromRender(line.get(0));
            double[] values = new double[this.params.length];
            for (int i = 0; i < this.params.length; ++i) {
                values[i] = PeriodDependentParamSet.csvValParse(line.get(i + 1));
            }
            this.set(period, values);
        }
    }

    public void writeCSV(File csvFile) throws IOException {
        CSVFile csv = new CSVFile(true);
        ArrayList header = Lists.newArrayList((Object[])new String[]{"Period"});
        for (E param : this.params) {
            header.add(((Enum)param).name());
        }
        csv.addLine(header);
        for (int i = 0; i < this.size(); ++i) {
            ArrayList line = Lists.newArrayList((Object[])new String[]{String.valueOf(PeriodDependentParamSetEditor.getPeriodForRender(this.getPeriod(i)))});
            for (double val : this.getValues(i)) {
                line.add("" + val);
            }
            csv.addLine(line);
        }
        csv.writeToFile(csvFile);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ClassUtils.getClassNameWithoutPackage(this.getClass())).append(":\n");
        sb.append("\tPeriod\t").append(j.join((Object[])this.params)).append("\n");
        for (int i = 0; i < this.size(); ++i) {
            sb.append("\t").append(this.getPeriod(i)).append("\t").append(j.join((Iterable)Doubles.asList((double[])this.getValues(i)))).append("\n");
        }
        return sb.toString();
    }

    private static <E extends Enum<E>> void plotInterpolation(PeriodDependentParamSet<E> paramSet, E[] paramsToPlot, File outputDir) throws IOException {
        ArrayList periods = Lists.newArrayList();
        for (int i = 1; i < 32; ++i) {
            double pre = i % 10;
            if (pre == 0.0) continue;
            double exp = i / 10 - 2;
            double p = pre * Math.pow(10.0, exp);
            periods.add(p);
        }
        ArbitrarilyDiscretizedFunc[] interpolated = new ArbitrarilyDiscretizedFunc[paramsToPlot.length];
        for (int i = 0; i < interpolated.length; ++i) {
            interpolated[i] = new ArbitrarilyDiscretizedFunc();
            interpolated[i].setName("Interpolated");
        }
        Iterator i = periods.iterator();
        while (i.hasNext()) {
            double period = (Double)i.next();
            double[] vals = paramSet.getInterpolated((Enum[])paramsToPlot, period);
            for (int i2 = 0; i2 < paramsToPlot.length; ++i2) {
                interpolated[i2].set(period, vals[i2]);
            }
        }
        ArrayList specs = Lists.newArrayList();
        for (int i3 = 0; i3 < paramsToPlot.length; ++i3) {
            ArrayList funcs = Lists.newArrayList();
            ArrayList chars = Lists.newArrayList();
            ArbitrarilyDiscretizedFunc input = new ArbitrarilyDiscretizedFunc();
            input.setName("Input");
            for (double period : paramSet.getPeriods()) {
                input.set(period, paramSet.get(paramsToPlot[i3], period));
            }
            funcs.add(input);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.TRIANGLE, 4.0f, Color.BLACK));
            funcs.add(interpolated[i3]);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
            PlotSpec spec = new PlotSpec(funcs, chars, "Parameter Interpolation", "Period", ((Enum)paramsToPlot[i3]).toString());
            if (i3 == paramsToPlot.length - 1) {
                spec.setLegendVisible(true);
            }
            specs.add(spec);
        }
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setBackgroundColor(Color.WHITE);
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(20);
        gp.setPlotLabelFontSize(21);
        ArrayList xRanges = Lists.newArrayList((Object[])new Range[]{new Range(((Double)periods.get(0)).doubleValue(), ((Double)periods.get(periods.size() - 1)).doubleValue())});
        gp.drawGraphPanel((List<? extends PlotSpec>)specs, true, false, (List<Range>)xRanges, null);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, "param_interpolation.png").getAbsolutePath());
    }

    public static void main(String[] args) throws IOException {
        PeriodDependentParamSet periodParams = PeriodDependentParamSet.loadCSV((Enum[])NonErgodicSiteResponseMod.Params.values(), (InputStream)PeriodDependentParamSet.class.getResourceAsStream("/data/imr/sag_2017_nonergodic/params.csv"));
        Enum[] paramsToPlot = new NonErgodicSiteResponseMod.Params[]{NonErgodicSiteResponseMod.Params.F1, NonErgodicSiteResponseMod.Params.F2};
        File outputDir = new File("/tmp");
        PeriodDependentParamSet.plotInterpolation((PeriodDependentParamSet)periodParams, (Enum[])paramsToPlot, (File)outputDir);
    }
}

