/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.mod.impl.stewartSiteSpecific;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.mod.AbstractAttenRelMod;
import org.opensha.sha.imr.mod.impl.stewartSiteSpecific.PeriodDependentParamSet;
import org.opensha.sha.imr.mod.impl.stewartSiteSpecific.PeriodDependentParamSetParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo2pt5kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.imr.param.SiteParams.Vs30_TypeParam;

@Deprecated
public class StewartSiteSpecificMod
extends AbstractAttenRelMod
implements ParameterChangeListener {
    private static final boolean D = true;
    private static final boolean DD = true;
    public static final String NAME = "Stewart 2014 Site Specific";
    public static final String SHORT_NAME = "Stewart2014";
    private PeriodDependentParamSet<Params> periodParams;
    private double curPeriod;
    private double[] curParamValues;
    private PeriodDependentParamSetParam<Params> periodParamsParam;
    private ParameterList paramList;
    private Parameter<Double> imt;
    private ParameterList referenceSiteParams;

    public StewartSiteSpecificMod() {
        try {
            this.periodParams = PeriodDependentParamSet.loadCSV((Enum[])Params.values(), (InputStream)this.getClass().getResourceAsStream("/data/imr/sag_2017_nonergodic/params.csv"));
            System.out.println("Loaded default params:\n" + String.valueOf(this.periodParams));
        }
        catch (IOException e) {
            System.err.println("Error loading default params:");
            e.printStackTrace();
            this.periodParams = new PeriodDependentParamSet((Enum[])Params.values());
        }
        this.periodParamsParam = new PeriodDependentParamSetParam<Params>("Period Dependent Params", this.periodParams);
        this.periodParamsParam.addParameterChangeListener(this);
        this.paramList = new ParameterList();
        this.paramList.addParameter(this.periodParamsParam);
        this.setReferenceSiteParams(StewartSiteSpecificMod.getDefaultReferenceSiteParams());
    }

    static ParameterList getDefaultReferenceSiteParams() {
        ParameterList params = new ParameterList();
        Vs30_Param vs30 = new Vs30_Param(760.0);
        vs30.setValueAsDefault();
        params.addParameter(vs30);
        Vs30_TypeParam vs30Type = new Vs30_TypeParam();
        vs30Type.setValue("Inferred");
        params.addParameter(vs30Type);
        DepthTo2pt5kmPerSecParam z25 = new DepthTo2pt5kmPerSecParam(null, true);
        z25.setValueAsDefault();
        params.addParameter(z25);
        DepthTo1pt0kmPerSecParam z10 = new DepthTo1pt0kmPerSecParam(null, true);
        z10.setValueAsDefault();
        params.addParameter(z10);
        return params;
    }

    public void setReferenceSiteParams(ParameterList referenceSiteParams) {
        this.referenceSiteParams = referenceSiteParams;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setIMRParams(ScalarIMR imr) {
        Parameter param;
        try {
            param = imr.getParameter("Vs30");
            param.setValue(this.referenceSiteParams.getParameter(Double.class, "Vs30").getValue());
        }
        catch (ParameterException e) {
            System.out.println("IMR doesn't support Vs30");
        }
        try {
            param = imr.getParameter("Vs30 Type");
            param.setValue(this.referenceSiteParams.getParameter(String.class, "Vs30 Type").getValue());
        }
        catch (ParameterException e) {
            System.out.println("IMR doesn't support Vs30 Type");
        }
        try {
            param = imr.getParameter("Depth 2.5 km/sec");
            param.setValue(this.referenceSiteParams.getParameter(Double.class, "Depth 2.5 km/sec").getValue());
        }
        catch (ParameterException e) {
            System.out.println("IMR doesn't support Z2.5");
        }
        try {
            param = imr.getParameter("Depth 1.0 km/sec");
            param.setValue(this.referenceSiteParams.getParameter(Double.class, "Depth 1.0 km/sec").getValue());
        }
        catch (ParameterException e) {
            System.out.println("IMR doesn't support Z1.0");
        }
        System.out.println("Set site params to default");
    }

    @Override
    public void setIMT_IMT(ScalarIMR imr, Parameter<Double> imt) {
        this.imt = imt;
        if (imt.getName().equals("SA")) {
            this.curPeriod = SA_Param.getPeriodInSA_Param(imt);
        } else {
            Preconditions.checkState((boolean)imt.getName().equals("PGA"), (Object)"Only SA and PGA supported");
            this.curPeriod = 0.0;
        }
        this.curParamValues = null;
        super.setIMT_IMT(imr, imt);
    }

    private synchronized double[] getCurParams() {
        if (this.curParamValues == null) {
            this.curParamValues = this.periodParams.getInterpolated((Params[])this.periodParams.getParams(), this.curPeriod);
        }
        return this.curParamValues;
    }

    public void setSiteAmpParams(double period, Map<Params, Double> values) {
        for (Params param : values.keySet()) {
            this.periodParams.set(period, param, (double)values.get((Object)param));
        }
    }

    @Override
    public void setIMRSiteParams(ScalarIMR imr, Site site) {
        imr.setSiteLocation(site.getLocation());
    }

    @Override
    public double getModMean(ScalarIMR imr) {
        double u_lnX = imr.getMean();
        Object imt = imr.getIntensityMeasure().getName();
        if (((String)imt).equals("SA")) {
            imt = (String)imt + " " + (float)SA_Param.getPeriodInSA_Param(imr.getIntensityMeasure()) + "s";
        }
        System.out.println("Orig IMT: " + (String)imt);
        System.out.println("Orig Mean, u_X=" + Math.exp(u_lnX));
        System.out.println("Setting to PGA");
        imr.setIntensityMeasure("PGA");
        Preconditions.checkState((boolean)imr.getIntensityMeasure().getName().equals("PGA"));
        double x_ref_ln = imr.getMean();
        double x_ref = Math.exp(x_ref_ln);
        System.out.println("Ref PGA, x_ref=" + x_ref);
        imr.setIntensityMeasure(this.imt);
        Preconditions.checkState((boolean)imr.getIntensityMeasure().getName().equals(this.imt.getName()));
        double[] params = this.getCurParams();
        double f1 = params[this.periodParams.getParamIndex(Params.F1)];
        double f2 = params[this.periodParams.getParamIndex(Params.F2)];
        double f3 = params[this.periodParams.getParamIndex(Params.F3)];
        System.out.println("Calculating mean with f1=" + f1 + ", f2=" + f2 + ", f3=" + f3);
        double ln_y = f1 + f2 * Math.log((x_ref + f3) / f3);
        System.out.println("y=" + Math.exp(ln_y));
        double yMax = Math.log(params[this.periodParams.getParamIndex(Params.Ymax)]);
        if (!Double.isNaN(yMax)) {
            ln_y = Math.min(ln_y, yMax);
            System.out.println("new y (after yMax=" + yMax + "): " + Math.exp(ln_y));
        }
        Preconditions.checkState((boolean)Doubles.isFinite((double)ln_y));
        return u_lnX + ln_y;
    }

    @Override
    public double getModStdDev(ScalarIMR imr) {
        StringParameter imrTypeParam = (StringParameter)imr.getParameter("Std Dev Type");
        String origIMRType = (String)imrTypeParam.getValue();
        imrTypeParam.setValue("Inter-Event");
        double interStdDev = imr.getStdDev();
        System.out.println("Orig inter event, tau=" + interStdDev);
        imrTypeParam.setValue("Intra-Event");
        double intraStdDev = imr.getStdDev();
        System.out.println("Orig intra event, phi=" + intraStdDev);
        imrTypeParam.setValue(origIMRType);
        double[] params = this.getCurParams();
        double f2 = params[this.periodParams.getParamIndex(Params.F2)];
        double f3 = params[this.periodParams.getParamIndex(Params.F3)];
        double F = params[this.periodParams.getParamIndex(Params.F)];
        double phiS2S = params[this.periodParams.getParamIndex(Params.PHI_S2S)];
        double phiLnY = params[this.periodParams.getParamIndex(Params.PHI_lnY)];
        System.out.println("Calculating std dev with f2=" + f2 + ", f3=" + f3 + ", F=" + F + ", phiS2S=" + phiS2S + ", phiLnY=" + phiLnY);
        imr.setIntensityMeasure("PGA");
        double x_ref_ln = imr.getMean();
        double x_ref = Math.exp(x_ref_ln);
        System.out.println("x_ref=" + x_ref);
        imr.setIntensityMeasure(this.imt);
        double term1 = Math.pow(f2 * x_ref / (x_ref + f3) + 1.0, 2.0);
        double phi_lnZ = Math.sqrt(term1 * (intraStdDev * intraStdDev - F * phiS2S * phiS2S) + phiLnY * phiLnY);
        System.out.println("phi_lnZ=" + phi_lnZ);
        return Math.sqrt(phi_lnZ * phi_lnZ + interStdDev * interStdDev);
    }

    @Override
    public ParameterList getModParams() {
        return this.paramList;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        System.out.println("Period params change, clearing");
        this.curParamValues = null;
    }

    public static void main(String[] args) {
        new StewartSiteSpecificMod();
    }

    public static enum Params {
        F1("f1"),
        F2("f2"),
        F3("f3"),
        PHI_lnY("\u03d5 lnY"),
        PHI_S2S("\u03d5 S2S"),
        F("F"),
        Ymax("Ymax");

        private String name;

        private Params(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

