/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.param.EqkRuptureParams;

import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.impl.WarningDoubleParameter;

public class RupWidthParam
extends WarningDoubleParameter {
    public static final String NAME = "Down-Dip Width";
    public static final String UNITS = "km";
    public static final String INFO = "Down-dip width of the rupture";
    public static final Double MIN = 0.0;
    public static final Double MAX = 200.0;

    public RupWidthParam(double minWarning, double maxWarning, double defaultWidth) {
        super(NAME, new DoubleConstraint(Math.min(MIN, minWarning), Math.max(MAX, maxWarning)));
        this.getConstraint().setNonEditable();
        DoubleConstraint warn = new DoubleConstraint(minWarning, maxWarning);
        warn.setNonEditable();
        this.setWarningConstraint(warn);
        this.setInfo(INFO);
        this.setDefaultValue(defaultWidth);
        this.setNonEditable();
    }

    public RupWidthParam(double minWarning, double maxWarning) {
        this(minWarning, maxWarning, 10.0);
    }

    public RupWidthParam(double defaultWidth) {
        super(NAME, new DoubleConstraint(MIN, MAX), UNITS);
        this.getConstraint().setNonEditable();
        this.setInfo(INFO);
        this.setDefaultValue(defaultWidth);
    }

    public RupWidthParam() {
        this(10.0);
    }
}

