/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.param.OtherParams;

import java.util.ArrayList;
import java.util.Collection;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.util.TectonicRegionType;

public class TectonicRegionTypeParam
extends StringParameter {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "Tectonic Region";
    public static final String INFO = "Applicable Tectonic Region(s) - not strictly enforced";

    public TectonicRegionTypeParam() {
        this(TectonicRegionType.ACTIVE_SHALLOW);
    }

    public TectonicRegionTypeParam(TectonicRegionType ... types) {
        super(NAME);
        StringConstraint options = new StringConstraint();
        for (TectonicRegionType trt : types) {
            options.addString(trt.toString());
        }
        this.setConstraint(options);
        this.setInfo(INFO);
        this.setDefaultValue(types[0].toString());
    }

    public TectonicRegionTypeParam(StringConstraint options, String defaultValue) {
        super(NAME, options);
        ArrayList<String> strings = options.getAllowedStrings();
        for (int i = 0; i < strings.size(); ++i) {
            if (TectonicRegionType.isValidType(strings.get(i))) continue;
            throw new RuntimeException("Constraint type not supported by TectonicRegionTypeParam");
        }
        this.setInfo(INFO);
        this.setDefaultValue(defaultValue);
    }

    private static StringConstraint toStringConst(Collection<TectonicRegionType> options) {
        StringConstraint sconst = new StringConstraint();
        for (TectonicRegionType trt : options) {
            sconst.addString(trt.toString());
        }
        return sconst;
    }

    public TectonicRegionTypeParam(Collection<TectonicRegionType> options, TectonicRegionType defaultValue) {
        this(TectonicRegionTypeParam.toStringConst(options), defaultValue.toString());
    }

    @Override
    public void setValue(TectonicRegionType trt) {
        super.setValue(trt.toString());
    }

    public TectonicRegionType getValueAsTRT() {
        return TectonicRegionType.getTypeForName((String)this.getValue());
    }

    public static boolean isTypePotentiallySupported(String option) {
        return TectonicRegionType.isValidType(option);
    }
}

