/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.param.PropagationEffectParams;

import org.dom4j.Element;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.MeanUCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.imr.param.PropagationEffectParams.AbstractDoublePropEffectParam;

public class DistanceX_Parameter
extends AbstractDoublePropEffectParam {
    protected static final String C = "DistanceJBParameter";
    protected static final boolean D = false;
    public static final String NAME = "DistanceX";
    private static final String UNITS = "km";
    private static final String INFO = "Horizontal distance to top edge of rupture, measured ppd to strike; neg valuse are on the foot wall";
    private static final Double MIN = -1.7976931348623157E308;
    private static final Double MAX = Double.MAX_VALUE;

    public DistanceX_Parameter() {
        super(NAME);
        this.init();
    }

    public DistanceX_Parameter(double defaultValue) {
        super(NAME);
        this.init();
        this.setDefaultValue(defaultValue);
    }

    public DistanceX_Parameter(ParameterConstraint warningConstraint) throws ConstraintException {
        super(NAME);
        if (warningConstraint != null && !(warningConstraint instanceof DoubleConstraint)) {
            throw new ConstraintException("DistanceJBParameter : Constructor(): Input constraint must be a DoubleConstraint");
        }
        this.init((DoubleConstraint)warningConstraint);
    }

    public DistanceX_Parameter(ParameterConstraint warningConstraint, double defaultValue) throws ConstraintException {
        super(NAME);
        if (warningConstraint != null && !(warningConstraint instanceof DoubleConstraint)) {
            throw new ConstraintException("DistanceJBParameter : Constructor(): Input constraint must be a DoubleConstraint");
        }
        this.init((DoubleConstraint)warningConstraint);
        this.setDefaultValue(defaultValue);
    }

    protected void init(DoubleConstraint warningConstraint) {
        this.warningConstraint = warningConstraint;
        this.constraint = new DoubleConstraint(MIN, MAX);
        this.constraint.setNullAllowed(false);
        this.name = NAME;
        this.constraint.setName(this.name);
        this.units = UNITS;
        this.info = INFO;
    }

    protected void init() {
        this.init(null);
    }

    @Override
    protected void calcValueFromSiteAndEqkRup() {
        if (this.site != null && this.eqkRupture != null) {
            this.setValueIgnoreWarning(this.eqkRupture.getRuptureSurface().getDistanceX(this.site.getLocation()));
        } else {
            this.setValue(null);
        }
    }

    @Override
    public String getType() {
        Object type = "DoubleParameter";
        ParameterConstraint constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + (String)type;
        }
        return type;
    }

    @Override
    public Object clone() {
        DoubleConstraint c1 = null;
        DoubleConstraint c2 = null;
        if (this.constraint != null) {
            c1 = (DoubleConstraint)this.constraint.clone();
        }
        if (this.warningConstraint != null) {
            c2 = (DoubleConstraint)this.warningConstraint.clone();
        }
        Double val = null;
        Double val2 = null;
        if (this.value != null) {
            val = (Double)this.value;
            val2 = (double)val;
        }
        DistanceX_Parameter param = new DistanceX_Parameter();
        param.info = this.info;
        param.value = val2;
        param.constraint = c1;
        param.warningConstraint = c2;
        param.name = this.name;
        param.info = this.info;
        param.site = this.site;
        param.eqkRupture = this.eqkRupture;
        if (!this.editable) {
            param.setNonEditable();
        }
        return param;
    }

    @Override
    public boolean setIndividualParamValueFromXML(Element el) {
        return false;
    }

    public static void main(String[] args) {
        MeanUCERF2 meanUCERF2 = new MeanUCERF2();
        meanUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        meanUCERF2.updateForecast();
        ProbEqkRupture sierraMadreRup = meanUCERF2.getSource(271).getRupture(meanUCERF2.getSource(271).getNumRuptures() - 1);
        Site site = new Site();
        site.setLocation(sierraMadreRup.getRuptureSurface().getFirstLocOnUpperEdge());
        DistanceX_Parameter distX = new DistanceX_Parameter();
        distX.setValue(sierraMadreRup, site);
    }
}

