/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.magdist;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.JsonAdapter;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.function.XY_DataSetList;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

@JsonAdapter(value=Adapter.class)
public class SummedMagFreqDist
extends IncrementalMagFreqDist {
    private boolean saveMagFreqDists = false;
    private boolean saveAllInfo = false;
    private XY_DataSetList savedMagFreqDists;
    private ArrayList savedInfoList;
    public static String NAME = "Summed Dist";

    public SummedMagFreqDist(double min, int num, double delta) throws InvalidRangeException {
        super(min, num, delta);
    }

    public SummedMagFreqDist(double min, double max, int num) throws InvalidRangeException {
        super(min, max, num);
    }

    public SummedMagFreqDist(double min, int num, double delta, boolean saveMagFreqDist, boolean saveAllInfo) throws InvalidRangeException {
        super(min, num, delta);
        this.saveMagFreqDists = saveMagFreqDist;
        this.saveAllInfo = saveAllInfo;
        if (this.saveMagFreqDists) {
            this.savedMagFreqDists = new XY_DataSetList();
        } else if (saveAllInfo) {
            this.savedInfoList = new ArrayList();
        }
    }

    public SummedMagFreqDist(double min, double max, int num, boolean saveMagFreqDist, boolean saveAllInfo) throws InvalidRangeException {
        super(min, max, num);
        this.saveMagFreqDists = saveMagFreqDist;
        this.saveAllInfo = saveAllInfo;
        if (this.saveMagFreqDists) {
            this.savedMagFreqDists = new XY_DataSetList();
        } else if (saveAllInfo) {
            this.savedInfoList = new ArrayList();
        }
    }

    public void addIncrementalMagFreqDist(EvenlyDiscretizedFunc magFreqDist) {
        this.addIncrementalMagFreqDist(magFreqDist, 1.0);
    }

    public void addIncrementalMagFreqDist(EvenlyDiscretizedFunc magFreqDist, double scalar) {
        if (magFreqDist.size() > 1 && Math.abs(this.getDelta() - magFreqDist.getDelta()) > this.tolerance) {
            throw new IllegalArgumentException("SummedMagFreqDist.addIncrementalMagFreqDist() error: deltas differ by more then tolerance; ours=" + (float)this.getDelta() + ", theirs=" + (float)magFreqDist.getDelta() + ", tol=" + (float)this.tolerance);
        }
        for (int i = 0; i < magFreqDist.size(); ++i) {
            double xVal = magFreqDist.getX(i);
            int indexHere = this.getXIndex(xVal);
            if (indexHere == -1) continue;
            super.set(xVal, this.getY(indexHere) + magFreqDist.getY(i) * scalar);
        }
        if (this.saveMagFreqDists) {
            this.savedMagFreqDists.add(magFreqDist);
        } else if (this.saveAllInfo) {
            this.savedInfoList.add(magFreqDist.getInfo());
        }
    }

    public void subtractIncrementalMagFreqDist(IncrementalMagFreqDist magFreqDist) {
        if (Math.abs(this.getDelta() - magFreqDist.getDelta()) > this.tolerance) {
            throw new IllegalArgumentException("SummedMagFreqDist.addIncrementalMagFreqDist() error: deltas differ by more then tolerance");
        }
        for (int i = 0; i < magFreqDist.size(); ++i) {
            double xVal = magFreqDist.getX(i);
            if (!(this.getMinX() - this.tolerance < xVal) || !(xVal < this.getMaxX() + this.tolerance)) continue;
            double newY = this.getY(xVal) - magFreqDist.getY(i);
            if (newY < 0.0) {
                newY = 0.0;
            }
            super.set(xVal, newY);
        }
        if (this.saveMagFreqDists) {
            this.savedMagFreqDists.add(magFreqDist);
        } else if (this.saveAllInfo) {
            this.savedInfoList.add(magFreqDist.getInfo());
        }
    }

    public void addResampledMagFreqDist(DiscretizedFunc func, boolean preserveRates) {
        for (int i = 0; i < func.size(); ++i) {
            this.addResampledMagRate(func.getX(i), func.getY(i), preserveRates);
        }
        if (this.saveMagFreqDists) {
            this.savedMagFreqDists.add(func);
        } else if (this.saveAllInfo) {
            this.savedInfoList.add(func.getInfo());
        }
    }

    public void addResampledMagRate(double mag, double rate, boolean preserveRates) {
        int index = (int)Math.round((mag - this.minX) / this.delta);
        if (!this.isIndexWithinRange(index)) {
            return;
        }
        if (preserveRates) {
            super.set(index, this.getY(index) + rate);
        } else {
            double newRate = rate * MagUtils.magToMoment(mag) / MagUtils.magToMoment(this.getX(index));
            super.set(index, this.getY(index) + newRate);
        }
    }

    @Override
    public void set(Point2D point) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(double x, double y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(int index, double y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void scale(double val) {
        for (int i = 0; i < this.size(); ++i) {
            super.set(i, val * this.getY(i));
        }
    }

    public void removeIncrementalMagFreqDist(IncrementalMagFreqDist magFreqDist) {
        int index;
        if (this.saveMagFreqDists) {
            index = this.savedMagFreqDists.indexOf(magFreqDist);
            if (index == -1) {
                throw new IllegalArgumentException("this distribution does not exist");
            }
            this.savedMagFreqDists.remove(magFreqDist);
        } else if (this.saveAllInfo) {
            index = this.savedInfoList.indexOf(magFreqDist.getInfo());
            if (index == -1) {
                throw new IllegalArgumentException("this distribution does not exist");
            }
            this.savedInfoList.remove(magFreqDist.getInfo());
        } else {
            throw new IllegalArgumentException("Distributions are not saved");
        }
        for (int i = 0; i < this.num; ++i) {
            super.set(i, this.getY(i) - magFreqDist.getY(i));
        }
    }

    public ArrayList getAllInfo() {
        if (this.saveMagFreqDists) {
            ArrayList<String> infoVector = new ArrayList<String>();
            for (int i = 0; i < this.savedMagFreqDists.size(); ++i) {
                infoVector.add(((XY_DataSet)this.savedMagFreqDists.get(i)).getInfo());
            }
            return infoVector;
        }
        if (this.saveAllInfo) {
            return this.savedInfoList;
        }
        return null;
    }

    public XY_DataSetList getMagFreqDists() {
        return this.savedMagFreqDists;
    }

    @Override
    public String getDefaultName() {
        return NAME;
    }

    @Override
    public String getDefaultInfo() {
        return "Sum of these Incremental Mag-Freq Dists";
    }

    public static class Adapter
    extends IncrementalMagFreqDist.GenericAdapter<SummedMagFreqDist> {
        @Override
        protected SummedMagFreqDist instance(Double minX, Double maxX, Integer size) {
            Preconditions.checkNotNull((Object)minX, (Object)"minX must be supplied before values to deserialize EvenlyDiscretizedFunc");
            Preconditions.checkNotNull((Object)maxX, (Object)"maxX must be supplied before values to deserialize EvenlyDiscretizedFunc");
            Preconditions.checkNotNull((Object)size, (Object)"size must be supplied before values to deserialize EvenlyDiscretizedFunc");
            return new SummedMagFreqDist(minX, maxX, size){

                @Override
                public void set(double x, double y) {
                    int index = this.getXIndex(x);
                    this.points[index] = y;
                }
            };
        }

        @Override
        protected Class<SummedMagFreqDist> getType() {
            return SummedMagFreqDist.class;
        }
    }
}

