/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.magdist.gui;

import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWidget;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotElement;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SingleMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.magdist.TaperedGR_MagFreqDist;
import org.opensha.sha.magdist.YC_1985_CharMagFreqDist;
import org.opensha.sha.param.MagFreqDistParameter;
import org.opensha.sha.param.MagPDF_Parameter;
import org.opensha.sha.param.editor.MagDistParameterEditorAPI;
import org.opensha.sha.param.editor.MagFreqDistParameterEditor;
import org.opensha.sha.param.editor.MagPDF_ParameterEditor;

public class MagFreqDistAppWindow
extends JFrame
implements ParameterChangeListener {
    private JSplitPane mainSplitPane = new JSplitPane();
    private JSplitPane plotSplitPane = new JSplitPane();
    private JTabbedPane plotTabPane = new JTabbedPane();
    private JPanel editorPanel = new JPanel();
    private JPanel MagSelectionEditorPanel;
    private JPanel buttonPanel = new JPanel();
    private JPanel incrRatePlotPanel = new JPanel();
    private JPanel momentRatePlotPanel = new JPanel();
    private JPanel cumRatePlotPanel = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private FlowLayout flowLayout1 = new FlowLayout();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JButton addButton = new JButton();
    protected static final int W = 870;
    protected static final int H = 750;
    private final boolean D = false;
    private GraphWidget incrRateGraphPanel;
    private GraphWidget momentRateGraphPanel;
    private GraphWidget cumRateGraphPanel;
    private JSplitPane paramSplitPane = new JSplitPane();
    private String incrRateXAxisName = "Magnitude";
    private String incrRateYAxisName = "Incremental Rate";
    private String cumRateXAxisName = "Magnitude";
    private String cumRateYAxisName = "Cumulative Rate";
    private String momentRateXAxisName = "Magnitude";
    private String momentRateYAxisName = "Moment Rate";
    private boolean isIncrRatePlot;
    private boolean isMomentRatePlot;
    private boolean isCumRatePlot;
    private JButton peelOffButton = new JButton();
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu();
    private JMenuItem fileExitMenu = new JMenuItem();
    private JMenuItem fileSaveMenu = new JMenuItem();
    private JMenuItem filePrintMenu = new JCheckBoxMenuItem();
    private JToolBar jToolBar = new JToolBar();
    private JButton closeButton = new JButton();
    private ImageIcon closeFileImage = new ImageIcon(FileUtils.loadImage("icons/closeFile.png"));
    private JButton printButton = new JButton();
    private ImageIcon printFileImage = new ImageIcon(FileUtils.loadImage("icons/printFile.jpg"));
    private JButton saveButton = new JButton();
    ImageIcon saveFileImage = new ImageIcon(FileUtils.loadImage("icons/saveFile.jpg"));
    private static final String POWERED_BY_IMAGE = "logos/PoweredByOpenSHA_Agua.jpg";
    private JLabel imgLabel = new JLabel(new ImageIcon(FileUtils.loadImage("logos/PoweredByOpenSHA_Agua.jpg")));
    private JButton clearButton = new JButton();
    private MagDistParameterEditorAPI magDistEditor;
    private MagFreqDistParameterEditor magFreqDistEditor;
    private MagPDF_ParameterEditor magPDF_Editor;
    private JCheckBox jCheckSumDist = new JCheckBox();
    private ArrayList<PlotElement> incrRateFunctionList = new ArrayList();
    private ArrayList<PlotElement> cumRateFunctionList = new ArrayList();
    private ArrayList<PlotElement> momentRateFunctionList = new ArrayList();
    private static final String textString = "(Last Plotted Dist. gets used, Summed Dist. gets used if selected)";
    private JLabel textLabel = new JLabel("(Last Plotted Dist. gets used, Summed Dist. gets used if selected)");
    private String incrRatePlotTitle = "";
    private String cumRatePlotTitle = "";
    private String momentRatePlotTitle = "";
    private int numFunctionsWithoutSumDist;
    private static final String MAG_DIST_PARAM_SELECTOR_NAME = "Mag. Dist. Type";
    private static final String MAG_FREQ_DIST = "Mag. Freq. Dist";
    private static final String MAG_PDF_PARAM = "Mag. PDF";
    private StringParameter stParam;
    private SummedMagFreqDist summedMagFreqDist;

    public MagFreqDistAppWindow() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.addButton.setText("Plot-Dist");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MagFreqDistAppWindow.this.addButton_actionPerformed(e);
            }
        });
        this.peelOffButton.setText("Peel-Off");
        this.peelOffButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MagFreqDistAppWindow.this.peelOffButton_actionPerformed(e);
            }
        });
        this.clearButton.setText("Clear-Plot");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MagFreqDistAppWindow.this.clearButton_actionPerformed(e);
            }
        });
        this.fileMenu.setText("File");
        this.fileExitMenu.setText("Exit");
        this.fileSaveMenu.setText("Save");
        this.filePrintMenu.setText("Print");
        this.fileExitMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MagFreqDistAppWindow.this.fileExitMenu_actionPerformed(e);
            }
        });
        this.fileSaveMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MagFreqDistAppWindow.this.fileSaveMenu_actionPerformed(e);
            }
        });
        this.filePrintMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MagFreqDistAppWindow.this.filePrintMenu_actionPerformed(e);
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MagFreqDistAppWindow.this.closeButton_actionPerformed(actionEvent);
            }
        });
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MagFreqDistAppWindow.this.printButton_actionPerformed(actionEvent);
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MagFreqDistAppWindow.this.saveButton_actionPerformed(actionEvent);
            }
        });
        this.menuBar.add(this.fileMenu);
        this.fileMenu.add(this.fileSaveMenu);
        this.fileMenu.add(this.filePrintMenu);
        this.fileMenu.add(this.fileExitMenu);
        this.setJMenuBar(this.menuBar);
        this.closeButton.setIcon(this.closeFileImage);
        this.closeButton.setToolTipText("Exit Application");
        Dimension d = this.closeButton.getSize();
        this.jToolBar.add(this.closeButton);
        this.printButton.setIcon(this.printFileImage);
        this.printButton.setToolTipText("Print Graph");
        this.printButton.setSize(d);
        this.jToolBar.add(this.printButton);
        this.saveButton.setIcon(this.saveFileImage);
        this.saveButton.setToolTipText("Save Graph as image");
        this.saveButton.setSize(d);
        this.jToolBar.add(this.saveButton);
        this.jToolBar.setFloatable(false);
        this.getContentPane().add((Component)this.jToolBar, "North");
        this.mainSplitPane.setOrientation(0);
        this.plotSplitPane.setOrientation(1);
        this.editorPanel.setLayout(this.gridBagLayout1);
        this.buttonPanel.setLayout(this.flowLayout1);
        this.plotSplitPane.add((Component)this.plotTabPane, "left");
        this.mainSplitPane.add((Component)this.plotSplitPane, "top");
        this.plotSplitPane.add((Component)this.paramSplitPane, "right");
        this.mainSplitPane.add((Component)this.buttonPanel, "bottom");
        this.paramSplitPane.setOrientation(0);
        this.paramSplitPane.setDividerLocation(200);
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
        this.plotSplitPane.setDividerLocation(600);
        this.mainSplitPane.setDividerLocation(570);
        this.incrRatePlotPanel.setLayout(this.gridBagLayout1);
        this.momentRatePlotPanel.setLayout(this.gridBagLayout1);
        this.cumRatePlotPanel.setLayout(this.gridBagLayout1);
        this.plotTabPane.add("Incremental-Rate", this.incrRatePlotPanel);
        this.plotTabPane.add("Cumulative-Rate", this.cumRatePlotPanel);
        this.plotTabPane.add("Moment-Rate", this.momentRatePlotPanel);
        this.plotTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MagFreqDistAppWindow.this.plotTabPane_stateChanged(e);
            }
        });
        this.jCheckSumDist.setForeground(Color.black);
        this.jCheckSumDist.setText("Summed Dist");
        this.jCheckSumDist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MagFreqDistAppWindow.this.jCheckSumDist_actionPerformed(e);
            }
        });
        this.jCheckSumDist.setVisible(false);
        this.buttonPanel.add((Component)this.jCheckSumDist, 0);
        this.buttonPanel.add((Component)this.addButton, 1);
        this.buttonPanel.add((Component)this.clearButton, 2);
        this.buttonPanel.add((Component)this.peelOffButton, 3);
        this.buttonPanel.add((Component)this.imgLabel, 4);
        this.buttonPanel.add((Component)this.textLabel, 5);
        this.incrRateGraphPanel = new GraphWidget();
        this.cumRateGraphPanel = new GraphWidget();
        this.momentRateGraphPanel = new GraphWidget();
        this.setSize(870, 750);
        Dimension dm = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dm.width - this.getSize().width) / 2, (dm.height - this.getSize().height) / 2);
        this.setTitle("Magnitude Frequency Distribution Application");
        this.incrRatePlotPanel.removeAll();
        this.cumRatePlotPanel.removeAll();
        this.momentRatePlotPanel.removeAll();
        this.incrRatePlotPanel.add((Component)this.incrRateGraphPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.incrRatePlotPanel.validate();
        this.incrRatePlotPanel.repaint();
        this.cumRatePlotPanel.add((Component)this.cumRateGraphPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.cumRatePlotPanel.validate();
        this.cumRatePlotPanel.repaint();
        this.momentRatePlotPanel.add((Component)this.momentRateGraphPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.momentRatePlotPanel.validate();
        this.momentRatePlotPanel.repaint();
        this.setVisible(true);
    }

    void initMagParamEditor() {
        ArrayList<String> magParamTypes = new ArrayList<String>();
        magParamTypes.add(MAG_FREQ_DIST);
        magParamTypes.add(MAG_PDF_PARAM);
        this.stParam = new StringParameter(MAG_DIST_PARAM_SELECTOR_NAME, magParamTypes, (String)magParamTypes.get(0));
        ConstrainedStringParameterEditor stParamEditor = new ConstrainedStringParameterEditor(this.stParam);
        this.stParam.addParameterChangeListener(this);
        this.MagSelectionEditorPanel = new JPanel();
        this.MagSelectionEditorPanel.setLayout(this.gridBagLayout1);
        this.MagSelectionEditorPanel.add((Component)stParamEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.MagSelectionEditorPanel.validate();
        this.MagSelectionEditorPanel.repaint();
        this.paramSplitPane.add((Component)this.MagSelectionEditorPanel, "top");
        this.setDefaultCloseOperation(3);
    }

    void createMagParam() {
        String magTypeSelected = (String)this.stParam.getValue();
        if (magTypeSelected.equals(MAG_FREQ_DIST)) {
            if (this.magFreqDistEditor == null) {
                ArrayList<String> distNames = new ArrayList<String>();
                distNames.add(SingleMagFreqDist.NAME);
                distNames.add(GutenbergRichterMagFreqDist.NAME);
                distNames.add(TaperedGR_MagFreqDist.NAME);
                distNames.add(GaussianMagFreqDist.NAME);
                distNames.add(YC_1985_CharMagFreqDist.NAME);
                distNames.add(SummedMagFreqDist.NAME);
                distNames.add(ArbIncrementalMagFreqDist.NAME);
                String MAG_DIST_PARAM_NAME = "Mag Dist Param";
                MagFreqDistParameter magDist = new MagFreqDistParameter(MAG_DIST_PARAM_NAME, distNames);
                this.magFreqDistEditor = new MagFreqDistParameterEditor();
                this.magFreqDistEditor.setParameter((Parameter)magDist);
                this.magFreqDistEditor.setMagFreqDistParamButtonVisible(false);
            } else {
                this.editorPanel.remove(this.magDistEditor.getMagFreqDistParameterEditor());
            }
            this.setMagDistEditor(this.magFreqDistEditor);
        } else {
            this.editorPanel.remove(this.magDistEditor.getMagFreqDistParameterEditor());
            this.makeSumDistVisible(false);
            if (this.magPDF_Editor == null) {
                String MAG_DIST_PARAM_NAME = "Mag Dist Param";
                ArrayList<String> distNames = new ArrayList<String>();
                distNames.add(SingleMagFreqDist.NAME);
                distNames.add(GutenbergRichterMagFreqDist.NAME);
                distNames.add(GaussianMagFreqDist.NAME);
                distNames.add(YC_1985_CharMagFreqDist.NAME);
                distNames.add(ArbIncrementalMagFreqDist.NAME);
                MagPDF_Parameter magDist = new MagPDF_Parameter(MAG_DIST_PARAM_NAME, distNames);
                this.magPDF_Editor = new MagPDF_ParameterEditor();
                this.magPDF_Editor.setParameter((Parameter)magDist);
                this.magPDF_Editor.setMagFreqDistParamButtonVisible(false);
            }
            this.setMagDistEditor(this.magPDF_Editor);
        }
        this.magDistEditor.refreshParamEditor();
    }

    public void setMagDistEditor(MagDistParameterEditorAPI magDistEditor) {
        this.magDistEditor = magDistEditor;
        ParameterListEditor listEditor = magDistEditor.createMagFreqDistParameterEditor();
        Parameter distParam = listEditor.getParameterEditor("Distribution Type").getParameter();
        distParam.addParameterChangeListener(this);
        List allowedVals = ((StringConstraint)listEditor.getParameterEditor("Distribution Type").getParameter().getConstraint()).getAllowedValues();
        if (((ArrayList)allowedVals).contains(SummedMagFreqDist.NAME)) {
            this.makeSumDistVisible(true);
        }
        this.editorPanel.add((Component)listEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        if (this.MagSelectionEditorPanel == null) {
            this.paramSplitPane.setDividerLocation(0);
            this.paramSplitPane.setOneTouchExpandable(false);
        }
        this.paramSplitPane.add((Component)this.editorPanel, "bottom");
        this.editorPanel.validate();
        this.editorPanel.repaint();
    }

    public void makeSumDistVisible(boolean toShow) {
        this.jCheckSumDist.setVisible(toShow);
    }

    void jCheckSumDist_actionPerformed(ActionEvent e) {
        if (this.jCheckSumDist.isSelected()) {
            this.magDistEditor.setSummedDistPlotted(true);
            double min = this.magDistEditor.getMin();
            double max = this.magDistEditor.getMax();
            int num = this.magDistEditor.getNum();
            this.summedMagFreqDist = new SummedMagFreqDist(min, max, num);
            int size = this.incrRateFunctionList.size();
            try {
                for (int i = 0; i < size; ++i) {
                    this.summedMagFreqDist.addIncrementalMagFreqDist((IncrementalMagFreqDist)this.incrRateFunctionList.get(i));
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "min, max, and num must be the same to sum the distributions");
                this.jCheckSumDist.setSelected(false);
                return;
            }
            this.insertSummedDistribution();
        } else {
            this.magDistEditor.setSummedDistPlotted(false);
            if (this.incrRateFunctionList.size() > 0) {
                this.incrRateFunctionList.remove(this.incrRateFunctionList.size() - 1);
                this.cumRateFunctionList.remove(this.cumRateFunctionList.size() - 1);
                this.momentRateFunctionList.remove(this.momentRateFunctionList.size() - 1);
                List<PlotCurveCharacterstics> incrPlotFeaturesList = this.incrRateGraphPanel.getPlottingFeatures();
                List<PlotCurveCharacterstics> cumPlotFeaturesList = this.cumRateGraphPanel.getPlottingFeatures();
                List<PlotCurveCharacterstics> momentPlotFeaturesList = this.momentRateGraphPanel.getPlottingFeatures();
                incrPlotFeaturesList.remove(incrPlotFeaturesList.size() - 1);
                cumPlotFeaturesList.remove(cumPlotFeaturesList.size() - 1);
                momentPlotFeaturesList.remove(momentPlotFeaturesList.size() - 1);
            }
        }
        this.addGraphPanel();
    }

    private void addGraphPanel() {
        String S = ": addGraphPanel(): ";
        PlotSpec incrSpec = this.incrRateGraphPanel.getPlotSpec();
        incrSpec.setXAxisLabel(this.incrRateXAxisName);
        incrSpec.setYAxisLabel(this.incrRateYAxisName);
        incrSpec.setPlotElems(this.incrRateFunctionList);
        incrSpec.setTitle(this.incrRatePlotTitle);
        this.incrRateGraphPanel.drawGraph();
        PlotSpec cumSpec = this.cumRateGraphPanel.getPlotSpec();
        cumSpec.setXAxisLabel(this.cumRateXAxisName);
        cumSpec.setYAxisLabel(this.cumRateYAxisName);
        cumSpec.setPlotElems(this.cumRateFunctionList);
        cumSpec.setTitle(this.cumRatePlotTitle);
        this.cumRateGraphPanel.drawGraph();
        PlotSpec momentSpec = this.momentRateGraphPanel.getPlotSpec();
        momentSpec.setXAxisLabel(this.momentRateXAxisName);
        momentSpec.setYAxisLabel(this.momentRateYAxisName);
        momentSpec.setPlotElems(this.momentRateFunctionList);
        momentSpec.setTitle(this.momentRatePlotTitle);
        this.momentRateGraphPanel.drawGraph();
    }

    private void insertSummedDistribution() {
        this.incrRateFunctionList.add(this.summedMagFreqDist);
        this.cumRateFunctionList.add(this.summedMagFreqDist.getCumRateDist());
        this.momentRateFunctionList.add(this.summedMagFreqDist.getMomentRateDist());
        String metadata = "\n" + ((EvenlyDiscretizedFunc)this.incrRateFunctionList.get(this.incrRateFunctionList.size() - 1)).getInfo() + "\n";
        for (int i = 0; i < this.incrRateFunctionList.size() - 1; ++i) {
            metadata = metadata + (i + 1) + ")" + ((EvenlyDiscretizedFunc)this.incrRateFunctionList.get(i)).getInfo() + "\n";
        }
        this.magDistEditor.setMagDistFromParams(this.summedMagFreqDist, metadata);
        this.addGraphPanel();
        List<PlotCurveCharacterstics> incrPlotFeaturesList = this.incrRateGraphPanel.getPlottingFeatures();
        List<PlotCurveCharacterstics> cumPlotFeaturesList = this.cumRateGraphPanel.getPlottingFeatures();
        List<PlotCurveCharacterstics> momentPlotFeaturesList = this.momentRateGraphPanel.getPlottingFeatures();
        incrPlotFeaturesList.set(incrPlotFeaturesList.size() - 1, new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, null, 4.0f, Color.BLACK));
        cumPlotFeaturesList.set(incrPlotFeaturesList.size() - 1, new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, null, 4.0f, Color.BLACK));
        momentPlotFeaturesList.set(incrPlotFeaturesList.size() - 1, new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, null, 4.0f, Color.BLACK));
        this.addGraphPanel();
    }

    private void plotTabPane_stateChanged(ChangeEvent e) {
        JTabbedPane pane = (JTabbedPane)e.getSource();
        int index = pane.getSelectedIndex();
        if (index == 0) {
            this.isCumRatePlot = false;
            this.isIncrRatePlot = true;
            this.isMomentRatePlot = false;
        } else if (index == 1) {
            this.isCumRatePlot = true;
            this.isIncrRatePlot = false;
            this.isMomentRatePlot = false;
        } else if (index == 2) {
            this.isCumRatePlot = false;
            this.isIncrRatePlot = false;
            this.isMomentRatePlot = true;
        }
    }

    void addButton_actionPerformed(ActionEvent e) {
        this.addButton();
    }

    private void addButton() {
        try {
            if (this.magDistEditor instanceof MagFreqDistParameterEditor) {
                this.magDistEditor.setSummedDistPlotted(false);
            }
            this.magDistEditor.setMagDistFromParams();
            Object magDistMetadata = this.magDistEditor.getMagFreqDistParameterEditor().getVisibleParametersCloned().getParameterListMetadataString();
            IncrementalMagFreqDist function = (IncrementalMagFreqDist)this.magDistEditor.getParameter().getValue();
            magDistMetadata = (String)magDistMetadata + "\n\n" + function.getInfo();
            function.setInfo((String)magDistMetadata);
            function.setName("Incremental MFD");
            EvenlyDiscretizedFunc cumRateFunction = function.getCumRateDist();
            cumRateFunction.setInfo((String)magDistMetadata);
            cumRateFunction.setName("Cumulative MFD");
            EvenlyDiscretizedFunc moRateFunction = function.getMomentRateDist();
            moRateFunction.setInfo((String)magDistMetadata);
            moRateFunction.setName("Moment Rate Distribution");
            int size = this.incrRateFunctionList.size();
            if (size == this.numFunctionsWithoutSumDist + 1) {
                this.incrRateFunctionList.remove(this.incrRateFunctionList.size() - 1);
                this.cumRateFunctionList.remove(this.cumRateFunctionList.size() - 1);
                this.momentRateFunctionList.remove(this.momentRateFunctionList.size() - 1);
                List<PlotCurveCharacterstics> incrPlotFeaturesList = this.incrRateGraphPanel.getPlottingFeatures();
                List<PlotCurveCharacterstics> cumPlotFeaturesList = this.cumRateGraphPanel.getPlottingFeatures();
                List<PlotCurveCharacterstics> momentPlotFeaturesList = this.momentRateGraphPanel.getPlottingFeatures();
                incrPlotFeaturesList.remove(incrPlotFeaturesList.size() - 1);
                cumPlotFeaturesList.remove(cumPlotFeaturesList.size() - 1);
                momentPlotFeaturesList.remove(momentPlotFeaturesList.size() - 1);
            }
            this.incrRateFunctionList.add(function);
            this.cumRateFunctionList.add(cumRateFunction);
            this.momentRateFunctionList.add(moRateFunction);
            this.numFunctionsWithoutSumDist = this.momentRateFunctionList.size();
            if (this.jCheckSumDist.isVisible() && this.jCheckSumDist.isSelected()) {
                try {
                    this.magDistEditor.setSummedDistPlotted(true);
                    double min = this.magDistEditor.getMin();
                    double max = this.magDistEditor.getMax();
                    int num = this.magDistEditor.getNum();
                    if (this.summedMagFreqDist == null) {
                        this.summedMagFreqDist = new SummedMagFreqDist(min, max, num);
                    }
                    this.summedMagFreqDist.addIncrementalMagFreqDist(function);
                    this.insertSummedDistribution();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "min, max, and num must be the same to sum the distributions.\n To add this distribution first deselect the Summed Dist option");
                    return;
                }
            }
            this.addGraphPanel();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, new String("Enter a Valid Numerical Value"), "Invalid Data Entered", 0);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, new String(e.getMessage()), "Invalid Data Entered", 0);
        }
    }

    void clearButton_actionPerformed(ActionEvent e) {
        this.clearPlot(true);
    }

    private void clearPlot(boolean clearFunctions) {
        int loc;
        int newLoc = loc = this.mainSplitPane.getDividerLocation();
        if (clearFunctions) {
            this.incrRateGraphPanel.removeChartAndMetadata();
            this.cumRateGraphPanel.removeChartAndMetadata();
            this.momentRateGraphPanel.removeChartAndMetadata();
            this.incrRateFunctionList.clear();
            this.cumRateFunctionList.clear();
            this.momentRateFunctionList.clear();
            this.summedMagFreqDist = null;
        }
        this.mainSplitPane.setDividerLocation(newLoc);
    }

    private void fileSaveMenu_actionPerformed(ActionEvent actionEvent) {
        try {
            this.save();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Save File Error", 0);
            return;
        }
    }

    private void filePrintMenu_actionPerformed(ActionEvent actionEvent) {
        this.print();
    }

    public void save() throws IOException {
        if (this.isIncrRatePlot) {
            this.incrRateGraphPanel.save();
        } else if (this.isCumRatePlot) {
            this.cumRateGraphPanel.save();
        } else if (this.isMomentRatePlot) {
            this.momentRateGraphPanel.save();
        }
    }

    public void print() {
        if (this.isIncrRatePlot) {
            this.incrRateGraphPanel.print();
        } else if (this.isCumRatePlot) {
            this.cumRateGraphPanel.print();
        } else if (this.isMomentRatePlot) {
            this.momentRateGraphPanel.print();
        }
    }

    private void peelOffCurves() {
        GraphWidget graphWidget = this.isCumRatePlot ? this.cumRateGraphPanel : (this.isIncrRatePlot ? this.incrRateGraphPanel : this.momentRateGraphPanel);
        GraphWindow graphWindow = new GraphWindow(graphWidget);
        graphWidget.getPlotSpec().setPlotElems(Lists.newArrayList(graphWidget.getPlotSpec().getPlotElems()));
        graphWindow.setVisible(true);
    }

    void peelOffButton_actionPerformed(ActionEvent e) {
        this.peelOffCurves();
    }

    private void fileExitMenu_actionPerformed(ActionEvent actionEvent) {
        this.close();
    }

    private void close() {
        int option = JOptionPane.showConfirmDialog(this, "Do you really want to exit the application?\nYou will loose all unsaved data.", "Exit App", 2);
        if (option == 0) {
            System.exit(0);
        }
    }

    public void closeButton_actionPerformed(ActionEvent actionEvent) {
        this.close();
    }

    public void printButton_actionPerformed(ActionEvent actionEvent) {
        this.print();
    }

    public void saveButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.save();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Save File Error", 0);
            return;
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String paramName = event.getParameterName();
        if (paramName.equals(MAG_DIST_PARAM_SELECTOR_NAME)) {
            this.createMagParam();
        }
    }
}

