/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.mapping;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.mapping.gmt.GMT_Map;
import org.opensha.commons.mapping.gmt.GMT_MapGenerator;
import org.opensha.commons.mapping.gmt.elements.PSXYPolygon;
import org.opensha.commons.mapping.gmt.elements.PSXYSymbol;
import org.opensha.commons.mapping.gmt.elements.PSXYSymbolSet;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.RunScript;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;

public class GMT_MapGeneratorForShakeMaps
extends GMT_MapGenerator {
    protected static final String C = "GMT_MapGeneratorForShakeMaps";
    public static final String OPENSHA_HAZUS_SERVLET_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "GMT_HazusMapServlet";
    protected static final boolean D = false;
    private String EQK_RUP_XYZ_FILE_NAME = "eqkRup_data.txt";
    private GeoDataSet eqkRup_xyzDataSet;
    private String DEFAULT_HAZUS_FILE_PREFIX;
    private String HAZUS_FILE_PREFIX = this.DEFAULT_HAZUS_FILE_PREFIX = "map_hazus";
    public static final String SA_10 = "sa10";
    public static final String SA_03 = "sa03";
    public static final String PGA = "pga";
    public static final String PGV = "pgv";
    private EqkRupture eqkRup;
    int counter = 0;
    private String imt;
    public static final String RUP_PLOT_PARAM_NAME = "Rupture-Surface Plotting";
    public static final String RUP_PLOT_PARAM_PERIMETER = "Draw Perimeter";
    public static final String RUP_PLOT_PARAM_POINTS = "Draw Discrete Points";
    public static final String RUP_PLOT_PARAM_NOTHING = "Draw Nothing";
    public static final String RUP_PLOT_PARAM_INFO = "The hypocenter will also be plotted (as a star) if it has been set";
    StringParameter rupPlotParam;
    public static final String HAZUS_SHAPE_PARAM_NAME = "Generate Hazus Shape Files";
    private static final String HAZUS_SHAPE_PARAM_INFO = "This will generate HAZUS shape files";
    BooleanParameter hazusShapeParam;

    public GMT_MapGeneratorForShakeMaps() {
        StringConstraint rupPlotConstraint = new StringConstraint();
        rupPlotConstraint.addString(RUP_PLOT_PARAM_PERIMETER);
        rupPlotConstraint.addString(RUP_PLOT_PARAM_POINTS);
        rupPlotConstraint.addString(RUP_PLOT_PARAM_NOTHING);
        this.rupPlotParam = new StringParameter(RUP_PLOT_PARAM_NAME, rupPlotConstraint, RUP_PLOT_PARAM_PERIMETER);
        this.rupPlotParam.setInfo(RUP_PLOT_PARAM_INFO);
        this.hazusShapeParam = new BooleanParameter(HAZUS_SHAPE_PARAM_NAME, false);
        this.hazusShapeParam.setInfo(HAZUS_SHAPE_PARAM_INFO);
        this.adjustableParams.addParameter(this.hazusShapeParam);
        this.adjustableParams.addParameter(this.rupPlotParam);
    }

    private void setFileNames(String prefix) {
        if (prefix != null) {
            this.XYZ_FILE_NAME = prefix + "_map_data.txt";
            this.PS_FILE_NAME = prefix + "_map.ps";
            this.JPG_FILE_NAME = prefix + "_map.jpg";
            this.PDF_FILE_NAME = prefix + "_map.pdf";
            this.HAZUS_FILE_PREFIX = prefix + "_" + this.DEFAULT_HAZUS_FILE_PREFIX;
        } else {
            this.GMT_SCRIPT_NAME = "map_GMT_Script.txt";
            this.XYZ_FILE_NAME = "map_data.txt";
            this.METADATA_FILE_NAME = "map_info.html";
            this.PS_FILE_NAME = "map.ps";
            this.JPG_FILE_NAME = "map.jpg";
            this.PDF_FILE_NAME = "map.pdf";
            this.HAZUS_FILE_PREFIX = this.DEFAULT_HAZUS_FILE_PREFIX;
        }
    }

    public String[] makeHazusFileSetLocally(GeoDataSet sa03DataSet, GeoDataSet sa10DataSet, GeoDataSet pgaDataSet, GeoDataSet pgvDataSet, EqkRupture eqkRupture, String metadata, String dirName) throws GMT_MapException {
        this.createMapInfoFile(metadata);
        this.eqkRup = eqkRupture;
        GMT_PATH = "/sw/bin/";
        GS_PATH = "/sw/bin/gs";
        PS2PDF_PATH = "/sw/bin/ps2pdf";
        CONVERT_PATH = "/sw/bin/convert";
        ArrayList gmtLines = new ArrayList();
        this.imt = "SA";
        this.SCALE_LABEL = SA_03;
        this.setFileNames(this.SCALE_LABEL);
        String sa_03Image = this.JPG_FILE_NAME;
        this.xyzDataSet = sa03DataSet;
        try {
            ArbDiscrGeoDataSet.writeXYZFile((XYZ_DataSet)this.xyzDataSet, this.XYZ_FILE_NAME);
        }
        catch (IOException e) {
            throw new GMT_MapException(e);
        }
        gmtLines.addAll(this.getGMT_ScriptLines());
        this.imt = "SA";
        this.SCALE_LABEL = SA_10;
        this.setFileNames(this.SCALE_LABEL);
        String sa_10Image = this.JPG_FILE_NAME;
        this.xyzDataSet = sa10DataSet;
        try {
            ArbDiscrGeoDataSet.writeXYZFile((XYZ_DataSet)this.xyzDataSet, this.XYZ_FILE_NAME);
        }
        catch (IOException e) {
            throw new GMT_MapException(e);
        }
        gmtLines.addAll(this.getGMT_ScriptLines());
        this.imt = "PGA";
        this.SCALE_LABEL = PGA;
        this.setFileNames(this.SCALE_LABEL);
        String pgaImage = this.JPG_FILE_NAME;
        this.xyzDataSet = pgaDataSet;
        try {
            ArbDiscrGeoDataSet.writeXYZFile((XYZ_DataSet)this.xyzDataSet, this.XYZ_FILE_NAME);
        }
        catch (IOException e) {
            throw new GMT_MapException(e);
        }
        gmtLines.addAll(this.getGMT_ScriptLines());
        this.imt = "PGV";
        this.SCALE_LABEL = PGV;
        this.setFileNames(this.SCALE_LABEL);
        String pgvImage = this.JPG_FILE_NAME;
        this.xyzDataSet = pgvDataSet;
        try {
            ArbDiscrGeoDataSet.writeXYZFile((XYZ_DataSet)this.xyzDataSet, this.XYZ_FILE_NAME);
        }
        catch (IOException e) {
            throw new GMT_MapException(e);
        }
        gmtLines.addAll(this.getGMT_ScriptLines());
        this.makeFileFromLines(gmtLines, this.GMT_SCRIPT_NAME);
        String[] command = new String[]{"sh", "-c", "sh " + this.GMT_SCRIPT_NAME};
        RunScript.runScript(command);
        this.imgWebAddr = this.JPG_FILE_NAME;
        String[] img = new String[]{new String(sa_03Image), new String(sa_10Image), new String(pgaImage), new String(pgvImage)};
        this.setFileNames(null);
        return img;
    }

    public String[] makeHazusFileSetUsingServlet(GeoDataSet sa03DataSet, GeoDataSet sa10DataSet, GeoDataSet pgaDataSet, GeoDataSet pgvDataSet, EqkRupture eqkRupture, String metadata, String dirName) throws GMT_MapException {
        this.eqkRup = eqkRupture;
        GMT_Map[] maps = new GMT_Map[4];
        this.imt = "SA";
        this.SCALE_LABEL = SA_03;
        this.xyzDataSet = sa03DataSet;
        this.setFileNames(this.SCALE_LABEL);
        maps[0] = this.getGMTMapSpecification(this.xyzDataSet);
        this.imt = "SA";
        this.SCALE_LABEL = SA_10;
        this.xyzDataSet = sa10DataSet;
        this.setFileNames(this.SCALE_LABEL);
        maps[1] = this.getGMTMapSpecification(this.xyzDataSet);
        this.imt = "PGA";
        this.SCALE_LABEL = PGA;
        this.xyzDataSet = pgaDataSet;
        this.setFileNames(this.SCALE_LABEL);
        maps[2] = this.getGMTMapSpecification(this.xyzDataSet);
        this.imt = "PGV";
        this.SCALE_LABEL = PGV;
        this.xyzDataSet = pgvDataSet;
        this.setFileNames(this.SCALE_LABEL);
        maps[3] = this.getGMTMapSpecification(this.xyzDataSet);
        String[] img = GMT_MapGeneratorForShakeMaps.makeHazusFileSetUsingServlet(maps[0], maps[1], maps[2], maps[3], metadata, dirName);
        this.imgWebAddr = img[0].substring(0, img[0].lastIndexOf("/")) + "/";
        this.setFileNames(null);
        return img;
    }

    public static String[] makeHazusFileSetUsingServlet(GMT_Map sa03Map, GMT_Map sa10Map, GMT_Map pgaMap, GMT_Map pgvMap, String metadata, String dirName) throws GMT_MapException {
        GMT_Map[] maps = new GMT_Map[4];
        GeoDataSet sa03DataSet = sa03Map.getGriddedData();
        maps[0] = sa03Map;
        String sa_03Image = sa03Map.getJPGFileName();
        GeoDataSet sa10DataSet = sa10Map.getGriddedData();
        maps[1] = sa10Map;
        String sa_10Image = sa10Map.getJPGFileName();
        GeoDataSet pgaDataSet = pgaMap.getGriddedData();
        maps[2] = pgaMap;
        String pgaImage = pgaMap.getJPGFileName();
        GeoDataSet pgvDataSet = pgvMap.getGriddedData();
        maps[3] = pgvMap;
        String pgvImage = pgvMap.getJPGFileName();
        String[] img = new String[4];
        try {
            String imgWebAddr = GMT_MapGeneratorForShakeMaps.openServletConnection(sa03DataSet, sa10DataSet, pgaDataSet, pgvDataSet, maps, metadata, dirName);
            img[0] = new String(imgWebAddr + sa_03Image);
            img[1] = new String(imgWebAddr + sa_10Image);
            img[2] = new String(imgWebAddr + pgaImage);
            img[3] = new String(imgWebAddr + pgvImage);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return img;
    }

    protected static String openServletConnection(GeoDataSet sa03_xyzDataVals, GeoDataSet sa10_xyzDataVals, GeoDataSet pga_xyzDataVals, GeoDataSet pgv_xyzDataVals, GMT_Map[] maps, String metadata, String dirName) throws RuntimeException {
        String webaddr = null;
        try {
            URL gmtMapServlet = new URL(OPENSHA_HAZUS_SERVLET_URL);
            URLConnection servletConnection = gmtMapServlet.openConnection();
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream outputToServlet = new ObjectOutputStream(servletConnection.getOutputStream());
            outputToServlet.writeObject(dirName);
            outputToServlet.writeObject(maps);
            outputToServlet.writeObject(metadata);
            outputToServlet.writeObject("map_info.html");
            outputToServlet.flush();
            outputToServlet.close();
            ObjectInputStream inputToServlet = new ObjectInputStream(servletConnection.getInputStream());
            Object messageFromServlet = inputToServlet.readObject();
            inputToServlet.close();
            if (!(messageFromServlet instanceof String)) {
                throw (RuntimeException)messageFromServlet;
            }
            webaddr = (String)messageFromServlet;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Server is down, please try again later. If the problem persists, make sure you are using the latest version of our applications.");
        }
        return webaddr;
    }

    public String makeMapLocally(GeoDataSet xyzDataSet, EqkRupture eqkRupture, String imtString, String metadata, String directoryName) throws GMT_MapException {
        this.eqkRup = eqkRupture;
        this.imt = imtString;
        String jpgFileName = super.makeMapLocally(xyzDataSet, imtString, metadata, directoryName);
        String dirName = null;
        String tempScript = null;
        if (directoryName != null) {
            File f = new File(directoryName);
            int fileCounter = 1;
            while (f.exists()) {
                String tempDirName = directoryName + fileCounter;
                f = new File(tempDirName);
                ++fileCounter;
            }
            dirName = "UserShakeMaps_" + f.getName();
            tempScript = "temp" + f.getName();
        } else {
            dirName = "UserShakeMaps_" + System.currentTimeMillis();
            tempScript = "temp" + System.currentTimeMillis();
        }
        ArrayList<CallSite> scriptLines = new ArrayList<CallSite>();
        String commandLine = COMMAND_PATH + "mkdir " + dirName;
        scriptLines.add((CallSite)((Object)(commandLine + "\n")));
        commandLine = COMMAND_PATH + "mv " + this.GMT_SCRIPT_NAME + " " + this.XYZ_FILE_NAME + " " + this.METADATA_FILE_NAME + " " + this.PS_FILE_NAME + " " + this.JPG_FILE_NAME + " " + this.PDF_FILE_NAME + "  " + this.HAZUS_FILE_PREFIX + ".shp " + this.HAZUS_FILE_PREFIX + ".shx " + this.HAZUS_FILE_PREFIX + ".dbf " + dirName;
        scriptLines.add((CallSite)((Object)(commandLine + "\n")));
        commandLine = COMMAND_PATH + "rm " + tempScript;
        scriptLines.add((CallSite)((Object)(commandLine + "\n")));
        this.makeFileFromLines(scriptLines, tempScript);
        String[] command = new String[]{"sh", "-c", "sh " + tempScript};
        RunScript.runScript(command);
        return dirName + "/" + jpgFileName;
    }

    public String makeMapUsingServlet(GeoDataSet xyzDataSet, EqkRupture eqkRupture, String imtString, String metadata, String dirName) throws GMT_MapException, RuntimeException {
        this.eqkRup = eqkRupture;
        this.imt = imtString;
        return super.makeMapUsingServlet(xyzDataSet, imtString, metadata, dirName);
    }

    public String makeMapUsingWebServer(GeoDataSet xyzDataSet, EqkRupture eqkRupture, String imtString, String metadata) throws GMT_MapException {
        this.eqkRup = eqkRupture;
        this.imt = imtString;
        return super.makeMapUsingWebServer(xyzDataSet, imtString, metadata);
    }

    public static void addHAZUS_Lines(ArrayList<String> gmtCommandLines, GMT_Map map, String imt, String hazusPrefix) {
        String commandLine;
        if (map.isLogPlot()) {
            throw new RuntimeException("You cannot make Hazus Shapefiles with log-plot selected!");
        }
        File hazusDir = new File(ServerPrefUtils.SERVER_PREFS.getTomcatDir().getParentFile(), "hazus");
        String HAZUS_SHAPE_FILE_GENERATOR = new File(hazusDir, "contour").getAbsolutePath();
        double minLat = map.getRegion().getMinLat();
        double maxTempLat = map.getRegion().getMaxLat();
        double minLon = map.getRegion().getMinLon();
        double maxTempLon = map.getRegion().getMaxLon();
        double gridSpacing = map.getGriddedDataInc();
        double maxLat = Math.rint((maxTempLat - minLat) / gridSpacing) * gridSpacing + minLat;
        double maxLon = Math.rint((maxTempLon - minLon) / gridSpacing) * gridSpacing + minLon;
        String region = " -R" + minLon + "/" + maxLon + "/" + minLat + "/" + maxLat + " ";
        gmtCommandLines.add("# HAZUS file generation");
        gmtCommandLines.add("# set LD_LIBRARY_PATH for old GMT");
        gmtCommandLines.add("ORIG_LD=$LD_LIBRARY_PATH");
        File gmtDir = new File(hazusDir, "gmt_4.5.14");
        File cdfDir = new File(hazusDir, "netcdf");
        gmtCommandLines.add("export LD_LIBRARY_PATH=" + gmtDir.getAbsolutePath() + "/lib:" + cdfDir.getAbsolutePath() + ":$ORIG_LD");
        if (imt.equals("SA")) {
            commandLine = "${GMT_PATH}xyz2grd " + map.getXyzFileName() + " -Gtemp.grd=1 -I" + gridSpacing + region + " -D/degree/degree/amp/=/=/= -:  -V";
            gmtCommandLines.add(commandLine + "\n");
            commandLine = HAZUS_SHAPE_FILE_GENERATOR + " -g temp.grd -C 0.04 -f 0.02 -Z 1.0 -T4 -o " + hazusPrefix;
            gmtCommandLines.add(commandLine + "\n");
        } else if (imt.equals("PGA")) {
            commandLine = "${GMT_PATH}xyz2grd " + map.getXyzFileName() + " -Gtemp.grd=1 -I" + gridSpacing + region + " -D/degree/degree/amp/=/=/= -:  -V";
            gmtCommandLines.add(commandLine + "\n");
            commandLine = HAZUS_SHAPE_FILE_GENERATOR + " -g temp.grd -C 0.04 -f 0.02 -Z 1.0 -T4 -o " + hazusPrefix;
            gmtCommandLines.add(commandLine + "\n");
        } else if (imt.equals("PGV")) {
            commandLine = "${GMT_PATH}xyz2grd " + map.getXyzFileName() + " -Gtemp.grd=1 -I" + gridSpacing + region + " -D/degree/degree/amp/=/=/= -:  -V";
            gmtCommandLines.add(commandLine + "\n");
            commandLine = HAZUS_SHAPE_FILE_GENERATOR + " -g temp.grd -C 4.0 -f 2.0 -Z 0.3937 -T4 -o " + hazusPrefix;
            gmtCommandLines.add(commandLine + "\n");
        } else {
            throw new RuntimeException("IMT not supported to generate Shape File");
        }
        commandLine = COMMAND_PATH + "rm temp.grd";
        gmtCommandLines.add(commandLine + "\n");
        gmtCommandLines.add("export LD_LIBRARY_PATH=$ORIG_LD\n");
    }

    @Override
    protected void addFinalGMT_ScriptLines(ArrayList gmtCommandLines) {
        boolean doHaveToGenerateShapeFile = (Boolean)this.hazusShapeParam.getValue();
        if (doHaveToGenerateShapeFile) {
            String commandLine;
            boolean logPlotCheck = (Boolean)this.logPlotParam.getValue();
            if (((Boolean)this.logPlotParam.getValue()).booleanValue()) {
                throw new RuntimeException("You cannot make Hazus Shapefiles with log-plot selected!");
            }
            String HAZUS_SHAPE_FILE_GENERATOR = "/usr/scec/hazus/shapefilegenerator/contour";
            double minLat = (Double)this.adjustableParams.getParameter("Min Latitude").getValue();
            double maxTempLat = (Double)this.adjustableParams.getParameter("Max Latitude").getValue();
            double minLon = (Double)this.adjustableParams.getParameter("Min Longitude").getValue();
            double maxTempLon = (Double)this.adjustableParams.getParameter("Max Longitude").getValue();
            double gridSpacing = (Double)this.adjustableParams.getParameter("Grid Spacing").getValue();
            double maxLat = Math.rint((maxTempLat - minLat) / gridSpacing) * gridSpacing + minLat;
            double maxLon = Math.rint((maxTempLon - minLon) / gridSpacing) * gridSpacing + minLon;
            String region = " -R" + minLon + "/" + maxLon + "/" + minLat + "/" + maxLat + " ";
            if (this.imt.equals("SA")) {
                commandLine = GMT_PATH + "xyz2grd " + this.XYZ_FILE_NAME + " -Gtemp.grd=1 -I" + gridSpacing + region + " -D/degree/degree/amp/=/=/= -:  -V";
                gmtCommandLines.add(commandLine + "\n");
                commandLine = HAZUS_SHAPE_FILE_GENERATOR + " -g temp.grd -C 0.04 -f 0.02 -Z 1.0 -T4 -o " + this.HAZUS_FILE_PREFIX;
                gmtCommandLines.add(commandLine + "\n");
            } else if (this.imt.equals("PGA")) {
                commandLine = GMT_PATH + "xyz2grd " + this.XYZ_FILE_NAME + " -Gtemp.grd=1 -I" + gridSpacing + region + " -D/degree/degree/amp/=/=/= -:  -V";
                gmtCommandLines.add(commandLine + "\n");
                commandLine = HAZUS_SHAPE_FILE_GENERATOR + " -g temp.grd -C 0.04 -f 0.02 -Z 1.0 -T4 -o " + this.HAZUS_FILE_PREFIX;
                gmtCommandLines.add(commandLine + "\n");
            } else if (this.imt.equals("PGV")) {
                commandLine = GMT_PATH + "xyz2grd " + this.XYZ_FILE_NAME + " -Gtemp.grd=1 -I" + gridSpacing + region + " -D/degree/degree/amp/=/=/= -:  -V";
                gmtCommandLines.add(commandLine + "\n");
                commandLine = HAZUS_SHAPE_FILE_GENERATOR + " -g temp.grd -C 4.0 -f 2.0 -Z 0.3937 -T4 -o " + this.HAZUS_FILE_PREFIX;
                gmtCommandLines.add(commandLine + "\n");
            } else {
                throw new RuntimeException("IMT not supported to generate Shape File");
            }
            commandLine = COMMAND_PATH + "rm temp.grd";
            gmtCommandLines.add(commandLine + "\n");
        }
    }

    public static final void addRupture(GMT_Map map, EvenlyGriddedSurface surface, Location hypo, String rupPlot) {
        if (!rupPlot.equals(RUP_PLOT_PARAM_NOTHING)) {
            int rows = surface.getNumRows();
            int cols = surface.getNumCols();
            double penWidth = 2.0;
            if (rupPlot.equals(RUP_PLOT_PARAM_PERIMETER)) {
                Color color;
                PSXYPolygon poly;
                Location loc;
                int shade;
                int r;
                int c;
                double dMin = surface.getLocation(0, 0).getDepth();
                double dMax = surface.getLocation(surface.getNumRows() - 1, 0).getDepth();
                double maxShade = 235.0;
                double minShade = 20.0;
                Location lastLoc = surface.getLocation(0, 0);
                if (surface.getAveDip() < 90.0) {
                    c = cols - 1;
                    lastLoc = surface.getLocation(0, c);
                    for (r = 1; r < rows; ++r) {
                        shade = 20 + (int)((maxShade - minShade) * (dMax - lastLoc.getDepth()) / (dMax - dMin));
                        loc = surface.getLocation(r, c);
                        poly = new PSXYPolygon(lastLoc, loc);
                        color = new Color(shade, shade, shade);
                        poly.setPenColor(color);
                        poly.setPenWidth(penWidth);
                        map.addPolys(poly);
                        lastLoc = loc;
                    }
                    r = rows - 1;
                    for (c = cols - 2; c >= 0; --c) {
                        shade = 20 + (int)((maxShade - minShade) * (dMax - lastLoc.getDepth()) / (dMax - dMin));
                        loc = surface.getLocation(r, c);
                        poly = new PSXYPolygon(lastLoc, loc);
                        color = new Color(shade, shade, shade);
                        poly.setPenColor(color);
                        poly.setPenWidth(penWidth);
                        map.addPolys(poly);
                        lastLoc = loc;
                    }
                    c = 0;
                    for (r = rows - 2; r >= 0; --r) {
                        shade = 20 + (int)((maxShade - minShade) * (dMax - lastLoc.getDepth()) / (dMax - dMin));
                        loc = surface.getLocation(r, c);
                        poly = new PSXYPolygon(lastLoc, loc);
                        color = new Color(shade, shade, shade);
                        poly.setPenColor(color);
                        poly.setPenWidth(penWidth);
                        map.addPolys(poly);
                        lastLoc = loc;
                    }
                }
                r = 0;
                for (c = 1; c < cols; ++c) {
                    shade = 20 + (int)((maxShade - minShade) * (dMax - lastLoc.getDepth()) / (dMax - dMin));
                    loc = surface.getLocation(r, c);
                    poly = new PSXYPolygon(lastLoc, loc);
                    color = new Color(shade, shade, shade);
                    poly.setPenColor(color);
                    poly.setPenWidth(penWidth);
                    map.addPolys(poly);
                    lastLoc = loc;
                }
            } else {
                String gmtSymbol = " c0.04i";
                Color bigColor = new Color(20, 20, 20);
                Color smallColor = new Color(235, 235, 235);
                float dep1 = (float)surface.getLocation(0, 0).getDepth();
                float dep2 = (float)surface.getLocation(surface.getNumRows() - 1, 0).getDepth();
                CPT cpt = new CPT();
                cpt.setCPTVal(new CPTVal(dep1, smallColor, dep2, bigColor));
                PSXYSymbolSet symbols = new PSXYSymbolSet();
                symbols.setCpt(cpt);
                for (int r = surface.getNumRows() - 1; r >= 0; --r) {
                    for (int c = 0; c < surface.getNumCols() - 1; ++c) {
                        Location loc = surface.getLocation(r, c);
                        Point2D.Double pt = new Point2D.Double(loc.getLongitude(), loc.getLatitude());
                        PSXYSymbol sym = new PSXYSymbol(pt, PSXYSymbol.Symbol.CIRCLE, 0.04);
                        symbols.addSymbol(sym, loc.getDepth());
                    }
                }
                map.setSymbolSet(symbols);
            }
            if (hypo != null) {
                Point2D.Double pt = new Point2D.Double(hypo.getLongitude(), hypo.getLatitude());
                PSXYSymbol.Symbol symbol = PSXYSymbol.Symbol.STAR;
                double width = 0.4;
                Color penColor = Color.BLACK;
                Color fillColor = null;
                PSXYSymbol hypoSym = new PSXYSymbol(pt, symbol, width, penWidth, penColor, fillColor);
                map.addSymbol(hypoSym);
            }
        }
    }

    @Override
    public GMT_Map getGMTMapSpecification(GeoDataSet xyzData) {
        GMT_Map map = super.getGMTMapSpecification(xyzData);
        if (this.eqkRup != null && this.eqkRup.getRuptureSurface() instanceof EvenlyGriddedSurface) {
            GMT_MapGeneratorForShakeMaps.addRupture(map, (EvenlyGriddedSurface)this.eqkRup.getRuptureSurface(), this.eqkRup.getHypocenterLocation(), (String)this.rupPlotParam.getValue());
        } else if (this.eqkRup != null) {
            System.out.println("Can't yet plot non-EvenlyGriddedSurface types in GMT_MapGeneratorForShakeMaps");
        }
        return map;
    }

    @Override
    protected void addIntermediateGMT_ScriptLines(ArrayList gmtLines, String region, String projWdth) {
        String rupPlot = (String)this.rupPlotParam.getValue();
        if (!rupPlot.equals(RUP_PLOT_PARAM_NOTHING)) {
            String commandLine;
            Location loc;
            EvenlyGriddedSurface surface = (EvenlyGriddedSurface)this.eqkRup.getRuptureSurface();
            ArrayList<String> fileLines = new ArrayList<String>();
            int rows = surface.getNumRows();
            int cols = surface.getNumCols();
            if (rupPlot.equals(RUP_PLOT_PARAM_PERIMETER)) {
                int shade;
                int r;
                int c;
                double dMin = surface.getLocation(0, 0).getDepth();
                double dMax = surface.getLocation(surface.getNumRows() - 1, 0).getDepth();
                double maxShade = 235.0;
                double minShade = 20.0;
                Location lastLoc = surface.getLocation(0, 0);
                if (this.eqkRup.getRuptureSurface().getAveDip() < 90.0) {
                    c = cols - 1;
                    lastLoc = surface.getLocation(0, c);
                    for (r = 1; r < rows; ++r) {
                        shade = 20 + (int)((maxShade - minShade) * (dMax - lastLoc.getDepth()) / (dMax - dMin));
                        fileLines.add(new String(">  -W8/" + shade + "/" + shade + "/" + shade));
                        fileLines.add(new String((float)lastLoc.getLongitude() + "  " + (float)lastLoc.getLatitude()));
                        loc = surface.getLocation(r, c);
                        fileLines.add(new String((float)loc.getLongitude() + "  " + (float)loc.getLatitude()));
                        lastLoc = loc;
                    }
                    r = rows - 1;
                    for (c = cols - 2; c >= 0; --c) {
                        shade = 20 + (int)((maxShade - minShade) * (dMax - lastLoc.getDepth()) / (dMax - dMin));
                        fileLines.add(new String(">  -W8/" + shade + "/" + shade + "/" + shade));
                        fileLines.add(new String((float)lastLoc.getLongitude() + "  " + (float)lastLoc.getLatitude()));
                        loc = surface.getLocation(r, c);
                        fileLines.add(new String((float)loc.getLongitude() + "  " + (float)loc.getLatitude()));
                        lastLoc = loc;
                    }
                    c = 0;
                    for (r = rows - 2; r >= 0; --r) {
                        shade = 20 + (int)((maxShade - minShade) * (dMax - lastLoc.getDepth()) / (dMax - dMin));
                        fileLines.add(new String(">  -W8/" + shade + "/" + shade + "/" + shade));
                        fileLines.add(new String((float)lastLoc.getLongitude() + "  " + (float)lastLoc.getLatitude()));
                        loc = surface.getLocation(r, c);
                        fileLines.add(new String((float)loc.getLongitude() + "  " + (float)loc.getLatitude()));
                        lastLoc = loc;
                    }
                }
                r = 0;
                for (c = 1; c < cols; ++c) {
                    shade = 20 + (int)((maxShade - minShade) * (dMax - lastLoc.getDepth()) / (dMax - dMin));
                    fileLines.add(new String(">  -W8/" + shade + "/" + shade + "/" + shade));
                    fileLines.add(new String((float)lastLoc.getLongitude() + "  " + (float)lastLoc.getLatitude()));
                    loc = surface.getLocation(r, c);
                    fileLines.add(new String((float)loc.getLongitude() + "  " + (float)loc.getLatitude()));
                    lastLoc = loc;
                }
                gmtLines.add(COMMAND_PATH + "cat << END > " + this.EQK_RUP_XYZ_FILE_NAME);
                Iterator it = fileLines.iterator();
                while (it.hasNext()) {
                    gmtLines.add((String)it.next());
                }
                gmtLines.add("END\n");
                commandLine = GMT_PATH + "psxy " + this.EQK_RUP_XYZ_FILE_NAME + region + projWdth + " -K -O >> " + this.PS_FILE_NAME;
                gmtLines.add((String)commandLine + "\n");
                gmtLines.add(COMMAND_PATH + "rm " + this.EQK_RUP_XYZ_FILE_NAME + "\n");
            } else {
                String gmtSymbol = " c0.04i";
                for (int r = surface.getNumRows() - 1; r >= 0; --r) {
                    for (int c = 0; c < surface.getNumCols() - 1; ++c) {
                        loc = surface.getLocation(r, c);
                        fileLines.add(new String((float)loc.getLongitude() + "  " + (float)loc.getLatitude() + "  " + (float)loc.getDepth() + gmtSymbol));
                    }
                }
                gmtLines.add(COMMAND_PATH + "cat << END > " + this.EQK_RUP_XYZ_FILE_NAME);
                Iterator it = fileLines.iterator();
                while (it.hasNext()) {
                    gmtLines.add((String)it.next());
                }
                gmtLines.add("END\n");
                double dep1 = surface.getLocation(0, 0).getDepth();
                double dep2 = surface.getLocation(surface.getNumRows() - 1, 0).getDepth();
                commandLine = COMMAND_PATH + "cat << END > temp_rup_cpt\n" + (float)dep1 + " 235 235 253 " + (float)dep2 + " 20 20 20\nF 235 235 235\nB 20 20 20\nEND";
                gmtLines.add(commandLine + "\n");
                commandLine = GMT_PATH + "psxy " + this.EQK_RUP_XYZ_FILE_NAME + region + projWdth + " -K -O -S -Ctemp_rup_cpt >> " + this.PS_FILE_NAME;
                gmtLines.add(commandLine + "\n");
                gmtLines.add(COMMAND_PATH + "rm temp_rup_cpt " + this.EQK_RUP_XYZ_FILE_NAME + "\n");
            }
            loc = this.eqkRup.getHypocenterLocation();
            if (loc != null) {
                commandLine = COMMAND_PATH + "cat << END > temp_hyp\n" + (float)loc.getLongitude() + "  " + (float)loc.getLatitude() + "  " + (float)loc.getDepth() + "\n" + (float)loc.getLongitude() + "  " + (float)loc.getLatitude() + "  " + (float)loc.getDepth() + "\nEND";
                gmtLines.add(commandLine + "\n");
                commandLine = GMT_PATH + "psxy temp_hyp " + region + projWdth + " -K -O -Sa0.4i -W8/0/0/0 >> " + this.PS_FILE_NAME;
                gmtLines.add(commandLine + "\n");
                gmtLines.add(COMMAND_PATH + "rm temp_hyp\n");
            }
        }
    }
}

