/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.distCalc;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.faultSurface.cache.SurfaceDistances;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.Vertex;

public class SimRuptureDistCalcUtils {
    public static LocationElementDistanceCache buildSiteLocDistCache(Location siteLoc) {
        return new LocationElementDistanceCache(siteLoc);
    }

    public static DiscretizedFunc calcDistScalarFunc(SimulatorEvent event, Location siteLoc, LocationElementDistanceCache siteLocDistCache, DistanceType distType, Scalar scalar) {
        ArrayList<SimulatorElement> elems = event.getAllElements();
        double[] slips = event.getAllElementSlips();
        ArbitrarilyDiscretizedFunc incrementalFunc = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < slips.length; ++i) {
            SimulatorElement elem = (SimulatorElement)elems.get(i);
            double scalarVal = scalar.calc(elem, slips[i]);
            double dist = distType.calc(siteLocDistCache.getDistances(elem));
            if (!Double.isFinite(dist) || !(scalarVal > 0.0)) continue;
            int xInd = incrementalFunc.getXIndex(dist);
            if (xInd >= 0) {
                incrementalFunc.set(xInd, scalarVal + incrementalFunc.getY(xInd));
                continue;
            }
            incrementalFunc.set(dist, scalarVal);
        }
        if (incrementalFunc.size() == 0) {
            return null;
        }
        double cumulativeVal = 0.0;
        ArbitrarilyDiscretizedFunc cumulativeFunc = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < incrementalFunc.size(); ++i) {
            cumulativeFunc.set(incrementalFunc.getX(i), cumulativeVal += incrementalFunc.getY(i));
        }
        return cumulativeFunc;
    }

    public static class LocationElementDistanceCache {
        private Location siteLoc;
        private Map<SimulatorElement, Location[]> elemVertexMap;
        private Map<Location, SurfaceDistances> vertexDistsMap;
        private Map<SimulatorElement, FootwallAwareSurfaceDistances> elemDistsMap;

        private LocationElementDistanceCache(Location siteLoc) {
            this.siteLoc = siteLoc;
            this.elemVertexMap = new ConcurrentHashMap<SimulatorElement, Location[]>();
            this.vertexDistsMap = new ConcurrentHashMap<Location, SurfaceDistances>();
            this.elemDistsMap = new ConcurrentHashMap<SimulatorElement, FootwallAwareSurfaceDistances>();
        }

        public FootwallAwareSurfaceDistances getDistances(SimulatorElement elem) {
            FootwallAwareSurfaceDistances dists = this.elemDistsMap.get(elem);
            if (dists == null) {
                Location[] locs = this.elemVertexMap.get(elem);
                if (locs == null) {
                    Vertex[] verts = elem.getVertices();
                    locs = new Location[verts.length];
                    for (int i = 0; i < locs.length; ++i) {
                        locs[i] = new Location((float)verts[i].getLatitude(), (float)verts[i].getLongitude(), (float)verts[i].getDepth());
                    }
                    this.elemVertexMap.put(elem, locs);
                }
                double rJB = Double.POSITIVE_INFINITY;
                double rRup = Double.POSITIVE_INFINITY;
                double rSeis = Double.POSITIVE_INFINITY;
                boolean dipping = (float)elem.getFocalMechanism().getDip() < 90.0f;
                double[] rJBs = new double[locs.length];
                for (int l = 0; l < locs.length; ++l) {
                    SurfaceDistances vertDists = this.vertexDistsMap.get(locs[l]);
                    if (vertDists == null) {
                        double vertJB = LocationUtils.horzDistanceFast(this.siteLoc, locs[l]);
                        double vertRup = Math.sqrt(vertJB * vertJB + locs[l].getDepth() * locs[l].getDepth());
                        vertDists = new SurfaceDistances(vertRup, vertJB, Double.NaN);
                        this.vertexDistsMap.put(locs[l], vertDists);
                    }
                    rJBs[l] = vertDists.getDistanceJB();
                    rJB = Double.min(rJB, vertDists.getDistanceJB());
                    rRup = Double.min(rRup, vertDists.getDistanceRup());
                    if (!(locs[l].depth >= 3.0)) continue;
                    rSeis = Double.min(rSeis, vertDists.getDistanceRup());
                }
                boolean footwall = true;
                if (dipping) {
                    FocalMechanism mech = elem.getFocalMechanism();
                    double dip = mech.getDip();
                    double strike = mech.getStrike();
                    Location center = elem.getCenterLocation();
                    double vDistance = -center.getDepth();
                    double hDistance = vDistance / Math.tan(Math.toRadians(dip));
                    double upDipDirection = strike - 90.0;
                    LocationVector dir = new LocationVector(upDipDirection, hDistance, vDistance);
                    Location surfProjCenter = LocationUtils.location(center, dir);
                    double fakeSurfLen = 10.0;
                    LocationVector alongStrike = new LocationVector(strike, 0.5 * fakeSurfLen, 0.0);
                    Location l0 = LocationUtils.location(surfProjCenter, alongStrike);
                    alongStrike.reverse();
                    Location l1 = LocationUtils.location(surfProjCenter, alongStrike);
                    double dist = LocationUtils.distanceToLineFast(l0, l1, this.siteLoc);
                    footwall = dist < 0.0;
                }
                dists = new FootwallAwareSurfaceDistances(rRup, rJB, rSeis, footwall);
                this.elemDistsMap.put(elem, dists);
            }
            return dists;
        }
    }

    public static enum Scalar {
        MOMENT("Scalar Moment", "Scalar Moment", "Nm", "Nm"){

            @Override
            protected double calc(SimulatorElement element, double slip) {
                return FaultMomentCalc.getMoment(element.getArea(), slip);
            }
        }
        ,
        AREA("Area", "Area", "km^2", "km<sup>2</sup>"){

            @Override
            protected double calc(SimulatorElement element, double slip) {
                return element.getArea() * 1.0E-6;
            }
        };

        public final String displayName;
        public final String htmlName;
        public final String units;
        public final String htmlUnits;

        private Scalar(String name, String htmlName, String units, String htmlUnits) {
            this.displayName = name;
            this.htmlName = htmlName;
            this.units = units;
            this.htmlUnits = htmlUnits;
        }

        protected abstract double calc(SimulatorElement var1, double var2);
    }

    public static class FootwallAwareSurfaceDistances
    extends SurfaceDistances {
        private final boolean footwall;

        public FootwallAwareSurfaceDistances(double distanceRup, double distanceJB, double distanceSeis, boolean footwall) {
            super(distanceRup, distanceJB, distanceSeis);
            this.footwall = footwall;
        }

        public boolean isOnFootfall() {
            return this.footwall;
        }
    }

    public static enum DistanceType {
        R_JB("Rjb", "R<sub>JB</sub>"){

            @Override
            protected double calc(SurfaceDistances dists) {
                return dists.getDistanceJB();
            }
        }
        ,
        R_RUP("Rrup", "R<sub>Rup</sub>"){

            @Override
            protected double calc(SurfaceDistances dists) {
                return dists.getDistanceRup();
            }
        }
        ,
        R_SEIS("Rseis", "R<sub>Seis</sub>"){

            @Override
            protected double calc(SurfaceDistances dists) {
                return dists.getDistanceSeis();
            }
        };

        public final String displayName;
        public final String htmlName;

        private DistanceType(String name, String htmlName) {
            this.displayName = name;
            this.htmlName = htmlName;
        }

        protected abstract double calc(SurfaceDistances var1);
    }

    public static class LocationElementDistanceCacheFactory {
        private Location[] locs;
        private LocationElementDistanceCache[] caches;
        private int index;

        public LocationElementDistanceCacheFactory() {
            this(Integer.max(10, Runtime.getRuntime().availableProcessors()));
        }

        public LocationElementDistanceCacheFactory(int maxSize) {
            this.locs = new Location[maxSize];
            this.caches = new LocationElementDistanceCache[maxSize];
            this.index = 0;
        }

        public synchronized LocationElementDistanceCache getCache(Location loc) {
            for (int i = 0; i < this.locs.length; ++i) {
                if (this.locs[i] == null || !loc.equals(this.locs[i])) continue;
                return this.caches[i];
            }
            LocationElementDistanceCache cache = SimRuptureDistCalcUtils.buildSiteLocDistCache(loc);
            this.locs[this.index] = loc;
            this.caches[this.index] = cache;
            ++this.index;
            if (this.index == this.locs.length) {
                this.index = 0;
            }
            return cache;
        }
    }
}

