/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.iden;

import com.google.common.collect.Range;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.Vertex;
import org.opensha.sha.simulators.iden.AbstractRuptureIdentifier;

public class DepthIden
extends AbstractRuptureIdentifier {
    private Range<Double> upperDepthRange;
    private Range<Double> lowerDepthRange;

    public DepthIden(Range<Double> upperDepthRange, Range<Double> lowerDepthRange) {
        this.upperDepthRange = upperDepthRange;
        this.lowerDepthRange = lowerDepthRange;
    }

    @Override
    public boolean isMatch(SimulatorEvent event) {
        double minDepth = Double.POSITIVE_INFINITY;
        double maxDepth = 0.0;
        for (SimulatorElement elem : event.getAllElements()) {
            for (Vertex v : elem.getVertices()) {
                minDepth = Math.min(minDepth, v.getDepth());
                maxDepth = Math.max(maxDepth, v.getDepth());
            }
        }
        if (minDepth == 0.0) {
            minDepth = 0.0;
        }
        if (maxDepth == 0.0) {
            maxDepth = 0.0;
        }
        if (this.upperDepthRange != null && !this.upperDepthRange.contains((Comparable)Double.valueOf(minDepth))) {
            return false;
        }
        return this.lowerDepthRange == null || this.lowerDepthRange.contains((Comparable)Double.valueOf(maxDepth));
    }

    @Override
    public String getName() {
        return "Depth Identifier";
    }
}

